/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.client;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.BizobjectFactory;
import com.kingdee.eas.base.attachment.client.AbstractBizobjectListUI;
import com.kingdee.eas.base.attachment.client.BizobjectEditUI;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfoSelector;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.attachment.util.Sout;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import org.apache.log4j.Logger;

public class BizobjectListUI
extends AbstractBizobjectListUI {
    Logger logger = Logger.getLogger(BizobjectListUI.class);
    private KDButton b;
    private AttachmentClientManager acm;

    public BizobjectListUI() throws Exception {
        this.btnShowAttachment.setEnabled(true);
        this.b = new KDButton("TestButton");
        this.b.setText(EASResource.getString((String)"com.kingdee.eas.base.attachment.ATTACHMENTAutoGenerateResource", (String)"4_BizobjectListUI"));
        this.b.setBounds(100, 100, 200, 80);
        this.b.setVisible(true);
        this.b.setEnabled(true);
        this.add((Component)this.b);
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BizobjectListUI.this.doSomeTest();
            }
        });
        this.acm = AttachmentManagerFactory.getClientManager();
    }

    private void doSomeTest() {
        try {
            this.testShowAllList();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void testShowListByBoIDAndCode() {
        String boID = "c7437c8d-0104-1000-e000-010bc0a8128bBCC89432";
        String code = "unformal";
        this.acm.showAttachmentListUIByBoID(boID, code, (Object)this);
    }

    private void testShowAllList() throws Exception {
        this.acm.showAllAttachmentListUI((Object)this);
    }

    private void testGetCollection() throws Exception {
        String boID = "c7437c8d-0104-1000-e000-010bc0a8128bBCC89432";
        ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
        cais.needMainName();
        cais.needSizeDesc();
        cais.needSizeInByte();
        this.acm.getComplexAttachmentInfoCollectionByBoID(boID, cais);
        Sout.show("sucess");
    }

    private void testAddAssociations() throws Exception {
        String oldBoID = "c7437c8d-0104-1000-e000-010bc0a8128bBCC89432";
        String newBoID = "e11ac158-0104-1000-e000-02d1c0a8128bBCC89432";
        String[] attchIDs = this.acm.getAttachmentIDsByBoID(oldBoID);
        this.acm.addAssociations(newBoID, attchIDs);
    }

    private void testGetComplexAttachmentInfo(String attchID) throws Exception {
        ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
        cais.needMainName();
        cais.needExtName();
        cais.needCUName();
        cais.needUpdatorName();
        cais.needTypeDesc();
        cais.needSizeDesc();
        cais.needSizeInByte();
        this.acm.getComplexAttachmentInfo(attchID, cais);
        Sout.show("Get is OK");
    }

    private String testAddNewFileAtClient() throws Exception {
        File f = this.acm.chooseFileByDialog((Component)((Object)this));
        String attchID = this.acm.addNewAttachment("c7437c8d-0104-1000-e000-010bc0a8128bBCC89432", f);
        return attchID;
    }

    private String testAddNewFileAtClientWithCode() throws Exception {
        File f = this.acm.chooseFileByDialog((Component)((Object)this));
        String attchID = this.acm.addNewAttachment("c7437c8d-0104-1000-e000-010bc0a8128bBCC89432", f, "toounformal");
        return attchID;
    }

    private String testAddNewFile() throws Exception {
        String boID = "c7437c8d-0104-1000-e000-010bc0a8128bBCC89432";
        File file = new File("d:/temp/K3.IE.Ctrl.exe");
        SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
        sai.setMainName(StringUtil4File.getMainFileName(file.getName()));
        sai.setExtName(StringUtil4File.getExtendedFileName(file.getName()));
        sai.setContent(FileGetter.getBytesFromFile(file));
        return this.acm.addNewAttachment(boID, sai);
    }

    private String testAddURL() throws Exception {
        String boID = "c7437c8d-0104-1000-e000-010bc0a8128bBCC89432";
        String url = "http://www.mysap.com/china/shenzhen/HowToKillOracle.doc";
        SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
        sai.setMainName(url);
        sai.setExtName("url");
        String attchID = this.acm.addNewAttachment(boID, sai);
        return attchID;
    }

    private void testUpdateName() throws Exception {
        String attchID = "4c799359-0105-1000-e000-0349c0a8128bF4AF4F03";
        String boID = "c7437c8d-0104-1000-e000-010bc0a8128bBCC89432";
        String name = "userconfig";
        this.acm.updateAttachmentMainName(attchID, boID, name);
    }

    private void testUpdateDescription() throws Exception {
        String attchID = "4c799359-0105-1000-e000-0349c0a8128bF4AF4F03";
        String desc = "Java to Python";
        this.acm.updateAttachmentDescription(attchID, desc);
    }

    private void testUpdateContent() throws Exception {
        String attchID = "4c799359-0105-1000-e000-032ec0a8128bF4AF4F03";
        byte[] content = FileGetter.getBytesFromFile(new File("d:/temp/xyz.doc"));
        this.acm.updateAttachmentContent(attchID, content);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return BizobjectEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BizobjectFactory.getRemoteInstance();
    }

    @Override
    public void actionShowAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionShowAttachment_actionPerformed(e);
        String boID = this.getSelectedKeyValue();
        AttachmentManagerFactory.getClientManager().showAttachmentListUIByBoID(boID, (Object)this);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            try {
                String boID = this.getSelectedKeyValue();
                this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())));
                AttachmentManagerFactory.getClientManager().deleteAttachemtsByBoID(boID);
            }
            catch (ObjectNotFoundException onfe) {
                this.logger.info((Object)"", (Throwable)onfe);
                this.refreshList();
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            this.refresh(e);
        }
    }
}

