/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.client;

import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.ConvertServerConfigFactory;
import com.kingdee.eas.base.attachment.ConvertServerConfigInfo;
import com.kingdee.eas.base.attachment.IConvertServerConfig;
import com.kingdee.eas.base.attachment.client.AbstractConvertConfigEditUI;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ConvertConfigEditUI
extends AbstractConvertConfigEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ConvertConfigEditUI.class);
    private ConvertServerConfigInfo convertConfig;

    public void onLoad() throws Exception {
        boolean status;
        super.onLoad();
        IConvertServerConfig convertServerConfigFactory = ConvertServerConfigFactory.getRemoteInstance();
        this.convertConfig = convertServerConfigFactory.getConfig();
        if (this.convertConfig == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.attachment.AttachmentResources", (String)"ConvertConfigError"));
            return;
        }
        if (this.convertConfig.getHost() != null) {
            this.txtHost.setText(this.convertConfig.getHost());
        }
        if (this.convertConfig.getPort() != null) {
            this.txtPort.setText(this.convertConfig.getPort());
        }
        this.txtTimeout.setText(String.valueOf(this.convertConfig.getTimeout()));
        this.txtFromPage.setText(String.valueOf(this.convertConfig.getFromPage()));
        if (this.convertConfig.getToPage() != 0) {
            this.txtToPage.setText(String.valueOf(this.convertConfig.getToPage()));
        }
        if (status = this.convertConfig.isStatus()) {
            this.kDRbtnEnable.setSelected(true);
        } else {
            this.kDRbtnDisable.setSelected(true);
        }
        this.cancelBtn.setEnabled(true);
        this.okBtn.setEnabled(true);
        this.kDRbtnEnable.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KDRadioButton _kDRbtnEnable = (KDRadioButton)e.getSource();
                if (_kDRbtnEnable.isSelected()) {
                    // empty if block
                }
            }
        });
        this.kDRbtnDisable.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KDRadioButton _kDRbtnDisable = (KDRadioButton)e.getSource();
                if (_kDRbtnDisable.isSelected()) {
                    // empty if block
                }
            }
        });
        if (!Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK((BOSUuid)SysContext.getSysContext().getCurrentUserInfo().get("id")))) {
            this.txtHost.setEnabled(false);
            this.txtPort.setEnabled(false);
            this.txtTimeout.setEditable(false);
            this.txtFromPage.setEditable(false);
            this.txtToPage.setEditable(false);
            this.kDRbtnEnable.setEnabled(false);
            this.kDRbtnDisable.setEnabled(false);
            this.okBtn.setEnabled(false);
        }
    }

    protected void checkServerConfig() {
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void kDRbtnEnable_actionPerformed(ActionEvent e) throws Exception {
        super.kDRbtnEnable_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudFeed_actionPerformed(e);
    }

    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudShare_actionPerformed(e);
    }

    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudScreen_actionPerformed(e);
    }

    public void actionXunTongFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionXunTongFeed_actionPerformed(e);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        String timeout;
        ConvertServerConfigInfo csci = new ConvertServerConfigInfo();
        String host = this.txtHost.getText();
        String port = this.txtPort.getText();
        if (!StringUtils.isEmpty((String)host) || !StringUtils.isEmpty((String)port)) {
            if (!this.checkHostConfig(host, port)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.attachment.AttachmentResources", (String)"ConvertConfigError"));
                return;
            }
            csci.setHost(host);
            csci.setPort(port);
        }
        if ((timeout = this.txtTimeout.getText()) != null && !timeout.equals("")) {
            if (!ConvertConfigEditUI.checkNumber(timeout)) {
                this.txtTimeout.requestFocusInWindow();
                return;
            }
            csci.setTimeout(Integer.parseInt(timeout));
        } else {
            csci.setTimeout(200);
        }
        String fromPage = this.txtFromPage.getText();
        if (fromPage != null && !fromPage.equals("")) {
            if (!ConvertConfigEditUI.checkNumber(fromPage)) {
                this.txtFromPage.requestFocusInWindow();
                return;
            }
            csci.setFromPage(Integer.parseInt(fromPage));
        } else {
            csci.setFromPage(1);
        }
        String toPage = this.txtToPage.getText();
        if (toPage != null && !toPage.equals("")) {
            if (!ConvertConfigEditUI.checkNumber(toPage)) {
                this.txtToPage.requestFocusInWindow();
                return;
            }
            csci.setToPage(Integer.parseInt(toPage));
        } else {
            csci.setToPage(0);
        }
        if (csci.getToPage() != 0 && csci.getToPage() < csci.getFromPage()) {
            this.txtToPage.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.attachment.AttachmentResources", (String)"ConvertConfigError"));
            return;
        }
        if (this.kDRbtnEnable.isSelected()) {
            csci.setStatus(true);
        } else {
            csci.setStatus(false);
        }
        IConvertServerConfig convertServerConfigFactory = ConvertServerConfigFactory.getRemoteInstance();
        convertServerConfigFactory.updateConfig(csci);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.attachment.AttachmentResources", (String)"savesuccess"));
        super.destroyWindow();
    }

    private static boolean checkNumber(String testStr) {
        Pattern p = Pattern.compile("^\\+?[1-9][0-9]*$");
        Matcher m = p.matcher(testStr.trim());
        if (testStr.length() > 5 || !m.matches()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.attachment.AttachmentResources", (String)"ConvertConfigError"));
            return false;
        }
        return true;
    }

    private boolean checkHostConfig(String host, String port) {
        Pattern p = Pattern.compile("(2(5[0-5]{1}|[0-4]\\d{1})|[0-1]?\\d{1,2})(\\.(2(5[0-5]{1}|[0-4]\\d{1})|[0-1]?\\d{1,2})){3}");
        if (StringUtils.isEmpty((String)host) || host.length() > 20 || !p.matcher(host).matches()) {
            this.txtHost.requestFocusInWindow();
            return false;
        }
        if (StringUtils.isEmpty((String)port) || port.length() > 5 || !ConvertConfigEditUI.checkNumber(port)) {
            this.txtPort.requestFocusInWindow();
            return false;
        }
        return true;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.destroyWindow();
    }

    public static void main(String[] args) {
        Pattern p = Pattern.compile("(2(5[0-5]{1}|[0-4]\\d{1})|[0-1]?\\d{1,2})(\\.(2(5[0-5]{1}|[0-4]\\d{1})|[0-1]?\\d{1,2})){3}");
        String a = "256.1.1.1";
        System.out.println(p.matcher(a).matches());
    }
}

