/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.client;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.attachment.FtpConfigFactory;
import com.kingdee.eas.base.attachment.FtpConfigHelper;
import com.kingdee.eas.base.attachment.FtpConfigInfo;
import com.kingdee.eas.base.attachment.FtpHandleFacadeFactory;
import com.kingdee.eas.base.attachment.client.AbstractFtpConfigEditUI;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class FtpConfigEditUI
extends AbstractFtpConfigEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FtpConfigEditUI.class);
    private static final String attachmentRes = "com.kingdee.eas.base.attachment.AttachmentResources";
    private boolean isSubmit = false;
    FtpConfigInfo oldEditData;

    public void onLoad() throws Exception {
        super.onLoad();
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            this.oldEditData = (FtpConfigInfo)this.editData.clone();
            if (this.oldEditData.getRootPath() == null) {
                this.oldEditData.setRootPath("");
            }
            if (this.oldEditData.getHost() == null) {
                this.oldEditData.setHost("");
            }
        }
        this.btnSFTP.setText("SFTP");
    }

    @Override
    protected void btnTestLink_actionPerformed(ActionEvent e) throws Exception {
        this.testLink();
    }

    private void testLink() {
        try {
            FtpConfigInfo ftpConfigInfo = new FtpConfigInfo();
            String userName = new String(this.txtUserName.getText());
            String password = new String(this.txtPassword.getPassword());
            ftpConfigInfo.setHost(this.txtHost.getText());
            ftpConfigInfo.setPort(Integer.parseInt(this.txtPort.getText()));
            ftpConfigInfo.setUserName(userName);
            ftpConfigInfo.setSftpStatus(this.btnSFTP.getSelectState());
            if (!OprtState.ADDNEW.equals(this.getOprtState())) {
                if (this.editData.getPassword() == null || this.editData.getPassword() != null && !this.editData.getPassword().equals(password)) {
                    ftpConfigInfo.setPassword(password);
                } else {
                    ftpConfigInfo.setPassword(CryptoTean.decrypt((String)this.editData.getUserName(), (String)this.editData.getPassword()));
                }
            } else {
                ftpConfigInfo.setPassword(password);
            }
            boolean isSuccess = FtpHandleFacadeFactory.getRemoteInstance().testConnection(ftpConfigInfo);
            if (isSuccess) {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"ConnectSuccess"));
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"ConnectFail"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"ConnectFail"));
        }
    }

    @Override
    public void storeFields() {
        boolean isPasswordChange = false;
        String password = new String(this.txtPassword.getPassword());
        if (this.editData.getPassword() == null || this.editData.getPassword() != null && !this.editData.getPassword().equals(password)) {
            isPasswordChange = true;
        }
        super.storeFields();
        String userName = this.txtUserName.getText();
        if (this.isSubmit) {
            try {
                if (isPasswordChange) {
                    this.editData.setPassword(CryptoTean.encrypt((String)userName, (String)password));
                } else {
                    String d_password = CryptoTean.decrypt((String)userName, (String)password);
                    this.editData.setPassword(CryptoTean.encrypt((String)userName, (String)d_password));
                }
            }
            catch (CryptException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.isSubmit = true;
        if (!this.addVerify()) {
            return;
        }
        if (OprtState.EDIT.equals(this.getOprtState()) && FtpConfigHelper.FtpIsUsed(null, this.editData.getId().toString()) && !this.editVerify()) {
            return;
        }
        super.actionSubmit_actionPerformed(e);
        this.isSubmit = false;
    }

    private boolean isEmpty(Object o) {
        return o == null || o.toString().trim().length() == 0;
    }

    private boolean addVerify() {
        if (this.isEmpty(this.txtName.getSelectedItemData())) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"NameNotNull"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtHost.getText())) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"HostNotNull"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtPort.getText())) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"PortNotNull"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtUserName.getText())) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"UserNameNotNull"));
            return false;
        }
        return true;
    }

    private boolean editVerify() {
        if (this.txtHost.getText() != null && !this.txtHost.getText().equals(this.oldEditData.getHost())) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"CanNotEditHost"));
            return false;
        }
        if (this.txtPort.getText() != null && !this.txtPort.getText().equals(Integer.toString(this.oldEditData.getPort()))) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"CanNotEditPort"));
            return false;
        }
        if (this.txtRootPath.getText() != null && !this.txtRootPath.getText().equals(this.oldEditData.getRootPath())) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"CanNotEditRootPath"));
            return false;
        }
        return true;
    }

    protected IObjectValue createNewData() {
        return new FtpConfigInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FtpConfigFactory.getRemoteInstance();
    }

    public boolean destroyWindow() {
        return super.destroyWindow();
    }
}

