/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.eas.base.attachment.AttachmentSizeFactory;
import com.kingdee.eas.base.attachment.IAttachmentSize;
import com.kingdee.eas.base.attachment.client.FileInfo;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;

public class NewSelector
implements KDPromptSelector {
    private KDFileChooser fc = new KDFileChooser(System.getProperty("user.home"));
    private int retVal;
    private File retFile;
    private Component parentComp;

    public NewSelector(Component parentComp) {
        this.fc.setFileSelectionMode(0);
        this.fc.setMultiSelectionEnabled(false);
        this.parentComp = parentComp;
    }

    public void show() {
        boolean isFileValid = false;
        while (!isFileValid) {
            this.retVal = this.fc.showOpenDialog(this.parentComp);
            if (this.retVal == 1) break;
            this.retFile = this.fc.getSelectedFile();
            if (this.retFile.exists()) {
                try {
                    IAttachmentSize attachmentFactory = AttachmentSizeFactory.getRemoteInstance();
                    double attSize = attachmentFactory.getFileSize();
                    double maxFileSize = attSize * 1024.0 * 1024.0;
                    if ((double)this.retFile.length() < maxFileSize) {
                        isFileValid = true;
                        continue;
                    }
                    String s = Resrcs.getString("FileSizeNotAllowed");
                    MessageFormat mf = new MessageFormat(s);
                    String result = mf.format(new String[]{String.valueOf(attSize)});
                    MsgBox.showInfo((String)result);
                    this.retFile = null;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                continue;
            }
            MsgBox.showInfo((String)Resrcs.getString("FileNotExisted"));
            this.retFile = null;
        }
    }

    public boolean isCanceled() {
        boolean hasBeenCanceled = true;
        if (this.retVal == 0) {
            hasBeenCanceled = false;
        }
        return hasBeenCanceled;
    }

    public Object getData() {
        String fullname = this.retFile.getName().trim();
        return new FileInfo(this.retFile, StringUtil4File.getMainFileName(fullname), StringUtil4File.getExtendedFileName(fullname));
    }
}

