/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.attachment.ObsConfigFactory;
import com.kingdee.eas.base.attachment.ObsConfigHelper;
import com.kingdee.eas.base.attachment.ObsConfigInfo;
import com.kingdee.eas.base.attachment.ObsHandleFacadeFactory;
import com.kingdee.eas.base.attachment.client.AbstractObsConfigEditUI;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ObsConfigEditUI
extends AbstractObsConfigEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ObsConfigEditUI.class);
    private static final String attachmentRes = "com.kingdee.eas.base.attachment.AttachmentResources";
    private boolean isSubmit = false;
    ObsConfigInfo oldEditData;

    public void onLoad() throws Exception {
        super.onLoad();
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            if (ObsConfigHelper.ObsIsUsed(null, this.editData.getId().toString())) {
                this.contName.setEnabled(false);
                this.contEndpoint.setEnabled(false);
                this.contObsBucketName.setEnabled(false);
            }
            this.oldEditData = (ObsConfigInfo)this.editData.clone();
            if (this.oldEditData.getObsBucketName() == null) {
                this.oldEditData.setObsBucketName("");
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        block4: {
            this.isSubmit = true;
            if (!this.addVerify()) {
                return;
            }
            if (OprtState.EDIT.equals(this.getOprtState()) && ObsConfigHelper.ObsIsUsed(null, this.editData.getId().toString()) && !this.editVerify()) {
                return;
            }
            try {
                super.actionSubmit_actionPerformed(e);
            }
            catch (BOSException e2) {
                if (!e2.getMessage().contains("JDKISNOTALLOW")) break block4;
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"CanNotAllowJDK"));
            }
        }
        this.isSubmit = false;
    }

    private boolean isEmpty(Object o) {
        return o == null || o.toString().trim().length() == 0;
    }

    private boolean addVerify() {
        if (this.isEmpty(this.txtName.getSelectedItemData())) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"ObsNameNotNull"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtAccessKeyId.getText())) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"AkNotNull"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtAccessKeySecret.getText())) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"SkNotNull"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtEndpoint.getText())) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"EndPointNotNull"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtObsBucketName.getText())) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"ObsBucketNameNotNull"));
            return false;
        }
        return true;
    }

    private boolean editVerify() {
        if (this.txtEndpoint.getText() != null && !this.txtEndpoint.getText().equals(this.oldEditData.getEndpoint())) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"CanNotEditEndPoint"));
            return false;
        }
        if (this.txtObsBucketName.getText() != null && !this.txtObsBucketName.getText().equals(this.oldEditData.getObsBucketName())) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"CanNotEditObsBucketName"));
            return false;
        }
        return true;
    }

    protected IObjectValue createNewData() {
        return new ObsConfigInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ObsConfigFactory.getRemoteInstance();
    }

    public boolean destroyWindow() {
        return super.destroyWindow();
    }

    @Override
    protected void btnTestLink_actionPerformed(ActionEvent e) throws Exception {
        this.testLink();
    }

    private void testLink() {
        try {
            ObsConfigInfo obsConfigInfo = new ObsConfigInfo();
            String accessKeyId = new String(this.txtAccessKeyId.getText());
            String accessKeySecret = new String(this.txtAccessKeySecret.getPassword());
            String endPoint = new String(this.txtEndpoint.getText());
            String obsBucketName = new String(this.txtObsBucketName.getText());
            obsConfigInfo.setAccessKeyId(accessKeyId);
            obsConfigInfo.setEndpoint(endPoint);
            obsConfigInfo.setObsBucketName(obsBucketName);
            if (!OprtState.ADDNEW.equals(this.getOprtState())) {
                if (this.editData.getAccessKeySecret() == null || this.editData.getAccessKeySecret() != null && !this.editData.getAccessKeySecret().equals(accessKeySecret)) {
                    obsConfigInfo.setAccessKeySecret(accessKeySecret);
                } else {
                    obsConfigInfo.setAccessKeySecret(CryptoTean.decrypt((String)this.editData.getId().toString(), (String)this.editData.getAccessKeySecret()));
                }
            } else {
                obsConfigInfo.setAccessKeySecret(accessKeySecret);
            }
            boolean isSuccess = ObsHandleFacadeFactory.getRemoteInstance().testConnection(obsConfigInfo);
            if (isSuccess) {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"ObsConnectSuccess"));
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"ConnectFail"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"ConnectFail"));
        }
    }
}

