/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.attachment.FtpStatusEnum;
import com.kingdee.eas.base.attachment.IObsConfig;
import com.kingdee.eas.base.attachment.ObsConfigCollection;
import com.kingdee.eas.base.attachment.ObsConfigFactory;
import com.kingdee.eas.base.attachment.ObsConfigHelper;
import com.kingdee.eas.base.attachment.ObsConfigInfo;
import com.kingdee.eas.base.attachment.ObsHandleFacadeFactory;
import com.kingdee.eas.base.attachment.ObsStatusEnum;
import com.kingdee.eas.base.attachment.client.AbstractObsConfigListUI;
import com.kingdee.eas.base.attachment.client.ObsConfigEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ObsConfigListUI
extends AbstractObsConfigListUI {
    private static final Logger logger = CoreUIObject.getLogger(ObsConfigListUI.class);
    private static final String attachmentRes = "com.kingdee.eas.base.attachment.AttachmentResources";

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void onLoad() throws Exception {
        ICell icell;
        super.onLoad();
        this.btnAttchMove.setEnabled(true);
        this.btnTestLink.setEnabled(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.btnEnabled.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnDisabled.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnTestLink.setIcon(EASResource.getIcon((String)"imgTbtn_cancelverification"));
        this.btnAttchMove.setIcon(EASResource.getIcon((String)"imgTbtn_cancelverification"));
        if (this.tblMain.getRow(0) != null && (icell = this.tblMain.getRow(0).getCell("status")) != null && icell.getValue() != null) {
            boolean enabled = icell.getValue().toString().equalsIgnoreCase(ObsStatusEnum.START.toString());
            this.changeWBTEnabeld(enabled);
        }
    }

    private void changeWBTEnabeld(boolean isEnabled) {
        this.btnEnabled.setEnabled(!isEnabled);
        this.btnDisabled.setEnabled(isEnabled);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.changeWBTEnabeld(this.statusIsEnabled());
        super.tblMain_tableClicked(e);
    }

    private boolean statusIsEnabled() {
        ICell icell;
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            return false;
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex != -1 && (icell = this.tblMain.getRow(rowIndex).getCell("status")) != null && icell.getValue() != null) {
            return icell.getValue().toString().equalsIgnoreCase(FtpStatusEnum.START.toString());
        }
        return false;
    }

    @Override
    public void actionEnabled_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ICell icell = this.tblMain.getRow(rowIndex).getCell("id");
        if (icell != null && icell.getValue() != null) {
            String obsConfigId = icell.getValue().toString();
            if (this.enabledObs(obsConfigId)) {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"EnabledSuccess"));
                this.changeWBTEnabeld(true);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"EnabledFail"));
            }
        }
        this.refresh(e);
    }

    private boolean enabledObs(String obsConfigId) throws Exception {
        String oql;
        IObsConfig iObsConfig = ObsConfigFactory.getRemoteInstance();
        ObsConfigCollection coll = iObsConfig.getObsConfigCollection(oql = "select id where status = 1");
        if (coll == null || coll.size() == 0) {
            ObjectUuidPK pk = new ObjectUuidPK(obsConfigId);
            ObsConfigInfo obsConfigInfo = iObsConfig.getObsConfigInfo((IObjectPK)pk);
            obsConfigInfo.setStatus(ObsStatusEnum.START);
            iObsConfig.update((IObjectPK)pk, obsConfigInfo);
            return true;
        }
        logger.info((Object)"other ftp is started");
        return false;
    }

    @Override
    public void actionDisabled_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ICell icell = this.tblMain.getRow(rowIndex).getCell("id");
        if (icell != null && icell.getValue() != null) {
            String obsConfigId = icell.getValue().toString();
            if (this.disabledFtp(obsConfigId)) {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"DisabledSuccess"));
                this.changeWBTEnabeld(false);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"DisabledFail"));
            }
        }
        this.refresh(e);
    }

    private boolean disabledFtp(String obsConfigId) throws Exception {
        IObsConfig iObsConfig = ObsConfigFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(obsConfigId);
        ObsConfigInfo obsConfigInfo = iObsConfig.getObsConfigInfo((IObjectPK)pk);
        obsConfigInfo.setStatus(ObsStatusEnum.STOP);
        iObsConfig.update((IObjectPK)pk, obsConfigInfo);
        return true;
    }

    @Override
    public void actionTestLink_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ICell icellID = this.tblMain.getRow(rowIndex).getCell("id");
        ICell icellAk = this.tblMain.getRow(rowIndex).getCell("accessKeyId");
        ICell icellSk = this.tblMain.getRow(rowIndex).getCell("accessKeySecret");
        ICell icellEndPoint = this.tblMain.getRow(rowIndex).getCell("endpoint");
        ICell icellObsBucketName = this.tblMain.getRow(rowIndex).getCell("obsBucketName");
        if (icellAk == null || icellAk.getValue() == null || icellSk == null || icellSk.getValue() == null || icellEndPoint == null || icellEndPoint.getValue() == null || icellObsBucketName == null || icellObsBucketName.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"ConnectFail"));
            return;
        }
        try {
            ObsConfigInfo obsConfigInfo = new ObsConfigInfo();
            obsConfigInfo.setAccessKeyId(icellAk.getValue().toString());
            obsConfigInfo.setAccessKeySecret(CryptoTean.decrypt((String)icellID.getValue().toString(), (String)icellSk.getValue().toString()));
            obsConfigInfo.setEndpoint(icellEndPoint.getValue().toString());
            obsConfigInfo.setObsBucketName(icellObsBucketName.getValue().toString());
            boolean isSuccess = ObsHandleFacadeFactory.getRemoteInstance().testConnection(obsConfigInfo);
            if (isSuccess) {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"ObsConnectSuccess"));
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"ConnectFail"));
            }
        }
        catch (Exception e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"ConnectFail"));
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.statusIsEnabled()) {
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"StartCanNotEdit"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String obsConfigId;
        ICell icell;
        if (this.statusIsEnabled()) {
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"StartCanNotRemove"));
            return;
        }
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex != -1 && (icell = this.tblMain.getRow(rowIndex).getCell("id")) != null && icell.getValue() != null && ObsConfigHelper.ObsIsUsed(null, obsConfigId = icell.getValue().toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"CanNotRemove"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    protected String getEditUIName() {
        return ObsConfigEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ObsConfigFactory.getRemoteInstance();
    }

    @Override
    public void actionAttchMove_actionPerformed(ActionEvent e) throws Exception {
        MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"CanNotAttachRemove"));
    }
}

