/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.FtpStatusEnum;
import com.kingdee.eas.base.attachment.IServerConfig;
import com.kingdee.eas.base.attachment.ServerConfigCollection;
import com.kingdee.eas.base.attachment.ServerConfigFactory;
import com.kingdee.eas.base.attachment.ServerConfigInfo;
import com.kingdee.eas.base.attachment.client.AbstractServerConfigListUI;
import com.kingdee.eas.base.attachment.client.AttchMoveReadyUI;
import com.kingdee.eas.base.attachment.client.ServerConfigEditUI;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ServerConfigListUI
extends AbstractServerConfigListUI {
    private static final Logger logger = CoreUIObject.getLogger(ServerConfigListUI.class);
    private static final String attachmentRes = "com.kingdee.eas.base.attachment.AttachmentResources";

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void onLoad() throws Exception {
        ICell icell;
        super.onLoad();
        this.btnAttchMove.setIcon(EASResource.getIcon((String)"imgTbtn_cancelverification"));
        this.tblMain.getSelectManager().setSelectMode(2);
        if (this.tblMain.getRow(0) != null && (icell = this.tblMain.getRow(0).getCell("status")) != null && icell.getValue() != null) {
            boolean enabled = icell.getValue().toString().equalsIgnoreCase(FtpStatusEnum.START.toString());
            this.changeWBTEnabeld(enabled);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ServerConfigFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return ServerConfigEditUI.class.getName();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.changeWBTEnabeld(this.statusIsEnabled());
        super.tblMain_tableClicked(e);
    }

    private boolean statusIsEnabled() {
        ICell icell;
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            return false;
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex != -1 && (icell = this.tblMain.getRow(rowIndex).getCell("status")) != null && icell.getValue() != null) {
            return icell.getValue().toString().equalsIgnoreCase(FtpStatusEnum.START.toString());
        }
        return false;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ICell icell = this.tblMain.getRow(rowIndex).getCell("id");
        if (icell != null && icell.getValue() != null) {
            String serverConfigId = icell.getValue().toString();
            String number = "";
            if (this.tblMain.getRow(rowIndex).getCell("number") != null) {
                number = this.tblMain.getRow(rowIndex).getCell("number").getValue().toString();
            }
            if (this.disableServer(serverConfigId)) {
                String logDetail = "\u7981\u7528\u7f16\u7801\u4e3a\uff1a" + number + "\u7684EAS\u76ee\u5f55\u914d\u7f6e";
                IObjectPK logPK = LogUtil.beginLog(null, (String)"actionAddNewUser", (BOSObjectType)new AttachmentInfo().getBOSType(), null, (String)logDetail, (String)"manual_default_logitem");
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"DisabledSuccess"));
                this.changeWBTEnabeld(false);
                LogUtil.afterLog(null, (IObjectPK)logPK);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"DisabledFail"));
            }
        }
        this.refresh(e);
    }

    private boolean disableServer(String serverConfigId) throws Exception {
        IServerConfig iServerConfig = ServerConfigFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(serverConfigId);
        ServerConfigInfo serverConfigInfo = iServerConfig.getServerConfigInfo((IObjectPK)pk);
        serverConfigInfo.setStatus(FtpStatusEnum.STOP);
        iServerConfig.update((IObjectPK)pk, serverConfigInfo);
        return true;
    }

    private boolean enabledServer(String serverConfigId) throws Exception {
        String oql;
        IServerConfig iServerConfig = ServerConfigFactory.getRemoteInstance();
        ServerConfigCollection coll = iServerConfig.getServerConfigCollection(oql = "select id where status = 1");
        if (coll == null || coll.size() == 0) {
            ObjectUuidPK pk = new ObjectUuidPK(serverConfigId);
            ServerConfigInfo serverConfigInfo = iServerConfig.getServerConfigInfo((IObjectPK)pk);
            serverConfigInfo.setStatus(FtpStatusEnum.START);
            iServerConfig.update((IObjectPK)pk, serverConfigInfo);
            return true;
        }
        logger.info((Object)"other easserver is started");
        return false;
    }

    private void changeWBTEnabeld(boolean isEnabled) {
        this.btnCancelCancel.setEnabled(!isEnabled);
        this.btnCancel.setEnabled(isEnabled);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ICell icell = this.tblMain.getRow(rowIndex).getCell("id");
        if (icell != null && icell.getValue() != null) {
            String serverConfigId = icell.getValue().toString();
            String number = "";
            if (this.tblMain.getRow(rowIndex).getCell("number") != null) {
                number = this.tblMain.getRow(rowIndex).getCell("number").getValue().toString();
            }
            if (this.enabledServer(serverConfigId)) {
                String logDetail = "\u542f\u7528\u7f16\u7801\u4e3a\uff1a" + number + "\u7684EAS\u76ee\u5f55\u914d\u7f6e";
                IObjectPK logPK = LogUtil.beginLog(null, (String)"actionAddNewUser", (BOSObjectType)new AttachmentInfo().getBOSType(), null, (String)logDetail, (String)"manual_default_logitem");
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"EnabledSuccess"));
                this.changeWBTEnabeld(true);
                LogUtil.afterLog(null, (IObjectPK)logPK);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"EnabledFail"));
            }
        }
        this.refresh(e);
    }

    @Override
    public void actionAttchMove_actionPerformed(ActionEvent e) throws Exception {
        AttchMoveReadyUI attchMoveReadyUI = new AttchMoveReadyUI();
        attchMoveReadyUI.getUIContext().put("AttchMoveType", 1);
        attchMoveReadyUI.show();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.statusIsEnabled()) {
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"StartCanNotEdit"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.statusIsEnabled()) {
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"StartCanNotRemove"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }
}

