/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.client.scan;

import com.kingdee.eas.base.attachment.client.scan.JTwain;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class JTwacker
extends JFrame {
    protected JPEGPanel mJpegPanel = new JPEGPanel();
    protected BufferedImage mBufferedImage;
    protected JComboBox mSourcesCombo;
    protected JToolBar mToolBar;

    public JTwacker() {
        super(EASResource.getString((String)"com.kingdee.eas.base.attachment.ATTACHMENTAutoGenerateResource", (String)"5_JTwacker"));
        JScrollPane ps = new JScrollPane(this.mJpegPanel, 22, 32);
        this.getContentPane().add((Component)ps, "Center");
        WindowAdapter wndCloser = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        this.addWindowListener(wndCloser);
        this.mToolBar = new JToolBar("Twain");
        this.mToolBar.setFloatable(false);
        this.addButtons();
        this.getContentPane().add((Component)this.mToolBar, "North");
        this.setSize(800, 600);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frameDim = this.getBounds();
        this.setLocation((screenDim.width - frameDim.width) / 2, (screenDim.height - frameDim.height) / 2);
        this.setVisible(true);
    }

    protected void addButtons() {
        JButton _ab = new JButton("\u626b\u951f\u65a4\u62f7");
        _ab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTwacker.this.acquireImage();
            }
        });
        this.mToolBar.add(_ab);
        this.mToolBar.addSeparator();
        if (JTwain.getInstance().isTwainAvailble()) {
            String[] twainSources = JTwain.getInstance().getAvailableSources();
            if (twainSources != null) {
                this.mSourcesCombo = new JComboBox<String>(twainSources);
            } else {
                this.mSourcesCombo = new JComboBox();
                this.mSourcesCombo.addItem("<NONE AVAILABLE>");
            }
        } else {
            this.mSourcesCombo = new JComboBox();
            this.mSourcesCombo.addItem("<NONE AVAILABLE>");
        }
        this.mToolBar.add(this.mSourcesCombo);
    }

    protected void acquireImage() {
        String _filename;
        String _source;
        if (JTwain.getInstance().isTwainAvailble() && this.mSourcesCombo.getItemCount() > 0 && (_source = (String)this.mSourcesCombo.getSelectedItem()) != null && (_filename = JTwain.getInstance().acquire(_source, this)) != null && _filename.length() > 0) {
            File fChoosen = new File(_filename);
            this.showImage(fChoosen);
        }
    }

    protected void showImage(final File file) {
        if (file == null || !file.exists()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Thread runner = new Thread(){

            @Override
            public void run() {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    JTwacker.this.mBufferedImage = ImageIO.read(in);
                    in.close();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JTwacker.this.reset();
                        }
                    });
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                JTwacker.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        runner.start();
    }

    protected void reset() {
        if (this.mBufferedImage != null) {
            this.mJpegPanel.setBufferedImage(this.mBufferedImage);
        }
    }

    public static void main(String[] argv) {
        new JTwacker();
    }

    class JPEGPanel
    extends JPanel {
        protected BufferedImage mJPEGPanelBufferedImage;

        public void setBufferedImage(BufferedImage bi) {
            if (bi == null) {
                return;
            }
            this.mJPEGPanelBufferedImage = bi;
            Dimension d = new Dimension(this.mJPEGPanelBufferedImage.getWidth(this), this.mJPEGPanelBufferedImage.getHeight(this));
            this.setPreferredSize(d);
            this.revalidate();
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension d = this.getSize();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, d.width, d.height);
            if (this.mJPEGPanelBufferedImage != null) {
                g.drawImage(this.mJPEGPanelBufferedImage, 0, 0, this);
            }
        }
    }
}

