/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.ftp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentObsFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentSizeFactory;
import com.kingdee.eas.base.attachment.IAttachmentFtpFacade;
import com.kingdee.eas.base.attachment.IAttachmentSize;
import com.kingdee.eas.base.attachment.ServerConfigHelper;
import com.kingdee.eas.base.attachment.common.AttachmentHelper;
import com.kingdee.eas.base.attachment.ftp.AttachmentFtpInfo;
import com.kingdee.eas.base.attachment.obs.AttachmentObsInfo;
import com.kingdee.eas.base.attachment.util.AttachmentEncryptUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class AttachmentUploadClient {
    Logger logger = Logger.getLogger(AttachmentUploadClient.class);
    IAttachmentFtpFacade iAttachmentFacade = null;
    private Context context = null;

    public AttachmentUploadClient(IAttachmentFtpFacade attachmentFacade) {
        this.iAttachmentFacade = attachmentFacade;
    }

    public String uploadFile4Client(byte[] content) throws BOSException, EASBizException {
        return this.uploadFile4Client(new ByteArrayInputStream(content));
    }

    private void checkInterface() throws BOSException {
        if (this.iAttachmentFacade == null) {
            this.logger.info((Object)"iAttachmentFacade is null, iAttachmentFacade must be set !");
            throw new BOSException("iAttachmentFacade is null!");
        }
    }

    public String uploadFile4Client(InputStream input) throws BOSException, EASBizException {
        return this.uploadFile4Client(null, input);
    }

    public String uploadFile4Client(String lockFilePath, InputStream input) throws BOSException, EASBizException {
        if (StringUtils.equalsIgnoreCase((String)"3", (String)AttachmentHelper.getParam(this.getContext()))) {
            return this.uploadFile4ClientByObs(null, lockFilePath, input);
        }
        return this.uploadFile4Client(null, lockFilePath, input);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String uploadFile4ClientByObs(String path, String lockFilePath, InputStream input) throws BOSException, EASBizException {
        String tempFileName = path;
        try {
            int length;
            this.logger.info((Object)("......... begin deal upload file, max file size :" + AttachmentObsInfo.MAX_OF_UPLOAD_LENGTH));
            if (input == null) {
                return null;
            }
            AttachmentObsInfo obsInfo = null;
            boolean isInit = false;
            if (StringUtils.isEmpty((String)lockFilePath)) {
                lockFilePath = System.getProperty("user.home") + File.separator + "canuploadfile.loc";
            }
            File fw = null;
            do {
                if ((fw = new File(lockFilePath)).exists()) {
                    fw.delete();
                    throw new BOSException("stop upload");
                }
                if (!isInit) {
                    AttachmentObsInfo.init();
                    this.checkInterface();
                    isInit = true;
                }
                byte[] bf = null;
                bf = input.available() > AttachmentObsInfo.MAX_OF_UPLOAD_LENGTH ? new byte[AttachmentObsInfo.MAX_OF_UPLOAD_LENGTH] : new byte[input.available()];
                length = input.read(bf, 0, bf.length);
                this.logger.info((Object)("....... begin upload file ,size is:" + length + " fileName is:" + StringUtils.cnulls((String)tempFileName)));
                if (length == 0) return tempFileName;
                obsInfo = AttachmentObsFacadeFactory.getRemoteInstance().uploadFile(tempFileName, bf);
                if (obsInfo == null || tempFileName != null && tempFileName.trim().length() != 0) continue;
                tempFileName = obsInfo.getTempFileName();
            } while (length >= AttachmentObsInfo.MAX_OF_UPLOAD_LENGTH);
            return tempFileName;
        }
        catch (IOException e) {
            this.logger.info((Object)e);
            throw new BOSException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String uploadFile4Client(String path, String lockFilePath, InputStream input) throws BOSException, EASBizException {
        String tempFileName = path;
        try {
            int length;
            this.logger.info((Object)("......... begin deal upload file, max file size :" + AttachmentFtpInfo.MAX_OF_UPLOAD_LENGTH));
            if (input == null) {
                return null;
            }
            AttachmentFtpInfo ftpInfo = null;
            boolean isInit = false;
            if (StringUtils.isEmpty((String)lockFilePath)) {
                lockFilePath = System.getProperty("user.home") + File.separator + "canuploadfile.loc";
            }
            File fw = null;
            do {
                if ((fw = new File(lockFilePath)).exists()) {
                    fw.delete();
                    throw new BOSException("stop upload");
                }
                if (!isInit) {
                    AttachmentFtpInfo.init();
                    this.checkInterface();
                    isInit = true;
                }
                byte[] bf = null;
                bf = input.available() > AttachmentFtpInfo.MAX_OF_UPLOAD_LENGTH ? new byte[AttachmentFtpInfo.MAX_OF_UPLOAD_LENGTH] : new byte[input.available()];
                length = input.read(bf, 0, bf.length);
                this.logger.info((Object)("....... begin upload file ,size is:" + length + " fileName is:" + StringUtils.cnulls((String)tempFileName)));
                if (length == 0) return tempFileName;
                ftpInfo = this.iAttachmentFacade.uploadFile(tempFileName, bf);
                if (ftpInfo == null || tempFileName != null && tempFileName.trim().length() != 0) continue;
                tempFileName = ftpInfo.getTempFileName();
            } while (length >= AttachmentFtpInfo.MAX_OF_UPLOAD_LENGTH);
            return tempFileName;
        }
        catch (IOException e) {
            this.logger.info((Object)e);
            throw new BOSException(e.getMessage());
        }
    }

    public String uploadFile4Client(String path, String lockPath, byte[] content) throws EASBizException, BOSException {
        return this.uploadFile4Client(path, null, new ByteArrayInputStream(content));
    }

    public void uploadFile(String attachmentId, byte[] content) throws BOSException, EASBizException {
        if (StringUtils.equalsIgnoreCase((String)"0", (String)AttachmentHelper.getParam(null)) && content.length > 0x3200000) {
            throw new AttachmentException(AttachmentException.ATTACHOTHERSTORE);
        }
        if (StringUtils.equalsIgnoreCase((String)"2", (String)AttachmentHelper.getParam(null))) {
            String path = ServerConfigHelper.getEASServerPath(null, attachmentId);
            this.uploadFile4Client(path, null, content);
            ServerConfigHelper.saveServerPath(null, attachmentId, path);
        } else if (StringUtils.equalsIgnoreCase((String)"3", (String)AttachmentHelper.getParam(null))) {
            String fileName = this.uploadFile4Client(content);
            AttachmentObsFacadeFactory.getRemoteInstance().fileToDb4Server(fileName, attachmentId);
        } else {
            String fileName = this.uploadFile4Client(content);
            this.checkInterface();
            this.iAttachmentFacade.fileToDb4Server(fileName, attachmentId);
        }
    }

    public void uploadFile(Context ctx, String attachmentId, byte[] content) throws BOSException, EASBizException {
        if (StringUtils.equalsIgnoreCase((String)"0", (String)AttachmentHelper.getParam(ctx)) && content.length > 0x3200000) {
            throw new AttachmentException(AttachmentException.ATTACHOTHERSTORE);
        }
        if (StringUtils.equalsIgnoreCase((String)"2", (String)AttachmentHelper.getParam(ctx))) {
            String path = ServerConfigHelper.getEASServerPath(ctx, attachmentId);
            this.uploadFile4Client(path, null, content);
            ServerConfigHelper.saveServerPath(ctx, attachmentId, path);
        } else {
            String fileName = this.uploadFile4Client(content);
            this.checkInterface();
            this.iAttachmentFacade.fileToDb4Server(fileName, attachmentId);
        }
    }

    public void uploadFile(String attachmentId, InputStream input) throws BOSException, EASBizException {
        try {
            byte[] filesize = new byte[input.available()];
            input.read(filesize);
            this.uploadFile(attachmentId, filesize);
        }
        catch (IOException e) {
            this.logger.info((Object)e);
        }
    }

    public void uploadFile(Context ctx, String attachmentId, InputStream input) throws BOSException, EASBizException {
        try {
            byte[] filesize = new byte[input.available()];
            input.read(filesize);
            this.uploadFile(ctx, attachmentId, filesize);
        }
        catch (IOException e) {
            this.logger.info((Object)e);
        }
    }

    public void setIAttachmentFacade(IAttachmentFtpFacade attachmentFacade) {
        this.iAttachmentFacade = attachmentFacade;
    }

    public void uploadFile(String attachmentId, String fileUrl) throws BOSException, EASBizException {
        String fileName;
        File file;
        if (StringUtils.equalsIgnoreCase((String)"0", (String)AttachmentHelper.getParam(null)) && (file = new File(fileUrl)).length() > 0x3200000L) {
            throw new AttachmentException(AttachmentException.ATTACHOTHERSTORE);
        }
        if (StringUtils.equalsIgnoreCase((String)"2", (String)AttachmentHelper.getParam(null))) {
            String path = ServerConfigHelper.getEASServerPath(null, attachmentId);
            this.uploadFile4Client(path, null, fileUrl);
            ServerConfigHelper.saveServerPath(null, attachmentId, path);
        } else if (StringUtils.equalsIgnoreCase((String)"3", (String)AttachmentHelper.getParam(null))) {
            fileName = this.uploadFile4ClientByObs(null, null, fileUrl);
            AttachmentObsFacadeFactory.getRemoteInstance().fileToDb4Server(fileName, attachmentId);
        } else {
            fileName = this.uploadFile4Client(null, null, fileUrl);
            this.iAttachmentFacade.fileToDb4Server(fileName, attachmentId);
        }
    }

    public String uploadFile4ClientByObs(String serverFilePath, String lockFilePath, String localFilePath) throws EASBizException, BOSException {
        String tempFileName = serverFilePath;
        BufferedInputStream input = null;
        try {
            File fw;
            this.logger.info((Object)("......... begin deal upload file, max file size :" + AttachmentObsInfo.MAX_OF_UPLOAD_LENGTH));
            if (localFilePath == null) {
                String string = null;
                return string;
            }
            AttachmentObsInfo obsInfo = null;
            if (StringUtils.isEmpty((String)lockFilePath)) {
                lockFilePath = System.getProperty("user.home") + File.separator + "canuploadfile.loc";
            }
            if ((fw = new File(lockFilePath)).exists()) {
                fw.delete();
                throw new BOSException("stop upload");
            }
            AttachmentObsInfo.init();
            input = new BufferedInputStream(new FileInputStream(localFilePath));
            boolean isEncryptStatus = false;
            if (input != null) {
                try {
                    IAttachmentSize attachmentFactory = AttachmentSizeFactory.getRemoteInstance();
                    boolean isEncrypt = attachmentFactory.isAttachmentEncrypt();
                    if (isEncrypt) {
                        isEncryptStatus = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            int position = 0;
            int readSize = AttachmentObsInfo.MAX_OF_UPLOAD_LENGTH;
            int totalSize = input.available();
            int n = readSize = readSize < totalSize ? readSize : totalSize;
            while (position < totalSize) {
                byte[] bf = new byte[readSize];
                if (isEncryptStatus) {
                    try {
                        bf = AttachmentEncryptUtil.encrypt(bf);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                input.read(bf, 0, readSize);
                obsInfo = AttachmentObsFacadeFactory.getRemoteInstance().uploadFile(tempFileName, bf);
                if (obsInfo != null && (tempFileName == null || tempFileName.trim().length() == 0)) {
                    tempFileName = obsInfo.getTempFileName();
                }
                readSize = totalSize - (position += readSize) < readSize ? totalSize - position : readSize;
            }
        }
        catch (IOException e) {
            this.logger.info((Object)e);
            throw new BOSException(e.getMessage());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)e);
                }
            }
        }
        return tempFileName;
    }

    public void uploadFile(Context ctx, String attachmentId, String fileUrl) throws BOSException, EASBizException {
        File file;
        if (StringUtils.equalsIgnoreCase((String)"0", (String)AttachmentHelper.getParam(ctx)) && (file = new File(fileUrl)).length() > 0x3200000L) {
            throw new AttachmentException(AttachmentException.ATTACHOTHERSTORE);
        }
        if (StringUtils.equalsIgnoreCase((String)"2", (String)AttachmentHelper.getParam(ctx))) {
            String path = ServerConfigHelper.getEASServerPath(ctx, attachmentId);
            this.uploadFile4Client(path, null, fileUrl);
            ServerConfigHelper.saveServerPath(ctx, attachmentId, path);
        } else {
            String fileName = this.uploadFile4Client(null, null, fileUrl);
            this.iAttachmentFacade.fileToDb4Server(fileName, attachmentId);
        }
    }

    public String uploadFile4Client(String serverFilePath, String lockFilePath, String localFilePath) throws BOSException, EASBizException {
        String tempFileName = serverFilePath;
        BufferedInputStream input = null;
        try {
            File fw;
            this.logger.info((Object)("......... begin deal upload file, max file size :" + AttachmentFtpInfo.MAX_OF_UPLOAD_LENGTH));
            if (localFilePath == null) {
                String string = null;
                return string;
            }
            AttachmentFtpInfo ftpInfo = null;
            if (StringUtils.isEmpty((String)lockFilePath)) {
                lockFilePath = System.getProperty("user.home") + File.separator + "canuploadfile.loc";
            }
            if ((fw = new File(lockFilePath)).exists()) {
                fw.delete();
                throw new BOSException("stop upload");
            }
            AttachmentFtpInfo.init();
            this.checkInterface();
            input = new BufferedInputStream(new FileInputStream(localFilePath));
            boolean isEncryptStatus = false;
            if (input != null) {
                try {
                    IAttachmentSize attachmentFactory = AttachmentSizeFactory.getRemoteInstance();
                    boolean isEncrypt = attachmentFactory.isAttachmentEncrypt();
                    if (isEncrypt) {
                        isEncryptStatus = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            int position = 0;
            int readSize = AttachmentFtpInfo.MAX_OF_UPLOAD_LENGTH;
            int totalSize = input.available();
            int n = readSize = readSize < totalSize ? readSize : totalSize;
            while (position < totalSize) {
                byte[] bf = new byte[readSize];
                input.read(bf, 0, readSize);
                if (isEncryptStatus) {
                    try {
                        bf = AttachmentEncryptUtil.encrypt(bf);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if ((ftpInfo = this.iAttachmentFacade.uploadFile(tempFileName, bf)) != null && (tempFileName == null || tempFileName.trim().length() == 0)) {
                    tempFileName = ftpInfo.getTempFileName();
                }
                readSize = totalSize - (position += readSize) < readSize ? totalSize - position : readSize;
            }
        }
        catch (IOException e) {
            this.logger.info((Object)e);
            throw new BOSException(e.getMessage());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)e);
                }
            }
        }
        return tempFileName;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

