/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.util;

import com.kingdee.bos.BOSException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.management.RuntimeErrorException;
import org.apache.log4j.Logger;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class FileVaildUtils {
    private static Logger logger = Logger.getLogger(FileVaildUtils.class);
    private static final String SRC_SCRIPT = "(src\\s*(=|\\())|(src\\s*[\r\n]\\s*(=|\\())";
    private static final String[] ON_EVENTS = new String[]{"onunload", "onsubmit", "onscroll", "onclick", "onchange", "onblur", "onbefore", "onafter", "onactivate", "onselect", "onload", "onkey", "onfocus", "onhelp", "ondrop", "onfinish", "onerror", "eval", "e-xpression", "onclick", "ondblclick", "onmouseenter", "onmousedown", "onmousemove", "onmouseover", "onmouseup"};
    private static final String[] FULL_MATCH_PATTENS = new String[]{"javascript:", "vbscript:", "set.constructor", "fscommand", "seeksegmenttime", "background:"};
    private static final String[] TAG_PATTERNS = new String[]{"iframe", "xss", "script", "img", "a", "div", "input", "body", "bgsound", "style", "meta", "link", "xml", "frameset", "svg", "form", "isindex", "applet", "video", "embed", "object", "base", "table", "button", "textarea", "h1", "h2", "h3", "h4", "h5", "h6"};

    private FileVaildUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean readExcel(InputStream is, String fileType) throws BOSException {
        Workbook workbook = FileVaildUtils.getWorkbook(is, fileType);
        if (null == workbook) {
            return false;
        }
        FormulaEvaluator formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
        formulaEvaluator.clearAllCachedResultValues();
        return FileVaildUtils.readWorkbook(workbook);
    }

    public static boolean readWorkbook(Workbook wb) {
        int sheetCount = wb.getNumberOfSheets();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = wb.getSheetAt(i);
            int rowCount = sheet.getLastRowNum();
            for (int j = 0; j <= rowCount; ++j) {
                Row row = sheet.getRow(j);
                if (row == null) continue;
                int cellCount = row.getLastCellNum();
                for (int k = 0; k < cellCount; ++k) {
                    Cell cell = row.getCell(k);
                    if (!FileVaildUtils.getCellFormatValue(cell)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Workbook getWorkbook(InputStream is, String fileType) throws BOSException {
        if (null == is || fileType == null || fileType.equals("")) {
            return null;
        }
        try {
            if ("xls".equals(fileType) || "xlsx".equals(fileType)) {
                Workbook workbook = WorkbookFactory.create((InputStream)is);
                return workbook;
            }
            Workbook workbook = null;
            return workbook;
        }
        catch (EncryptedDocumentException e) {
            Workbook workbook = null;
            return workbook;
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        catch (POIXMLException e) {
            if (e.getMessage().contains("content type part [M1.13]")) {
                Workbook workbook = null;
                return workbook;
            }
            throw new BOSException((Throwable)e);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)"FileStream close", (Throwable)e);
                }
            }
        }
    }

    public static String stripXSS(String value) {
        if (value == null) {
            return null;
        }
        if ((value = FileVaildUtils.doMatcher(SRC_SCRIPT, value)).contains("=") || value.contains("(")) {
            for (String onEvent : ON_EVENTS) {
                value = FileVaildUtils.doMatcher(onEvent + "(\\s*?)(=|\\()", value);
            }
        }
        for (String fullMatch : FULL_MATCH_PATTENS) {
            value = FileVaildUtils.doMatcher(fullMatch, value);
        }
        if (value.contains("<")) {
            for (String tagPattern : TAG_PATTERNS) {
                value = FileVaildUtils.doMatcher("</" + tagPattern + ">", value);
                value = FileVaildUtils.doMatcher("<" + tagPattern + "(.*?)", value);
            }
        }
        return value;
    }

    public static boolean checkZipBomb(String fileType, InputStream ins) throws BOSException, IOException {
        if ("zip".equalsIgnoreCase(fileType)) {
            long size = 0L;
            ZipEntry zipEntry = null;
            BufferedInputStream in = new BufferedInputStream(ins);
            ZipInputStream zin = new ZipInputStream((InputStream)in, Charset.forName("GBK"));
            while ((zipEntry = zin.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                size += zipEntry.getSize();
            }
            if (size > 524288000L) {
                return false;
            }
        }
        return true;
    }

    private static boolean getCellFormatValue(Cell cell) {
        if (null == cell) {
            return false;
        }
        if (null != cell.getHyperlink()) {
            return true;
        }
        boolean cellValue = false;
        try {
            FileVaildUtils.stripXSS(cell.toString());
            switch (cell.getCellType()) {
                case BLANK: 
                case STRING: 
                case BOOLEAN: 
                case NUMERIC: 
                case FORMULA: {
                    if (FileVaildUtils.isVaildCSV(cell)) {
                        cellValue = true;
                        break;
                    }
                    cellValue = false;
                    break;
                }
                default: {
                    cellValue = false;
                    break;
                }
            }
        }
        catch (FormulaParseException formulaParseException) {
            // empty catch block
        }
        return cellValue;
    }

    private static boolean isVaildCSV(Cell cell) {
        String cellString = cell.toString();
        if (cellString.startsWith("=") || cellString.startsWith("#") || cellString.startsWith("+") || cellString.startsWith("-") || cellString.startsWith("@")) {
            System.out.println("\u5b58\u5728CSV\u5b89\u5168\u6f0f\u6d1e\uff0c\u5185\u5bb9\u4e3a\uff1a" + cellString);
            return true;
        }
        if (cellString.contains("cmd") || cellString.contains("HYPERLIN") || cellString.contains("+1[1]") || cellString.contains("1+[1]") || cellString.contains("[1]!z")) {
            System.out.println("\u5b58\u5728CSV\u5b89\u5168\u6f0f\u6d1e\uff0c\u5185\u5bb9\u4e3a\uff1a" + cellString);
            return true;
        }
        return false;
    }

    private static String doMatcher(String reqex, String value) {
        Pattern pattern = Pattern.compile(reqex, 2);
        Matcher matcher = pattern.matcher(value);
        if (matcher.find()) {
            throw new RuntimeErrorException(new Error(), "\u89e3\u6790\u5f02\u5e38");
        }
        return value;
    }
}

