/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.kingdee.util.StringUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class SFTPClientTool {
    Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.attachment.util.SFTPClientTool");
    private ChannelSftp sftp = null;
    private Session sshSession = null;
    private String host = "";
    private int port = 22;
    private String username = "";
    private String password = "";

    public SFTPClientTool(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public SFTPClientTool(String host, String username, String password) {
        this.host = host;
        this.username = username;
        this.password = password;
    }

    public void connect() throws Exception {
        this.connect(10000);
    }

    public void connect(int timeout) throws Exception {
        if (this.sftp == null) {
            JSch jsch = new JSch();
            this.sshSession = jsch.getSession(this.username, this.host, this.port);
            this.sshSession.setConfig("PreferredAuthentications", "password");
            this.sshSession.setPassword(this.password);
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            this.sshSession.setConfig(sshConfig);
            this.sshSession.connect(timeout);
            Channel channel = this.sshSession.openChannel("sftp");
            channel.connect();
            this.sftp = (ChannelSftp)channel;
        } else {
            this.sftp.cd("/");
        }
    }

    public boolean checkConnect() {
        boolean isConn = false;
        try {
            JSch jsch = new JSch();
            this.sshSession = jsch.getSession(this.username, this.host, this.port);
            this.sshSession.setConfig("PreferredAuthentications", "password");
            this.sshSession.setPassword(this.password);
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            this.sshSession.setConfig(sshConfig);
            this.sshSession.connect(10000);
            Channel channel = this.sshSession.openChannel("sftp");
            channel.connect();
            isConn = true;
        }
        catch (Exception e) {
            this.logger.error((Object)("\u5931\u8d25\u4fe1\u606f" + e.getMessage()));
            e.printStackTrace();
            isConn = false;
        }
        return isConn;
    }

    public void disconnect() throws Exception {
        if (this.sftp != null) {
            if (this.sftp.isConnected()) {
                this.sftp.disconnect();
            } else if (this.sftp.isClosed()) {
                // empty if block
            }
            this.sftp = null;
        }
        if (this.sshSession != null) {
            this.sshSession.disconnect();
            this.sshSession = null;
        }
    }

    public void createDir(ChannelSftp sftp, String createpath) {
        try {
            if (this.checkFileExist(createpath)) {
                sftp.cd(createpath);
                return;
            }
            String[] pathArry = createpath.split("/");
            StringBuffer filePath = new StringBuffer("/");
            for (String path : pathArry) {
                if (StringUtils.isEmpty((String)path)) continue;
                filePath.append(path + "/");
                if (this.checkFileExist(filePath.toString())) {
                    sftp.cd(filePath.toString());
                    continue;
                }
                sftp.mkdir(filePath.toString());
                sftp.cd(filePath.toString());
            }
            sftp.cd(createpath);
        }
        catch (Exception e) {
            this.logger.error((Object)("\u521b\u5efa\u8def\u5f84\u9519\u8bef\uff1a" + createpath));
        }
    }

    public String getUploadPath(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        String filePath = path.substring(0, path.lastIndexOf("/"));
        return filePath;
    }

    public String getFileName(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        String[] pathArry = path.split("/");
        return pathArry[pathArry.length - 1];
    }

    public boolean checkFileExist(String remotePath) {
        ChannelSftp channelSftp = this.sftp;
        try {
            channelSftp.ls(remotePath);
            return true;
        }
        catch (Exception e) {
            if (e.getMessage().toLowerCase().equals("no such file")) {
                return false;
            }
            return false;
        }
    }

    public void upload(String directory, String fileName, InputStream inputStream) throws Exception {
        this.createDir(this.sftp, directory);
        this.sftp.put(inputStream, fileName);
    }

    public byte[] download(String directory, String downloadFile) throws Exception {
        if (this.checkFileExist(directory)) {
            this.sftp.cd(directory);
            InputStream inputStream = this.sftp.get(downloadFile);
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            return bytes;
        }
        return null;
    }

    public InputStream downloadStream(String directory, String downloadFile) throws Exception {
        if (this.checkFileExist(directory)) {
            this.sftp.cd(directory);
            InputStream inputStream = this.sftp.get(downloadFile);
            return inputStream;
        }
        return null;
    }

    public boolean delete(String directory, String deleteFile) throws Exception {
        boolean isDelete = false;
        try {
            if (this.checkFileExist(directory)) {
                this.sftp.cd(directory);
                this.sftp.rm(deleteFile);
                isDelete = true;
            }
        }
        catch (Exception e) {
            isDelete = false;
        }
        return isDelete;
    }

    public List<String> listFiles(String directory) throws Exception {
        ArrayList<String> fileNameList = new ArrayList<String>();
        if (this.checkFileExist(directory)) {
            Vector fileList = this.sftp.ls(directory);
            Iterator it = fileList.iterator();
            while (it.hasNext()) {
                String fileName = ((ChannelSftp.LsEntry)it.next()).getFilename();
                if (".".equals(fileName) || "..".equals(fileName)) continue;
                fileNameList.add(fileName);
            }
        }
        return fileNameList;
    }

    public void rename(String directory, String oldFileNm, String newFileNm) throws Exception {
        if (this.checkFileExist(directory)) {
            this.sftp.cd(directory);
            this.sftp.rename(oldFileNm, newFileNm);
        }
    }
}

