/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.client.AbstractBOTMappingUipkConfigUI;
import com.kingdee.eas.base.botp.client.WafUIPkSeclector;
import com.kingdee.eas.base.botp.util.BotpMetaDataFactory;
import com.kingdee.eas.base.botp.util.IBotpMetaData;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public class BOTMappingUipkConfigUI
extends AbstractBOTMappingUipkConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(BOTMappingUipkConfigUI.class);
    private EntityObjectInfo srcEntity;
    private EntityObjectInfo destEntity;
    private IBotpMetaData srcBotpEntity;
    private IBotpMetaData destBotpEntity;
    private BOTMappingInfo botMappingInfo;
    private boolean hasModified = false;
    private String uipkConfigfield = "";
    private BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper().new BotpExtConfigHelper.XMLProcessor();

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public boolean isHasModified() {
        return this.hasModified;
    }

    public String getUipkConfigfield() {
        return this.uipkConfigfield;
    }

    public void setBotMappingInfo(BOTMappingInfo botMappingInfo) {
        this.botMappingInfo = botMappingInfo;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        try {
            this.srcEntity = loader.getEntity(BOSObjectType.create((String)botMappingInfo.getSrcEntityName()));
            this.destEntity = loader.getEntity(BOSObjectType.create((String)botMappingInfo.getDestEntityName()));
        }
        catch (MetaDataNotFoundException e) {
            MsgBox.showError((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.SRCENTITYNOTEXISTINBOTMAPPING"), botMappingInfo.getSrcEntityName()));
            SysUtil.abort();
        }
        this.srcBotpEntity = BotpMetaDataFactory.createEntity(this.srcEntity);
        this.destBotpEntity = BotpMetaDataFactory.createEntity(this.destEntity);
        WafUIPkSeclector srcEditSeclector = new WafUIPkSeclector();
        srcEditSeclector.setEntityName(this.srcBotpEntity.getEntity().getFullName());
        srcEditSeclector.setPageType("edit");
        this.srcEditURLPromptBox.setSelector((KDPromptSelector)srcEditSeclector);
        WafUIPkSeclector srcListSeclector = new WafUIPkSeclector();
        srcListSeclector.setEntityName(this.srcBotpEntity.getEntity().getFullName());
        srcListSeclector.setPageType("list");
        this.srcListURLPromptBox.setSelector((KDPromptSelector)srcListSeclector);
        WafUIPkSeclector destEditSeclector = new WafUIPkSeclector();
        destEditSeclector.setEntityName(this.destBotpEntity.getEntity().getFullName());
        destEditSeclector.setPageType("edit");
        this.destEditURLPromptBox.setSelector((KDPromptSelector)destEditSeclector);
        WafUIPkSeclector destListSeclector = new WafUIPkSeclector();
        destListSeclector.setEntityName(this.destBotpEntity.getEntity().getFullName());
        destListSeclector.setPageType("list");
        this.destListURLPromptBox.setSelector((KDPromptSelector)destListSeclector);
        this.loadFields();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields(this.botMappingInfo);
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        BotpExtConfigHelper.ExtConfigInfo extConfigInfo = this.botMappingInfo.getExtConfigInfo();
        if (extConfigInfo != null) {
            if (extConfigInfo.getSrcBillEditURL() != null) {
                BotpExtConfigHelper.UipkConfigInfo srcEditURLInfo = new BotpExtConfigHelper().new BotpExtConfigHelper.UipkConfigInfo();
                srcEditURLInfo.setUipk(extConfigInfo.getSrcBillEditURL());
                srcEditURLInfo.setURLName(extConfigInfo.getSrcBillEditURLName());
                this.srcEditURLPromptBox.setValue((Object)srcEditURLInfo);
            }
            if (extConfigInfo.getSrcBillListURL() != null) {
                BotpExtConfigHelper.UipkConfigInfo srcListURLInfo = new BotpExtConfigHelper().new BotpExtConfigHelper.UipkConfigInfo();
                srcListURLInfo.setUipk(extConfigInfo.getSrcBillListURL());
                srcListURLInfo.setURLName(extConfigInfo.getSrcBillListURLName());
                this.srcListURLPromptBox.setValue((Object)srcListURLInfo);
            }
            if (extConfigInfo.getDestBillEditURL() != null) {
                BotpExtConfigHelper.UipkConfigInfo destEditURLInfo = new BotpExtConfigHelper().new BotpExtConfigHelper.UipkConfigInfo();
                destEditURLInfo.setUipk(extConfigInfo.getDestBillEditURL());
                destEditURLInfo.setURLName(extConfigInfo.getDestBillEditURLName());
                this.destEditURLPromptBox.setValue((Object)destEditURLInfo);
            }
            if (extConfigInfo.getDestBillListURL() != null) {
                BotpExtConfigHelper.UipkConfigInfo destListURLInfo = new BotpExtConfigHelper().new BotpExtConfigHelper.UipkConfigInfo();
                destListURLInfo.setUipk(extConfigInfo.getDestBillListURL());
                destListURLInfo.setURLName(extConfigInfo.getDestBillListURLName());
                this.destListURLPromptBox.setValue((Object)destListURLInfo);
            }
        }
    }

    public void storeFields(BOTMappingInfo botMappingInfo) {
        super.storeFields();
        BotpExtConfigHelper.ExtConfigInfo info = botMappingInfo.getExtConfigInfo();
        if (info == null) {
            info = new BotpExtConfigHelper().new BotpExtConfigHelper.ExtConfigInfo();
        }
        if (this.srcEditURLPromptBox.getValue() != null && this.srcEditURLPromptBox.getValue().toString().trim() != "") {
            info.setSrcBillEditURL(((BotpExtConfigHelper.UipkConfigInfo)this.srcEditURLPromptBox.getValue()).getUipk());
            info.setSrcBillEditURLName(((BotpExtConfigHelper.UipkConfigInfo)this.srcEditURLPromptBox.getValue()).getURLName());
        } else {
            info.setSrcBillEditURL("");
            info.setSrcBillEditURLName("");
        }
        if (this.srcListURLPromptBox.getValue() != null && this.srcListURLPromptBox.getValue().toString().trim() != "") {
            info.setSrcBillListURL(((BotpExtConfigHelper.UipkConfigInfo)this.srcListURLPromptBox.getValue()).getUipk());
            info.setSrcBillListURLName(((BotpExtConfigHelper.UipkConfigInfo)this.srcListURLPromptBox.getValue()).getURLName());
        } else {
            info.setSrcBillListURL("");
            info.setSrcBillListURLName("");
        }
        if (this.destEditURLPromptBox.getValue() != null && this.destEditURLPromptBox.getValue().toString().trim() != "") {
            info.setDestBillEditURL(((BotpExtConfigHelper.UipkConfigInfo)this.destEditURLPromptBox.getValue()).getUipk());
            info.setDestBillEditURLName(((BotpExtConfigHelper.UipkConfigInfo)this.destEditURLPromptBox.getValue()).getURLName());
        } else {
            info.setDestBillEditURL("");
            info.setDestBillEditURLName("");
        }
        if (this.destListURLPromptBox.getValue() != null && this.destListURLPromptBox.getValue().toString().trim() != "") {
            info.setDestBillListURL(((BotpExtConfigHelper.UipkConfigInfo)this.destListURLPromptBox.getValue()).getUipk());
            info.setDestBillListURLName(((BotpExtConfigHelper.UipkConfigInfo)this.destListURLPromptBox.getValue()).getURLName());
        } else {
            info.setDestBillListURL("");
            info.setDestBillListURLName("");
        }
        String text = null;
        try {
            text = this.processor.unmarshallingExtConfig(info);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        this.hasModified = true;
        this.uipkConfigfield = text;
        botMappingInfo.setExtConfig(text);
    }

    public Dimension preferredSize() {
        Dimension newSize = super.preferredSize();
        newSize.width = (int)this.getBounds().getWidth();
        newSize.height = (int)this.getBounds().getHeight();
        return newSize;
    }
}

