/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client;

import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.client.AbstractBillQueryUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BillQueryUI
extends AbstractBillQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(BillQueryUI.class);
    private Map<String, BillInfo> billMap = new HashMap<String, BillInfo>();
    private StringBuffer billMsg;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    public void init() {
        Set entitySet = (Set)this.getUIContext().get("entitySet");
        if (entitySet == null || entitySet.size() == 0) {
            return;
        }
        this.kDButton1.setEnabled(true);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        for (String bostype : entitySet) {
            EntityObjectInfo entityinfo = loader.getEntity(BOSObjectType.create((String)bostype));
            BillInfo info = new BillInfo(entityinfo.getAlias(), entityinfo.getTable().getName().toString(), bostype);
            this.billMap.put(entityinfo.getAlias(), info);
            this.kDComboBox1.addItem((Object)entityinfo.getAlias());
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String alias = this.kDComboBox1.getSelectedItem().toString();
        String number = this.kDTextField1.getText().trim();
        BillInfo info = this.billMap.get(alias);
        String tableName = info.getTableName();
        String sql = "select fid, fnumber,fcreateTime from " + tableName + " where fnumber like '%" + number + "%'";
        SQLExecutor sqltor = new SQLExecutor(sql);
        IRowSet rowset = sqltor.executeSQL();
        if (rowset.size() > 0) {
            this.billMsg = new StringBuffer();
            this.billMsg.append("\u5355\u636e :" + alias + " \n");
            while (rowset.next()) {
                String num = rowset.getObject("fnumber").toString();
                String id = rowset.getObject("fid").toString();
                String time = rowset.getDate("fcreateTime").toString();
                this.billMsg.append("------------------------- \n");
                this.billMsg.append("ID :" + id + " \n");
                this.billMsg.append("Num :" + num + " \n");
                this.billMsg.append("CreateTime :" + time + " \n");
                this.billMsg.append("------------------------- \n");
            }
        }
        this.getUIWindow().close();
    }

    public String getBillMsg() {
        return this.billMsg.toString();
    }

    private class BillInfo {
        String alias;
        String tableName;
        String bosType;

        public BillInfo(String alias, String tableName, String bosType) {
            this.alias = alias;
            this.tableName = tableName;
            this.bosType = bosType;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getBosType() {
            return this.bosType;
        }

        public void setBosType(String bosType) {
            this.bosType = bosType;
        }
    }
}

