/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client;

import com.kingdee.bos.bot.engine.provider.BotpFormulaSQLEFunctions;
import com.kingdee.bos.bot.engine.provider.IBotSQLFunctions;
import com.kingdee.bos.bot.engine.sql.BotFormulaExprVerifier;
import com.kingdee.bos.bot.engine.sql.BotKSqlFunctions;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.formula.kscript.debug.IScriptFormater;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bot.BOTDynFunctionInfo;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.MappingTypeEnum;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.formula.api.FormulaGrammarVerifier;
import com.kingdee.bos.service.formula.api.IFormulaFunctions;
import com.kingdee.bos.service.formula.builder.FormulaBuilderPanelBean;
import com.kingdee.bos.service.formula.builder.highlight.ExtendKDTextPane;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.botp.BOTPExtendInterface;
import com.kingdee.eas.base.botp.client.AbstractFomulaUI;
import com.kingdee.eas.base.botp.client.BotpDynamicFunctionUI;
import com.kingdee.eas.base.botp.client.CommonRuleSegDefUI;
import com.kingdee.eas.base.botp.client.RuleSegDefSelector;
import com.kingdee.eas.base.botp.client.RuleSegDefUIFactory;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.botp.util.BotpDynamicFormulaFunctions;
import com.kingdee.eas.base.botp.util.BotpFormulaFunctions;
import com.kingdee.eas.base.botp.util.BotpScriptFormater;
import com.kingdee.eas.base.botp.util.IBotpMetaData;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FomulaUI
extends AbstractFomulaUI {
    private static final String RESXFILE = "com.kingdee.eas.base.botp.BotpResx";
    private static final String ERRORFORMULA = "ERRORFORMULA";
    private static final Logger logger = CoreUIObject.getLogger(FomulaUI.class);
    private int runMode = FormulaBuilderPanelBean.MODE_STAND;
    private List formulaFunctionLists = new ArrayList();
    private static final String SRCFLAG = "__src";
    private static final String DESTFLAG = "__dest";
    private boolean cancel = true;
    private FormulaBuilderPanelBean pnlFormula;
    private EntityObjectInfo srcEntity = null;
    private EntityObjectInfo destEntity = null;
    private static final String HGNAME = "entries.assistRecords.assGrp";
    KDPromptBox f7;

    public void onLoad() throws Exception {
        super.onLoad();
        this.addF7Listener();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (d.width >= 1280 && d.height >= 1024) {
            this.setPreferredSize(new Dimension(1024, 768));
            this.pnlFormula.setPanelSplitPercetage(768, 0.2);
        } else if (d.width <= 800 && d.height <= 600) {
            this.setPreferredSize(new Dimension(750, 520));
            this.pnlFormula.setPanelSplitPercetage(520, 0.15);
        } else {
            this.setPreferredSize(new Dimension(880, 600));
            this.pnlFormula.setPanelSplitPercetage(600, 0.23);
        }
        this.runMode = MappingTypeEnum.SqlEngine == (MappingTypeEnum)((Object)this.getUIContext().get("runmode")) ? FormulaBuilderPanelBean.MODE_KSQL : FormulaBuilderPanelBean.MODE_STAND;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getAlias() {
        return this.pnlFormula.getFormulaAliasStr();
    }

    public String getAlias(Locale locale) {
        return this.pnlFormula.getFormulaAliasStr();
    }

    public void setAlias(String alias) {
    }

    public void setExpression(String expression) {
        if (expression != null && expression.length() > 0) {
            if (this.srcEntity != null && this.srcEntity.getObjectValueClass() != null && this.srcEntity.getObjectValueClass().length() > 0) {
                expression = expression.replaceAll(SRCFLAG, FomulaUI.getEntityObjectValueName(this.srcEntity));
            }
            if (this.destEntity != null && this.destEntity.getObjectValueClass() != null && this.destEntity.getObjectCollectionClass().length() > 0) {
                expression = expression.replaceAll(DESTFLAG, FomulaUI.getEntityObjectValueName(this.destEntity));
            }
            if (expression.indexOf("formula_result;") > -1) {
                this.pnlFormula.setFormulaStr(expression);
            } else if (this.runMode == FormulaBuilderPanelBean.MODE_KSQL) {
                this.pnlFormula.setFormulaStr(expression);
            } else {
                this.pnlFormula.setFormulaStr("");
            }
        }
        BotpScriptFormater formater = new BotpScriptFormater();
        formater.setDestEntity(this.destEntity);
        formater.setSrcEntity(this.srcEntity);
        this.pnlFormula.setScriptFormater((IScriptFormater)formater);
    }

    public String getExpression() {
        String expression = this.pnlFormula.getFormulaStr();
        if (this.srcEntity != null && this.srcEntity.getObjectValueClass() != null && this.srcEntity.getObjectValueClass().length() > 0) {
            expression = expression.replaceAll(FomulaUI.getEntityObjectValueName(this.srcEntity), SRCFLAG);
        }
        if (this.destEntity != null && this.destEntity.getObjectValueClass() != null && this.destEntity.getObjectCollectionClass().length() > 0) {
            expression = expression.replaceAll(FomulaUI.getEntityObjectValueName(this.destEntity), DESTFLAG);
        }
        logger.debug((Object)expression);
        return expression;
    }

    private static String getEntityObjectValueName(EntityObjectInfo entity) {
        String[] packs = StringUtil.split((String)entity.getObjectValueClass(), (String)".");
        return packs[packs.length - 1];
    }

    public boolean isCancel() {
        return this.cancel;
    }

    @Override
    public void actionAddDynFunc_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, BOTDynFunctionInfo> uiContext = new HashMap<String, BOTDynFunctionInfo>();
        IUIWindow uiWindow = null;
        try {
            BOTDynFunctionInfo botDynFunctionInfo = new BOTDynFunctionInfo();
            botDynFunctionInfo.setSrcBostype(this.srcEntity.getType().toString());
            botDynFunctionInfo.setDestBostype(this.destEntity.getType().toString());
            botDynFunctionInfo.setSrcEntityName(this.srcEntity.getFullName());
            botDynFunctionInfo.setDestEntityName(this.destEntity.getFullName());
            botDynFunctionInfo.setIsShare(false);
            uiContext.put("botDynFunctionInfo", botDynFunctionInfo);
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BotpDynamicFunctionUI.class.getName(), uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            BotpDynamicFunctionUI ui = (BotpDynamicFunctionUI)uiWindow.getUIObject();
            if (ui.isHasModified()) {
                this.reloadDynFunctions();
            }
        }
        catch (UIException ee) {
            logger.error((Object)"error when open BotpDynamicFunctionUI");
        }
    }

    @Override
    public void actionSaveAsDynFunc_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, BOTDynFunctionInfo> uiContext = new HashMap<String, BOTDynFunctionInfo>();
        IUIWindow uiWindow = null;
        try {
            BOTDynFunctionInfo botDynFunctionInfo = new BOTDynFunctionInfo();
            botDynFunctionInfo.setSrcBostype(this.srcEntity.getType().toString());
            botDynFunctionInfo.setDestBostype(this.destEntity.getType().toString());
            botDynFunctionInfo.setSrcEntityName(this.srcEntity.getFullName());
            botDynFunctionInfo.setDestEntityName(this.destEntity.getFullName());
            botDynFunctionInfo.setIsShare(false);
            String expr = this.getExpression();
            while (expr.indexOf("//") >= 0) {
                int begin = expr.indexOf("//");
                int end = expr.indexOf("}");
                expr = expr.substring(0, begin) + expr.substring(end + 1);
            }
            botDynFunctionInfo.setExpression(expr);
            uiContext.put("botDynFunctionInfo", botDynFunctionInfo);
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BotpDynamicFunctionUI.class.getName(), uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            BotpDynamicFunctionUI ui = (BotpDynamicFunctionUI)uiWindow.getUIObject();
            if (ui.isHasModified()) {
                this.reloadDynFunctions();
            }
        }
        catch (UIException ee) {
            logger.error((Object)"error when open BotpDynamicFunctionUI");
        }
    }

    public void reloadDynFunctions() {
        this.pnlFormula.clearFunctions();
        this.addDestEntityFormulaFunctions();
        this.pnlFormula.addBatchFormulaFunctions(this.formulaFunctionLists);
        this.pnlFormula.validate();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        if (this.runMode == FormulaBuilderPanelBean.MODE_STAND) {
            FormulaGrammarVerifier verifier = new FormulaGrammarVerifier();
            String strFormula = this.pnlFormula.getFormulaStr();
            boolean flag = verifier.isCompatibleWithBOSFormula(strFormula);
            if (!flag) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESXFILE, (String)ERRORFORMULA));
                return;
            }
            if (!verifier.hasSetFormulaResult(strFormula)) {
                return;
            }
        } else if (this.runMode == FormulaBuilderPanelBean.MODE_KSQL) {
            String strFormula = this.pnlFormula.getFormulaStr();
            BotFormulaExprVerifier verifier = new BotFormulaExprVerifier(this.getCurrentLocale(), this.formulaFunctionLists);
            if (!verifier.validate((Component)((Object)this), strFormula)) {
                return;
            }
        }
        this.getUIWindow().close();
        this.cancel = false;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
        this.cancel = true;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        try {
            this.initFormulaPanel();
        }
        catch (ClassNotFoundException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (InstantiationException e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
        }
        catch (IllegalAccessException e3) {
            logger.error((Object)e3.getMessage(), (Throwable)e3);
        }
    }

    protected void initFormulaPanel() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (MappingTypeEnum.SqlEngine == (MappingTypeEnum)((Object)this.getUIContext().get("runmode"))) {
            this.runMode = FormulaBuilderPanelBean.MODE_KSQL;
            this.pnlFormula = new FormulaBuilderPanelBean(FormulaBuilderPanelBean.MODE_KSQL);
        } else {
            this.runMode = FormulaBuilderPanelBean.MODE_STAND;
            this.pnlFormula = new FormulaBuilderPanelBean();
        }
        this.pnlFormulaContainer.setLayout((LayoutManager)new BorderLayout());
        this.pnlFormulaContainer.add((Component)this.pnlFormula, (Object)"Center");
    }

    private void addDestEntityFormulaFunctions() {
        this.formulaFunctionLists.clear();
        if (this.runMode == FormulaBuilderPanelBean.MODE_STAND) {
            this.addFunctionsByMode(this.formulaFunctionLists, new BotpFormulaFunctions(this.getLocale()));
        } else {
            this.addFunctionsByMode(this.formulaFunctionLists, new BotpFormulaSQLEFunctions(this.getLocale()));
            this.addFunctionsByMode(this.formulaFunctionLists, new BotKSqlFunctions(this.getLocale()));
        }
        this.addFunctionsByMode(this.formulaFunctionLists, new BotpDynamicFormulaFunctions(null, this.srcEntity, this.destEntity));
        this.addExtendFormulaFunctions(this.formulaFunctionLists);
        List formulaFuncsList = this.getUserDefineFormulaFunctions(this.destEntity);
        int count = formulaFuncsList.size();
        for (int i = 0; i < count; ++i) {
            IFormulaFunctions clz = (IFormulaFunctions)formulaFuncsList.get(i);
            this.addFunctionsByMode(this.formulaFunctionLists, clz);
        }
        List formulaFuncsSrcList = this.getUserDefineFormulaFunctions(this.srcEntity);
        int count2 = formulaFuncsSrcList.size();
        for (int i = 0; i < count2; ++i) {
            IFormulaFunctions clz = (IFormulaFunctions)formulaFuncsSrcList.get(i);
            this.addFunctionsByMode(this.formulaFunctionLists, clz);
        }
        this.pnlFormula.addBatchFormulaFunctions(this.formulaFunctionLists);
    }

    private void addExtendFormulaFunctions(List formulaFunctionLists) {
        Object extClz = null;
        if (this.runMode == FormulaBuilderPanelBean.MODE_KSQL) {
            try {
                extClz = BOTPExtendInterface.getBOTP_EXTENDSQLFUNCIONS();
            }
            catch (Exception e) {
                logger.error((Object)("Load extend fucntion error! " + e.getMessage()), (Throwable)e);
            }
        } else {
            try {
                extClz = BOTPExtendInterface.getBOTP_EXTENDFUNCIONS();
            }
            catch (Exception e) {
                logger.error((Object)("Load extend fucntion error! " + e.getMessage()), (Throwable)e);
            }
            if (extClz == null) {
                extClz = FomulaUI.getExtendFormulaFunctionClzByXML();
            }
        }
        if (extClz != null) {
            this.addFunctionsByMode(formulaFunctionLists, extClz);
        }
    }

    private static Object getExtendFormulaFunctionClzByXML() {
        Object clz = null;
        try {
            clz = BOTPTools.getProviderClassObject("BOTP_EXTENDFUNCIONS");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return clz;
    }

    private void addFunctionsByMode(List formulaFunctionLists, Object function) {
        if (this.runMode == FormulaBuilderPanelBean.MODE_KSQL && function instanceof IBotSQLFunctions) {
            formulaFunctionLists.add(function);
        } else if (this.runMode == FormulaBuilderPanelBean.MODE_STAND && function instanceof IFormulaFunctions) {
            formulaFunctionLists.add(function);
        }
    }

    public List getUserDefineFormulaFunctions(EntityObjectInfo entity) {
        ArrayList<IFormulaFunctions> formulaFuncsList = new ArrayList<IFormulaFunctions>();
        if (entity != null) {
            String baseClass = "com.kingdee.eas.framework.app";
            EntityObjectInfo entityObjectInfo = entity;
            do {
                String billFormulaClassStr;
                if ((billFormulaClassStr = entityObjectInfo.getExtendedProperty("billFormulaClass")) == null || billFormulaClassStr.length() <= 0) continue;
                String[] billFormulaClass = StringUtils.split((String)billFormulaClassStr, (String)";");
                for (int i = 0; i < billFormulaClass.length; ++i) {
                    if (billFormulaClass[i].trim().equals("")) continue;
                    try {
                        Class<?> billFormula = Class.forName(billFormulaClass[i].trim());
                        IFormulaFunctions funcInstance = (IFormulaFunctions)billFormula.newInstance();
                        if (funcInstance == null) continue;
                        formulaFuncsList.add(funcInstance);
                        continue;
                    }
                    catch (ClassNotFoundException ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                        continue;
                    }
                    catch (InstantiationException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            } while ((entityObjectInfo = entityObjectInfo.getParent()) != null && entityObjectInfo.getFullName() != null && entityObjectInfo.getFullName().indexOf(baseClass) < 0);
        }
        return formulaFuncsList;
    }

    public void setEntity(EntityObjectInfo srcEntity) {
        this.setEntity(srcEntity, null, false);
    }

    public void setEntity(EntityObjectInfo srcEntity, EntityObjectInfo destEntity, boolean isRevRule) {
        this.pnlFormula.setDisplayObjMethods(false);
        this.srcEntity = srcEntity;
        this.destEntity = destEntity;
        BusinessObjectInfo[] metaObjs = isRevRule && destEntity != null ? new BusinessObjectInfo[]{srcEntity, destEntity} : new BusinessObjectInfo[]{srcEntity};
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        this.pnlFormula.setMetaDataObjs(metaObjs, loader);
        this.addDestEntityFormulaFunctions();
        IBotpMetaData botpMetaData = (IBotpMetaData)this.getUIContext().get("botpMetaData");
        if (botpMetaData != null) {
            this.f7 = this.buildRuleFieldF7Editor(botpMetaData, srcEntity, (IUIObject)this);
        }
    }

    protected JButton getDefaultButton() {
        return this.btnOk;
    }

    private void addF7Listener() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke("F7"), "actionF7");
        this.getActionMap().put("actionF7", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FomulaUI.this.f7 == null) {
                    return;
                }
                FomulaUI.this.f7.setDataBySelector();
                if (FomulaUI.this.f7.getData() == null || !(FomulaUI.this.f7.getData() instanceof BOTRuleSegmentInfo)) {
                    return;
                }
                BOTRuleSegmentInfo info = (BOTRuleSegmentInfo)FomulaUI.this.f7.getData();
                String tempstr = info.getExpression();
                if (tempstr == null || tempstr.length() == 0) {
                    tempstr = info.getAlias();
                } else {
                    tempstr = tempstr.replaceAll("return", "");
                    tempstr = tempstr.replaceAll(";", "").trim();
                }
                if (tempstr == null) {
                    return;
                }
                ExtendKDTextPane scrollPaneFormula = null;
                try {
                    Field field = FomulaUI.this.pnlFormula.getClass().getDeclaredField("scrollPaneFormula");
                    field.setAccessible(true);
                    scrollPaneFormula = (ExtendKDTextPane)field.get(FomulaUI.this.pnlFormula);
                }
                catch (Exception e1) {
                    return;
                }
                String str = scrollPaneFormula.getText();
                StringBuffer sb = new StringBuffer();
                int caretPo = scrollPaneFormula.getCaretPosition();
                String left = str.substring(0, caretPo);
                String right = str.substring(caretPo);
                sb.append(left);
                sb.append(tempstr);
                sb.append(right);
                scrollPaneFormula.setText(sb.toString());
                scrollPaneFormula.requestFocus();
                scrollPaneFormula.setSelectionStart(caretPo);
                scrollPaneFormula.setSelectionEnd(caretPo + tempstr.length());
            }
        });
    }

    private KDPromptBox buildRuleFieldF7Editor(final IBotpMetaData botpMetaData, final EntityObjectInfo srcEntity, final IUIObject owner) {
        KDPromptBox f7Box = new KDPromptBox();
        final BOTMappingInfo mappingInfo = ((CommonRuleSegDefUI)this.getUIContext().get((Object)"Owner")).mappingInfo;
        f7Box.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                KDPromptBox box = (KDPromptBox)e.getSource();
                if (!botpMetaData.getLongName().equals(FomulaUI.HGNAME)) {
                    if (box.getSelector() == null || !(box.getSelector() instanceof RuleSegDefSelector)) {
                        RuleSegDefSelector selector = RuleSegDefUIFactory.createRuleSegDefUI(srcEntity, botpMetaData, owner.getUIWindow());
                        selector.setRuleSeg(box.getData() instanceof BOTRuleSegmentInfo ? (BOTRuleSegmentInfo)box.getData() : null);
                        box.setSelector((KDPromptSelector)selector);
                        ((RuleSegDefSelector)box.getSelector()).setMappingInfo(mappingInfo);
                    } else {
                        ((RuleSegDefSelector)box.getSelector()).setRuleSeg(box.getData() instanceof BOTRuleSegmentInfo ? (BOTRuleSegmentInfo)box.getData() : null);
                        ((RuleSegDefSelector)box.getSelector()).setMappingInfo(mappingInfo);
                    }
                }
            }
        });
        f7Box.setEditable(false);
        return f7Box;
    }
}

