/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.base.botp.client.AbstractSrcSelectorSettingUI;
import com.kingdee.eas.base.botp.client.util.EntityTreeUtil;
import com.kingdee.eas.base.botp.client.util.MetaDataUtil;
import com.kingdee.eas.base.botp.util.BotpProperty;
import com.kingdee.eas.base.botp.util.IBotpMetaData;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.tree.TreeNode;

public class SrcSelectorSettingUI
extends AbstractSrcSelectorSettingUI {
    private static final String RESXFILENAME = "com.kingdee.eas.base.botp.BotpResx";
    private boolean isCancel = false;
    protected EntityObjectInfo srcEntity = null;
    protected BOTMappingInfo mappingInfo = null;
    private List selectorsArray = new ArrayList();
    private static Locale zh_en = LocaleUtils.locale_en_US;
    private static Locale zh_cn = LocaleUtils.locale_zh_CN;
    private static Locale zh_hk = LocaleUtils.locale_zh_TW;
    private Map enMap = new HashMap();
    private Map cnMap = new HashMap();
    private Map hkMap = new HashMap();
    private Map xenMap = new HashMap();
    private Map xcnMap = new HashMap();
    private Map xhkMap = new HashMap();
    private List delArray = new ArrayList();
    private List sysSelectors = new ArrayList();
    private List userSelectors = new ArrayList();

    public SrcSelectorSettingUI() throws Exception {
        this.selectorsArray.clear();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
        this.setCancel(true);
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
        this.setCancel(false);
        int propertyNum = this.srcPropertyList.getElementCount();
        this.selectorsArray.clear();
        for (int i = 0; i < propertyNum; ++i) {
            String xName = (String)this.srcPropertyList.getElement(i);
            String name = null;
            name = this.getCurLocale().equals(zh_hk) ? (String)this.xhkMap.get(xName) : (this.getCurLocale().equals(zh_en) ? (String)this.xenMap.get(xName) : (String)this.xcnMap.get(xName));
            this.selectorsArray.add(name);
        }
        this.selectorsArray.clear();
        if (this.userSelectors.size() > 0) {
            this.selectorsArray.addAll(this.userSelectors);
        }
    }

    @Override
    protected void tree_mouseClicked(MouseEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode;
        if (e.getClickCount() == 2 && (treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent()) != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof BotpProperty) {
            IBotpMetaData srcBotpProperty = (IBotpMetaData)treeNode.getUserObject();
            PropertyInfo srcProperty = srcBotpProperty.getProperty();
            if (srcProperty instanceof OwnPropertyInfo) {
                this.addToKDList(treeNode);
            } else if (srcProperty instanceof LinkPropertyInfo) {
                this.addToKDList(treeNode);
            }
        }
    }

    public void addToKDList(DefaultKingdeeTreeNode treeNode) {
        IBotpMetaData srcBotpProperty = (IBotpMetaData)treeNode.getUserObject();
        this.showSrcPropertyName(srcBotpProperty.getFullDisplayName(zh_cn), srcBotpProperty.getFullDisplayName(zh_hk), srcBotpProperty.getFullDisplayName(zh_en), srcBotpProperty.getLongName(), null, this.getCurLocale());
    }

    public void showSrcPropertyName(String alias_zh_cn, String alias_zh_hk, String srcPropertyName, String expression, Locale curLocale) {
        this.showSrcPropertyName(alias_zh_cn, alias_zh_hk, "", srcPropertyName, expression, curLocale);
    }

    public void showSrcPropertyName(String alias_zh_cn, String alias_zh_hk, String alias_zh_en, String srcPropertyName, String expression, Locale curLocale) {
        ArrayList<String> sArray = new ArrayList<String>();
        if (curLocale.equals(zh_hk)) {
            if (this.isExists(alias_zh_hk)) {
                return;
            }
            sArray.add(alias_zh_hk);
            this.showToKDList(sArray);
            if (alias_zh_hk != null && alias_zh_hk.length() > 0) {
                this.srcPropertyList.setSelectedValue((Object)alias_zh_hk, true);
            }
        } else if (curLocale.equals(zh_en)) {
            if (this.isExists(alias_zh_en)) {
                return;
            }
            sArray.add(alias_zh_en);
            this.showToKDList(sArray);
            if (alias_zh_en != null && alias_zh_en.length() > 0) {
                this.srcPropertyList.setSelectedValue((Object)alias_zh_en, true);
            }
        } else {
            if (this.isExists(alias_zh_cn)) {
                return;
            }
            sArray.add(alias_zh_cn);
            this.showToKDList(sArray);
            if (alias_zh_cn != null && alias_zh_cn.length() > 0) {
                this.srcPropertyList.setSelectedValue((Object)alias_zh_cn, true);
            }
        }
        if (!this.sysSelectors.contains(srcPropertyName) && !this.userSelectors.contains(srcPropertyName)) {
            this.userSelectors.add(srcPropertyName);
        }
    }

    private boolean isExists(String propertyName) {
        ArrayList<Object> sArray = new ArrayList<Object>();
        int propertyNum = this.srcPropertyList.getElementCount();
        for (int i = 0; i < propertyNum; ++i) {
            sArray.add(this.srcPropertyList.getElement(i));
        }
        return sArray.contains(propertyName);
    }

    public void expandAll(KDTree tree, boolean expand) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        this.expandAll(tree, root, expand);
    }

    private void expandAll(KDTree tree, DefaultKingdeeTreeNode node, boolean expand) {
        if (node.getLevel() == 2) {
            return;
        }
        tree.expandAllNodes(expand, (TreeNode)node);
        if (node.getChildCount() >= 0) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                DefaultKingdeeTreeNode n = (DefaultKingdeeTreeNode)e.nextElement();
                this.expandAll(tree, n, expand);
            }
        }
    }

    public void setSrcEntity(EntityObjectInfo entity) {
        int i;
        String[] sArray;
        this.srcEntity = entity;
        EntityTreeUtil.initEntityTree(this.tree, entity);
        this.tab.setTitleAt(0, MetaDataUtil.getDisplayName(entity));
        this.expandAll(this.tree, true);
        this.visitAllNodes(this.tree);
        String selectorsString = (String)this.getUIContext().get("selectorsString");
        String userSelectorsString = (String)this.getUIContext().get("userSelectorsString");
        HashSet<String> allSelectors = new HashSet<String>();
        ArrayList<String> storArray = new ArrayList<String>();
        if (userSelectorsString != null) {
            sArray = userSelectorsString.split(",");
            for (i = 0; i < sArray.length; ++i) {
                if (sArray[i].equals("null")) continue;
                allSelectors.add(sArray[i]);
                this.userSelectors.add(sArray[i]);
            }
        }
        if (selectorsString != null) {
            sArray = selectorsString.split(",");
            for (i = 0; i < sArray.length; ++i) {
                if (sArray[i].equals("null")) continue;
                allSelectors.add(sArray[i]);
            }
        }
        storArray.addAll(allSelectors);
        ArrayList<String> cnNameList = new ArrayList<String>();
        for (i = 0; i < storArray.size(); ++i) {
            String name = (String)storArray.get(i);
            if (this.getCurLocale().equals(zh_hk)) {
                String hkName = (String)this.hkMap.get(name);
                if (hkName == null) {
                    this.delArray.add(name);
                    continue;
                }
                cnNameList.add(hkName);
                continue;
            }
            if (this.getCurLocale().equals(zh_en)) {
                String enName = (String)this.enMap.get(name);
                if (enName == null) {
                    this.delArray.add(name);
                    continue;
                }
                cnNameList.add(enName);
                continue;
            }
            String cnName = (String)this.cnMap.get(name);
            if (cnName == null) {
                this.delArray.add(name);
                continue;
            }
            cnNameList.add(cnName);
        }
        this.showToKDList(cnNameList);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tree.getModel().getRoot();
        if (root.getChildCount() >= 0) {
            Enumeration e = root.children();
            while (e.hasMoreElements()) {
                DefaultKingdeeTreeNode n = (DefaultKingdeeTreeNode)e.nextElement();
                this.tree.expandAllNodes(false, (TreeNode)n);
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.pnlTree.setLayout((LayoutManager)new BorderLayout());
        this.pnlTree.add((Component)this.treeView, (Object)"Center");
    }

    private void showToKDList(List selectArray) {
        int i;
        int propertyNum = this.srcPropertyList.getElementCount();
        ArrayList<Object> cnNameList = new ArrayList<Object>();
        for (i = 0; i < propertyNum; ++i) {
            cnNameList.add(this.srcPropertyList.getElement(i));
        }
        cnNameList.addAll(selectArray);
        Collections.sort(cnNameList);
        if (cnNameList != null && cnNameList.size() > 0) {
            this.srcPropertyList.removeAllElements();
            for (i = 0; i < cnNameList.size(); ++i) {
                this.srcPropertyList.addElement(cnNameList.get(i));
            }
        }
    }

    public void setMappingInfo(BOTMappingInfo mappingInfo) {
        this.mappingInfo = mappingInfo;
        try {
            this.sysSelectors = BotUtil.getSrcBillPropList(this.mappingInfo);
        }
        catch (KScriptException kScriptException) {
            // empty catch block
        }
    }

    protected JButton getDefaultButton() {
        return this.btnOK;
    }

    public Locale getCurLocale() {
        return SysContext.getSysContext().getOriginLocale();
    }

    public List getSelectorsArray() {
        return this.selectorsArray;
    }

    @Override
    protected void btnReCal_actionPerformed(ActionEvent e) throws Exception {
        if (this.mappingInfo == null) {
            return;
        }
        this.srcPropertyList.removeAllElements();
        List rt = BotUtil.getSrcBillPropList(this.mappingInfo);
        ArrayList<String> cnNameList = new ArrayList<String>();
        for (int i = 0; i < rt.size(); ++i) {
            String name = (String)rt.get(i);
            if (this.getCurLocale().equals(zh_hk)) {
                String hkName = (String)this.hkMap.get(name);
                if (hkName == null) continue;
                cnNameList.add(hkName);
                continue;
            }
            String cnName = (String)this.cnMap.get(name);
            if (cnName == null) continue;
            cnNameList.add(cnName);
        }
        this.showToKDList(cnNameList);
        this.sysSelectors = rt;
        this.userSelectors.clear();
    }

    @Override
    protected void btnRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.srcPropertyList.getElementCount() == 0) {
            return;
        }
        Object[] selectors = this.srcPropertyList.getSelectedValues();
        if (selectors.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        for (int i = 0; i < selectors.length; ++i) {
            this.srcPropertyList.removeElement(selectors[i]);
            String enName = this.getLocaleName(selectors[i].toString());
            if (!this.userSelectors.contains(enName)) continue;
            this.userSelectors.remove(enName);
        }
        if (this.srcPropertyList.getElementCount() > 0) {
            this.srcPropertyList.setSelectedIndex(0);
        }
    }

    private String getLocaleName(String xName) {
        String name = null;
        name = this.getCurLocale().equals(zh_hk) ? (String)this.xhkMap.get(xName) : (this.getCurLocale().equals(zh_en) ? (String)this.xenMap.get(xName) : (String)this.xcnMap.get(xName));
        return name;
    }

    private void traverseSrcProperty(DefaultKingdeeTreeNode treeNode) {
        if (treeNode != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof BotpProperty) {
            IBotpMetaData srcBotpProperty = (IBotpMetaData)treeNode.getUserObject();
            PropertyInfo srcProperty = srcBotpProperty.getProperty();
            if (srcProperty instanceof OwnPropertyInfo) {
                this.noteSrcProperty(treeNode);
            } else if (srcProperty instanceof LinkPropertyInfo) {
                this.noteSrcProperty(treeNode);
            }
        }
    }

    private void noteSrcProperty(DefaultKingdeeTreeNode treeNode) {
        IBotpMetaData srcBotpProperty = (IBotpMetaData)treeNode.getUserObject();
        String enName = srcBotpProperty.getFullDisplayName(zh_en);
        String cnName = srcBotpProperty.getFullDisplayName(zh_cn);
        String hkName = srcBotpProperty.getFullDisplayName(zh_hk);
        String name = srcBotpProperty.getLongName();
        if (this.getCurLocale().equals(zh_hk)) {
            this.hkMap.put(name, hkName);
            this.xhkMap.put(hkName, name);
        } else if (this.getCurLocale().equals(zh_en)) {
            this.enMap.put(name, enName);
            this.xenMap.put(enName, name);
        } else {
            this.cnMap.put(name, cnName);
            this.xcnMap.put(cnName, name);
        }
    }

    private void visitAllNodes(KDTree tree) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        this.visitAllNodes(root);
    }

    private void visitAllNodes(DefaultKingdeeTreeNode node) {
        this.traverseSrcProperty(node);
        if (node.getChildCount() >= 0) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                DefaultKingdeeTreeNode n = (DefaultKingdeeTreeNode)e.nextElement();
                this.visitAllNodes(n);
            }
        }
    }
}

