/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client.util;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.botp.client.util.BotpCommonConstant;
import com.kingdee.eas.base.botp.client.util.BotpCommonEntityPanel;
import com.kingdee.eas.base.botp.client.util.BotpCommonEntityProcessor;
import com.kingdee.eas.base.botp.client.util.BotpCommonFilterUtil;
import com.kingdee.eas.base.botp.client.util.BotpCommonIProcessor;
import com.kingdee.eas.base.botp.client.util.BotpCommonUtil;
import com.kingdee.eas.base.botp.client.util.BotpEntityTreePromptDialog;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.CompareSignDateEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.CompareSignStringEnum;
import com.kingdee.eas.base.commonquery.LeftBracketSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.RightBracketSignEnum;
import com.kingdee.eas.base.commonquery.VarEnum;
import com.kingdee.eas.base.commonquery.client.CommonFilterUtil;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.IFilterPanel;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.commonquery.client.RowObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BotpCommonEntityFilterPanel
extends KDPanel
implements IFilterPanel {
    private static Logger logger = Logger.getLogger(BotpCommonEntityFilterPanel.class);
    private KDTable kdtTable;
    private KDPanel filterButtonPanel;
    private KDWorkButton addRowButton;
    private KDWorkButton delRowButton;
    private KDWorkButton clearButton;
    private FilterInfo filterInfo;
    private EntityObjectInfo entity;
    private String[] filterProperties;
    private BotpCommonIProcessor processor;
    private IPromptBoxFactory promptBoxFactory;
    private int width;
    private int height;
    private int defaultRows;
    private boolean extendCondition;
    private String panelName;
    private int[] FILTER_COLUMN_WIDTHs;
    private static final String commonEntityFilterRes = "com.kingdee.eas.base.commonquery.client.CommonEntityFilter";
    private static final String entityTreePromptDialogRes = "com.kingdee.eas.base.commonquery.client.EntityTreePromptDialog";
    private static final String EXTEND_CONDITION_SIGN = "%";
    private static int defaultFieldMaxLenth = 80;

    public BotpCommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, BotpCommonIProcessor processor, IPromptBoxFactory promptBoxFactory, int width, int height, int defaultRows, boolean extendCondition) throws BaseCommonQueryClientException {
        this.entity = BotpCommonUtil.getEntity(entityPK);
        this.entity.setDefaultLocale(SysContext.getSysContext().getOriginLocale());
        this.filterInfo = filterInfo == null ? null : (FilterInfo)filterInfo.clone();
        this.filterProperties = filterProperties;
        this.processor = processor;
        this.promptBoxFactory = promptBoxFactory;
        this.width = width;
        this.height = height;
        this.defaultRows = defaultRows;
        this.extendCondition = extendCondition;
        this.FILTER_COLUMN_WIDTHs = this.calculateWidths();
        if (processor != null) {
            processor.set("COMMON_ENTITY_FILTER_PANEL", (Object)this);
        }
        this.jbInit();
    }

    public BotpCommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, BotpCommonIProcessor processor, IPromptBoxFactory promptBoxFactory, int width, int height, int defaultRows) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, processor, promptBoxFactory, width, height, 10, false);
    }

    public BotpCommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, BotpCommonIProcessor processor, IPromptBoxFactory promptBoxFactory, int width, int height) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, processor, promptBoxFactory, width, height, 10);
    }

    public BotpCommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IPromptBoxFactory promptBoxFactory, int width, int height) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, null, promptBoxFactory, width, height);
    }

    public BotpCommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IPromptBoxFactory promptBoxFactory) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, promptBoxFactory, 540, 400);
    }

    private int[] calculateWidths() {
        int unit = (this.width - 8 - 8) / 5;
        return new int[]{unit / 2, unit, unit, unit, unit / 2, unit - 45};
    }

    private void jbInit() throws BaseCommonQueryClientException {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.addRowButton = new KDWorkButton();
        this.addRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.addRowButton.setToolTipText(EASResource.getString((String)commonEntityFilterRes, (String)"addRow"));
        this.addRowButton.setBounds(this.width - 8 - 22 - 3 - 22 - 3 - 22, 3, 22, 19);
        this.addRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BotpCommonEntityFilterPanel.this.addRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.addRowButton);
        this.delRowButton = new KDWorkButton();
        this.delRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.delRowButton.setToolTipText(EASResource.getString((String)commonEntityFilterRes, (String)"removeRow"));
        this.delRowButton.setBounds(this.width - 8 - 22 - 3 - 22, 3, 22, 19);
        this.delRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BotpCommonEntityFilterPanel.this.delRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.delRowButton);
        this.clearButton = new KDWorkButton();
        this.clearButton.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.clearButton.setToolTipText(EASResource.getString((String)commonEntityFilterRes, (String)"clear"));
        this.clearButton.setBounds(this.width - 8 - 22, 3, 22, 19);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BotpCommonEntityFilterPanel.this.clearButton_actionPerformed(e);
            }
        });
        this.add((Component)this.clearButton);
        this.kdtTable = new KDTable();
        this.initTable();
        this.kdtTable.setBounds(8, 23, this.width - 8 - 8, this.height - 19 - 1 - 3);
        this.add((Component)this.kdtTable);
    }

    private void addTableListener() {
        this.kdtTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    BotpCommonEntityFilterPanel.this.kdtTable_editStarting(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    BotpCommonEntityFilterPanel.this.kdtTable_editStopped(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.kdtTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    BotpCommonEntityFilterPanel.this.onMouseClicked(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    private void kdtTable_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        switch (colIndex) {
            case 0: {
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                return;
            }
            case 3: {
                ICell currentCell = this.kdtTable.getRow(rowIndex).getCell(3);
                ICell signCell = this.kdtTable.getRow(rowIndex).getCell(2);
                ICell condiCell = this.kdtTable.getRow(rowIndex).getCell(1);
                if (currentCell.getEditor() != null) {
                    Component editor = currentCell.getEditor().getComponent();
                    if (this.processor != null && !currentCell.getStyleAttributes().isLocked()) {
                        String condition = BotpCommonUtil.getValue(this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
                        BotpCommonEntityProcessor commonEntityProcessor = (BotpCommonEntityProcessor)this.processor;
                        commonEntityProcessor.prepareEditor(this.entity, condition, editor);
                    }
                }
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    private void initTable() throws BaseCommonQueryClientException {
        int columnSize = BotpCommonConstant.FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            IColumn iColumn = this.kdtTable.addColumn();
            iColumn.setWidth(this.FILTER_COLUMN_WIDTHs[i]);
        }
        IRow headRow = this.kdtTable.addHeadRow();
        for (int i = 0; i < columnSize; ++i) {
            headRow.getCell(i).setValue((Object)EASResource.getString((String)commonEntityFilterRes, (String)BotpCommonConstant.FILTER_COLUMN_CODEs[i]));
        }
        this.fillFilterTableBody();
        this.addTableListener();
        this.kdtTable.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.kdtTable.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.fillLeftRows();
    }

    private void fillLeftRows() {
        int rowCount = this.kdtTable.getRowCount();
        if (rowCount < this.defaultRows) {
            for (int i = 0; i < this.defaultRows - rowCount; ++i) {
                this.kdtTable.addRow();
            }
        }
    }

    private void fillFilterTableBody() throws BaseCommonQueryClientException {
        int filterSize;
        if (this.filterInfo != null && (filterSize = this.filterInfo.getFilterItems().size()) > 0) {
            if (!this.extendCondition) {
                this.checkFilters();
            }
            ArrayList rowInfos = BotpCommonUtil.getRowInfos(this.filterInfo);
            for (int i = 0; i < filterSize; ++i) {
                RowObject rowObject = (RowObject)rowInfos.get(i);
                FilterItemInfo filterItemInfo = this.filterInfo.getFilterItems().get(i);
                this.kdtTable.addRow(i);
                rowObject.setLeftBracket(rowObject.getLeftBracket());
                rowObject.setCondition(filterItemInfo.getPropertyName());
                String compare = filterItemInfo.getCompareType().getName();
                if (filterItemInfo.isCompareValueIsProperty()) {
                    compare = BotpCommonFilterUtil.filterStdCompare2Field(compare);
                }
                if (filterItemInfo.getCompareValue() != null) {
                    EntityObjectInfo targetEntity = BotpCommonUtil.getEntity(this.entity, filterItemInfo.getPropertyName());
                    if (!CommonFilterUtil.isFieldJudge((String)compare) && BotpCommonUtil.isDate(targetEntity, BotpCommonUtil.getPropertyName(filterItemInfo.getPropertyName()))) {
                        if (filterItemInfo.getCompareValue() instanceof Date) {
                            rowObject.setCompareValue(filterItemInfo.getCompareValue());
                        } else {
                            try {
                                rowObject.setCompareValue((Object)DateTimeUtils.parseDate((String)filterItemInfo.getCompareValue().toString()));
                            }
                            catch (ParseException e) {
                                ExceptionHandler.handle((Throwable)e);
                            }
                        }
                    } else if (filterItemInfo.getCompareValue() != null) {
                        BotpCommonUtil.updateLikeRowObject(rowObject, filterItemInfo.getCompareValue(), filterItemInfo.getCompareType());
                    } else {
                        rowObject.setCompareValue(filterItemInfo.getCompareValue());
                    }
                } else if (filterItemInfo.getCompareValue() == null && filterItemInfo.getCompareType().equals((Object)CompareType.NOTEQUALS) || filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS)) {
                    if (compare.equalsIgnoreCase("=")) {
                        compare = "IS";
                    }
                    if (compare.equalsIgnoreCase("<>")) {
                        compare = "IS NOT";
                    }
                    rowObject.setCompareValue(null);
                }
                rowObject.setCompare(compare);
                rowObject.setRightBracket(rowObject.getRightBracket());
                rowObject.setLogic(rowObject.getLogic());
                this.loadFilter(i, rowObject);
            }
        }
    }

    private void checkFilters() {
        int filterSize = this.filterInfo.getFilterItems().size();
        if (this.filterProperties != null && this.filterProperties.length > 0) {
            for (int i = 0; i < filterSize; ++i) {
                int length = this.filterProperties.length;
                String currentField = this.filterInfo.getFilterItems().get(i).getPropertyName();
                boolean flag = true;
                for (int j = 0; j < length; ++j) {
                    if (!this.filterProperties[j].toLowerCase().equalsIgnoreCase(currentField.toLowerCase())) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                MsgBox.showError((String)(currentField + EASResource.getString((String)commonEntityFilterRes, (String)"checkFilterWarning")));
                SysUtil.abort();
            }
        } else {
            for (int i = 0; i < filterSize; ++i) {
                String currentField = this.filterInfo.getFilterItems().get(i).getPropertyName();
                if (BotpCommonUtil.getEntityPropertyAlias(this.entity, currentField) != null) continue;
                MsgBox.showError((String)(currentField + EASResource.getString((String)commonEntityFilterRes, (String)"checkFilterWarning")));
                SysUtil.abort();
            }
        }
    }

    private KDPromptBox getEntityTreePromptBox() {
        return this.getEntityTreePromptBox(null);
    }

    private KDPromptBox getEntityTreePromptBox(String destPropName) {
        KDPromptBox entityTreePromptBox = new KDPromptBox();
        Window window = null;
        BotpCommonEntityPanel commonEntityPanel = (BotpCommonEntityPanel)((Object)BotpCommonUtil.getComponent((Component)((Object)this), BotpCommonEntityPanel.class.getName()));
        if (commonEntityPanel != null && commonEntityPanel.getParentUI() != null) {
            window = BotpCommonUtil.getWindow(commonEntityPanel.getParentUI());
        }
        if (window == null) {
            window = BotpCommonUtil.getWindow((Component)this.kdtTable);
        }
        BotpEntityTreePromptDialog entityTreePromptDialog = null;
        String sTitle = EASResource.getString((String)entityTreePromptDialogRes, (String)"dialogTitle") + " -- " + BotpCommonUtil.getEntityAlias(this.entity);
        DataType dataType = null;
        if (destPropName != null) {
            PropertyInfo destProp = null;
            try {
                destProp = this.entity.getFieldByFullName(destPropName);
            }
            catch (InvalidDAOMetaDataException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (destProp != null) {
                dataType = ((OwnPropertyInfo)destProp).getDataType();
            }
        }
        entityTreePromptDialog = window instanceof Frame ? new BotpEntityTreePromptDialog((Frame)window, sTitle, this.entity, this.filterProperties, dataType) : (window instanceof Dialog ? new BotpEntityTreePromptDialog((Dialog)window, sTitle, this.entity, this.filterProperties, dataType) : new BotpEntityTreePromptDialog((Frame)null, sTitle, this.entity, this.filterProperties, dataType));
        if (this.extendCondition) {
            entityTreePromptBox.setEditable(true);
        }
        entityTreePromptBox.setSelector((KDPromptSelector)entityTreePromptDialog);
        entityTreePromptBox.setEditable(false);
        return entityTreePromptBox;
    }

    private void loadLeftBracket(int rowIndex, RowObject rowObject) {
        BotpCommonUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 0, LeftBracketSignEnum.class.getName(), rowObject.getLeftBracket());
    }

    private void loadCondition(int rowIndex, RowObject rowObject) {
        String conditon = rowObject.getCondition();
        if (conditon != null) {
            String strCondition = conditon.toString();
            if (strCondition.indexOf(EXTEND_CONDITION_SIGN) != -1) {
                this.kdtTable.getRow(rowIndex).getCell(1).setValue((Object)strCondition);
            } else {
                DataObject dataObject = new DataObject();
                dataObject.setName(BotpCommonUtil.getEntityPropertyAlias(this.entity, rowObject.getCondition()));
                dataObject.setValue(strCondition);
                this.kdtTable.getRow(rowIndex).getCell(1).setValue((Object)dataObject);
            }
        }
    }

    private void loadCompareSign(int rowIndex, RowObject rowObject) {
        EntityObjectInfo targetEntity = BotpCommonUtil.getEntity(this.entity, rowObject.getCondition());
        String targetProperty = BotpCommonUtil.getPropertyName(rowObject.getCondition());
        String compare = rowObject.getCompare();
        if (compare.equalsIgnoreCase(CompareType.LIKE.toString())) {
            if (rowObject.getCompareValue().toString().startsWith(EXTEND_CONDITION_SIGN) && !rowObject.getCompareValue().toString().endsWith(EXTEND_CONDITION_SIGN)) {
                compare = "RIGHT LIKE";
            } else if (!rowObject.getCompareValue().toString().startsWith(EXTEND_CONDITION_SIGN) && rowObject.getCompareValue().toString().endsWith(EXTEND_CONDITION_SIGN)) {
                compare = "LEFT LIKE";
            }
        }
        boolean hasVar = false;
        if (rowObject.getCompareValue() != null && CommonFilterUtil.isVarValue((String)rowObject.getCompareValue().toString())) {
            if (compare.equalsIgnoreCase(CompareType.EQUALS.toString())) {
                compare = "VAREQUAL";
                hasVar = true;
            } else if (compare.equalsIgnoreCase(CompareType.NOTEQUALS.toString())) {
                compare = "VARNOTEQUAL";
                hasVar = true;
            }
        }
        KDComboBox comboBox = BotpCommonUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignEnum.class.getName(), compare);
        this.removeIncludeEnum(comboBox);
        this.removeDateEnum(comboBox);
        this.removeFieldCompare(comboBox);
        if (hasVar) {
            this.removeVarEnum(comboBox);
        } else {
            this.removeVarEnum(comboBox);
        }
        PropertyInfo propertyInfo = BotpCommonUtil.getEntityPropertyByName(targetEntity, targetProperty);
        if (propertyInfo != null && !BotpCommonUtil.isString((OwnPropertyInfo)propertyInfo)) {
            comboBox.removeItem((Object)CompareSignEnum.LIKESIGN);
            comboBox.removeItem((Object)CompareSignEnum.NOTLIKESIGN);
            comboBox.removeItem((Object)CompareSignEnum.NOTLEFTLIKESIGN);
            this.removeDateEnum(comboBox);
            comboBox.removeItem((Object)CompareSignEnum.LEFTLIKESIGN);
            comboBox.removeItem((Object)CompareSignEnum.RIGHTLIKESIGN);
        }
    }

    private void loadCompareValue(int rowIndex, RowObject rowObject) {
        EntityObjectInfo targetEntity = BotpCommonUtil.getEntity(this.entity, rowObject.getCondition());
        String targetProperty = BotpCommonUtil.getPropertyName(rowObject.getCondition());
        DataObject dataInfo = BotpCommonUtil.getRefMetaData(targetEntity, targetProperty);
        String compare = BotpCommonUtil.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
        this.setNullSignLocked(rowIndex);
        if (CommonFilterUtil.isFieldJudge((String)compare)) {
            DataObject dataObject = new DataObject();
            String strValue = rowObject.getCompareValue().toString();
            dataObject.setName(BotpCommonUtil.getEntityPropertyAlias(this.entity, strValue));
            dataObject.setValue(strValue);
            this.kdtTable.getRow(rowIndex).getCell(3).setValue((Object)dataObject);
            String propName = this.getCondiCellPropNameByIndex(rowIndex);
            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)this.getEntityTreePromptBox(propName));
            this.kdtTable.getRow(rowIndex).getCell(3).setEditor((ICellEditor)kdtDefaultCellEditor);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(false);
            return;
        }
        if (dataInfo != null) {
            if (CommonFilterUtil.isDateCompareSign((String)compare) || compare.equals("IS") || compare.equals("IS NOT")) {
                this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
                this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
            } else if (CommonFilterUtil.isEnumType((String)dataInfo.getName())) {
                BotpCommonUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 3, dataInfo.getValue(), BotpCommonUtil.getValue(rowObject.getCompareValue()).toString());
            } else if (dataInfo.getName().equalsIgnoreCase(DataType.BOOLEAN.getName())) {
                BotpCommonUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 3, dataInfo.getValue(), BotpCommonUtil.getValue(rowObject.getCompareValue()).toString());
            } else if (CommonFilterUtil.isDateType((String)dataInfo.getName())) {
                Date dateValue = BotpCommonUtil.getDate((Date)rowObject.getCompareValue(), dataInfo.getName());
                BotpCommonUtil.setDateCtrlField(this.kdtTable, rowIndex, 3, dateValue);
                this.kdtTable.getRow(rowIndex).getCell(3).setValue((Object)dateValue);
                String format = BotpCommonUtil.getTimeFormatForTable(dataInfo.getName());
                format = this.getTimeFormat(dataInfo.getName());
                this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setNumberFormat(format);
            } else if (CommonFilterUtil.isF7Type((String)dataInfo.getName())) {
                KDBizPromptBox promptBox = (KDBizPromptBox)BotpCommonUtil.getF7(targetProperty, targetEntity, this.promptBoxFactory);
                if (promptBox != null) {
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)promptBox);
                    ObjectValueRender avr = new ObjectValueRender();
                    avr.setFormat((IDataFormat)new BizDataFormat(promptBox.getDisplayFormatter().toString()));
                    Object f7Data = rowObject.getCompareValue();
                    promptBox.setData(f7Data);
                    this.kdtTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                    this.kdtTable.getRow(rowIndex).getCell(3).setEditor((ICellEditor)kdtDefaultCellEditor);
                    this.kdtTable.getRow(rowIndex).getCell(3).setValue(f7Data);
                }
            } else if (CommonFilterUtil.isIntType((String)dataInfo.getName())) {
                this.setNumberCell(this.kdtTable.getRow(rowIndex).getCell(3), dataInfo.getName(), rowObject.getCompareValue());
            } else {
                Object compareValue = rowObject.getCompareValue();
                Object sign = this.kdtTable.getRow(rowIndex).getCell(2).getValue();
                if (CompareSignEnum.LIKESIGN.equals(sign)) {
                    if (compareValue.toString().startsWith(EXTEND_CONDITION_SIGN) && compareValue.toString().endsWith(EXTEND_CONDITION_SIGN)) {
                        compareValue = compareValue.toString().substring(1, compareValue.toString().length() - 1);
                    }
                } else if (CompareSignEnum.LEFTLIKESIGN.equals(sign)) {
                    if (compareValue.toString().endsWith(EXTEND_CONDITION_SIGN)) {
                        compareValue = compareValue.toString().substring(0, compareValue.toString().length() - 1);
                    }
                } else if (CompareSignEnum.RIGHTLIKESIGN.equals(sign) && compareValue.toString().startsWith(EXTEND_CONDITION_SIGN)) {
                    compareValue = compareValue.toString().substring(1, compareValue.toString().length());
                }
                this.kdtTable.getRow(rowIndex).getCell(3).setValue(compareValue);
            }
        } else {
            this.kdtTable.getRow(rowIndex).getCell(3).setValue(rowObject.getCompareValue());
        }
        if (this.isNullSign(rowObject.getCompare())) {
            this.kdtTable.getRow(rowIndex).getCell(3).setValue(rowObject.getCompareValue());
        }
        if (rowObject.getCompareValue() != null && CommonFilterUtil.isVarValue((String)rowObject.getCompareValue().toString())) {
            this.kdtTable.getRow(rowIndex).getCell(3).setValue((Object)VarEnum.getEnum((String)rowObject.getCompareValue().toString()));
        }
    }

    public String getTimeFormat(String dateType) {
        String format = "yyyy-MM-dd";
        if (dateType.equalsIgnoreCase(DataType.DATE.getName()) && CtrlFormatUtilities.getDateFormatString() != null) {
            format = CtrlFormatUtilities.getDateFormatString();
        } else if (dateType.equalsIgnoreCase(DataType.TIME.getName()) && CtrlFormatUtilities.getTimeFormatString() != null) {
            format = CtrlFormatUtilities.getTimeFormatString();
        } else if (dateType.equalsIgnoreCase(DataType.TIMESTAMP.getName()) && CtrlFormatUtilities.getDateTimeFormatString() != null) {
            format = CtrlFormatUtilities.getDateTimeFormatString();
        }
        return "%{" + format + "}t";
    }

    private void setNumberCell(ICell icell, String dataType, Object value) {
        KDFormattedTextField field = new KDFormattedTextField();
        if (DataType.SHORT.getName().equals(dataType)) {
            field.setDataType(2);
        } else if (DataType.INTEGER.getName().equals(dataType)) {
            field.setDataType(0);
        } else if (DataType.FLOAT.getName().equals(dataType)) {
            field.setDataType(4);
        } else if (DataType.DECIMAL.getName().equals(dataType)) {
            field.setDataType(1);
        } else if (DataType.DOUBLE.getName().equals(dataType)) {
            field.setDataType(5);
        }
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JTextField)field);
        icell.setEditor((ICellEditor)kdtDefaultCellEditor);
        icell.setValue(value);
    }

    private boolean isNullSign(String compare) {
        return compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS NOT");
    }

    private void loadRightBracket(int rowIndex, RowObject rowObject) {
        BotpCommonUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 4, RightBracketSignEnum.class.getName(), rowObject.getRightBracket());
    }

    private void loadLogicSign(int rowIndex, RowObject rowObject) {
        BotpCommonUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 5, LogicSignEnum.class.getName(), rowObject.getLogic());
    }

    protected void loadFilter(int rowIndex, RowObject rowObject) throws BaseCommonQueryClientException {
        int length = BotpCommonConstant.FILTER_COLUMN_CODEs.length;
        block8: for (int i = 0; i < length; ++i) {
            switch (i) {
                case 0: {
                    this.loadLeftBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 1: {
                    this.loadCondition(rowIndex, rowObject);
                    continue block8;
                }
                case 2: {
                    this.loadCompareSign(rowIndex, rowObject);
                    continue block8;
                }
                case 3: {
                    this.loadCompareValue(rowIndex, rowObject);
                    continue block8;
                }
                case 4: {
                    this.loadRightBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 5: {
                    this.loadLogicSign(rowIndex, rowObject);
                    continue block8;
                }
            }
        }
    }

    private void increaseRow(KDTEditEvent e) {
        Object object;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 5 && rowIndex == this.kdtTable.getRowCount() - 1 && (object = this.kdtTable.getRow(rowIndex).getCell(5).getValue()) != null && object.toString() != null && !this.isBlankRow(rowIndex) && !this.checkCurrentHasBlankCol(rowIndex)) {
            this.addRow();
        }
    }

    protected void kdtTable_editStopped(KDTEditEvent e) throws Exception {
        this.increaseRow(e);
        this.editedCellAfter(e);
    }

    private boolean isBlankRow(int rowIndex) {
        int columnSize = BotpCommonConstant.FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            if (BotpCommonUtil.getValue(this.kdtTable.getRow(rowIndex).getCell(i).getValue()).toString().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    private void editedCondtionCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() == null) {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
        } else {
            Object object = this.kdtTable.getRow(rowIndex).getCell(colIndex).getValue();
            if (object instanceof DataObject) {
                this.processCompareSignCell(e);
                this.processCompareValueCell(e);
            } else {
                this.kdtTable.getRow(rowIndex).getCell(3).setEditor(null);
            }
        }
    }

    private void editedCompareValueCellAfter(KDTEditEvent e) throws Exception {
        String targetProperty;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        DataObject dataObject = new DataObject();
        String conditonValue = BotpCommonUtil.getValue(this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
        EntityObjectInfo targetEntity = BotpCommonUtil.getEntity(this.entity, conditonValue);
        DataObject dataType = BotpCommonUtil.getRefMetaData(targetEntity, targetProperty = BotpCommonUtil.getPropertyName(conditonValue));
        if (dataType != null) {
            if (CommonFilterUtil.isEnumType((String)dataType.getName())) {
                return;
            }
            if (CommonFilterUtil.isDateType((String)dataType.getName())) {
                return;
            }
            if (CommonFilterUtil.isBooleanType((String)dataType.getName())) {
                return;
            }
            if (CommonFilterUtil.isIntType((String)dataType.getName())) {
                String numberValue = null;
                ICellEditor editor = this.kdtTable.getRow(rowIndex).getCell(3).getEditor();
                if (editor != null) {
                    Object value = editor.getValue();
                    if (value == null) {
                        return;
                    }
                    numberValue = value.toString();
                    if (this.checkFilterData(numberValue, dataType.getName())) {
                        MsgBox.showWarning((String)EASResource.getString((String)commonEntityFilterRes, (String)"compareValueWarning"));
                        this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
                        return;
                    }
                    dataObject.setValue(numberValue);
                    dataObject.setName(numberValue);
                    this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue((Object)numberValue);
                }
            } else {
                ICellEditor editor = this.kdtTable.getRow(rowIndex).getCell(3).getEditor();
                if (editor != null) {
                    KDComboBox box;
                    Object value;
                    Component valueObject = this.kdtTable.getRow(rowIndex).getCell(3).getEditor().getComponent();
                    if (valueObject instanceof KDBizPromptBox) {
                        KDBizPromptBox promptBox = (KDBizPromptBox)valueObject;
                        Object objData = promptBox.getData();
                        if (objData == null) {
                            return;
                        }
                        if (objData instanceof String) {
                            this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue((Object)((String)objData));
                            return;
                        }
                        if (objData instanceof DataObject) {
                            this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue(objData);
                        } else if (objData instanceof IObjectValue) {
                            IObjectValue bizObject = (IObjectValue)objData;
                            bizObject = BotpCommonUtil.getBizData(bizObject);
                            promptBox.setData((Object)bizObject);
                            this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue((Object)promptBox.getEditFormatter().valueToString((Object)bizObject));
                            return;
                        }
                    } else if (valueObject instanceof KDComboBox && (value = (box = (KDComboBox)valueObject).getSelectedItem()) instanceof VarEnum) {
                        this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue(value);
                    }
                }
            }
        }
    }

    private void editedCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object object = this.kdtTable.getRow(rowIndex).getCell(colIndex).getValue();
        if (object == null) {
            if (colIndex == 1) {
                this.resetCell(this.kdtTable.getRow(rowIndex).getCell(2));
                this.resetCell(this.kdtTable.getRow(rowIndex).getCell(3));
            }
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
            return;
        }
        switch (colIndex) {
            case 0: {
                return;
            }
            case 1: {
                this.editedCondtionCellAfter(e);
                return;
            }
            case 2: {
                this.processCompareValueCell(e);
                return;
            }
            case 3: {
                this.editedCompareValueCellAfter(e);
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    private void setNullSignLocked(int rowIndex) {
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(3);
        if (this.kdtTable.getRow(rowIndex).getCell(2).getValue() != null) {
            String filter_compare_sign = this.kdtTable.getRow(rowIndex).getCell(2).getValue().toString();
            if (filter_compare_sign.equals(CompareSignDateEnum.NULLSIGN.toString()) || filter_compare_sign.equals(CompareSignDateEnum.NOTNULLSIGN.toString())) {
                iCell.getStyleAttributes().setLocked(true);
                iCell.setValue(null);
            } else if (filter_compare_sign.equals(CompareSignEnum.VAREQUAL.toString()) || filter_compare_sign.equals(CompareSignEnum.VARNOTEQUAL.toString())) {
                iCell.getStyleAttributes().setLocked(false);
            } else {
                iCell.getStyleAttributes().setLocked(false);
            }
        }
    }

    private boolean checkFilterData(String value, String dataType) {
        boolean flag = false;
        try {
            if (dataType.equalsIgnoreCase(DataType.SHORT.getName())) {
                new Short(value);
            } else if (dataType.equalsIgnoreCase(DataType.INTEGER.getName())) {
                new Integer(value);
            } else if (dataType.equalsIgnoreCase(DataType.LONG.getName())) {
                new Long(value);
            } else if (dataType.equalsIgnoreCase(DataType.FLOAT.getName())) {
                new Short(value);
            } else if (dataType.equalsIgnoreCase(DataType.DOUBLE.getName())) {
                new Double(value);
            } else if (dataType.equalsIgnoreCase(DataType.DECIMAL.getName())) {
                new BigDecimal(value);
            }
        }
        catch (NumberFormatException e) {
            flag = true;
        }
        return flag;
    }

    private void processCompareSignCell(KDTEditEvent e) throws Exception {
        KDComboBox comboBox;
        String targetProperty;
        int rowIndex = e.getRowIndex();
        ICell condiCell = this.kdtTable.getRow(rowIndex).getCell(1);
        ICell signCell = this.kdtTable.getRow(rowIndex).getCell(2);
        ICell valueCell = this.kdtTable.getRow(rowIndex).getCell(3);
        String value = ((DataObject)condiCell.getValue()).getValue();
        EntityObjectInfo targetEntity = BotpCommonUtil.getEntity(this.entity, value);
        if (targetEntity.getPropertyByName(targetProperty = BotpCommonUtil.getPropertyName(value)) instanceof OwnPropertyInfo && !BotpCommonUtil.isString((OwnPropertyInfo)targetEntity.getPropertyByName(targetProperty))) {
            if (signCell.getEditor() != null) {
                comboBox = (KDComboBox)signCell.getEditor().getComponent();
                this.removeFieldCompare(comboBox);
                if (BotpCommonUtil.hasLikeCompare(comboBox)) {
                    this.removeDateEnum(comboBox);
                    this.removeLikeEnum(comboBox);
                    comboBox.setSelectedIndex(0);
                    signCell.setValue(null);
                }
            } else {
                comboBox = BotpCommonUtil.setComboBoxField(this.kdtTable, rowIndex, 2, BotpCommonUtil.addObjectToArray(CompareSignEnum.getEnumList().toArray(), null));
                this.removeIncludeEnum(comboBox);
                this.removeDateEnum(comboBox);
                this.removeLikeEnum(comboBox);
                this.removeFieldCompare(comboBox);
            }
        } else if (signCell.getEditor() != null && !BotpCommonUtil.hasLikeCompare(comboBox = this.getCompareSignBox(rowIndex))) {
            comboBox.addItem((Object)CompareSignEnum.LIKESIGN);
            comboBox.addItem((Object)CompareSignEnum.NOTLIKESIGN);
            comboBox.addItem((Object)CompareSignEnum.NOTLEFTLIKESIGN);
            comboBox.addItem((Object)CompareSignEnum.LEFTLIKESIGN);
            comboBox.addItem((Object)CompareSignEnum.RIGHTLIKESIGN);
        }
        if (signCell.getEditor() != null) {
            comboBox = this.getCompareSignBox(rowIndex);
            if (this.isSelectUser(rowIndex)) {
                this.removeVarEnum(comboBox);
            } else {
                this.removeVarEnum(comboBox);
            }
        }
        if (signCell.getValue() == null || condiCell.isChange()) {
            signCell.setValue((Object)CompareSignDateEnum.EQUALSSIGN);
            valueCell.setValue(null);
            if (signCell.getEditor() != null) {
                comboBox = this.getCompareSignBox(rowIndex);
                comboBox.setSelectedIndex(1);
            }
            this.processCompareValueCell(e);
        }
    }

    private KDComboBox getCompareSignBox(int rowIndex) {
        return (KDComboBox)this.kdtTable.getRow(rowIndex).getCell(2).getEditor().getComponent();
    }

    private boolean isSelectUser(int rowIndex) {
        String value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
        EntityObjectInfo targetEntity = BotpCommonUtil.getEntity(this.entity, value);
        String targetProperty = BotpCommonUtil.getPropertyName(value);
        String userBOType = "13B7DE7F";
        return userBOType.equals(targetEntity.getType().toString()) && (targetProperty.equalsIgnoreCase("id") || targetProperty.equalsIgnoreCase("number") || targetProperty.equalsIgnoreCase("name"));
    }

    private void removeVarEnum(KDComboBox comboBox) {
        comboBox.removeItem((Object)CompareSignEnum.VAREQUAL);
        comboBox.removeItem((Object)CompareSignEnum.VARNOTEQUAL);
    }

    private void removeLikeEnum(KDComboBox comboBox) {
        comboBox.removeItem((Object)CompareSignEnum.LIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTLEFTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.LEFTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.RIGHTLIKESIGN);
    }

    private void removeIncludeEnum(KDComboBox comboBox) {
        comboBox.removeItem((Object)CompareSignEnum.INCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTINCLUDESIGN);
    }

    private void removeDateEnum(KDComboBox comboBox) {
        comboBox.removeItem((Object)CompareSignEnum.YESTERDAY);
        comboBox.removeItem((Object)CompareSignEnum.TODAY);
        comboBox.removeItem((Object)CompareSignEnum.TOMORROW);
        comboBox.removeItem((Object)CompareSignEnum.LASTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.THISWEEK);
        comboBox.removeItem((Object)CompareSignEnum.NEXTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.LASTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.THISMONTH);
        comboBox.removeItem((Object)CompareSignEnum.NEXTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.BEFORETODAY);
        comboBox.removeItem((Object)CompareSignEnum.AFTERTODAY);
    }

    private void removeFieldCompare(KDComboBox comboBox) {
    }

    private void processCompareValueCell(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        String filter_compare_sign = BotpCommonUtil.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(3);
        if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() != null && !"".equals(this.kdtTable.getRow(rowIndex).getCell(1).getValue())) {
            if (e.getOldValue() != null) {
                String oldSignValue = e.getOldValue().toString();
                Object newSignValue = this.kdtTable.getRow(rowIndex).getCell(2).getValue();
                if (newSignValue != null && !newSignValue.toString().equalsIgnoreCase(oldSignValue)) {
                    if (CommonFilterUtil.isFieldJudge((String)newSignValue.toString())) {
                        iCell.getStyleAttributes().setLocked(false);
                        iCell.setValue(null);
                        String propName = this.getCondiCellPropNameByIndex(rowIndex);
                        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)this.getEntityTreePromptBox(propName));
                        iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                        iCell.getStyleAttributes().setLocked(false);
                        return;
                    }
                    if (filter_compare_sign.equals("IS") || filter_compare_sign.equals("IS NOT")) {
                        iCell.getStyleAttributes().setLocked(true);
                        iCell.setValue(null);
                    } else {
                        iCell.getStyleAttributes().setLocked(false);
                    }
                    if (CommonFilterUtil.isFieldJudge((String)oldSignValue)) {
                        iCell.setValue(null);
                    }
                    String value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
                    DataObject dataObject = null;
                    if (value.indexOf(".") >= 0) {
                        String value1 = value.substring(value.lastIndexOf(".") + 1);
                        dataObject = BotpCommonUtil.getRefMetaData(BotpCommonUtil.getEntity(this.entity, value), value1);
                    } else {
                        dataObject = BotpCommonUtil.getRefMetaData(this.entity, value);
                    }
                    int colMaxLength = defaultFieldMaxLenth;
                    if (dataObject != null) {
                        this.setDataObjectCompareValue(dataObject, rowIndex, filter_compare_sign, iCell);
                    } else {
                        this.resetCell(iCell, colMaxLength);
                    }
                } else if (CommonFilterUtil.isDateCompareSign((String)filter_compare_sign)) {
                    String value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
                    DataObject dataObject = null;
                    if (value.indexOf(".") >= 0) {
                        String value1 = value.substring(value.lastIndexOf(".") + 1);
                        dataObject = BotpCommonUtil.getRefMetaData(BotpCommonUtil.getEntity(this.entity, value), value1);
                    } else {
                        dataObject = BotpCommonUtil.getRefMetaData(this.entity, value);
                    }
                    int colMaxLength = defaultFieldMaxLenth;
                    if (dataObject != null) {
                        this.setDataObjectCompareValue(dataObject, rowIndex, filter_compare_sign, iCell);
                    } else {
                        this.resetCell(iCell, colMaxLength);
                    }
                }
            } else if (this.kdtTable.getRow(rowIndex).getCell(2).getValue() != null) {
                String value = null;
                if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() instanceof DataObject) {
                    value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
                }
                DataObject dataObject = null;
                if (value.indexOf(".") >= 0) {
                    String value1 = value.substring(value.lastIndexOf(".") + 1);
                    dataObject = BotpCommonUtil.getRefMetaData(BotpCommonUtil.getEntity(this.entity, value), value1);
                } else {
                    dataObject = BotpCommonUtil.getRefMetaData(this.entity, value);
                }
                int colMaxLength = defaultFieldMaxLenth;
                if (dataObject != null) {
                    this.setDataObjectCompareValue(dataObject, rowIndex, filter_compare_sign, iCell);
                } else {
                    this.resetCell(iCell, colMaxLength);
                }
            }
        }
    }

    private void setDataObjectCompareValue(DataObject dataObject, int rowIndex, String filter_compare_sign, ICell iCell) {
        String value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
        String type = dataObject.getName();
        if (CommonFilterUtil.isEnumType((String)type)) {
            String enumClassName = dataObject.getValue();
            Object[] em = EnumUtils.getEnumList((String)enumClassName).toArray();
            BotpCommonUtil.setComboBoxField(this.kdtTable, rowIndex, 3, BotpCommonUtil.addObjectToArray(em, null));
        } else if (CommonFilterUtil.isBooleanType((String)type)) {
            String enumClassName = dataObject.getValue();
            Object[] em = EnumUtils.getEnumList((String)enumClassName).toArray();
            BotpCommonUtil.setComboBoxField(this.kdtTable, rowIndex, 3, BotpCommonUtil.addObjectToArray(em, null));
            iCell.setValue(null);
        } else if (CommonFilterUtil.isDateType((String)type)) {
            if (CommonFilterUtil.isDateCompareSign((String)filter_compare_sign) || filter_compare_sign.equals("IS") || filter_compare_sign.equals("IS NOT")) {
                iCell.getStyleAttributes().setLocked(true);
                iCell.setValue(null);
            } else {
                String format = this.getTimeFormat(type);
                BotpCommonUtil.setDateCtrlField(this.kdtTable, rowIndex, 3, BotpCommonUtil.getDate(new Date(), type, CompareSignDateEnum.getEnum((String)filter_compare_sign)));
                iCell.getStyleAttributes().setNumberFormat(format);
                iCell.getStyleAttributes().setLocked(false);
            }
        } else if (CommonFilterUtil.isF7Type((String)type)) {
            Component obj = null;
            if (this.kdtTable.getRow(rowIndex).getCell(3).getEditor() != null) {
                obj = this.kdtTable.getRow(rowIndex).getCell(3).getEditor().getComponent();
            }
            Object f7 = null;
            f7 = obj instanceof KDBizPromptBox ? (KDBizPromptBox)obj : BotpCommonUtil.getF7(value, this.entity, this.promptBoxFactory);
            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
            iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
            iCell.getStyleAttributes().setLocked(false);
            if (filter_compare_sign.equals("IS") || filter_compare_sign.equals("IS NOT")) {
                iCell.getStyleAttributes().setLocked(true);
            }
        } else if (CommonFilterUtil.isSimpleEntityType((String)type)) {
            Object[] simpleQueryResult = BotpCommonUtil.getSimpleQueryResult(this.entity, dataObject.getValue(), value);
            BotpCommonUtil.setComboBoxField(this.kdtTable, rowIndex, 3, BotpCommonUtil.addObjectToArray(simpleQueryResult, null));
        } else if (CommonFilterUtil.isIntType((String)type)) {
            if (dataObject.getValue() != null) {
                this.setNumberCell(iCell, type, dataObject.getValue());
            } else {
                this.resetCell(iCell, dataObject.getColLength());
            }
        } else {
            this.resetCell(iCell);
        }
    }

    private void resetCell(ICell cell) {
        cell.setEditor(null);
        cell.setValue(null);
        if (cell.getStyleAttributes() != null) {
            // empty if block
        }
    }

    private void resetCell(ICell iCell, int maxLength) {
        if (maxLength <= 0) {
            maxLength = defaultFieldMaxLenth;
        }
        KDTextField field = new KDTextField();
        field.setMaxLength(maxLength);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JTextField)field);
        iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
        if (iCell.getStyleAttributes() != null) {
            // empty if block
        }
    }

    private boolean checkCurrentHasBlankCol(int rowIndex) {
        boolean flag = false;
        int columnSize = BotpCommonConstant.FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            Object filterValue;
            if (i == 0 || i == 4) continue;
            if (i == 5) {
                if (this.isLastUsefulRow(rowIndex)) {
                    return !this.isExistLogicSign(rowIndex);
                }
                filterValue = this.kdtTable.getRow(rowIndex).getCell(i).getValue();
                if (filterValue == null || filterValue.toString().trim().length() == 0) {
                    this.kdtTable.getRow(rowIndex).getCell(i).setValue((Object)LogicSignEnum.AND);
                }
            }
            if ((filterValue = this.kdtTable.getRow(rowIndex).getCell(i).getValue()) == null) {
                String compareSign = BotpCommonUtil.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
                if (compareSign.equalsIgnoreCase("YESTERDAY") || compareSign.equalsIgnoreCase("TODAY") || compareSign.equalsIgnoreCase("TOMORROW") || compareSign.equalsIgnoreCase("LASTWEEK") || compareSign.equalsIgnoreCase("THISWEEK") || compareSign.equalsIgnoreCase("NEXTWEEK") || compareSign.equalsIgnoreCase("LASTMONTH") || compareSign.equalsIgnoreCase("THISMONTH") || compareSign.equalsIgnoreCase("NEXTMONTH") || compareSign.equalsIgnoreCase("BEFORETODAY") || compareSign.equalsIgnoreCase("AFTERTODAY") || compareSign.equalsIgnoreCase("IS") || compareSign.equalsIgnoreCase("IS NOT")) {
                    if (this.kdtTable.getRow(rowIndex).getCell(3).getValue() != null) continue;
                    continue;
                }
                return true;
            }
            String strFilterValue = filterValue.toString();
            if (strFilterValue == null) {
                return true;
            }
            if (!strFilterValue.trim().equalsIgnoreCase("")) continue;
            return true;
        }
        return flag;
    }

    private boolean isLastUsefulRow(int rowIndex) {
        int rowCount = this.kdtTable.getRowCount();
        for (int i = rowIndex + 1; i < rowCount; ++i) {
            if (this.isBlankRow(i)) continue;
            return false;
        }
        return true;
    }

    private void setLeftBracketCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(columnIndex).getEditor() == null) {
            BotpCommonUtil.setComboBoxField(this.kdtTable, rowIndex, columnIndex, BotpCommonUtil.addObjectToArray(LeftBracketSignEnum.getEnumList().toArray(), null));
        }
    }

    private void setConditionCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)this.getEntityTreePromptBox());
        this.kdtTable.getRow(rowIndex).getCell(1).setEditor((ICellEditor)kdtDefaultCellEditor);
    }

    private void setCompareSignCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() == null) {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
        } else {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(false);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(false);
            if (this.kdtTable.getRow(rowIndex).getCell(columnIndex).getEditor() == null) {
                KDComboBox comboBox = BotpCommonUtil.setComboBoxField(this.kdtTable, rowIndex, columnIndex, BotpCommonUtil.addObjectToArray(CompareSignEnum.getEnumList().toArray(), null));
                this.removeIncludeEnum(comboBox);
                this.removeDateEnum(comboBox);
                this.removeFieldCompare(comboBox);
                if (this.isSelectUser(rowIndex)) {
                    this.removeVarEnum(comboBox);
                } else {
                    this.removeVarEnum(comboBox);
                }
            }
        }
    }

    private void setCompareValueCell(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        ICell condiCell = this.kdtTable.getRow(rowIndex).getCell(1);
        ICell signCell = this.kdtTable.getRow(rowIndex).getCell(2);
        ICell valueCell = this.kdtTable.getRow(rowIndex).getCell(3);
        if (condiCell.getValue() == null) {
            signCell.getStyleAttributes().setLocked(true);
            valueCell.getStyleAttributes().setLocked(true);
            return;
        }
        signCell.getStyleAttributes().setLocked(false);
        valueCell.getStyleAttributes().setLocked(false);
        ICell currentCell = this.kdtTable.getRow(rowIndex).getCell(columnIndex);
        this.setNullSignLocked(rowIndex);
        if (currentCell.getEditor() != null) {
            Component editor = currentCell.getEditor().getComponent();
            if (editor instanceof KDDatePicker && currentCell.getValue() == null) {
                currentCell.setValue((Object)new Date());
            }
            if (editor instanceof KDBizPromptBox) {
                KDBizPromptBox f7Editor = (KDBizPromptBox)editor;
                String strCompare = BotpCommonUtil.getValue(signCell.getValue()).toString();
                if (!strCompare.equalsIgnoreCase("")) {
                    CompareSignEnum signEnum = CompareSignEnum.getEnum((String)strCompare.toUpperCase());
                    if (BotpCommonUtil.isIncludeCompare(signEnum)) {
                        f7Editor.setEnabledMultiSelection(true);
                    } else {
                        f7Editor.setEnabledMultiSelection(false);
                    }
                }
            }
        }
        if (signCell.getValue() != null && CommonFilterUtil.isFieldJudge((String)signCell.getValue().toString())) {
            String propName = this.getCondiCellPropNameByIndex(rowIndex);
            valueCell.getStyleAttributes().setLocked(false);
            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)this.getEntityTreePromptBox(propName));
            valueCell.setEditor((ICellEditor)kdtDefaultCellEditor);
            return;
        }
    }

    private String getCondiCellPropNameByIndex(int rowIndex) {
        ICell condiCell = this.kdtTable.getRow(rowIndex).getCell(1);
        String propName = "";
        Object obj = condiCell.getValue();
        if (obj != null) {
            DataObject dbo = (DataObject)obj;
            propName = dbo.getValue();
        }
        return propName;
    }

    private void setRightBracketCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(columnIndex).getEditor() == null) {
            BotpCommonUtil.setComboBoxField(this.kdtTable, rowIndex, columnIndex, BotpCommonUtil.addObjectToArray(RightBracketSignEnum.getEnumList().toArray(), null));
        }
    }

    private void setLogicSignCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(columnIndex).getEditor() == null) {
            BotpCommonUtil.setComboBoxField(this.kdtTable, rowIndex, columnIndex, BotpCommonUtil.addObjectToArray(LogicSignEnum.getEnumList().toArray(), null));
        }
    }

    private void onMouseClicked(KDTMouseEvent e) throws Exception {
        int columnIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (rowIndex >= 0 && e.getType() == 1) {
            switch (columnIndex) {
                case 0: {
                    this.setLeftBracketCell(e);
                    break;
                }
                case 1: {
                    this.setConditionCell(e);
                    break;
                }
                case 2: {
                    this.setCompareSignCell(e);
                    break;
                }
                case 3: {
                    this.setCompareValueCell(e);
                    break;
                }
                case 4: {
                    this.setRightBracketCell(e);
                    break;
                }
                case 5: {
                    this.setLogicSignCell(e);
                    break;
                }
            }
        }
    }

    private boolean checkInvaildFilter() {
        int rowCount = this.kdtTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.isBlankRow(i) || !this.checkCurrentHasBlankCol(i)) continue;
            return true;
        }
        return false;
    }

    protected String getExistBlankColumnWarning() {
        String customerFilterWarning = null;
        if (this.checkInvaildFilter()) {
            customerFilterWarning = EASResource.getString((String)commonEntityFilterRes, (String)"blankRowWarning");
        }
        return customerFilterWarning;
    }

    protected boolean isExistLogicSign(int rowIndex) {
        Object object = this.kdtTable.getRow(rowIndex).getCell(5).getValue();
        return object == null || object.toString() == null || object.toString().equalsIgnoreCase("");
    }

    protected String getBracketNotMatchingWarning() {
        String bracketNotMatchingWarning = null;
        int rowCount = this.kdtTable.getRowCount();
        int balance = 0;
        for (int i = 0; i < rowCount; ++i) {
            RightBracketSignEnum rightBracketSignEnum;
            int j;
            String bracketValue;
            LeftBracketSignEnum leftBracketSignEnum;
            int brackAmount = 0;
            Object object = null;
            object = this.kdtTable.getRow(i).getCell(0).getValue();
            if (object != null && object.toString() != null && !object.toString().equalsIgnoreCase("") && (leftBracketSignEnum = (LeftBracketSignEnum)object) != null && (bracketValue = leftBracketSignEnum.getValue()) != null) {
                brackAmount = bracketValue.length();
                for (j = 0; j < brackAmount; ++j) {
                    ++balance;
                }
            }
            if ((object = this.kdtTable.getRow(i).getCell(4).getValue()) == null || object.toString() == null || object.toString().equalsIgnoreCase("") || (rightBracketSignEnum = (RightBracketSignEnum)object) == null || (bracketValue = rightBracketSignEnum.getValue()) == null) continue;
            brackAmount = bracketValue.length();
            for (j = 0; j < brackAmount; ++j) {
                --balance;
            }
        }
        if (balance != 0) {
            bracketNotMatchingWarning = EASResource.getString((String)commonEntityFilterRes, (String)"bracketWarning");
        }
        return bracketNotMatchingWarning;
    }

    private void setCurrentFilterInfo() {
        int rowCount = this.kdtTable.getRowCount();
        FilterInfo newFilterInfo = new FilterInfo();
        if (rowCount > 0) {
            StringBuffer sbFormula = new StringBuffer();
            for (int i = 0; i < rowCount; ++i) {
                FilterItemInfo filterItemInfo4;
                FilterItemInfo filterItemInfo;
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.kdtTable.getRow(i);
                String leftBracket = BotpCommonUtil.getValue(iRow.getCell(0).getValue()).toString();
                String condition = BotpCommonUtil.getValue(iRow.getCell(1).getValue()).toString();
                String compare = BotpCommonUtil.getValue(iRow.getCell(2).getValue()).toString().toLowerCase();
                String rightBracket = BotpCommonUtil.getValue(iRow.getCell(4).getValue()).toString();
                String logic = BotpCommonUtil.getValue(iRow.getCell(5).getValue()).toString();
                if (logic == null || "".equals(logic)) {
                    logic = "AND";
                }
                Object compareValue = null;
                ICell valueCell = iRow.getCell(3);
                if (valueCell.getEditor() != null && valueCell.getEditor().getComponent() != null) {
                    Component obj = valueCell.getEditor().getComponent();
                    if (obj instanceof KDBizPromptBox) {
                        KDBizPromptBox promptBox = (KDBizPromptBox)obj;
                        Object f7Data = promptBox.getData();
                        if (f7Data instanceof String) {
                            compareValue = (String)f7Data;
                        } else if (f7Data instanceof IObjectValue) {
                            IObjectValue objectValue = (IObjectValue)f7Data;
                            compareValue = BotpCommonUtil.getValue(objectValue.get(BotpCommonUtil.getEntityPropertyByName(this.entity, condition).getName()));
                        } else if (f7Data instanceof Object[]) {
                            compareValue = promptBox.getEditFormatter().valueToString(f7Data);
                        }
                    } else {
                        Object cellValue = valueCell.getValue();
                        compareValue = BotpCommonUtil.getValue(cellValue);
                        if (compareValue instanceof Date) {
                            DataObject tmpdo = BotpCommonUtil.getRefMetaData(this.entity, condition);
                            String dateType = DataType.DATE.getName();
                            if (tmpdo != null) {
                                dateType = tmpdo.getName();
                            }
                            compareValue = BotpCommonUtil.getDate((Date)compareValue, dateType, CompareSignDateEnum.getEnum((String)compare));
                        }
                    }
                } else {
                    compareValue = BotpCommonUtil.getValue(valueCell.getValue());
                    if (compareValue instanceof Date) {
                        DataObject tmpdo = BotpCommonUtil.getRefMetaData(this.entity, condition);
                        String dateType = DataType.DATE.getName();
                        if (tmpdo != null) {
                            dateType = tmpdo.getName();
                        }
                        compareValue = BotpCommonUtil.getDate((Date)compareValue, dateType, CompareSignDateEnum.getEnum((String)compare));
                    }
                }
                Object compareSign = iRow.getCell(2).getValue();
                if (CommonFilterUtil.isIncludeSign((Object)compareSign)) {
                    FilterItemInfo includeFilter = new FilterItemInfo(condition, (Object)BotpCommonUtil.processIncludeValue(compareValue.toString()), CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(includeFilter);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isDateCompareSign((String)compare)) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)compare, CompareType.EQUALS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS")) {
                    filterItemInfo = new FilterItemInfo(condition, null, CompareType.EQUALS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("IS NOT") || compare.equalsIgnoreCase("IS NOT")) {
                    filterItemInfo = new FilterItemInfo(condition, null, CompareType.NOTEQUALS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isFieldJudge((String)compare)) {
                    filterItemInfo4 = CommonFilterUtil.getFieldFilter((String)compare, (String)condition, (Object)compareValue);
                    filterItemInfo4.setCompareValueIsProperty(true);
                    newFilterInfo.getFilterItems().add(filterItemInfo4);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isVarJudge((String)compare)) {
                    filterItemInfo4 = CommonFilterUtil.getVarFilterForSave((String)compare, (String)condition, (Object)compareValue);
                    newFilterInfo.getFilterItems().add(filterItemInfo4);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isLikeSign((Object)compareSign)) {
                    if (compareSign == CompareSignStringEnum.LEFTLIKESIGN || compareSign == CompareSignEnum.LEFTLIKESIGN) {
                        compare = "like";
                    } else if (compareSign == CompareSignStringEnum.RIGHTLIKESIGN || compareSign == CompareSignEnum.RIGHTLIKESIGN) {
                        compare = "like";
                    } else if (compareSign == CompareSignStringEnum.NOTLEFTLIKESIGN || compareSign == CompareSignEnum.NOTLEFTLIKESIGN) {
                        compare = "not like";
                    }
                    compareValue = CommonFilterUtil.getLikeCompareValue((Object)compareValue, (Object)compareSign);
                }
                DataObject dataInfo = BotpCommonUtil.getRefMetaData(this.entity, condition);
                FilterItemInfo filterItemInfo2 = null;
                if (dataInfo != null) {
                    String dataType = BotpCommonUtil.getRefMetaData(this.entity, condition).getName();
                    if (CommonFilterUtil.isIntType((String)dataType)) {
                        Number tmpCompareValue = null;
                        tmpCompareValue = compareValue.toString().indexOf(".") >= 0 || DataType.DECIMAL.getName().equals(dataType) ? new BigDecimal(compareValue.toString()) : new Integer(compareValue.toString());
                        filterItemInfo2 = new FilterItemInfo(condition, (Object)tmpCompareValue, CompareType.getEnum((String)compare));
                        newFilterInfo.getFilterItems().add(filterItemInfo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.isF7Type((String)dataType)) {
                        filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                        newFilterInfo.getFilterItems().add(filterItemInfo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(filterItemInfo2);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                newFilterInfo.getFilterItems().add(filterItemInfo2);
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                if ((strFormula = strFormula.trim()).endsWith("AND")) {
                    strFormula = strFormula.substring(0, strFormula.length() - "AND".length());
                }
                newFilterInfo.setMaskString(strFormula.substring(0, strFormula.length() - 1));
            }
        }
        this.filterInfo = newFilterInfo;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public FilterInfo getFilterInfo() {
        this.setCurrentFilterInfo();
        return this.filterInfo;
    }

    public FilterInfo getInnerFilterInfo() {
        this.setCurrentFilterInfo();
        return this.filterInfo;
    }

    public EntityObjectInfo getEntity() {
        return this.entity;
    }

    public boolean verify() {
        boolean flag = true;
        String existBlankColumnWarning = this.getExistBlankColumnWarning();
        if (existBlankColumnWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)existBlankColumnWarning);
            return false;
        }
        String bracketNotMatchingWarning = this.getBracketNotMatchingWarning();
        if (bracketNotMatchingWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)bracketNotMatchingWarning);
            return false;
        }
        return flag;
    }

    private void addRow() {
        int currentRowSize = this.kdtTable.getRowCount();
        this.kdtTable.addRow(currentRowSize);
    }

    private void delRow() {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        this.kdtTable.removeRow(selectedRowIndex);
    }

    protected void clearTable() {
        this.kdtTable.removeRows();
    }

    protected void clearButton_actionPerformed(ActionEvent e) {
        this.clear();
    }

    protected void addRowButton_actionPerformed(ActionEvent e) {
        this.addRow();
    }

    protected void delRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonEntityFilterRes, (String)"delWarning"));
        } else {
            this.delRow();
        }
    }

    public KDTable getKdtTable() {
        return this.kdtTable;
    }

    public KDWorkButton getAddRowButton() {
        return this.addRowButton;
    }

    public KDWorkButton getClearButton() {
        return this.clearButton;
    }

    public KDWorkButton getDelRowButton() {
        return this.delRowButton;
    }

    public KDPanel getFilterButtonPanel() {
        return this.filterButtonPanel;
    }

    public String getPanelName() {
        return this.panelName;
    }

    public void setPanelName(String panelName) {
        this.panelName = panelName;
    }

    public void clear() {
        this.clearTable();
        this.fillLeftRows();
    }
}

