/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client.util;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.event.TreeWillExpandAdapter;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.base.botp.client.util.BotpCommonUtil;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class BotpEntityTreePromptDialog
extends KDDialog
implements KDPromptSelector {
    private EntityObjectInfo entity;
    private KDTree tree;
    private KDButton btnCommit;
    private KDButton btnCancel;
    private boolean cancel = false;
    private DefaultKingdeeTreeNode result = null;
    private Map entities = new Hashtable();
    private HashSet preferedProperties = null;
    private Set linkPropertyNames = null;
    private DataType dataType = null;
    private boolean extendConditon;
    private static final String entityTreePromptDialogRes = "com.kingdee.eas.base.commonquery.client.EntityTreePromptDialog";
    private boolean isShowEntry = false;

    public BotpEntityTreePromptDialog(Frame owner, String title, boolean modal, EntityObjectInfo entity, String[] properties, boolean extendCondition) {
        this(owner, title, modal, entity, properties, false, false);
    }

    public BotpEntityTreePromptDialog(Dialog owner, String title, boolean modal, EntityObjectInfo entity, String[] properties, boolean extendCondition) {
        this(owner, title, modal, entity, properties, false, false);
    }

    public BotpEntityTreePromptDialog(Dialog owner, String title, boolean modal, EntityObjectInfo entity, String[] properties) {
        this(owner, title, modal, entity, properties, false);
    }

    public BotpEntityTreePromptDialog(Frame owner, String title, EntityObjectInfo entity, String[] properties) {
        this(owner, title, true, entity, properties);
    }

    public BotpEntityTreePromptDialog(Frame owner, String title, boolean modal, EntityObjectInfo entity, String[] properties) {
        this(owner, title, modal, entity, properties, false);
    }

    public BotpEntityTreePromptDialog(Frame owner, String title, EntityObjectInfo entity, String[] properties, DataType dataType) {
        this(owner, title, true, entity, properties, false, false, dataType);
    }

    public BotpEntityTreePromptDialog(Dialog owner, String title, EntityObjectInfo entity, String[] properties) {
        this(owner, title, true, entity, properties);
    }

    public BotpEntityTreePromptDialog(Dialog owner, String title, EntityObjectInfo entity, String[] properties, DataType dataType) {
        this(owner, title, true, entity, properties, false, false, dataType);
    }

    public BotpEntityTreePromptDialog(Frame owner, EntityObjectInfo entity, String[] properties) {
        this(owner, EASResource.getString((String)entityTreePromptDialogRes, (String)"dialogTitle"), true, entity, properties);
    }

    public BotpEntityTreePromptDialog(Dialog owner, EntityObjectInfo entity, String[] properties) {
        this(owner, EASResource.getString((String)entityTreePromptDialogRes, (String)"dialogTitle"), true, entity, properties);
    }

    public BotpEntityTreePromptDialog(Frame owner, EntityObjectInfo entity) {
        this(owner, entity, null);
    }

    public BotpEntityTreePromptDialog(Dialog owner, EntityObjectInfo entity) {
        this(owner, entity, null);
    }

    public BotpEntityTreePromptDialog(Frame owner, String title, boolean modal, EntityObjectInfo entity, String[] properties, boolean extendCondition, boolean isShowEntry) {
        this(owner, title, modal, entity, properties, extendCondition, isShowEntry, null);
    }

    public BotpEntityTreePromptDialog(Dialog owner, String title, boolean modal, EntityObjectInfo entity, String[] properties, boolean extendCondition, boolean isShowEntry) {
        this(owner, title, modal, entity, properties, extendCondition, isShowEntry, null);
    }

    public BotpEntityTreePromptDialog(Frame owner, String title, boolean modal, EntityObjectInfo entity, String[] properties, boolean extendCondition, boolean isShowEntry, DataType dataType) {
        super(owner, title, modal);
        this.dataType = dataType;
        this.setShowEntry(isShowEntry);
        this.entity = entity;
        this.extendConditon = extendCondition;
        if (properties != null && properties.length > 0) {
            this.preferedProperties = BotpEntityTreePromptDialog.toHashSet(properties);
            this.linkPropertyNames = this.getLinkPropertyNames(this.preferedProperties);
        }
        this.jbInit();
    }

    public BotpEntityTreePromptDialog(Dialog owner, String title, boolean modal, EntityObjectInfo entity, String[] properties, boolean extendCondition, boolean isShowEntry, DataType dataType) {
        super(owner, title, modal);
        this.dataType = dataType;
        this.setShowEntry(isShowEntry);
        this.entity = entity;
        this.extendConditon = extendCondition;
        if (properties != null && properties.length > 0) {
            this.preferedProperties = BotpEntityTreePromptDialog.toHashSet(properties);
            this.linkPropertyNames = this.getLinkPropertyNames(this.preferedProperties);
        }
        this.jbInit();
    }

    private static HashSet toHashSet(String[] strary) {
        if (strary == null) {
            return null;
        }
        HashSet<String> hs = new HashSet<String>();
        int len = strary.length;
        for (int i = 0; i < len; ++i) {
            hs.add(strary[i]);
        }
        return hs;
    }

    public void show() {
        super.show();
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    public Object getData() {
        if (this.result != null) {
            DataObject dataObject = null;
            if (this.result.getUserObject() instanceof DataObject) {
                dataObject = (DataObject)this.result.getUserObject();
                String property = dataObject.getValue();
                int index = property.lastIndexOf(".");
                if (index != -1) {
                    property = property.substring(index + 1);
                }
                String alias = BotpCommonUtil.processEntityPropertyAlias(this.getEntity(dataObject.getExtendValue()), property, dataObject.getName());
                dataObject.setName(alias);
                return dataObject;
            }
        }
        return null;
    }

    private void jbInit() {
        this.createTree(this.extendConditon);
        KDTreeView kDTreeView = new KDTreeView();
        kDTreeView.setShowButton(false);
        kDTreeView.setShowControlPanel(false);
        kDTreeView.setTree(this.tree);
        kDTreeView.setAutoscrolls(true);
        this.setSize(new Dimension(510, 410));
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(null);
        this.getContentPane().add((Component)kDTreeView);
        kDTreeView.setBounds(10, 10, 480, 323);
        KDSeparator separator = new KDSeparator();
        this.getContentPane().add((Component)separator);
        separator.setBounds(0, 343, 500, 2);
        this.btnCommit = new KDButton();
        this.btnCommit.setText(EASResource.getString((String)entityTreePromptDialogRes, (String)"confirm"));
        this.btnCommit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BotpEntityTreePromptDialog.this.btnCommit_onclick(e);
            }
        });
        this.btnCancel = new KDButton();
        this.btnCancel.setText(EASResource.getString((String)entityTreePromptDialogRes, (String)"cancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BotpEntityTreePromptDialog.this.btnCancel_onclick(e);
            }
        });
        this.getContentPane().add((Component)this.btnCommit);
        this.getContentPane().add((Component)this.btnCancel);
        this.btnCommit.setBounds(341, 353, 73, 21);
        this.btnCancel.setBounds(417, 353, 73, 21);
        this.setResizable(false);
    }

    private void btnCommit_onclick(ActionEvent e) {
        this.result = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.result == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)entityTreePromptDialogRes, (String)"choseWarning"));
        } else if (this.result instanceof DefaultKingdeeTreeNode) {
            if (this.result.getAllowsChildren()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)entityTreePromptDialogRes, (String)"nodeCanNotFilter"));
                this.result = null;
            } else {
                this.dispose();
                this.cancel = false;
            }
        }
    }

    private void btnCancel_onclick(ActionEvent e) {
        this.dispose();
        this.cancel = true;
    }

    private DefaultKingdeeTreeNode createRoot(boolean extendCondition) {
        EntityObjectInfo entity = this.getEntity(this.entity.getFullName());
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(BotpCommonUtil.getEntityAlias(this.entity));
        DataObject dataObject = new DataObject();
        dataObject.setExtendValue(entity.getFullName());
        dataObject.setName("");
        dataObject.setValue("");
        root.setUserObject((Object)dataObject);
        this.createChildNode(root, extendCondition);
        return root;
    }

    private void createTree(boolean extendCondition) {
        DefaultKingdeeTreeNode root = this.createRoot(extendCondition);
        this.tree = new KDTree((ITreeNode)root, false);
        ((KingdeeTreeModel)this.tree.getModel()).setAsksAllowsChildren(true);
        this.tree.addTreeWillExpandListener((TreeWillExpandListener)new TreeWillExpandAdapter(){

            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                BotpEntityTreePromptDialog.this.tree_treeWillExpand(event);
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BotpEntityTreePromptDialog.this.tree_mouseClicked(e);
            }
        });
    }

    private void tree_treeWillExpand(TreeExpansionEvent e) {
        this.result = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
        if (this.result.getChildCount() == 0) {
            this.createChildNode(this.result, this.extendConditon);
            ((KingdeeTreeModel)this.tree.getModel()).reload((TreeNode)this.result);
        }
    }

    private void tree_mouseClicked(MouseEvent e) {
        this.result = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            if (this.result == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)entityTreePromptDialogRes, (String)"choseWarning"));
            } else if (this.result instanceof DefaultKingdeeTreeNode && !this.result.getAllowsChildren()) {
                this.dispose();
                this.cancel = false;
            }
        }
    }

    private Set getLinkPropertyNames(Set preferedProperties) {
        HashSet<String> linkPropertyNames = new HashSet<String>();
        for (String propertyName : preferedProperties) {
            int index = propertyName.lastIndexOf(".");
            if (index == -1) continue;
            linkPropertyNames.add(propertyName.substring(0, index));
        }
        return linkPropertyNames;
    }

    public void setShowEntry(boolean isShowEntry) {
        this.isShowEntry = isShowEntry;
    }

    protected boolean isShowEntry() {
        return this.isShowEntry;
    }

    private void createChildNode(DefaultKingdeeTreeNode parentNode, boolean extendCondition) {
        DataObject dataObject = (DataObject)parentNode.getUserObject();
        EntityObjectInfo entity = this.getEntity(dataObject.getExtendValue());
        ArrayList al = BotpCommonUtil.getWithOutProperties(dataObject.getExtendValue());
        PropertyCollection properties = BotpCommonUtil.getAllEntityProperties(entity);
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = properties.get(i);
            if (propertyInfo instanceof OwnPropertyInfo) {
                if (this.preferedProperties != null && !this.preferedProperties.contains(this.getValue(dataObject, propertyInfo.getName()))) continue;
                DataType destType = ((OwnPropertyInfo)propertyInfo).getDataType();
                if (this.dataType != null && !this.dataType.equals((Object)destType)) continue;
            }
            if (BotpCommonUtil.checkIsMultiEntry(entity, propertyInfo) && !this.isShowEntry()) continue;
            DataObject childDataObject = new DataObject();
            childDataObject.setName(this.getName(dataObject, BotpCommonUtil.getPropertyAlias(propertyInfo)));
            childDataObject.setValue(this.getValue(dataObject, propertyInfo.getName()));
            childDataObject.setExtendValue(this.getExtendValue(dataObject, propertyInfo));
            DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode((Object)childDataObject);
            childNode.setText(BotpCommonUtil.getPropertyAlias(propertyInfo));
            if (!(propertyInfo instanceof LinkPropertyInfo)) {
                childNode.setAllowsChildren(false);
            }
            if (propertyInfo instanceof LinkPropertyInfo ? this.preferedProperties != null && this.preferedProperties.size() > 0 && !this.linkPropertyNames.contains(childDataObject.getValue()) : ((OwnPropertyInfo)propertyInfo).getDataType().equals((Object)DataType.BYTEARRAY) || al.contains(propertyInfo.getName())) continue;
            parentNode.add((MutableTreeNode)childNode);
        }
    }

    private EntityObjectInfo getEntity(String entityName) {
        EntityObjectInfo objectInfo = null;
        if (!this.entities.containsKey(entityName)) {
            objectInfo = BotpCommonUtil.getEntity((IMetaDataPK)new MetaDataPK(entityName));
            this.entities.put(entityName, objectInfo);
        } else {
            objectInfo = (EntityObjectInfo)this.entities.get(entityName);
        }
        return objectInfo;
    }

    private String getName(DataObject parent, String propertyAlias) {
        String name = "";
        String parentName = parent.getName();
        name = parentName.length() == 0 ? propertyAlias : parentName + "." + propertyAlias;
        return name;
    }

    private String getValue(DataObject parent, String propertyName) {
        String value = "";
        String parentValue = parent.getValue();
        value = parentValue.length() == 0 ? propertyName : parentValue + "." + propertyName;
        return value;
    }

    private String getExtendValue(DataObject parent, PropertyInfo propertyInfo) {
        String extendValue = "";
        String parentExtendValue = parent.getExtendValue();
        String refEntityName = null;
        if (propertyInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            refEntityName = BotpCommonUtil.getEntity(parentExtendValue, linkPropertyInfo).getFullName();
        }
        extendValue = refEntityName == null ? parentExtendValue : refEntityName;
        return extendValue;
    }
}

