/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.btp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRuleCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.bot.MappingUtil;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.AbstractUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.core.IEASBillEntryInfo;
import com.kingdee.eas.base.core.IEASBillHeadInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class BOTClientTools {
    private static Logger logger = Logger.getLogger(BOTClientTools.class);
    private static String RESNAME = "com.kingdee.eas.base.btp.btpResource";

    public static boolean getExtendPropertyBooleanValue(IObjectValue model, String extPropertyName, boolean defaultValue) throws BOSException, EASBizException {
        return BOTPTools.getExtendPropertyBooleanValue(null, model, extPropertyName, defaultValue);
    }

    public static String getExtendPropertyStringValue(BOSObjectType bosType, String extPropertyName) throws BOSException, EASBizException {
        return BOTPTools.getExtendPropertyStringValue(null, bosType, extPropertyName);
    }

    public static String getEntityObjectInfoExtendPro(String sBosType, String extPropertyName) throws BOSException, BTPException {
        try {
            return BOTPTools.getExtendPropertyStringValue(null, BOSObjectType.create((String)sBosType), extPropertyName);
        }
        catch (Exception e) {
            throw new BTPException(BTPException.GETEXTENDPROPERROR, e);
        }
    }

    public static boolean hasReBuild(CoreBillBaseCollection srcBillInfos, String destBillTypeBOSType) throws BOSException {
        BOTRelationCollection relations = BOTClientTools.getRelationCollection(srcBillInfos, destBillTypeBOSType);
        return relations != null && relations.size() != 0;
    }

    private static BOTRelationCollection getRelationCollection(CoreBillBaseCollection srcBillInfos, String destBillTypeBOSType) throws BOSException {
        ArrayList<String> idlist = new ArrayList<String>();
        for (int i = 0; i < srcBillInfos.size(); ++i) {
            idlist.add(srcBillInfos.get(i).getId().toString());
        }
        String billIds = StringUtils.arrayToString((Object[])idlist.toArray(), (String)",");
        IBOTRelation iBOTRelation = BOTRelationFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterBill = new FilterInfo();
        FilterInfo filterMapping = new FilterInfo();
        filterBill.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billIds, CompareType.INCLUDE));
        filterMapping.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBillTypeBOSType, CompareType.EQUALS));
        filterBill.mergeFilter(filterMapping, "And");
        viewInfo.setFilter(filterBill);
        BOTRelationCollection relations = iBOTRelation.getCollection(viewInfo);
        return relations;
    }

    private static List getMappingEntryNames(BOTMappingInfo botMappingInfo) throws BOSException {
        BOTRuleCollection botRuleCols = botMappingInfo.getRules();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader(null);
        MappingUtil.initMappingEntity(botMappingInfo, loader);
        List srcEntryNameList = BOTClientTools.GetAllEntryList(botMappingInfo.getSrcEntity(), "__src.");
        if (botRuleCols == null || botRuleCols.size() == 0) {
            IBOTMapping iBOTMapping = BOTMappingFactory.getRemoteInstance();
            botMappingInfo = iBOTMapping.getMappingInfoByPK((IObjectPK)new ObjectUuidPK(botMappingInfo.getId().toString()));
            botRuleCols = botMappingInfo.getRules();
        }
        ArrayList<String> srcEntryNameInBotRuleList = new ArrayList<String>();
        int count = botRuleCols.size();
        for (int i = 0; i < count; ++i) {
            BOTRuleSegmentCollection segmentCol = botRuleCols.get(i).getRuleSegments();
            ArrayList srcIdentList = new ArrayList();
            int size = segmentCol.size();
            for (int j = 0; j < size; ++j) {
                BOTRuleSegmentInfo segment = segmentCol.get(j);
                String srcExpr = segment.getSrcPropertyName();
                if (srcExpr == null || srcExpr.length() == 0) {
                    srcExpr = segment.getExpression();
                }
                try {
                    BotUtil.computeIdent(srcExpr, srcIdentList);
                    continue;
                }
                catch (KScriptException e) {
                    logger.error((Object)"\u89e3\u6790\u516c\u5f0f\u51fa\u9519", (Throwable)e);
                }
            }
            int num = srcIdentList.size();
            for (int k = 0; k < num; ++k) {
                int lastDotIndex;
                String ident = (String)srcIdentList.get(k);
                if (!ident.startsWith("__src.")) {
                    ident = "__src." + ident;
                }
                while ((lastDotIndex = ident.lastIndexOf(46)) > -1 && !(ident = ident.substring(0, lastDotIndex)).equals("__src")) {
                    if (!srcEntryNameList.contains(ident) || srcEntryNameInBotRuleList.contains(ident)) continue;
                    srcEntryNameInBotRuleList.add(ident.substring(ident.indexOf(".") + 1));
                }
                if (srcEntryNameInBotRuleList.size() == srcEntryNameList.size()) break;
            }
            Collections.sort(srcEntryNameInBotRuleList);
        }
        return srcEntryNameInBotRuleList;
    }

    private static List getEntryID(CoreBillBaseCollection srcBillInfos, List EntryName) {
        ArrayList<String> EntryId = new ArrayList<String>();
        for (int j = 0; j < EntryName.size(); ++j) {
            for (int i = 0; i < srcBillInfos.size(); ++i) {
                IObjectCollection entryInfos = (IObjectCollection)srcBillInfos.get(i).get((String)EntryName.get(j));
                if (entryInfos == null || entryInfos.size() <= 0) continue;
                for (int k = 0; k < entryInfos.size(); ++k) {
                    EntryId.add(entryInfos.getObject(k).get("id").toString());
                }
            }
        }
        return EntryId;
    }

    public static boolean hasRebuildEntry(CoreBillBaseCollection srcBillInfos, String destBillTypeBOSType, BOTMappingInfo botMappingInfo) throws BOSException, SQLException {
        List EntryName = BOTClientTools.getMappingEntryNames(botMappingInfo);
        List entryIds = BOTClientTools.getEntryID(srcBillInfos, EntryName);
        boolean flag = false;
        if (EntryName.size() == 0 || entryIds.size() == 0) {
            return flag;
        }
        EntityObjectInfo destObjectInfo = botMappingInfo.getDestEntity();
        EntityObjectInfo srcObjectInfo = botMappingInfo.getSrcEntity();
        if ("false".equals(destObjectInfo.getExtendedProperty("IsSaveBotpEntryRelation")) && "false".equals(srcObjectInfo.getExtendedProperty("IsSaveBotpEntryRelation"))) {
            flag = BOTClientTools.hasRebuildEntry2(srcBillInfos, destBillTypeBOSType, entryIds);
        } else {
            String entryids = StringUtils.arrayToString((Object[])entryIds.toArray(), (String)"','");
            StringBuffer sql = new StringBuffer();
            sql.append("select  T1.FID from T_BOT_RELATION T0  INNER JOIN ");
            sql.append("T_BOT_RELATIONENTRY T1 on T1.FKEYID = T0.FID where T1.FSRCENTRYID in ('");
            sql.append(entryids).append("')");
            sql.append(" and T0.FDESTENTITYID ='").append(destBillTypeBOSType).append("'");
            SQLExecutor exe = new SQLExecutor(sql.toString());
            IRowSet rowSet = exe.executeSQL();
            flag = rowSet.next();
        }
        return flag;
    }

    private static boolean hasRebuildEntry2(CoreBillBaseCollection srcBillInfos, String destBillTypeBOSType, List entryIds) throws BOSException {
        ArrayList<String> headList = new ArrayList<String>();
        BOTRelationCollection relations = BOTClientTools.getRelationCollection(srcBillInfos, destBillTypeBOSType);
        if (relations != null && relations.size() > 0) {
            for (int i = 0; i < relations.size(); ++i) {
                headList.add(relations.get(i).getDestObjectID());
            }
            BOSUuid bosuuid = BOSUuid.read((String)((String)headList.get(0)));
            BOSObjectType type = bosuuid.getType();
            IDynamicObject iDynamicObject = DynamicObjectFactory.getRemoteInstance();
            String billIds = StringUtils.arrayToString((Object[])headList.toArray(), (String)",");
            FilterInfo filterBill = new FilterInfo();
            filterBill.getFilterItems().add(new FilterItemInfo("id", (Object)billIds, CompareType.INCLUDE));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterBill);
            IObjectCollection cols = iDynamicObject.getCollection(type, viewInfo);
            ArrayList srcEntryIdList = new ArrayList();
            for (int k = 0; k < cols.size(); ++k) {
                IObjectValue destObjectInfo = cols.getObject(k);
                if (!(destObjectInfo instanceof IEASBillHeadInfo) || ((IEASBillHeadInfo)destObjectInfo).getEntries() == null) continue;
                IObjectCollection easBillEntries = ((IEASBillHeadInfo)destObjectInfo).getEntries();
                IObjectValue destObjectEntryInfo2 = null;
                for (IObjectValue destObjectEntryInfo2 : easBillEntries) {
                    if (!(destObjectEntryInfo2 instanceof IEASBillEntryInfo) || ((IEASBillEntryInfo)destObjectEntryInfo2).getSourceBillId() == null || !entryIds.contains(((IEASBillEntryInfo)destObjectEntryInfo2).getSourceBillEntryId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static List GetAllEntryList(EntityObjectInfo entity, String prefix) {
        PropertyCollection properties = entity.getInheritedProperties();
        ArrayList<String> entryList = new ArrayList<String>();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo property = properties.get(i);
            if (!(property instanceof LinkPropertyInfo) || !BOTClientTools.isEntry((LinkPropertyInfo)property)) continue;
            entryList.add(prefix + property.getName());
        }
        return entryList;
    }

    private static boolean isEntry(LinkPropertyInfo property) {
        RelationshipInfo relationship = property.getRelationship();
        return Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || relationship != null && relationship.getClientObject() != null && RelationshipType.COMPOSITION.equals((Object)relationship.getType()) && (CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) || CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getClientCardinality())) && (CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()) || CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()));
    }

    public static void reBuildControl(CoreUI uiObj, BOTMappingInfo botMappingInfo, CoreBillBaseCollection srcBillInfos, String destBillTypeBOSType) throws Exception {
        String reBuildControl = "";
        String extconfig = botMappingInfo.getExtConfig();
        BotpExtConfigHelper.ExtConfigInfo info = null;
        BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper().new BotpExtConfigHelper.XMLProcessor();
        if (extconfig != null && !extconfig.equals("")) {
            info = processor.marshallingExtConfig(extconfig);
            reBuildControl = info.getReBuildControl();
            if (reBuildControl == null || reBuildControl.equals("")) {
                reBuildControl = "1";
            }
        } else {
            reBuildControl = "1";
        }
        if (reBuildControl.equals("1")) {
            return;
        }
        if (reBuildControl.equals("2")) {
            if (BOTClientTools.hasReBuild(srcBillInfos, destBillTypeBOSType)) {
                MsgBox.showWarning((Component)uiObj, (String)EASResource.getString((String)RESNAME, (String)"notReBuild"));
                SysUtil.abort();
            }
        } else if (reBuildControl.equals("3")) {
            if (BOTClientTools.hasRebuildEntry(srcBillInfos, destBillTypeBOSType, botMappingInfo)) {
                MsgBox.showWarning((Component)uiObj, (String)EASResource.getString((String)RESNAME, (String)"notReBuild"));
                SysUtil.abort();
            }
        } else if (BOTClientTools.hasReBuild(srcBillInfos, destBillTypeBOSType)) {
            int result = MsgBox.showConfirm2((Component)uiObj, (String)EASResource.getString((String)RESNAME, (String)"reBuildHint"));
            if (result == 0) {
                return;
            }
            SysUtil.abort();
        }
    }

    public static SelectorItemCollection getBillEditUISelector(String billTypeBOSType) throws BOSException, BTPException {
        String billEditUIClassName = BOTPTools.getEntityObjectInfoExtendProClient(billTypeBOSType, "editUI");
        SelectorItemCollection editUiSelectors = null;
        if (!StringUtils.isEmpty((String)billEditUIClassName)) {
            try {
                Class<?> c = null;
                try {
                    c = Class.forName(billEditUIClassName + "CTEx", false, AbstractUIFactory.class.getClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    try {
                        c = Class.forName(billEditUIClassName + "PIEx", false, AbstractUIFactory.class.getClassLoader());
                    }
                    catch (ClassNotFoundException _) {
                        c = Class.forName(billEditUIClassName);
                    }
                }
                IUIObject uiObj = (IUIObject)c.newInstance();
                if (uiObj instanceof EditUI) {
                    editUiSelectors = ((EditUI)uiObj).getSelectors();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return editUiSelectors;
    }

    public static CtrlUnitInfo getCUByOrgId(String orgId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().appendFilterItem("id", (Object)orgId);
        view.getSelector().add("cu.id");
        FullOrgUnitCollection fo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(view);
        if (fo != null && fo.size() > 0) {
            return fo.get(0).getCU();
        }
        return null;
    }
}

