/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.btp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.IBOTFilterDestBosTypeByID;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.botp.util.BotpMetaDataFactory;
import com.kingdee.eas.base.botp.util.IBotpMetaData;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.btp.client.AbstractBTPMakeBillFIUI;
import com.kingdee.eas.base.btp.client.BOTClientTools;
import com.kingdee.eas.base.btp.client.BTPBillListImpl;
import com.kingdee.eas.base.btp.client.BTPRPCHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public class BTPMakeBillFIUI
extends AbstractBTPMakeBillFIUI {
    private static final Logger logger = CoreUIObject.getLogger(BTPMakeBillFIUI.class);
    private KDComboBox cmbBotMapping = new KDComboBox();
    private boolean isCancel = true;
    private BTPBillListImpl btpImpl = null;
    private CtrlUnitInfo cu = null;
    private List<String> cuList = null;
    private Map<String, List<String>> orgBillIDs;
    private CoreBillBaseCollection srcBillInfos;
    private CoreBillListUI srcBillListUI;
    private Map destBillNameToObject;
    private String destBillTypeBOSType;
    private ArrayList destDetailEntryList = new ArrayList();
    private BOTMappingCollection botMappingCollection;
    private EntityViewInfo botpFilter;
    private static String RESNAME = "com.kingdee.eas.base.btp.btpResource";
    private static String handlerName = "com.kingdee.eas.base.btp.app.BTPMakeBillFIUIHandler";
    private String[] idList;
    private String[] entryNames;
    private List entriesKey;
    private String srcBillType;
    private SelectorItemCollection botpSelectors;
    private boolean isInitCbx = true;
    private static final String ORG = "org";
    private static final String BILLNUMBERS = "billNumbers";
    private static final String DESTBILL = "destBill";
    private static final String RULES = "rules";
    private static final String CHECK = "check";
    private static int flag = 0;
    private String transSucees = EASResource.getString((String)"com.kingdee.eas.base.btp.btpResource.transSuccess");
    private String transFailed = EASResource.getString((String)"com.kingdee.eas.base.btp.btpResource.transFailed");
    Map<String, List<String>> cuMap = new HashMap<String, List<String>>();
    Map<String, String> cuDestBillBosTypeMap = new HashMap<String, String>();
    Map<String, KDComboBox> cuCmbDestBosType = new HashMap<String, KDComboBox>();
    Map<String, BOTMappingInfo> cuMappingInfoMap = new HashMap<String, BOTMappingInfo>();
    Map<String, KDComboBox> cuCmbMappingInfo = new HashMap<String, KDComboBox>();
    Map<String, Integer> cuBillBumbersMap = new HashMap<String, Integer>();
    Map<BOSUuid, BOTMappingCollection> cuBOTMappingCollection = new HashMap<BOSUuid, BOTMappingCollection>();
    Map<String, Map> cuDestBillNameToObject = new HashMap<String, Map>();
    Map<String, Integer> cuRowNum = new HashMap<String, Integer>();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public IUIActionPostman prepareRPC(RequestContext request) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        handler.setAvailabe(true);
        request.setClassName(handlerName);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = (RequestContext)clientHanlder.getRequestContext();
        CtrlUnitInfo orgUnit = null;
        if (this.cu != null) {
            orgUnit = this.cu;
        } else {
            orgUnit = SysContext.getSysContext().getCurrentFIUnit();
            if (orgUnit != null) {
                orgUnit = orgUnit.getCU();
            }
        }
        HashMap<String, CtrlUnitInfo> transmitContext = new HashMap<String, CtrlUnitInfo>();
        transmitContext.put("TRANSMITCU", orgUnit);
        request.put("BTPMakeBillFIUI_Init_TRANSMITCU", transmitContext);
        this.idList = (String[])this.getUIContext().get("idList");
        this.entryNames = (String[])this.getUIContext().get("entryNames");
        this.entriesKey = (List)this.getUIContext().get("entriesKey");
        this.srcBillType = (String)this.getUIContext().get("srcBillType");
        this.botpSelectors = (SelectorItemCollection)this.getUIContext().get("botpSelectors");
        request.put("BTPMakeBillFIUI_Init_idList", (Object)this.idList);
        request.put("BTPMakeBillFIUI_Init_entryNames", (Object)this.entryNames);
        request.put("BTPMakeBillFIUI_Init_entriesKey", (Object)this.entriesKey);
        request.put("BTPMakeBillFIUI_Init_srcBillType", (Object)this.srcBillType);
        request.put("BTPMakeBillFIUI_Init_botpSelectors", (Object)this.botpSelectors);
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionConfirm.setEnabled(true);
        this.actionCancel.setEnabled(true);
        this.tblFIRules.checkParsed();
        this.idList = (String[])this.getUIContext().get("idList");
        this.entryNames = (String[])this.getUIContext().get("entryNames");
        this.entriesKey = (List)this.getUIContext().get("entriesKey");
        this.srcBillType = (String)this.getUIContext().get("srcBillType");
        this.botpSelectors = (SelectorItemCollection)this.getUIContext().get("botpSelectors");
        this.srcBillListUI = (CoreBillListUI)this.getUIContext().get("SRCBILLLIST");
        this.cu = (CtrlUnitInfo)this.getUIContext().get("ctrlUnit");
        this.cuList = (List)this.getUIContext().get("ctrlUnitList");
        this.orgBillIDs = (Map)this.getUIContext().get("cuBillsRelation");
        this.initUI();
        ThreadPool.setBackgroundRunButtonEnabled((boolean)true);
        this.actionConfirm.setDaemonRun(false);
    }

    private void initUI() throws Exception {
        this.loadSrcType();
        this.loadDestBillType();
        this.loadRuleStructure();
    }

    private void loadSrcType() {
        BOSUuid billID = BOSUuid.read((String)this.idList[0]);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo srcEntityInfo = loader.getEntity(BOSObjectType.create((String)billID.getType().toString()));
        IBotpMetaData srcBotpEntity = BotpMetaDataFactory.createEntity(srcEntityInfo);
        this.txtSrcBill.setText(srcBotpEntity.getDisplayName(this.getLocale()));
        this.txtSrcBill.setEditable(false);
    }

    private void loadDestBillType() throws Exception {
        this.cmbDestBosType = this.initDestBOSType();
        this.cmbDestBosType.setSelectedItem(this.cmbDestBosType.getItemAt(0));
        this.cmbDestBosType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    for (int i = 0; i < BTPMakeBillFIUI.this.cuList.size(); ++i) {
                        String orgID = (String)BTPMakeBillFIUI.this.cuList.get(i);
                        KDComboBox mappingInfoBox = BTPMakeBillFIUI.this.initCmbBotMapping(e.getItem(), BOSUuid.read((String)orgID));
                        ICell cell = BTPMakeBillFIUI.this.tblFIRules.getRow(i).setCell(3, BTPMakeBillFIUI.this.tblFIRules.getCell(i, 3));
                        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)mappingInfoBox));
                        cell.setValue(mappingInfoBox.getItemAt(0));
                        mappingInfoBox.setSelectedItem(mappingInfoBox.getItemAt(0));
                        BTPMakeBillFIUI.this.cuCmbMappingInfo.put(orgID, mappingInfoBox);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
    }

    private void loadRuleStructure() throws Exception {
        ArrayList<String> billIDList = new ArrayList<String>();
        for (int i = 0; i < this.idList.length; ++i) {
            billIDList.add(this.idList[i]);
        }
        this.buildRulesTable(this.tblFIRules, this.cuList);
    }

    private void buildRulesTable(KDTable tblRule, List<String> cuList) throws Exception {
        Object tableName = null;
        Object billOrgID = null;
        String billOrgName = null;
        ArrayList<String> billOrgNames = new ArrayList<String>();
        int size = cuList.size();
        for (int i = 0; i < size; ++i) {
            int count = 0;
            String orgID = cuList.get(i);
            this.cuRowNum.put(orgID, i);
            List<String> billIDs = this.orgBillIDs.get(orgID);
            count = billIDs.size();
            String sql = "select distinct fname_l2 as orgName from T_ORG_BaseUnit where fid='" + orgID + "'";
            SQLExecutor executor = new SQLExecutor(sql);
            IRowSet rowSet = executor.executeSQL();
            while (rowSet.next()) {
                billOrgName = rowSet.getString("orgName");
            }
            billOrgNames.add(billOrgName);
            this.cuBillBumbersMap.put(orgID, count);
            this.cuMap.put(orgID, billIDs);
            this.cmbBotMapping = this.initCmbBotMapping(this.cmbDestBosType.getSelectedItem(), BOSUuid.read((String)orgID));
            this.cuCmbMappingInfo.put(orgID, this.cmbBotMapping);
            this.cuCmbDestBosType.put(orgID, this.cmbDestBosType);
            IRow row = tblRule.addRow();
            ICell cellKey = row.getCell(ORG);
            cellKey.setValue(billOrgNames.get(i));
            cellKey.getStyleAttributes().setLocked(true);
            ICell billNums = row.getCell(BILLNUMBERS);
            billNums.setValue((Object)new Integer(count));
            billNums.getStyleAttributes().setLocked(true);
            if (this.cmbDestBosType.getItemCount() > 0) {
                this.isInitCbx = true;
                this.cmbDestBosType.setSelectedIndex(0);
            }
            this.isInitCbx = false;
            ICell rules = row.getCell(RULES);
            rules.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cmbBotMapping));
            rules.setValue(this.cmbBotMapping.getItemAt(0));
            this.cmbBotMapping.setSelectedItem(this.cmbBotMapping.getItemAt(0));
            ICell check = row.getCell(CHECK);
            if (this.cmbBotMapping.getItemCount() == 0) {
                check.setValue((Object)Boolean.FALSE);
                continue;
            }
            check.setValue((Object)Boolean.TRUE);
        }
    }

    protected KDComboBox initDestBOSType() throws BOSException, EASBizException {
        String targetTypeAndAliasString = BTPRPCHelper.getDestBOSTypeAndAliasString(this.srcBillType);
        String[] targetTypeAndAlias = StringUtil.split((String)targetTypeAndAliasString, (String)"|");
        assert (targetTypeAndAlias.length == 2);
        if (targetTypeAndAlias.length != 2) {
            MsgBox.showWarning((Component)((Component)this.getUIContext().get("Owner")), (String)EASResource.getString((String)"com.kingdee.eas.base.btp.btpResource.noDestBill"));
            SysUtil.abort();
        }
        String targetBillTypeString = targetTypeAndAlias[0];
        String targetAliasString = targetTypeAndAlias[1];
        String[] targetAlias = StringUtil.split((String)targetAliasString, (String)",");
        String[] targetBillType = StringUtil.split((String)targetBillTypeString, (String)",");
        assert (targetBillType.length == targetAlias.length);
        ArrayList<String> destBosType = new ArrayList<String>();
        int count = targetBillType.length;
        for (int i = 0; i < count; ++i) {
            destBosType.add(targetBillType[i]);
        }
        if (this.srcBillListUI instanceof IBOTFilterDestBosTypeByID) {
            ((IBOTFilterDestBosTypeByID)this.srcBillListUI).getDestBosTypeForBotpByID(this.idList, this.entryNames, this.entriesKey, destBosType);
        } else {
            this.srcBillInfos = BTPRPCHelper.getNewBillCollectionByType(this.srcBillType, this.idList, this.entryNames, this.entriesKey, this.botpSelectors);
            this.srcBillListUI.getDestBosTypeForBotp(this.srcBillInfos, destBosType);
        }
        if (destBosType == null || destBosType.size() < 1) {
            MsgBox.showWarning((Component)((Component)this.getUIContext().get("Owner")), (String)EASResource.getString((String)"com.kingdee.eas.base.btp.btpResource.noDestBill"));
            SysUtil.abort();
        }
        this.destBillNameToObject = new HashMap();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        for (int i = 0; i < targetBillType.length; ++i) {
            if (!destBosType.contains(targetBillType[i])) continue;
            EntityObjectInfo tempObj = loader.getEntity(BOSObjectType.create((String)targetBillType[i]));
            this.destBillNameToObject.put(targetAlias[i], targetBillType[i]);
            this.isInitCbx = true;
            this.cmbDestBosType.addItem((Object)targetAlias[i]);
        }
        return this.cmbDestBosType;
    }

    private KDComboBox initCmbBotMapping(Object selectCmbDestBosType, BOSUuid orgID) {
        CompanyOrgUnitInfo srcCompanyInfo;
        BOTMappingCollection botMappingCols = null;
        this.destBillTypeBOSType = this.destBillNameToObject.get(selectCmbDestBosType).toString();
        CtrlUnitInfo orgUnit = new CtrlUnitInfo(null, orgID);
        HashMap<String, CtrlUnitInfo> transmitContext = new HashMap<String, CtrlUnitInfo>();
        transmitContext.put("TRANSMITCU", orgUnit);
        CoreBillBaseInfo coreBillBaseInfo = this.srcBillInfos.get(0);
        if (coreBillBaseInfo instanceof BillBaseInfo && (srcCompanyInfo = ((BillBaseInfo)coreBillBaseInfo).getCompany()) != null) {
            CtrlUnitInfo srcOrgUnit = srcCompanyInfo.getCU();
            transmitContext.put("TRANSMITCU", srcOrgUnit);
        }
        try {
            botMappingCols = BTPRPCHelper.getMappingCollectionForSelectUseRuleFilter(this.srcBillType, this.destBillTypeBOSType, DefineSysEnum.BTP, transmitContext, this.idList, this.entryNames, this.entriesKey, this.botpSelectors);
            if (botMappingCols.size() == 0) {
                throw new BOTPException(BOTPException.MAPPINGNUMZERO);
            }
        }
        catch (BOTPException botE) {
            if (this.getUIWindow() != null) {
                logger.error((Object)botE);
            } else {
                logger.error((Object)botE);
            }
        }
        catch (BOSException e2) {
            e2.printStackTrace();
        }
        BOTMappingCollection botMappingCollection = botMappingCols;
        botMappingCollection = this.srcBillListUI.getRulesForBotp(this.destBillTypeBOSType, botMappingCollection);
        KDComboBox cmbBotMapping = new KDComboBox();
        if (botMappingCollection != null) {
            int count = botMappingCollection.size();
            for (int i = 0; i < count; ++i) {
                cmbBotMapping.addItem((Object)botMappingCollection.get(i).getAlias(SysContext.getSysContext().getLocale()));
            }
            if (count > 0) {
                cmbBotMapping.setSelectedIndex(0);
            }
        }
        this.cuBOTMappingCollection.put(orgID, botMappingCollection);
        return cmbBotMapping;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public boolean isPrepareActionConfirm() {
        return false;
    }

    @Override
    public RequestContext prepareActionConfirm(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionConfirm(itemAction);
        return request;
    }

    private BTPTransformResult tran(String[] transIDLists, String[] entryNames, List selectEntryIDs, SelectorItemCollection botpSelectors2, String destBillTypeBOSType2, ObjectUuidPK objectUuidPK, String srcBillType2) throws Exception {
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        BTPTransformResult btpResult = iBTPManager.transformForBotp(transIDLists, entryNames, selectEntryIDs, botpSelectors2, destBillTypeBOSType2, (IObjectPK)objectUuidPK, srcBillType2);
        return btpResult;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        String orgID;
        super.actionConfirm_actionPerformed(e);
        this.setCancel(false);
        if (this.btpImpl != null) {
            this.btpImpl.setCancel(false);
        }
        this.getUIWindow().close();
        KDComboBox cmbBotMapping = new KDComboBox();
        BOTMappingCollection botMappingCollection = new BOTMappingCollection();
        for (int i = 0; i < this.tblFIRules.getRowCount(); ++i) {
            orgID = this.cuList.get(i);
            cmbBotMapping = this.cuCmbMappingInfo.get(orgID);
            botMappingCollection = this.cuBOTMappingCollection.get(BOSUuid.read((String)orgID));
            for (int j = 0; j < cmbBotMapping.getItemCount(); ++j) {
                if (!this.tblFIRules.getCell(i, 3).getValue().equals(cmbBotMapping.getItemAt(j))) continue;
                BOTMappingInfo botMappingInfo = botMappingCollection.get(j);
                this.cuMappingInfoMap.put(orgID, botMappingInfo);
            }
        }
        BOTMappingInfo botMappingInfo = new BOTMappingInfo();
        HashMap<String, SelectorItemCollection> cuBotpSelectorsMap = new HashMap<String, SelectorItemCollection>();
        if (this.srcBillInfos != null && this.srcBillInfos.size() != 0) {
            BTPTransformResult btpResult = null;
            List<Object> transIDList = new ArrayList();
            HashMap<String, BTPTransformResult> cuBtpResultMap = new HashMap<String, BTPTransformResult>();
            ArrayList<String> errorMessage = new ArrayList<String>();
            ArrayList<String> e2Message = new ArrayList<String>();
            ArrayList<String> succesedMessage = new ArrayList<String>();
            String succesMessage = null;
            String failMessage = null;
            ArrayList<String> failedMessage = new ArrayList<String>();
            HashMap<String, BOTMappingInfo> transBotMappingInfo = new HashMap<String, BOTMappingInfo>();
            for (int i = 0; i < this.cuMap.size(); ++i) {
                orgID = this.cuList.get(i);
                int rowNum = this.cuRowNum.get(orgID);
                IRow row = this.tblFIRules.getRow(rowNum);
                ICell check = row.getCell(CHECK);
                if (Boolean.FALSE.equals(check.getValue())) continue;
                this.destBillTypeBOSType = this.destBillNameToObject.get(this.cmbDestBosType.getSelectedItem()).toString();
                this.srcBillListUI.beforeTransform((IObjectCollection)this.srcBillInfos, this.destBillTypeBOSType);
                botMappingInfo = this.cuMappingInfoMap.get(orgID);
                if (botMappingInfo == null) continue;
                transIDList = this.cuMap.get(orgID);
                flag = 0;
                BTPMakeBillFIUI.reBuildControl((CoreUI)this, botMappingInfo, transIDList, this.destBillTypeBOSType);
                this.botpSelectors = null;
                if (botMappingInfo.getIsTempSave() == 2) {
                    this.botpSelectors = BOTClientTools.getBillEditUISelector(this.destBillTypeBOSType);
                    cuBotpSelectorsMap.put(orgID, this.botpSelectors);
                }
                String[] transIDLists = new String[transIDList.size()];
                transIDLists = transIDList.toArray(transIDLists);
                this.botpSelectors = (SelectorItemCollection)cuBotpSelectorsMap.get(orgID);
                this.botpFilter = this.getQueryFilterFromBotMapping(botMappingInfo);
                this.srcBillInfos = BTPRPCHelper.getNewBillCollectionByType(this.srcBillType, transIDLists, this.entryNames, this.entriesKey, this.botpSelectors);
                transBotMappingInfo.put(orgID, botMappingInfo);
                try {
                    if (flag == 0) {
                        btpResult = this.tran(transIDLists, this.entryNames, this.getSelectEntryIDs(this.srcBillInfos), this.botpSelectors, this.destBillTypeBOSType, new ObjectUuidPK(botMappingInfo.getId().toString()), this.srcBillType);
                        cuBtpResultMap.put(orgID, btpResult);
                        succesMessage = (String)this.tblFIRules.getCell(i, 1).getValue();
                        succesedMessage.add(succesMessage);
                        continue;
                    }
                    if (flag != 1) continue;
                    failMessage = (String)this.tblFIRules.getCell(i, 1).getValue();
                    failedMessage.add(failMessage);
                    continue;
                }
                catch (Exception e2) {
                    String message = (String)this.tblFIRules.getCell(i, 1).getValue();
                    errorMessage.add(message);
                    if (!StringUtils.isEmpty((String)succesMessage) && StringUtils.isEmpty((String)failMessage)) {
                        succesMessage = ((Object)succesedMessage).toString().replace(",", "  " + this.transSucees + "\n");
                        succesMessage = succesMessage.replace("[", "");
                        succesMessage = succesMessage.replace("]", "  " + this.transSucees);
                        e2Message.add(message + " " + this.transFailed + ": " + e2.getMessage() + "\n");
                        logger.error((Object)(succesMessage + " " + message + " " + this.transFailed + ": " + e2.getMessage() + "\n"));
                        continue;
                    }
                    if (StringUtils.isEmpty((String)succesMessage) && !StringUtils.isEmpty((String)failMessage)) {
                        failMessage = ((Object)failedMessage).toString().replace(",", "  " + this.transFailed + "\n");
                        failMessage = failMessage.replace("[", "");
                        failMessage = failMessage.replace("]", "  " + this.transFailed);
                        e2Message.add(message + " " + this.transFailed + ": " + e2.getMessage() + "\n");
                        logger.error((Object)(failMessage + " " + message + " " + this.transFailed + ": " + e2.getMessage() + "\n"));
                        continue;
                    }
                    if (StringUtils.isEmpty((String)succesMessage) && !StringUtils.isEmpty((String)failMessage)) {
                        succesMessage = ((Object)succesedMessage).toString().replace(",", "  " + this.transSucees + "\n");
                        succesMessage = succesMessage.replace("[", "");
                        succesMessage = succesMessage.replace("]", "  " + this.transSucees);
                        failMessage = ((Object)failedMessage).toString().replace(",", "  " + this.transFailed + "\n");
                        failMessage = failMessage.replace("[", "");
                        failMessage = failMessage.replace("]", "  " + this.transFailed);
                        e2Message.add(message + " " + this.transFailed + ": " + e2.getMessage() + "\n");
                        logger.error((Object)(succesMessage + " " + failMessage + " " + message + " " + this.transFailed + ": " + e2.getMessage() + "\n"));
                        continue;
                    }
                    e2Message.add(message + " " + this.transFailed + ": " + e2.getMessage() + "\n");
                    logger.error((Object)(message + " " + this.transFailed + ": " + e2.getMessage() + "\n"));
                }
            }
            if (errorMessage.size() >= 1) {
                String showMessage = ((Object)errorMessage).toString().replace(",", "  " + this.transFailed + "\n");
                showMessage = showMessage.replace("[", "");
                showMessage = showMessage.replace("]", "  " + this.transFailed);
                if (succesedMessage.size() >= 1 && failedMessage.size() == 0) {
                    succesMessage = ((Object)succesedMessage).toString().replace(",", "  \n");
                    succesMessage = succesMessage.replace("[", "");
                    succesMessage = succesMessage.replace("]", "  " + this.transSucees);
                    String showError = ((Object)e2Message).toString();
                    MsgBox.showError((Component)((Object)this), (String)(succesMessage + "\n" + showMessage), (String)showError);
                } else if (succesedMessage.size() == 0 && failedMessage.size() >= 1) {
                    failMessage = ((Object)failedMessage).toString().replace(",", "  " + this.transFailed + "\n");
                    failMessage = failMessage.replace("[", "");
                    failMessage = failMessage.replace("]", "  " + this.transFailed);
                    String showError = ((Object)e2Message).toString();
                    MsgBox.showError((Component)((Object)this), (String)(failMessage + "\n" + showMessage), (String)showError);
                } else if (succesedMessage.size() >= 1 && failedMessage.size() >= 1) {
                    succesMessage = ((Object)succesedMessage).toString().replace(",", "  " + this.transSucees + "\n");
                    succesMessage = succesMessage.replace("[", "");
                    succesMessage = succesMessage.replace("]", "  " + this.transSucees);
                    failMessage = ((Object)failedMessage).toString().replace(",", "  " + this.transFailed + "\n");
                    failMessage = failMessage.replace("[", "");
                    failMessage = failMessage.replace("]", "  " + this.transFailed);
                    String showError = ((Object)e2Message).toString();
                    MsgBox.showError((Component)((Object)this), (String)(succesMessage + "\n" + failMessage + "\n" + showMessage), (String)showError);
                } else {
                    String showError = ((Object)e2Message).toString();
                    MsgBox.showError((Component)((Object)this), (String)showMessage, (String)showError);
                }
            } else {
                ArrayList<String> transNotSaveMessage = new ArrayList<String>();
                for (int i = 0; i < this.cuList.size(); ++i) {
                    BOTMappingInfo transMappingInfo;
                    orgID = this.cuList.get(i);
                    int rowNum = this.cuRowNum.get(orgID);
                    IRow row = this.tblFIRules.getRow(rowNum);
                    ICell check = row.getCell(CHECK);
                    if (Boolean.FALSE.equals(check.getValue()) || (transMappingInfo = (BOTMappingInfo)transBotMappingInfo.get(orgID)).getIsTempSave() != 2) continue;
                    String notSaveMessage = "\u89c4\u5219\uff1a     " + transMappingInfo.getAlias();
                    transNotSaveMessage.add(notSaveMessage);
                }
                if (transNotSaveMessage.size() >= 1) {
                    if (succesedMessage.size() >= 1) {
                        succesMessage = ((Object)succesedMessage).toString().replace(",", "  \n");
                        succesMessage = succesMessage.replace("[", "");
                        succesMessage = succesMessage.replace("]", "  " + this.transSucees + "\n\n");
                    }
                    if (failedMessage.size() >= 1) {
                        failMessage = ((Object)failedMessage).toString().replace(",", "  " + this.transFailed + "\n");
                        failMessage = failMessage.replace("[", "");
                        failMessage = failMessage.replace("]", "  " + this.transFailed);
                    }
                    String showNotSaveMessage = ((Object)transNotSaveMessage).toString().replace(",", "  \n");
                    showNotSaveMessage = showNotSaveMessage.replace("[", "");
                    showNotSaveMessage = showNotSaveMessage.replace("]", "\n\n\u89c4\u5219\u7684\u8f85\u52a9\u914d\u7f6e\u4e2d\u8bf7\u914d\u7f6e\u4e3a\u6682\u5b58\u6216\u8005\u63d0\u4ea4\u5355\u636e\uff0c\u5426\u5219\u4e0a\u4e0b\u67e5\u65f6\u6ca1\u6709\u751f\u6210\u7684\u76ee\u6807\u5355\u636e\uff01");
                    if (succesedMessage.size() >= 1 && failedMessage.size() == 0) {
                        MsgBox.showWarning((Component)((Object)this), (String)(succesMessage + "\n" + showNotSaveMessage));
                    } else if (succesedMessage.size() == 0 && failedMessage.size() >= 1) {
                        MsgBox.showWarning((Component)((Object)this), (String)(failMessage + "\n" + showNotSaveMessage));
                    } else if (succesedMessage.size() >= 1 && failedMessage.size() >= 1) {
                        MsgBox.showWarning((Component)((Object)this), (String)(succesMessage + "\n" + failMessage + "\n" + showNotSaveMessage));
                    } else {
                        MsgBox.showWarning((Component)((Object)this), (String)showNotSaveMessage);
                    }
                } else {
                    if (succesedMessage.size() >= 1) {
                        succesMessage = ((Object)succesedMessage).toString().replace(",", "  \n");
                        succesMessage = succesMessage.replace("[", "");
                        succesMessage = succesMessage.replace("]", "  " + this.transSucees + "\n\n");
                    }
                    if (failedMessage.size() >= 1) {
                        failMessage = ((Object)failedMessage).toString().replace(",", "  " + this.transFailed + "\n");
                        failMessage = failMessage.replace("[", "");
                        failMessage = failMessage.replace("]", "  " + this.transFailed);
                    }
                    if (succesedMessage.size() == 0 && failedMessage.size() >= 1) {
                        MsgBox.showWarning((Component)((Object)this), failMessage);
                    } else if (succesedMessage.size() >= 1 && failedMessage.size() >= 1) {
                        MsgBox.showWarning((Component)((Object)this), (String)(succesMessage + "\n" + failMessage));
                    } else {
                        MsgBox.showInfo((Component)((Object)this), (String)this.transSucees);
                    }
                }
            }
        }
    }

    public static void reBuildControl(CoreUI uiObj, BOTMappingInfo botMappingInfo, CoreBillBaseCollection srcBillInfos, String destBillTypeBOSType) throws Exception {
        String reBuildControl = "";
        String extconfig = botMappingInfo.getExtConfig();
        BotpExtConfigHelper.ExtConfigInfo info = null;
        BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper().new BotpExtConfigHelper.XMLProcessor();
        String botMappingAlias = botMappingInfo.getAlias();
        if (extconfig != null && !extconfig.equals("")) {
            info = processor.marshallingExtConfig(extconfig);
            reBuildControl = info.getReBuildControl();
            if (reBuildControl == null || reBuildControl.equals("")) {
                reBuildControl = "1";
            }
        } else {
            reBuildControl = "1";
        }
        if (reBuildControl.equals("1")) {
            return;
        }
        if (reBuildControl.equals("2")) {
            if (BTPMakeBillFIUI.hasReBuild(srcBillInfos, destBillTypeBOSType)) {
                MsgBox.showWarning((Component)uiObj, (String)("\u89c4\u5219\uff1a  " + botMappingAlias + "\n" + EASResource.getString((String)RESNAME, (String)"notReBuild")));
                flag = 1;
            }
        } else if (BTPMakeBillFIUI.hasReBuild(srcBillInfos, destBillTypeBOSType)) {
            int result = MsgBox.showConfirm2((Component)uiObj, (String)("\u89c4\u5219\uff1a  " + botMappingAlias + "\n" + EASResource.getString((String)RESNAME, (String)"reBuildHint")));
            if (result == 0) {
                return;
            }
            flag = 1;
        }
    }

    public static void reBuildControl(CoreUI uiObj, BOTMappingInfo botMappingInfo, List srcIdlist, String destBillTypeBOSType) throws Exception {
        String reBuildControl = "";
        String extconfig = botMappingInfo.getExtConfig();
        BotpExtConfigHelper.ExtConfigInfo info = null;
        BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper().new BotpExtConfigHelper.XMLProcessor();
        String botMappingAlias = botMappingInfo.getAlias();
        if (extconfig != null && !extconfig.equals("")) {
            info = processor.marshallingExtConfig(extconfig);
            reBuildControl = info.getReBuildControl();
            if (reBuildControl == null || reBuildControl.equals("")) {
                reBuildControl = "1";
            }
        } else {
            reBuildControl = "1";
        }
        if (reBuildControl.equals("1")) {
            return;
        }
        if (reBuildControl.equals("2")) {
            if (BTPMakeBillFIUI.hasReBuild(srcIdlist, destBillTypeBOSType)) {
                MsgBox.showWarning((Component)uiObj, (String)("\u89c4\u5219\uff1a  " + botMappingAlias + "\n" + EASResource.getString((String)RESNAME, (String)"notReBuild")));
                flag = 1;
            }
        } else if (BTPMakeBillFIUI.hasReBuild(srcIdlist, destBillTypeBOSType)) {
            int result = MsgBox.showConfirm2((Component)uiObj, (String)("\u89c4\u5219\uff1a  " + botMappingAlias + "\n" + EASResource.getString((String)RESNAME, (String)"reBuildHint")));
            if (result == 0) {
                return;
            }
            flag = 1;
        }
    }

    public static boolean hasReBuild(CoreBillBaseCollection srcBillInfos, String destBillTypeBOSType) throws BOSException {
        ArrayList<String> idlist = new ArrayList<String>();
        for (int i = 0; i < srcBillInfos.size(); ++i) {
            idlist.add(srcBillInfos.get(i).getId().toString());
        }
        return BTPMakeBillFIUI.hasReBuild(idlist, destBillTypeBOSType);
    }

    public static boolean hasReBuild(List idlist, String destBillTypeBOSType) throws BOSException {
        String billIds = StringUtils.arrayToString((Object[])idlist.toArray(), (String)",");
        IBOTRelation iBOTRelation = BOTRelationFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterBill = new FilterInfo();
        FilterInfo filterMapping = new FilterInfo();
        filterBill.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billIds, CompareType.INCLUDE));
        filterMapping.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBillTypeBOSType, CompareType.EQUALS));
        filterBill.mergeFilter(filterMapping, "And");
        viewInfo.setFilter(filterBill);
        BOTRelationCollection relations = iBOTRelation.getCollection(viewInfo);
        return relations != null && relations.size() != 0;
    }

    private void sortByRule(BOTMappingInfo botMappingInfo, CoreBillBaseCollection billCols) throws Exception {
        block8: {
            CoreBillBaseInfo bill;
            int i;
            String extconfig = botMappingInfo.getExtConfig();
            BotpExtConfigHelper.ExtConfigInfo info = null;
            BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper().new BotpExtConfigHelper.XMLProcessor();
            if (extconfig == null || extconfig.equals("")) break block8;
            try {
                info = processor.marshallingExtConfig(extconfig);
            }
            catch (DocumentException e) {
                logger.error((Object)e);
                throw e;
            }
            if (info.getOrderField() == null || info.getOrderField().equals("")) {
                return;
            }
            String orderField = info.getOrderField();
            String orderStyle = info.getOrderStyle();
            CoreBillBaseInfoComparator comparator = new CoreBillBaseInfoComparator(orderField);
            ArrayList<CoreBillBaseInfo> list = new ArrayList<CoreBillBaseInfo>();
            int size = billCols.size();
            for (i = 0; i < size; ++i) {
                bill = billCols.get(i);
                list.add(bill);
            }
            Collections.sort(list, comparator);
            billCols.clear();
            if (orderStyle.equals("asc")) {
                size = list.size();
                for (i = 0; i < size; ++i) {
                    bill = (CoreBillBaseInfo)list.get(i);
                    billCols.add(bill);
                }
            } else {
                for (i = list.size(); i > 0; --i) {
                    CoreBillBaseInfo bill2 = (CoreBillBaseInfo)list.get(i - 1);
                    billCols.add(bill2);
                }
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    private List getSelectEntryIDs(CoreBillBaseCollection srcBills) {
        ArrayList<String> entryids = new ArrayList<String>();
        if (this.srcBillListUI == null) {
            return entryids;
        }
        String entryName = this.srcBillListUI.getEntriesName();
        for (int i = 0; i < srcBills.size(); ++i) {
            CoreBillBaseInfo bills = srcBills.get(i);
            IObjectCollection entries = (IObjectCollection)bills.get(entryName);
            if (entries == null) {
                return entryids;
            }
            for (CoreBaseInfo cInfo : entries) {
                String ss = cInfo.getId().toString();
                entryids.add(ss);
            }
        }
        return entryids;
    }

    private EntityViewInfo getQueryFilterFromBotMapping(BOTMappingInfo botMappingInfo) throws ParserException, BOSException {
        EntityViewInfo filter = null;
        if (botMappingInfo.getExtRule().getFilter() != null && botMappingInfo.getExtRule().getFilter().length() > 0) {
            filter = BOTPTools.getEntityViewInfoFromMapping(botMappingInfo, 0);
        }
        EntityViewInfo dataFilter = null;
        if (botMappingInfo.getExtRule().getDataFilter() != null && botMappingInfo.getExtRule().getDataFilter().length() > 0) {
            dataFilter = BOTPTools.getEntityViewInfoFromMapping(botMappingInfo, 1);
        }
        EntityViewInfo botpFilter = this.mergeEntityFilterAndTransToQueryFilter(filter, dataFilter);
        return botpFilter;
    }

    private EntityViewInfo mergeEntityFilterAndTransToQueryFilter(EntityViewInfo filter, EntityViewInfo dataFilter) throws BOSException {
        EntityViewInfo botpFilter = new EntityViewInfo();
        if (filter == null) {
            botpFilter = dataFilter;
        } else if (dataFilter == null) {
            botpFilter = filter;
        } else {
            FilterInfo billFilter = null;
            if (filter.getFilter() == null || filter.getFilter().getFilterItems().size() == 0) {
                billFilter = dataFilter.getFilter();
            } else if (dataFilter.getFilter() == null || dataFilter.getFilter().getFilterItems().size() == 0) {
                billFilter = filter.getFilter();
            } else {
                billFilter = filter.getFilter();
                billFilter.mergeFilter(dataFilter.getFilter(), "and");
            }
            if (billFilter == null) {
                billFilter = new FilterInfo();
            }
            botpFilter.setFilter(billFilter);
            FilterCollection entryFilterCols = null;
            if (filter.getEntryFilters() == null && filter.getEntryFilters().size() == 0) {
                entryFilterCols = dataFilter.getEntryFilters();
            } else if (dataFilter.getEntryFilters() == null || dataFilter.getEntryFilters().size() == 0) {
                entryFilterCols = filter.getEntryFilters();
            } else {
                entryFilterCols = new FilterCollection();
                entryFilterCols.addObjectCollection((IObjectCollection)filter.getEntryFilters());
                entryFilterCols.addObjectCollection((IObjectCollection)dataFilter.getEntryFilters());
            }
            if (entryFilterCols != null && entryFilterCols.size() > 0) {
                botpFilter.getEntryFilters().addObjectCollection((IObjectCollection)entryFilterCols);
            }
        }
        if (botpFilter == null) {
            botpFilter = new EntityViewInfo();
        }
        if (botpFilter.getFilter() == null) {
            FilterInfo defaultFilter = new FilterInfo();
            botpFilter.setFilter(defaultFilter);
        }
        if (botpFilter.getEntryFilters() != null && botpFilter.getEntryFilters().size() > 0) {
            FilterCollection entryFilterCols = botpFilter.getEntryFilters();
            FilterInfo billFilter = botpFilter.getFilter();
            FilterInfo entryQueryFilter = new FilterInfo();
            if (entryFilterCols != null && entryFilterCols.size() > 0) {
                int size = entryFilterCols.size();
                for (int i = 0; i < size; ++i) {
                    FilterInfo entryFilterInfo = entryFilterCols.get(i);
                    if (entryFilterInfo == null || entryFilterInfo.getFilterItems().size() <= 0) continue;
                    String entryName = entryFilterInfo.getEntryName();
                    int count = entryFilterInfo.getFilterItems().size();
                    for (int j = 0; j < count; ++j) {
                        entryQueryFilter.getFilterItems().add(new FilterItemInfo(entryName + '.' + entryFilterInfo.getFilterItems().get(j).getPropertyName(), entryFilterInfo.getFilterItems().get(j).getCompareValue(), entryFilterInfo.getFilterItems().get(j).getCompareType()));
                    }
                    if (i == 0) {
                        entryQueryFilter.setMaskString(entryFilterInfo.getMaskString());
                        continue;
                    }
                    entryQueryFilter.setMaskString(entryQueryFilter.getMaskString() + " and " + entryFilterInfo.getMaskString());
                }
            }
            if (entryQueryFilter.getFilterItems().size() > 0) {
                if (billFilter.getFilterItems().size() > 0) {
                    billFilter.mergeFilter(entryQueryFilter, "and");
                } else {
                    billFilter = entryQueryFilter;
                }
            }
            botpFilter.getEntryFilters().clear();
            botpFilter.setFilter(billFilter);
        }
        return botpFilter;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public void setBTPImplCaller(BTPBillListImpl btpImpl) {
        this.btpImpl = btpImpl;
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudFeed_actionPerformed(e);
    }

    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudShare_actionPerformed(e);
    }

    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudScreen_actionPerformed(e);
    }

    public void actionXunTongFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionXunTongFeed_actionPerformed(e);
    }

    class CoreBillBaseInfoComparator
    implements Comparator {
        String orderField = null;

        public CoreBillBaseInfoComparator(String orderField) {
            this.orderField = orderField;
        }

        public int compare(Object arg0, Object arg1) {
            CoreBillBaseInfo info1 = (CoreBillBaseInfo)arg0;
            CoreBillBaseInfo info2 = (CoreBillBaseInfo)arg1;
            Object value1 = info1.get(this.orderField);
            Object value2 = info2.get(this.orderField);
            if (value1 == null || value2 == null) {
                return 0;
            }
            if (value1 instanceof BigDecimal) {
                return ((BigDecimal)value1).compareTo((BigDecimal)value2);
            }
            if (value1 instanceof Integer) {
                return ((Integer)value1).compareTo((Integer)value2);
            }
            if (value1 instanceof Date) {
                return ((Date)value1).compareTo((Date)value2);
            }
            return value1.toString().compareToIgnoreCase(value2.toString());
        }
    }
}

