/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.common.configuredfield;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.EntityRefInfo;
import com.kingdee.bos.config.MetadataRefDetailInfo;
import com.kingdee.bos.config.MetadataRefInfo;
import com.kingdee.bos.config.ModuleEnum;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.eas.base.common.configuredfield.IEntityRefRegister;
import com.kingdee.eas.base.common.configuredfield.RegisterManager;
import com.kingdee.eas.base.common.configuredfield.register.RegisterUtil;
import java.util.List;

public abstract class AbstractEntityRefRegister
implements IEntityRefRegister {
    @Override
    public void register(IObjectValue ov, Context ctx) throws BOSException {
        EntityRefInfo[] entityRefs = this.getEntityRefList(ov, ctx);
        RegisterManager rm = new RegisterManager();
        if (entityRefs != null && entityRefs.length > 0) {
            rm.register(entityRefs, ctx);
        }
    }

    protected EntityRefInfo[] getEntityRefs(List entityRefList) {
        return entityRefList.toArray(new EntityRefInfo[0]);
    }

    public abstract EntityRefInfo[] getEntityRefList(IObjectValue var1, Context var2) throws BOSException;

    @Override
    public void registerUpdate(IObjectValue ov, Context ctx) throws BOSException {
        EntityRefInfo[] entityRefs = this.getEntityRefList(ov, ctx);
        RegisterManager rm = new RegisterManager();
        if (entityRefs != null && entityRefs.length > 0) {
            rm.unRegister(entityRefs, ctx);
            rm.register(entityRefs, ctx);
        }
    }

    @Override
    public void unRegister(IObjectValue ov, Context ctx) throws BOSException {
        EntityRefInfo[] entityRefs = this.getEntityRefList(ov, ctx);
        RegisterManager rm = new RegisterManager();
        if (entityRefs != null && entityRefs.length > 0) {
            rm.unRegister(entityRefs, ctx);
        }
    }

    @Override
    public void unRegister(IObjectPK[] objectKeys, Context ctx) throws BOSException {
        RegisterManager rm = new RegisterManager();
        rm.unRegister(objectKeys, ctx);
    }

    protected EntityRefInfo createEntityRefInfo(String[] propNames, IMetaDataPK pk, String objectKey, Context ctx) {
        EntityRefInfo erf = new EntityRefInfo();
        erf.setMetaDataPK(this.getMetaDataPKStr());
        erf.setModule(this.getModule());
        erf.setObjectKey(objectKey);
        for (int i = 0; i < propNames.length; ++i) {
            MetadataRefDetailInfo detailInfo = this.createMetadataRefDetailInfo(propNames[i], pk, objectKey, ctx);
            if (detailInfo == null) continue;
            detailInfo.setParent((MetadataRefInfo)erf);
            erf.getDetails().add(detailInfo);
        }
        return erf;
    }

    protected MetadataRefDetailInfo createMetadataRefDetailInfo(String propName, IMetaDataPK pk, String objectKey, Context ctx) {
        PropertyInfo propertyInfo = RegisterUtil.getProp(propName, pk, ctx);
        if (propertyInfo == null || !propertyInfo.isConfigured()) {
            return null;
        }
        MetadataRefDetailInfo detail = new MetadataRefDetailInfo();
        detail.setBosType(propertyInfo.getBOSType().toString());
        detail.setKey(propertyInfo.getName());
        detail.setObjectKey(objectKey);
        detail.setCanDelete(this.isCanDelete());
        return detail;
    }

    protected EntityRefInfo createEntityRefInfo(String[] propNames, String bosType, String objectKey, Context ctx) {
        EntityRefInfo erf = new EntityRefInfo();
        erf.setMetaDataPK(this.getMetaDataPKStr());
        erf.setModule(this.getModule());
        erf.setObjectKey(objectKey);
        for (int i = 0; i < propNames.length; ++i) {
            MetadataRefDetailInfo detailInfo = this.createMetadataRefDetailInfo(propNames[i], bosType, objectKey, ctx);
            if (detailInfo == null) continue;
            detailInfo.setParent((MetadataRefInfo)erf);
            erf.getDetails().add(detailInfo);
        }
        return erf;
    }

    protected MetadataRefDetailInfo createMetadataRefDetailInfo(String propName, String bosType, String objectKey, Context ctx) {
        PropertyInfo propertyInfo = RegisterUtil.getProp(propName, bosType, ctx);
        if (propertyInfo == null || !propertyInfo.isConfigured()) {
            return null;
        }
        MetadataRefDetailInfo detail = new MetadataRefDetailInfo();
        detail.setBosType(propertyInfo.getBOSType().toString());
        detail.setKey(propertyInfo.getName());
        detail.setObjectKey(objectKey);
        detail.setCanDelete(this.isCanDelete());
        return detail;
    }

    @Override
    public void processOtherRegister(IServiceContext serviceContext) throws BOSException {
    }

    protected String getMetaDataPKStr() {
        return "";
    }

    protected ModuleEnum getModule() {
        return null;
    }

    protected boolean isCanDelete() {
        return false;
    }
}

