/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.ContextUtil;
import org.apache.log4j.Logger;

public class PermissionChecker {
    private static final Logger logger = Logger.getLogger(PermissionChecker.class);

    public static boolean hasEditOtherCQSolutionPerm(Context ctx) {
        try {
            IPermission perm = null;
            perm = ctx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
            return PermissionChecker.isSuperAdministrator(ctx) || perm.hasFunctionPermission(PermissionChecker.getCurUser(ctx), PermissionChecker.getCurCU(ctx), PermissionChecker.getItemName());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static IObjectPK getCurUser(Context ctx) {
        if (ctx == null) {
            return new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        }
        return new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
    }

    private static IObjectPK getCurCU(Context ctx) {
        if (ctx == null) {
            return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
        }
        return new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
    }

    private static String getItemName() {
        return "querysolutionmanage";
    }

    private static boolean isSuperAdministrator(Context ctx) {
        if (ctx == null) {
            return "administrator".equalsIgnoreCase(SysContext.getSysContext().getCurrentUserInfo().getNumber());
        }
        return "administrator".equalsIgnoreCase(ContextUtil.getCurrentUserInfo((Context)ctx).getNumber());
    }
}

