/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery;

import com.kingdee.eas.base.commonquery.CustomerParams;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XMLBean {
    private static final Logger logger = Logger.getLogger(XMLBean.class);
    private String name;
    private String value;

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector LoadXML(String path) throws Exception {
        Vector<XMLBean> xmlVector = null;
        FileInputStream fi = null;
        try {
            fi = new FileInputStream(path);
            xmlVector = new Vector<XMLBean>();
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build((InputStream)fi);
            Element root = doc.getRootElement();
            List properties = root.getChildren();
            Element property = null;
            XMLBean xml = null;
            for (int i = 0; i < properties.size(); ++i) {
                xml = new XMLBean();
                property = (Element)properties.get(i);
                xml.setName(property.getChild("name").getText());
                xml.setValue(property.getChild("value").getText());
                xmlVector.add(xml);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                fi.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return xmlVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DelXML(String path, int xmlid) throws Exception {
        FileInputStream fi = null;
        FileOutputStream fo = null;
        try {
            fi = new FileInputStream(path);
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build((InputStream)fi);
            Element root = doc.getRootElement();
            List properties = root.getChildren();
            properties.remove(xmlid);
            Format format = Format.getRawFormat();
            format.setIndent(" ");
            format.setEncoding("GBK");
            XMLOutputter outp = new XMLOutputter(format);
            fo = new FileOutputStream(path);
            outp.output(doc, (OutputStream)fo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
                if (fo != null) {
                    fo.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void AddXML(String path, String name, String sex) throws Exception {
        FileInputStream fi = null;
        FileOutputStream fo = null;
        try {
            fi = new FileInputStream(path);
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build((InputStream)fi);
            Element root = doc.getRootElement();
            List properties = root.getChildren();
            Element newproperty = new Element("Property");
            Element newName = new Element("Name");
            newName.setText(name);
            newproperty.addContent((Content)newName);
            Element newValue = new Element("Value");
            newValue.setText(sex);
            newproperty.addContent((Content)newValue);
            properties.add(newproperty);
            Format format = Format.getRawFormat();
            format.setIndent(" ");
            format.setEncoding("GBK");
            XMLOutputter outp = new XMLOutputter(format);
            fo = new FileOutputStream(path);
            outp.output(doc, (OutputStream)fo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
                if (fo != null) {
                    fo.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void EditXML(String path, int xmlid, String name, String sex) throws Exception {
        FileInputStream fi = null;
        FileOutputStream fo = null;
        try {
            fi = new FileInputStream(path);
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build((InputStream)fi);
            Element root = doc.getRootElement();
            List properties = root.getChildren();
            Element property = (Element)properties.get(xmlid);
            Element newName = property.getChild("Name");
            newName.setText(name);
            Element newValue = property.getChild("Value");
            newValue.setText(sex);
            Format format = Format.getRawFormat();
            format.setIndent(" ");
            format.setEncoding("GBK");
            XMLOutputter outp = new XMLOutputter(format);
            fo = new FileOutputStream(path);
            outp.output(doc, (OutputStream)fo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
                if (fo != null) {
                    fo.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static String CreateXMLStr(ArrayList al) throws Exception {
        Object xmlVector = null;
        Document myDocument = null;
        String returnStr = null;
        try {
            Element rootElement = new Element("properties");
            myDocument = new Document(rootElement);
            for (int i = 0; i < al.size(); ++i) {
                Element property = new Element("property");
                rootElement.addContent((Content)property);
                property.addContent((Content)new Element("name").addContent(((XMLBean)al.get(i)).getName()));
                property.addContent((Content)new Element("value").addContent(((XMLBean)al.get(i)).getValue().toString()));
            }
            Format format = Format.getRawFormat();
            format.setIndent("  ");
            XMLOutputter outputter = new XMLOutputter(format);
            outputter.output(myDocument, (OutputStream)System.out);
            StringWriter strWriter = new StringWriter();
            outputter.output(myDocument, (Writer)strWriter);
            returnStr = strWriter.toString();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return returnStr;
    }

    public static String CreateXMLStr(HashMap hm) throws Exception {
        Object xmlVector = null;
        Document myDocument = null;
        String returnStr = null;
        try {
            Element rootElement = new Element("properties");
            myDocument = new Document(rootElement);
            for (String key : hm.keySet()) {
                String value = (String)hm.get(key);
                Element property = new Element("property");
                rootElement.addContent((Content)property);
                property.addContent((Content)new Element("name").addContent(key));
                property.addContent((Content)new Element("value").addContent(value));
            }
            Format format = Format.getRawFormat();
            format.setIndent("  ");
            XMLOutputter outputter = new XMLOutputter(format);
            outputter.output(myDocument, (OutputStream)System.out);
            StringWriter strWriter = new StringWriter();
            outputter.output(myDocument, (Writer)strWriter);
            returnStr = strWriter.toString();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return returnStr;
    }

    public static String CreateXMLStr(Collection a, Collection b) throws Exception {
        Object xmlVector = null;
        Document myDocument = null;
        String returnStr = null;
        try {
            Element rootElement = new Element("properties");
            myDocument = new Document(rootElement);
            Iterator j = a.iterator();
            Iterator k = b.iterator();
            while (j.hasNext() && k.hasNext()) {
                Element property = new Element("property");
                try {
                    rootElement.addContent((Content)property);
                    property.addContent((Content)new Element("name").addContent((String)j.next()));
                    property.addContent((Content)new Element("value").addContent((String)k.next()));
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            Format format = Format.getRawFormat();
            format.setIndent("  ");
            format.setEncoding("GBK");
            XMLOutputter outputter = new XMLOutputter(format);
            outputter.output(myDocument, (OutputStream)System.out);
            StringWriter strWriter = new StringWriter();
            outputter.output(myDocument, (Writer)strWriter);
            returnStr = strWriter.toString();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return returnStr;
    }

    public static String CreateXMLStrRecursion(Collection a, Collection b) throws Exception {
        Object xmlVector = null;
        Document myDocument = null;
        String returnStr = null;
        try {
            Element rootElement = new Element("properties");
            myDocument = new Document(rootElement);
            XMLBean.writeToXml(rootElement, a, b);
            Format format = Format.getRawFormat();
            format.setIndent("  ");
            format.setEncoding("utf-8");
            XMLOutputter outputter = new XMLOutputter(format);
            outputter.output(myDocument, (OutputStream)System.out);
            StringWriter strWriter = new StringWriter();
            outputter.output(myDocument, (Writer)strWriter);
            returnStr = strWriter.toString();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return returnStr;
    }

    private static void writeToXml(Element mapElement, Collection a, Collection b) {
        Iterator j = a.iterator();
        Iterator k = b.iterator();
        while (j.hasNext() && k.hasNext()) {
            Element property = new Element("property");
            try {
                mapElement.addContent((Content)property);
                property.addContent((Content)new Element("name").addContent((String)j.next()));
                Object ob = k.next();
                CustomerParams cp = XMLBean.getCustomerParams(ob);
                if (cp != null) {
                    Collection keys = cp.getKeys();
                    Collection values = cp.getValues();
                    Element mapElementNode = new Element("properties");
                    property.addContent((Content)mapElementNode);
                    XMLBean.writeToXml(mapElementNode, keys, values);
                    continue;
                }
                property.addContent((Content)new Element("value").addContent(ob.toString()));
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private static CustomerParams getCustomerParams(Object obj) {
        String className = obj.getClass().getName();
        CustomerParams commonCustomerParams = null;
        if ("com.kingdee.eas.base.commonquery.client.CustomerParams".equals(className)) {
            com.kingdee.eas.base.commonquery.client.CustomerParams clienCustomerParams = (com.kingdee.eas.base.commonquery.client.CustomerParams)obj;
            commonCustomerParams = clienCustomerParams.castToCommonCustomerParams();
        } else if (obj instanceof CustomerParams) {
            commonCustomerParams = (CustomerParams)obj;
        }
        return commonCustomerParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList TransStrToAL(String customerParams) throws Exception {
        StringReader in = null;
        ArrayList<XMLBean> xmlList = null;
        try {
            in = new StringReader(customerParams);
            xmlList = new ArrayList<XMLBean>();
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build((Reader)in);
            Element root = doc.getRootElement();
            List properties = root.getChildren();
            Element property = null;
            XMLBean xml = null;
            for (int i = 0; i < properties.size(); ++i) {
                xml = new XMLBean();
                property = (Element)properties.get(i);
                xml.setName(property.getChild("name").getText());
                xml.setValue(property.getChild("value").getText());
                xmlList.add(xml);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                ((Reader)in).close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return xmlList;
    }

    public static com.kingdee.eas.base.commonquery.client.CustomerParams TransStrToCustParams(String customerParams) throws Exception {
        return com.kingdee.eas.base.commonquery.client.CustomerParams.castToClientCustomerParams(XMLBean.transStrToCommonCustParams(customerParams));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CustomerParams transStrToCommonCustParams(String customerParams) throws Exception {
        CustomerParams cp = new CustomerParams();
        Object fi = null;
        StringReader in = null;
        HashMap hm = null;
        try {
            in = new StringReader(customerParams);
            hm = new HashMap();
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build((Reader)in);
            Element root = doc.getRootElement();
            List properties = root.getChildren();
            hm = XMLBean.readFromXml(hm, properties);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                ((Reader)in).close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        cp.setHm(hm);
        return cp;
    }

    private static HashMap readFromXml(HashMap hm, List properties) {
        XMLBean xml = null;
        Element property = null;
        for (int i = 0; i < properties.size(); ++i) {
            xml = new XMLBean();
            property = (Element)properties.get(i);
            xml.setName(property.getChild("name").getText());
            if (property.getChild("value") == null && property.getChild("properties") != null) {
                Element rootElement = property.getChild("properties");
                CustomerParams cp = new CustomerParams();
                HashMap map = XMLBean.readFromXml(cp.getCustomerParamsHashMap(), rootElement.getChildren());
                cp.setHm(map);
                hm.put(xml.getName(), cp);
                continue;
            }
            if (property.getChild("value") == null) continue;
            xml.setValue(property.getChild("value").getText());
            hm.put(xml.getName(), xml.getValue());
        }
        return hm;
    }
}

