/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.DyAssignUserInfoCollection;
import com.kingdee.eas.base.commonquery.DyAssignUserInfoFactory;
import com.kingdee.eas.base.commonquery.DyAssignUserInfoInfo;
import com.kingdee.eas.base.commonquery.DynamicSolutionFactory;
import com.kingdee.eas.base.commonquery.DynamicSolutionInfo;
import com.kingdee.eas.base.commonquery.IDyAssignUserInfo;
import com.kingdee.eas.base.commonquery.IDynamicSolution;
import com.kingdee.eas.base.commonquery.client.AbstractDySolutionUnAssignUI;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DySolutionUnAssignUI
extends AbstractDySolutionUnAssignUI {
    private static final Logger logger = CoreUIObject.getLogger(DySolutionUnAssignUI.class);
    private static final String commonRes = "com.kingdee.eas.base.commonquery.client.DynamicQueryResource";
    private HashMap map = new HashMap();

    public DySolutionUnAssignUI() throws Exception {
        this.init();
    }

    private void init() {
        this.unAssignButton.setIcon(EASResource.getIcon((String)"imgTbtn_undistribute"));
        this.allSelectButton.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.allClearButton.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.kDTable1.doLayout();
        IColumn column = this.kDTable1.getColumn(0);
        IColumn column2 = this.kDTable1.getColumn(2);
        IColumn column3 = this.kDTable1.getColumn(3);
        IColumn column4 = this.kDTable1.getColumn(4);
        column.getStyleAttributes().setLocked(true);
        column2.getStyleAttributes().setLocked(true);
        column3.getStyleAttributes().setLocked(true);
        column4.getStyleAttributes().setLocked(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String id = (String)this.getUIContext().get("solutionId");
        if (!StringUtils.isEmpty((String)id)) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            try {
                IDynamicSolution dy = DynamicSolutionFactory.getRemoteInstance();
                DynamicSolutionInfo info = dy.getDynamicSolutionInfo((IObjectPK)pk);
                this.DySolutionBox.setData((Object)info);
                this.DySolutionBox.setQueryInfo("com.kingdee.eas.base.commonquery.app.DynamicSolutionQuery");
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void fillTable(DyAssignUserInfoCollection coll) throws Exception {
        int size = coll.size();
        this.kDTable1.removeRows();
        for (int i = 0; i < size; ++i) {
            DyAssignUserInfoInfo info = coll.get(i);
            if (info.getUser() == null) continue;
            String id = info.getUser().getId().toString();
            ObjectUuidPK pk = new ObjectUuidPK(id);
            UserInfo uInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)pk);
            IRow row = this.kDTable1.addRow();
            this.setRowData(row, uInfo);
            this.map.put(uInfo.getId().toString(), uInfo);
        }
    }

    private void setRowData(IRow row, UserInfo info) {
        row.getCell(0).setValue((Object)info.getId());
        row.getCell(1).setValue((Object)new Boolean(true));
        row.getCell(2).setValue((Object)info.getName());
        row.getCell(3).setValue((Object)info.getNumber());
        if (info.getCU().getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)info.getCU().getId().toString()));
            try {
                CtrlUnitInfo ctrlInfo = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)pk);
                row.getCell(4).setValue((Object)ctrlInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void unAssignSolution() throws Exception {
        int size = this.kDTable1.getRowCount();
        if (this.DySolutionBox.getData() == null || size == 0) {
            MsgBox.showError((String)EASResource.getString((String)commonRes, (String)"NoSolutionUser"));
            return;
        }
        DynamicSolutionInfo info = (DynamicSolutionInfo)this.DySolutionBox.getData();
        DyAssignUserInfoCollection coll = new DyAssignUserInfoCollection();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kDTable1.getRow(i);
            try {
                IDyAssignUserInfo dy = DyAssignUserInfoFactory.getRemoteInstance();
                if (!row.getCell(1).getValue().toString().equals("true")) continue;
                DyAssignUserInfoInfo assignInfo = new DyAssignUserInfoInfo();
                assignInfo.setSolution(info);
                UserInfo userinfo = (UserInfo)this.map.get(row.getCell(0).getValue().toString());
                assignInfo.setUser(userinfo);
                FilterInfo filterInfo = new FilterInfo();
                String maskString = null;
                FilterItemInfo queryUser = new FilterItemInfo("user", (Object)assignInfo.getUser().getId());
                filterInfo.getFilterItems().add(queryUser);
                FilterItemInfo querySolution = new FilterItemInfo("solution", (Object)assignInfo.getSolution().getId());
                filterInfo.getFilterItems().add(querySolution);
                maskString = " #0 and #1 ";
                filterInfo.setMaskString(maskString);
                dy.delete(filterInfo);
                coll.add(assignInfo);
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (coll.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)commonRes, (String)"NoSolutionUser"));
            return;
        }
        MsgBox.showInfo((String)EASResource.getString((String)commonRes, (String)"UnassignSuccess"));
        this.DySolutionBox_dataChanged(null);
    }

    @Override
    protected void DySolutionBox_dataChanged(DataChangeEvent e) throws Exception {
        super.DySolutionBox_dataChanged(e);
        if (this.DySolutionBox.getData() != null) {
            DynamicSolutionInfo info = (DynamicSolutionInfo)this.DySolutionBox.getData();
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)info.getId().toString()));
            IDynamicSolution dy = DynamicSolutionFactory.getRemoteInstance();
            DynamicSolutionInfo infoTemp = dy.getDynamicSolutionInfo((IObjectPK)pk);
            DyAssignUserInfoCollection coll = infoTemp.getAssignUser();
            this.fillTable(coll);
        }
    }

    @Override
    protected void allClearButton_actionPerformed(ActionEvent e) throws Exception {
        super.allClearButton_actionPerformed(e);
        int size = this.kDTable1.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kDTable1.getRow(i);
            Boolean flag = new Boolean(false);
            row.getCell(1).setValue((Object)flag);
        }
    }

    @Override
    protected void allSelectButton_actionPerformed(ActionEvent e) throws Exception {
        super.allSelectButton_actionPerformed(e);
        int size = this.kDTable1.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kDTable1.getRow(i);
            Boolean flag = new Boolean(true);
            row.getCell(1).setValue((Object)flag);
        }
    }

    @Override
    protected void unAssignButton_actionPerformed(ActionEvent e) throws Exception {
        super.unAssignButton_actionPerformed(e);
        this.unAssignSolution();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }
}

