/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemCollection;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.JoinType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.ColumnItemData;
import com.kingdee.eas.base.commonquery.CompareTypeEnum;
import com.kingdee.eas.base.commonquery.DynQueryEntityJoinFieldCollection;
import com.kingdee.eas.base.commonquery.DynQueryEntityJoinFieldInfo;
import com.kingdee.eas.base.commonquery.DynQuerySelectFieldCollection;
import com.kingdee.eas.base.commonquery.DynQuerySelectFieldInfo;
import com.kingdee.eas.base.commonquery.DynQuerySolutionCollection;
import com.kingdee.eas.base.commonquery.DynQuerySolutionFactory;
import com.kingdee.eas.base.commonquery.DynQuerySubEntityTreeCollection;
import com.kingdee.eas.base.commonquery.DynQuerySubEntityTreeInfo;
import com.kingdee.eas.base.commonquery.IDynQuerySolution;
import com.kingdee.eas.base.commonquery.IUserOrgDynQuery;
import com.kingdee.eas.base.commonquery.LinkTypeEnum;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.TableXMLHelper;
import com.kingdee.eas.base.commonquery.TreeNodeInfo;
import com.kingdee.eas.base.commonquery.UserCustomConfigItemData;
import com.kingdee.eas.base.commonquery.UserOrgDynQueryCollection;
import com.kingdee.eas.base.commonquery.UserOrgDynQueryFactory;
import com.kingdee.eas.base.commonquery.client.TreeUtil;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.tools.datatask.client.SimpleValueObjectInfo;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.jdom2.JDOMException;

public class DynQueryUtil {
    private static final Logger logger = Logger.getLogger(DynQueryUtil.class);
    private static final int LINKPROPCOUNT = 10;

    public static void initJoinType(KDComboBox box) {
        box.addItem((Object)LinkTypeEnum.INNERJOIN);
        box.addItem((Object)LinkTypeEnum.LEFTJOIN);
        box.addItem((Object)LinkTypeEnum.RIGHTJOIN);
    }

    public static void initEntityTree(QueryInfo queryInfo, KDTree tree) throws BOSException {
        if (queryInfo == null || tree == null) {
            return;
        }
        tree.setModel(null);
        SubObjectInfo mainInfo = queryInfo.getMainObject();
        DefaultKingdeeTreeNode rootNode = DynQueryUtil.createRootNode(mainInfo);
        tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)rootNode));
        tree.setSelectionNode(rootNode);
    }

    public static void initQuerySelectorArea(QueryInfo queryInfo, KDList list, DynQuerySubEntityTreeCollection coll, List visibleList) throws BOSException, EASBizException {
        if (queryInfo == null || list == null) {
            return;
        }
        list.removeAllElements();
        PropertyUnitCollection selectorInfo = queryInfo.getUnits();
        QueryFieldCollection fields = selectorInfo.getQueryFields();
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            DynQuerySelectFieldInfo fieldInfo = DynQueryUtil.convertDynQuerySelectField(coll, fields.get(i));
            if (fieldInfo == null) continue;
            fieldInfo.setIsInSelect(true);
            DynQueryUtil.addFieldToList(list, fieldInfo, visibleList);
        }
        if (list.getModel().getSize() > 0) {
            list.setSelectedIndex(0);
        }
    }

    public static DynQuerySubEntityTreeCollection convertEntityTreeCollection(DefaultKingdeeTreeNode rootNode) {
        DynQuerySubEntityTreeCollection coll = new DynQuerySubEntityTreeCollection();
        ArrayList al = TreeUtil.getUserObjectIncludeChild(rootNode);
        int size = al.size();
        for (int i = 0; i < size; ++i) {
            coll.add((DynQuerySubEntityTreeInfo)al.get(i));
        }
        return coll;
    }

    private static DynQuerySubEntityTreeInfo getDynQuerySubEntityTree(DynQuerySubEntityTreeCollection coll, QueryFieldInfo fieldInfo) {
        if (fieldInfo == null || fieldInfo.getPropertyRefs() == null || fieldInfo.getPropertyRefs().get(0) == null) {
            return null;
        }
        SubEntityInfo subEntity = fieldInfo.getPropertyRefs().get(0).getSubEntity();
        if (subEntity == null) {
            return null;
        }
        String name = subEntity.getName();
        return DynQueryUtil.getSameTreeInfo(coll, name);
    }

    private static DynQuerySubEntityTreeInfo getSameTreeInfo(DynQuerySubEntityTreeCollection coll, String name) {
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.get(i).getNumber().equals(name)) continue;
            return coll.get(i);
        }
        return null;
    }

    private static DynQuerySelectFieldInfo convertDynQuerySelectField(DynQuerySubEntityTreeCollection coll, QueryFieldInfo qfInfo) {
        DynQuerySelectFieldInfo dsfInfo = new DynQuerySelectFieldInfo();
        dsfInfo.setNumber(qfInfo.getName());
        dsfInfo.setName(qfInfo.getDisplayName());
        dsfInfo.setIsOrderBy(qfInfo.isIsSorter());
        dsfInfo.setIsVisibleInTable(false);
        boolean isMustInSelect = !"true".equalsIgnoreCase(qfInfo.getExtendedProperty("DYNAMIC_CAN_DELETE"));
        dsfInfo.setIsMustInSelect(isMustInSelect);
        String theExtendPropertyValue = qfInfo.getExtendedProperty("isCommonQueryFilter");
        if (theExtendPropertyValue != null && theExtendPropertyValue.equals("true")) {
            dsfInfo.setIsFilter(true);
        } else {
            dsfInfo.setIsFilter(false);
        }
        DynQuerySubEntityTreeInfo treeInfo = DynQueryUtil.getDynQuerySubEntityTree(coll, qfInfo);
        if (treeInfo == null) {
            return null;
        }
        dsfInfo.setEntity(treeInfo);
        return dsfInfo;
    }

    private static DefaultKingdeeTreeNode createRootNode(SubObjectInfo objInfo) {
        DefaultKingdeeTreeNode rootNode = DynQueryUtil.getRootNode(objInfo);
        DynQueryUtil.createNode(rootNode, objInfo);
        return rootNode;
    }

    private static DefaultKingdeeTreeNode createNode(DefaultKingdeeTreeNode parentNode, SubObjectInfo objInfo) {
        JoinCollection joinColl = objInfo.getJoinsFromClient();
        if (joinColl.size() == 0) {
            return null;
        }
        JoinInfo joinInfo = null;
        int size = joinColl.size();
        for (int i = 0; i < size; ++i) {
            joinInfo = joinColl.get(i);
            JoinType type = joinInfo.getJoinType();
            SubObjectInfo rightInfo = joinInfo.getRightObject();
            DefaultKingdeeTreeNode tmpNode = DynQueryUtil.getNode(joinInfo);
            if (tmpNode == null) continue;
            parentNode.add((MutableTreeNode)tmpNode);
            DynQueryUtil.initLongNumber(parentNode, tmpNode);
            DynQueryUtil.createNode(tmpNode, rightInfo);
        }
        return parentNode;
    }

    private static void initLongNumber(DefaultKingdeeTreeNode parentNode, DefaultKingdeeTreeNode tmpNode) {
        DynQuerySubEntityTreeInfo info = (DynQuerySubEntityTreeInfo)tmpNode.getUserObject();
        DynQuerySubEntityTreeInfo parentInfo = (DynQuerySubEntityTreeInfo)parentNode.getUserObject();
        info.setLongNumber(DynQueryUtil.getLongNumber(parentInfo.getLongNumber(), info.getNumber()));
    }

    private static TreeNodeInfo getObjectInfo(String name, EntityObjectInfo oInfo) {
        return new TreeNodeInfo(name, oInfo);
    }

    private static DefaultKingdeeTreeNode getNode(JoinInfo joinInfo) {
        DynQuerySubEntityTreeInfo entityInfo = DynQueryUtil.getSubEntityInfo(joinInfo);
        if (entityInfo == null) {
            return null;
        }
        return new DefaultKingdeeTreeNode((Object)entityInfo);
    }

    private static DefaultKingdeeTreeNode getRootNode(SubObjectInfo objInfo) {
        return new DefaultKingdeeTreeNode((Object)DynQueryUtil.getRootSubEntityInfo(objInfo));
    }

    public static EntityObjectInfo getEntityObjectInfo(SubObjectInfo objInfo) {
        EntityObjectInfo eoInfo = null;
        if (objInfo instanceof SubEntityInfo) {
            SubEntityInfo seInfo = (SubEntityInfo)objInfo;
            eoInfo = seInfo.getEntityRef();
        }
        return eoInfo;
    }

    private static DynQuerySubEntityTreeInfo getRootSubEntityInfo(SubObjectInfo objInfo) {
        DynQuerySubEntityTreeInfo entityInfo = new DynQuerySubEntityTreeInfo();
        EntityObjectInfo eoInfo = DynQueryUtil.getEntityObjectInfo(objInfo);
        entityInfo.setEntityName(eoInfo.getAlias());
        entityInfo.setNumber(objInfo.getName());
        entityInfo.setLongNumber(entityInfo.getNumber());
        String bostype = eoInfo.getType().toString();
        entityInfo.setEntityBosType(bostype);
        return entityInfo;
    }

    private static DynQuerySubEntityTreeInfo getSubEntityInfo(JoinInfo joinInfo) {
        if (null == joinInfo) {
            return null;
        }
        DynQuerySubEntityTreeInfo entityInfo = new DynQuerySubEntityTreeInfo();
        SubObjectInfo soInfo = joinInfo.getRightObject();
        EntityObjectInfo eoInfo = DynQueryUtil.getEntityObjectInfo(soInfo);
        if (eoInfo == null || null == eoInfo.getType()) {
            return null;
        }
        entityInfo.setNumber(soInfo.getName());
        String entityName = eoInfo.getAlias();
        entityInfo.setEntityName(eoInfo.getAlias());
        JoinType jt = joinInfo.getJoinType();
        LinkTypeEnum ltype = DynQueryUtil.convertLinkType(jt);
        entityInfo.setLinkType(ltype);
        String bostype = eoInfo.getType().toString();
        entityInfo.setEntityBosType(bostype);
        JoinItemCollection jiColl = joinInfo.getJoinItems();
        DynQueryEntityJoinFieldCollection jfColl = DynQueryUtil.convertDynQueryEntityJoinFieldCollection(jiColl);
        entityInfo.getLinkProp().addCollection(jfColl);
        PropertyUnitCollection ptu = joinInfo.getQuery().getUnits();
        Object puInfo = null;
        entityInfo.getSelectors().addCollection(null);
        return entityInfo;
    }

    private static LinkTypeEnum convertLinkType(JoinType jt) {
        if (JoinType.INNERJOIN.getName().equals(jt.getName())) {
            return LinkTypeEnum.INNERJOIN;
        }
        if (JoinType.LEFTJOIN.getName().equals(jt.getName())) {
            return LinkTypeEnum.LEFTJOIN;
        }
        if (JoinType.RIGHTJOIN.getName().equals(jt.getName())) {
            return LinkTypeEnum.RIGHTJOIN;
        }
        return LinkTypeEnum.LEFTJOIN;
    }

    private static DynQueryEntityJoinFieldCollection convertDynQueryEntityJoinFieldCollection(JoinItemCollection jiColl) {
        DynQueryEntityJoinFieldCollection coll = new DynQueryEntityJoinFieldCollection();
        int size = jiColl.size();
        for (int i = 0; i < size; ++i) {
            coll.add(DynQueryUtil.convertDynQueryEntityJoinFieldInfo(jiColl.get(i)));
        }
        return coll;
    }

    private static DynQueryEntityJoinFieldInfo convertDynQueryEntityJoinFieldInfo(JoinItemInfo jiInfo) {
        DynQueryEntityJoinFieldInfo info = new DynQueryEntityJoinFieldInfo();
        info.setLeftProp(jiInfo.getLeftField().getRefPropertyName());
        info.setRightProp(jiInfo.getRightField().getRefPropertyName());
        CompareType ctype = jiInfo.getCompareType();
        info.setCompareType(DynQueryUtil.convertCompareType(ctype));
        return info;
    }

    private static CompareTypeEnum convertCompareType(CompareType cType) {
        return CompareTypeEnum.getEnum(cType.getName());
    }

    public static void initEntityLinkProp(KDTable tblProp, String parentEntityName, String subEntityName) {
    }

    private static void initEntityLinkPropEditor(KDTable tblProp, int rowIndex, int colIndex, Object[] objs) {
        if (tblProp.getRow(rowIndex).getCell(colIndex) == null || tblProp.getRow(rowIndex).getCell(colIndex).getEditor() == null) {
            Util.setComboBoxField(tblProp, rowIndex, colIndex, objs);
        }
    }

    public static void fillLeftEntityLinkPropRows(KDTable tblProp, String parentEntityBosType, String subEntityBosType) {
        int rowCount = tblProp.getRowCount();
        if (rowCount < 10) {
            for (int i = 0; i < 10 - rowCount; ++i) {
                DynQueryUtil.addARow(tblProp, parentEntityBosType, subEntityBosType);
            }
        }
    }

    private static Object[] getEntityProps(String entityName) {
        EntityObjectInfo eoInfo = Util.getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection coll = eoInfo.getInheritedNoDuplicatedProperties();
        ArrayList<SimpleValueObjectInfo> validProps = new ArrayList<SimpleValueObjectInfo>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo tmp = coll.get(i);
            if (!DynQueryUtil.isValidProp(tmp)) continue;
            SimpleValueObjectInfo info = new SimpleValueObjectInfo();
            info.setName((tmp.getAlias() == null ? "" : tmp.getAlias()) + "(" + tmp.getName() + ")");
            info.setValue(tmp.getName());
            info.setUserObject((Object)tmp);
            validProps.add(info);
        }
        Object[] svoInfos = validProps.toArray(new SimpleValueObjectInfo[0]);
        return svoInfos;
    }

    private static Object[] getEntityProps(BOSObjectType objectType) {
        EntityObjectInfo eoInfo = Util.getEntity(objectType);
        PropertyCollection coll = eoInfo.getInheritedNoDuplicatedProperties();
        ArrayList<SimpleValueObjectInfo> validProps = new ArrayList<SimpleValueObjectInfo>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo tmp = coll.get(i);
            if (!DynQueryUtil.isValidProp(tmp)) continue;
            SimpleValueObjectInfo info = new SimpleValueObjectInfo();
            info.setName((tmp.getAlias() == null ? "" : tmp.getAlias()) + "(" + tmp.getName() + ")");
            info.setValue(tmp.getName());
            info.setUserObject((Object)tmp);
            validProps.add(info);
        }
        Object[] svoInfos = validProps.toArray(new SimpleValueObjectInfo[0]);
        return svoInfos;
    }

    private static boolean isValidProp(PropertyInfo info) {
        if (info instanceof LinkPropertyInfo) {
            return true;
        }
        OwnPropertyInfo opinfo = (OwnPropertyInfo)info;
        return opinfo.getDataType().equals((Object)DataType.BOSUUID) || opinfo.getDataType().equals((Object)DataType.UUID) || opinfo.getDataType().equals((Object)DataType.STRING) || opinfo.getDataType().equals((Object)DataType.BOOLEAN);
    }

    private static IRow addARow(KDTable tblProp, String parentEntityBosType, String subEntityBosType) {
        IRow row = tblProp.addRow();
        DynQueryUtil.initEntityLinkPropEditor(tblProp, row.getRowIndex(), 0, DynQueryUtil.getEntityProps(BOSObjectType.create((String)parentEntityBosType)));
        DynQueryUtil.initEntityLinkPropEditor(tblProp, row.getRowIndex(), 1, Util.addObjectToArray(CompareTypeEnum.getEnumList().toArray(), null));
        if (subEntityBosType != null) {
            DynQueryUtil.initEntityLinkPropEditor(tblProp, row.getRowIndex(), 2, DynQueryUtil.getEntityProps(BOSObjectType.create((String)subEntityBosType)));
        }
        return row;
    }

    private static void setEntityLinkProp(KDTable tblProp, int rowIndex, DynQueryEntityJoinFieldInfo jfInfo) {
        Util.setEnumComboBoxField(tblProp, rowIndex, 1, CompareTypeEnum.class.getName(), jfInfo.getCompareType().getValue());
        IRow row = tblProp.getRow(rowIndex);
        row.getCell(0).setValue((Object)DynQueryUtil.getSimpleValueObjectInfo(tblProp, rowIndex, 0, jfInfo.getLeftProp()));
        row.getCell(2).setValue((Object)DynQueryUtil.getSimpleValueObjectInfo(tblProp, rowIndex, 2, jfInfo.getRightProp()));
    }

    private static SimpleValueObjectInfo getSimpleValueObjectInfo(KDTable tblProp, int rowIndex, int colIndex, String value) {
        IRow row = tblProp.getRow(rowIndex);
        KDComboBox lb = (KDComboBox)row.getCell(colIndex).getEditor().getComponent();
        int size = lb.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            SimpleValueObjectInfo svoInfo = (SimpleValueObjectInfo)lb.getItemAt(i);
            if (svoInfo == null || !svoInfo.getValue().equals(value)) continue;
            return svoInfo;
        }
        return null;
    }

    public static SimpleValueObjectInfo getSltSimpleValueObjectInfo(KDTable tblProp, int rowIndex, int colIndex) {
        IRow row = tblProp.getRow(rowIndex);
        KDComboBox lb = (KDComboBox)row.getCell(colIndex).getEditor().getComponent();
        SimpleValueObjectInfo svoInfo = (SimpleValueObjectInfo)lb.getSelectedItem();
        return svoInfo;
    }

    public static void loadEntityLinkProp(KDTable tblProp, String parentEntityBosType, String subEntityBosType, DynQueryEntityJoinFieldCollection dejfColl) {
        tblProp.removeRows();
        if (dejfColl != null) {
            int size = dejfColl.size();
            for (int i = 0; i < size; ++i) {
                IRow row = DynQueryUtil.addARow(tblProp, parentEntityBosType, subEntityBosType);
                DynQueryUtil.setEntityLinkProp(tblProp, row.getRowIndex(), dejfColl.get(i));
            }
        }
        DynQueryUtil.fillLeftEntityLinkPropRows(tblProp, parentEntityBosType, subEntityBosType);
    }

    public static KDTree getCopyTreeEntityWithProps(KDTree treeEntity) throws BOSException, EASBizException {
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)treeEntity.getModel().getRoot();
        DefaultKingdeeTreeNode newRootNode = DynQueryUtil.cloneNode(rootNode);
        KDTree tree = new KDTree((ITreeNode)newRootNode);
        tree.setSyncChecked(false);
        DynQueryUtil.addEntityPropNode(tree, newRootNode);
        return tree;
    }

    private static void addEntityPropNode(KDTree tree, DefaultKingdeeTreeNode newRootNode) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
        newRootNode.setCheckBoxVisible(false);
        HashMap<String, FieldPermission> bosTypeFieldPerm = new HashMap<String, FieldPermission>();
        for (int i = 0; i < newRootNode.getChildCount(); ++i) {
            String key;
            FieldPermission fieldPermission;
            DynQuerySubEntityTreeInfo rootInfo = (DynQuerySubEntityTreeInfo)newRootNode.getUserObject();
            DefaultKingdeeTreeNode newRootChildNode = (DefaultKingdeeTreeNode)newRootNode.getChildAt(i);
            DynQuerySubEntityTreeInfo rootChildInfo = (DynQuerySubEntityTreeInfo)newRootChildNode.getUserObject();
            if (rootInfo.getEntityBosType() == null) {
                return;
            }
            String bosType = rootInfo.getEntityBosType();
            OrgUnitInfo ouInfo = QueryUtils.getCurrentOrgUnitInfo(QueryUtils.getOrgType(QueryUtils.getEntity(null, BOSObjectType.create((String)bosType))), null);
            if (ouInfo != null) {
                orgPK = new ObjectUuidPK(ouInfo.getId());
            }
            if ((fieldPermission = (FieldPermission)bosTypeFieldPerm.get(key = bosType + userPK.toString() + orgPK.toString())) == null) {
                fieldPermission = QueryUtils.getFieldPermission(null, bosType);
                bosTypeFieldPerm.put(key, fieldPermission);
            }
            if (!QueryUtils.hasFieldPermission(fieldPermission, rootChildInfo.getNumber())) {
                tree.removeNodeFromParent((MutableTreeNode)newRootChildNode);
                --i;
                continue;
            }
            DynQueryUtil.addEntityPropNode(tree, (DefaultKingdeeTreeNode)newRootNode.getChildAt(i));
        }
        DynQuerySubEntityTreeInfo info = (DynQuerySubEntityTreeInfo)newRootNode.getUserObject();
        if (info.getEntityBosType() == null) {
            return;
        }
        EntityObjectInfo eoInfo = Util.getEntity(BOSObjectType.create((String)info.getEntityBosType()));
        PropertyCollection pc = eoInfo.getInheritedNoDuplicatedProperties();
        int size = pc.size();
        for (int i = 0; i < size; ++i) {
            String key;
            FieldPermission fieldPermission;
            PropertyInfo tmpInfo = pc.get(i);
            if (!DynQueryUtil.isValidQueryProp(tmpInfo)) continue;
            DynQuerySelectFieldInfo fieldInfo = DynQueryUtil.convertDynQuerySelectFieldInfo(info, tmpInfo);
            String bosType1 = info.getEntityBosType();
            OrgUnitInfo ouInfo = QueryUtils.getCurrentOrgUnitInfo(QueryUtils.getOrgType(QueryUtils.getEntity(null, BOSObjectType.create((String)bosType1))), null);
            if (ouInfo != null) {
                orgPK = new ObjectUuidPK(ouInfo.getId());
            }
            if ((fieldPermission = (FieldPermission)bosTypeFieldPerm.get(key = bosType1 + userPK.toString() + orgPK.toString())) == null) {
                fieldPermission = QueryUtils.getFieldPermission(null, bosType1);
                bosTypeFieldPerm.put(key, fieldPermission);
            }
            if (!QueryUtils.hasFieldPermission(fieldPermission, tmpInfo.getName())) continue;
            DefaultKingdeeTreeNode tmpNode = DynQueryUtil.createNewNode(fieldInfo);
            tmpNode.setCheckBoxVisible(true);
            tree.addNodeInto((MutableTreeNode)tmpNode, (MutableTreeNode)newRootNode);
        }
    }

    private static boolean isValidQueryProp(PropertyInfo tmpInfo) {
        return tmpInfo instanceof OwnPropertyInfo;
    }

    private static DynQuerySelectFieldInfo convertDynQuerySelectFieldInfo(DynQuerySubEntityTreeInfo info, PropertyInfo propInfo) {
        DynQuerySelectFieldInfo fieldInfo = new DynQuerySelectFieldInfo();
        fieldInfo.setEntity(info);
        fieldInfo.setNumber(DynQueryUtil.getPropPrefix(info.getLongNumber()) + propInfo.getName());
        fieldInfo.setName(propInfo.getAlias());
        return fieldInfo;
    }

    private static DefaultKingdeeTreeNode createNewNode(Object userObject) {
        return new DefaultKingdeeTreeNode(userObject);
    }

    private static DefaultKingdeeTreeNode cloneNode(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode anewnode = new DefaultKingdeeTreeNode();
        anewnode.setUserObject(node.getUserObject());
        anewnode.setText(node.getText());
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            anewnode.add((MutableTreeNode)DynQueryUtil.cloneNode((DefaultKingdeeTreeNode)node.getChildAt(i)));
        }
        return anewnode;
    }

    public static DynQuerySelectFieldCollection getNoMetaProps(KDList list) {
        DynQuerySelectFieldCollection coll = new DynQuerySelectFieldCollection();
        int size = list.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            DynQuerySelectFieldInfo fieldInfo = (DynQuerySelectFieldInfo)list.getElement(i);
            if (!fieldInfo.isIsDynField()) continue;
            coll.add(fieldInfo);
        }
        return coll;
    }

    public static DynQuerySubEntityTreeCollection getNoMetaEntitis(KDTree tree, KDList list) {
        DynQuerySubEntityTreeCollection coll = new DynQuerySubEntityTreeCollection();
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        ArrayList uoAl = TreeUtil.getUserObjectIncludeChild(rootNode);
        DynQuerySelectFieldCollection fieldColl = DynQueryUtil.getNoMetaProps(list);
        int size = uoAl.size();
        for (int i = 0; i < size; ++i) {
            DynQuerySubEntityTreeInfo info;
            DynQuerySubEntityTreeInfo tmpInfo = (DynQuerySubEntityTreeInfo)uoAl.get(i);
            if (tmpInfo != null && tmpInfo.getSelectors() != null) {
                tmpInfo.getSelectors().clear();
            }
            if ((info = DynQueryUtil.getNoMetaEntity(tmpInfo, fieldColl)) == null) continue;
            coll.add(info);
        }
        return coll;
    }

    private static DynQuerySubEntityTreeInfo getNoMetaEntity(DynQuerySubEntityTreeInfo info, DynQuerySelectFieldCollection fieldColl) {
        DynQuerySelectFieldCollection coll = DynQueryUtil.getThisEntityFields(info, fieldColl);
        if (coll.size() > 0) {
            info.getSelectors().clear();
            info.getSelectors().addCollection(coll);
            DynQueryUtil.removeSelectFieldColl(fieldColl, coll);
        } else if (!info.isIsDynEntity()) {
            return null;
        }
        return info;
    }

    private static void removeSelectFieldColl(DynQuerySelectFieldCollection fieldColl, DynQuerySelectFieldCollection removeColl) {
        int size = removeColl.size();
        for (int i = 0; i < size; ++i) {
            fieldColl.remove(removeColl.get(i));
        }
    }

    private static DynQuerySelectFieldCollection getThisEntityFields(DynQuerySubEntityTreeInfo info, DynQuerySelectFieldCollection fieldColl) {
        DynQuerySelectFieldCollection coll = new DynQuerySelectFieldCollection();
        int size = fieldColl.size();
        for (int i = 0; i < size; ++i) {
            DynQuerySelectFieldInfo fieldInfo = fieldColl.get(i);
            if (fieldInfo.getEntity() == null || fieldInfo.getEntity().getLongNumber() == null || !fieldInfo.getEntity().getLongNumber().equals(info.getLongNumber())) continue;
            coll.add(fieldInfo);
        }
        return coll;
    }

    public static void loadEntitisAndFields(KDTree tree, KDList list, DynQuerySubEntityTreeCollection coll, List notVisibleList) throws BOSException, EASBizException {
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            DefaultKingdeeTreeNode rootNode;
            DefaultKingdeeTreeNode parentNode;
            DynQuerySubEntityTreeInfo treeInfo = coll.get(i);
            String parentNumber = DynQueryUtil.getParentNumber(treeInfo.getLongNumber() == null ? "" : treeInfo.getLongNumber());
            if (treeInfo.isIsDynEntity() && (parentNode = DynQueryUtil.getEntityParentNode(rootNode = (DefaultKingdeeTreeNode)tree.getModel().getRoot(), parentNumber)) != null) {
                tree.addNodeInto((MutableTreeNode)new DefaultKingdeeTreeNode((Object)treeInfo), (MutableTreeNode)parentNode);
            }
            DynQuerySelectFieldCollection fieldColl = DynQueryUtil.getNoMetaDynQuerySelectFieldCollection(treeInfo);
            int size1 = fieldColl.size();
            for (int i1 = 0; i1 < size1; ++i1) {
                for (int i2 = 0; i2 < list.getModel().getSize(); ++i2) {
                    if (!fieldColl.get(i1).getNumber().equals(((DynQuerySelectFieldInfo)list.getModel().getElementAt(i2)).getNumber())) continue;
                    list.removeElementAt(i2);
                }
                DynQueryUtil.addFieldToList(list, fieldColl.get(i1), notVisibleList);
            }
        }
    }

    private static String getParentNumber(String longNumber) {
        String[] numbers = longNumber.split("\\.");
        if (numbers.length <= 1) {
            return null;
        }
        return numbers[numbers.length - 2];
    }

    private static DynQuerySelectFieldCollection getNoMetaDynQuerySelectFieldCollection(DynQuerySubEntityTreeInfo treeInfo) {
        DynQuerySelectFieldCollection coll = treeInfo.getSelectors();
        DynQuerySelectFieldCollection newColl = new DynQuerySelectFieldCollection();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            DynQuerySelectFieldInfo fieldInfo = coll.get(i);
            if (!fieldInfo.isIsDynField()) continue;
            newColl.add(fieldInfo);
        }
        return newColl;
    }

    private static DefaultKingdeeTreeNode getEntityParentNode(DefaultKingdeeTreeNode node, String number) {
        DynQuerySubEntityTreeInfo info = (DynQuerySubEntityTreeInfo)node.getUserObject();
        if (DynQueryUtil.isSameInfo(info, number)) {
            return node;
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultKingdeeTreeNode tmpNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            DefaultKingdeeTreeNode parentNode = DynQueryUtil.getEntityParentNode(tmpNode, number);
            if (parentNode == null) continue;
            return parentNode;
        }
        return null;
    }

    private static boolean isSameInfo(DynQuerySubEntityTreeInfo info, String number) {
        return info.getNumber().equals(number);
    }

    public static void getCheckedLeafNode(DefaultKingdeeTreeNode parentNode, ArrayList result) {
        if (parentNode == null || parentNode.getChildCount() == 0) {
            return;
        }
        int childCount = parentNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultKingdeeTreeNode tmpNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            if (tmpNode.isLeaf()) {
                if (!tmpNode.isChecked()) continue;
                result.add(tmpNode);
                continue;
            }
            DynQueryUtil.getCheckedLeafNode(tmpNode, result);
        }
    }

    public static void importFieldColl(KDList list, DynQuerySelectFieldCollection sltColl) throws BOSException, EASBizException {
        int size = sltColl.size();
        for (int i = 0; i < size; ++i) {
            DynQuerySelectFieldInfo fieldInfo = sltColl.get(i);
            if (DynQueryUtil.isExistSameField(list, fieldInfo)) continue;
            fieldInfo.setIsVisibleInTable(false);
            if (StringUtils.isEmpty((String)fieldInfo.getExtendedProperty("isDynCommonQuery")) || Boolean.valueOf(fieldInfo.getExtendedProperty("isDynCommonQuery")).equals(Boolean.TRUE)) {
                fieldInfo.setIsFilter(true);
            }
            fieldInfo.setIsInSelect(true);
            DynQueryUtil.addFieldToList(list, fieldInfo, null);
        }
    }

    private static boolean isExistSameField(KDList list, DynQuerySelectFieldInfo fieldInfo) {
        DynQuerySubEntityTreeInfo treeInfo = fieldInfo.getEntity();
        int size = list.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            DynQuerySelectFieldInfo tmpInfo = (DynQuerySelectFieldInfo)list.getElement(i);
            DynQuerySubEntityTreeInfo tmpTreeInfo = tmpInfo.getEntity();
            if (tmpInfo == null || !tmpInfo.getNumber().equals(fieldInfo.getNumber()) || treeInfo == null || treeInfo.getLongNumber() == null || tmpTreeInfo == null || tmpTreeInfo.getLongNumber() == null || !treeInfo.getLongNumber().equals(tmpTreeInfo.getLongNumber())) continue;
            return true;
        }
        return false;
    }

    private static void addFieldToList(KDList list, DynQuerySelectFieldInfo fieldInfo, List visibleList) throws BOSException, EASBizException {
        if (visibleList != null && visibleList.indexOf(fieldInfo.getNumber()) != -1) {
            fieldInfo.setIsVisibleInTable(true);
        }
        list.addElement((Object)fieldInfo);
    }

    public static void removeFieldByEntity(KDList list, DynQuerySubEntityTreeInfo info) {
        int size = list.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            DynQuerySelectFieldInfo tmpInfo = (DynQuerySelectFieldInfo)list.getElement(i);
            if (tmpInfo == null || tmpInfo.getEntity() == null || tmpInfo.getEntity().getLongNumber() == null || !tmpInfo.getEntity().getLongNumber().equals(info.getLongNumber())) continue;
            list.removeElementAt(i);
            --size;
            --i;
        }
    }

    public static void syncNumberInFields(KDList list) {
        int size = list.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            DynQuerySelectFieldInfo tmpInfo = (DynQuerySelectFieldInfo)list.getElement(i);
            tmpInfo.setNumber(DynQueryUtil.getCorrectNumberByEntityTreeInfo(tmpInfo));
        }
    }

    public static String getCorrectNumberByEntityTreeInfo(DynQuerySelectFieldInfo fieldInfo) {
        String number = fieldInfo.getNumber();
        if (fieldInfo != null && fieldInfo.getEntity() != null && fieldInfo.getEntity().getLongNumber() != null) {
            String entityLongNum = fieldInfo.getEntity().getLongNumber();
            if (number.lastIndexOf(".") > 0 && entityLongNum.indexOf(".") > 0) {
                String subNum = number.substring(0, number.lastIndexOf("."));
                String subEntityNum = entityLongNum.substring(entityLongNum.indexOf(".") + 1);
                if (!subEntityNum.equals(subNum)) {
                    number = number.replaceFirst(subNum, subEntityNum);
                }
            }
        }
        return number;
    }

    public static String getNewEntityTreeNumber(DynQuerySubEntityTreeCollection coll, String entityBosType) {
        String name = Util.getEntity(BOSObjectType.create((String)entityBosType)).getName();
        int i = 0;
        String tmpName = name + i;
        while (DynQueryUtil.getSameTreeInfo(coll, tmpName) != null) {
            tmpName = name + ++i;
        }
        return tmpName;
    }

    public static String getLongNumber(String parentLongNum, String number) {
        return parentLongNum + "." + number;
    }

    public static void convertEntityViewInfo(EntityViewInfo viewInfo, DynQuerySubEntityTreeInfo info) throws BOSException, EASBizException {
        QueryUtils.convertEntityViewInfo(null, viewInfo, info);
    }

    private static String getPropPrefix(String longNumber) {
        String fix = "";
        fix = longNumber == null || longNumber != null && longNumber.indexOf(".") < 0 ? "" : longNumber.substring(longNumber.indexOf(".") + 1) + ".";
        return fix;
    }

    public static PropertyUnitInfo convertPropertyUnitInfo(QueryInfo queryInfo, DynQuerySelectFieldInfo fieldInfo) {
        PropertyUnitInfo puInfo = new PropertyUnitInfo(queryInfo);
        return puInfo;
    }

    public static JoinCollection convertJoinInfo(QueryInfo queryInfo, DynQueryEntityJoinFieldCollection fieldColl) {
        JoinCollection coll = new JoinCollection();
        return coll;
    }

    public static JoinType convert(LinkTypeEnum lt) {
        if (LinkTypeEnum.INNERJOIN.getName().equals(lt.getName())) {
            return JoinType.INNERJOIN;
        }
        if (LinkTypeEnum.LEFTJOIN.getName().equals(lt.getName())) {
            return JoinType.LEFTJOIN;
        }
        if (LinkTypeEnum.RIGHTJOIN.getName().equals(lt.getName())) {
            return JoinType.RIGHTJOIN;
        }
        return JoinType.LEFTJOIN;
    }

    public static CompareType convert(CompareTypeEnum enum1) {
        if (CompareTypeEnum.EQUAL.equals((Object)enum1)) {
            return CompareType.EQUALS;
        }
        if (CompareTypeEnum.GREATE.equals((Object)enum1)) {
            return CompareType.GREATER;
        }
        if (CompareTypeEnum.LITTE.equals((Object)enum1)) {
            return CompareType.LESS;
        }
        return null;
    }

    public static boolean isIDProperty(OwnPropertyInfo prop) {
        return prop.getDataType().equals((Object)DataType.BOSUUID) || prop.getDataType().equals((Object)DataType.UUID);
    }

    public static DynQuerySolutionCollection getOwnDynQuerySolutions(String parentUIName, String queryFullName) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        String currentUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)currentUserId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("baseQuery", (Object)queryFullName));
        filter.getFilterItems().add(new FilterItemInfo("uiName", (Object)parentUIName));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(DynQueryUtil.getDynQuerySimpleSelector());
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("name"));
        evi.setSorter(sort);
        IDynQuerySolution dynQuerySolution = DynQuerySolutionFactory.getRemoteInstance();
        return dynQuerySolution.getDynQuerySolutionCollection(evi);
    }

    private static SelectorItemCollection getDynQuerySimpleSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        return selector;
    }

    public static String getVisibleDynQueryString(String parentUIName, String queryFullName) throws BOSException, EASBizException {
        ArrayList<String> ownList = new ArrayList<String>();
        DynQuerySolutionCollection ownCol = DynQueryUtil.getOwnDynQuerySolutions(parentUIName, queryFullName);
        for (int i = 0; i < ownCol.size(); ++i) {
            ownList.add(ownCol.get(i).getId().toString());
        }
        List accreditedList = DynQueryUtil.getAccreditedDynQueryIdList(parentUIName, queryFullName);
        ArrayList<String> allList = new ArrayList<String>();
        allList.addAll(ownList);
        allList.addAll(accreditedList);
        return ToolUtils.aryToStr(allList, (boolean)false);
    }

    public static String getAccreditedDynQuerySql(String parentUIName, String queryFullName, String orgId) throws BOSException, EASBizException {
        String currentUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("select FDynQueryID from T_CQ_UserOrgDynQuery as orgQuery left outer join T_QUERY_DynQuerySolution as querysolution ").append(" on orgQuery.FDynQueryID = querysolution.FID").append(" where orgQuery.FUserID = '").append(currentUserId).append("' and orgQuery.FOrgID in (").append(orgId).append(") ").append(" and FBaseQuery='").append(queryFullName).append("' ").append(" and FUiName = '").append(parentUIName).append("' ").append(" and FDeletedStatus = ").append(1);
        return sb.toString();
    }

    public static List getAccreditedDynQueryIdList(String parentUIName, String queryFullName) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        FilterInfo filter = new FilterInfo();
        String currentUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)currentUserId));
        filter.getFilterItems().add(new FilterItemInfo("org.id", (Object)orgId));
        filter.mergeFilter(DynQueryUtil.getDynQueryCommonFilter(queryFullName, parentUIName), "and");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("dynQuery.id"));
        evi.setSelector(selector);
        IUserOrgDynQuery iUserOrgDynQuery = UserOrgDynQueryFactory.getRemoteInstance();
        UserOrgDynQueryCollection uodqCol = iUserOrgDynQuery.getUserOrgDynQueryCollection(evi);
        for (int i = 0; i < uodqCol.size(); ++i) {
            list.add(uodqCol.get(i).getDynQuery().getId().toString());
        }
        return list;
    }

    public static FilterInfo getDynQueryCommonFilter(String queryFullName, String parentUIName) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("dynQuery.baseQuery", (Object)queryFullName));
        filter.getFilterItems().add(new FilterItemInfo("dynQuery.uiName", (Object)parentUIName));
        filter.getFilterItems().add(new FilterItemInfo("dynQuery.deletedStatus", (Object)new Integer(1)));
        return filter;
    }

    public static List getVisibleInListUI(Object listUI) {
        if (listUI == null) {
            return new ArrayList();
        }
        if (listUI instanceof ListUI) {
            return DynQueryUtil.getVisibleInListUI((ListUI)listUI);
        }
        return DynQueryUtil.getVisibleInListUI((String)listUI);
    }

    public static List getVisibleInListUI(String listUIName) {
        ArrayList visibleList = new ArrayList();
        try {
            Class<?> listUIClass = Class.forName(listUIName);
            Object listUI = listUIClass.newInstance();
            if (listUI instanceof ListUI) {
                return DynQueryUtil.getVisibleInListUI((ListUI)listUI);
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (IllegalAccessException e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
        }
        return visibleList;
    }

    public static List getVisibleInListUI(ListUI listUI) {
        listUI.initLayout();
        ArrayList<String> visibleList = new ArrayList<String>();
        KDTable table = listUI.getMainTable();
        String formatXML = Util.getOrigialTableParams((Component)listUI);
        if (table.getColumnCount() == 0) {
            table.checkParsed();
        }
        Map listQueryMap = DynQueryUtil.getQueryFieldNameMapFromTable(table);
        try {
            if (!StringUtils.isEmpty((String)formatXML)) {
                UserCustomConfigItemData itemData = TableXMLHelper.loadPreferenceData(formatXML).getTableCurrentSetting();
                Map map = itemData.getColumnData();
                Iterator itr = map.keySet().iterator();
                while (itr.hasNext()) {
                    String key = itr.next().toString();
                    ColumnItemData columnData = (ColumnItemData)map.get(key);
                    if (columnData.isHidden()) continue;
                    String listqueryName = String.valueOf(listQueryMap.get(key));
                    visibleList.add(listqueryName);
                }
            }
        }
        catch (JDOMException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return visibleList;
    }

    public static Map getQueryFieldNameMapFromTable(KDTable table) {
        HashMap<String, String> queryFieldNameMap = new HashMap<String, String>();
        if (table != null) {
            for (int i = 0; i < table.getColumnCount(); ++i) {
                IColumn col = table.getColumn(i);
                if (StringUtils.isEmpty((String)col.getKey()) || StringUtils.isEmpty((String)col.getFieldName())) continue;
                queryFieldNameMap.put(col.getKey(), col.getFieldName());
            }
        }
        return queryFieldNameMap;
    }
}

