/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.client.QueryToolBar;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SolutionPromptUI
extends CoreUI {
    private ResourceBundleHelper resHelper = null;
    private KDBizMultiLangBox solutionNameTextField;
    private KDComboBox shareTypeComboBox;
    private KDButton confirmButton;
    private KDButton cancelButton;
    private int closeWindowType = 2;
    public static final String CURRENT_SOLUTION = "current_solution";
    private static final String solutionDialogRes = "com.kingdee.eas.base.commonquery.client.SolutionPromptUI";

    public SolutionPromptUI() throws Exception {
        this.init();
    }

    private void init() {
        this.setUITitle(EASResource.getString((String)solutionDialogRes, (String)"title"));
        KDLabelContainer solutionLabContainer = new KDLabelContainer();
        solutionLabContainer.setBoundLabel((JLabel)new KDLabel(EASResource.getString((String)solutionDialogRes, (String)"text")));
        solutionLabContainer.setBoundLabelLength(80);
        solutionLabContainer.setBoundLabelUnderline(true);
        solutionLabContainer.setBounds(new Rectangle(10, 15, 280, 19));
        this.solutionNameTextField = new KDBizMultiLangBox();
        this.solutionNameTextField.setRequired(true);
        List langList = KDBizMultiLangBox.getLanguageList();
        for (int i = 0; i < langList.size(); ++i) {
            if (!SysContext.getSysContext().getLocale().toString().equalsIgnoreCase(((LanguageInfo)langList.get(i)).getLocale().toString())) continue;
            this.solutionNameTextField.setSelectedLanguage((LanguageInfo)langList.get(i));
        }
        solutionLabContainer.setBoundEditor((JComponent)this.solutionNameTextField);
        this.solutionNameTextField.setMaxLength(79);
        this.add((Component)solutionLabContainer);
        this.confirmButton = new KDButton();
        this.confirmButton.setText(EASResource.getString((String)solutionDialogRes, (String)"confirmButtonText"));
        this.confirmButton.setBounds(new Rectangle(141, 71, 73, 19));
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolutionPromptUI.this.confirmButton_actionPerformed(e);
            }
        });
        this.add((Component)this.confirmButton);
        this.cancelButton = new KDButton();
        this.cancelButton.setText(EASResource.getString((String)solutionDialogRes, (String)"cancelButtonText"));
        this.cancelButton.setBounds(new Rectangle(217, 71, 73, 19));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolutionPromptUI.this.cancelButton_actionPerformed(e);
            }
        });
        this.add((Component)this.cancelButton);
        KDSeparator separator = new KDSeparator();
        separator.setBounds(new Rectangle(0, 64, 300, 2));
        this.add((Component)separator);
        this.setLayout(null);
        this.setPreferredSize(new Dimension(300, 100));
    }

    private void confirmButton_actionPerformed(ActionEvent e) {
        String solutionName = this.solutionNameTextField.getSelectedItem().toString();
        if (solutionName == null || solutionName.trim().equalsIgnoreCase("")) {
            MsgBox.showWarning((String)EASResource.getString((String)solutionDialogRes, (String)"solutionNameIsNull"));
            return;
        }
        QuerySolutionInfo qsi = new QuerySolutionInfo();
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.solutionNameTextField, (IObjectValue)qsi, (String)"name");
        this.getQueryToolBar().setQuerySolution(qsi);
        this.getQueryToolBar().setSolutionName(this.solutionNameTextField.getSelectedItem().toString());
        this.getQueryToolBar().setShareType((ShareTypeEnum)((Object)this.shareTypeComboBox.getSelectedItem()));
        this.getQueryToolBar().getShareTypeComboBox().setModel(this.shareTypeComboBox.getModel());
        this.closeWindowType = 0;
        Util.getWindow((Component)((Object)this)).dispose();
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        this.closeWindowType = 1;
        Util.getWindow((Component)((Object)this)).dispose();
    }

    private QueryToolBar getQueryToolBar() {
        return (QueryToolBar)((Object)this.getUIContext().get("TOOLBAR"));
    }

    protected int getCloseWindowType() {
        return this.closeWindowType;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        QuerySolutionInfo currentQuerySolutionInfo = (QuerySolutionInfo)this.getUIContext().get(CURRENT_SOLUTION);
        if (currentQuerySolutionInfo != null) {
            UIHelper.loadMultiLangFields((KDMultiLangBox)this.solutionNameTextField, (IObjectValue)currentQuerySolutionInfo, (String)"name");
        }
        KDLabelContainer shareTypeLabContainer = new KDLabelContainer();
        shareTypeLabContainer.setBoundLabel((JLabel)new KDLabel(EASResource.getString((String)solutionDialogRes, (String)"shareType")));
        shareTypeLabContainer.setBoundLabelLength(80);
        shareTypeLabContainer.setBoundLabelUnderline(true);
        shareTypeLabContainer.setBounds(new Rectangle(10, 40, 280, 19));
        this.solutionNameTextField.setMaxLength(200);
        this.shareTypeComboBox = Util.createShareTypeComboBox(this.getQueryToolBar().getShowShareType(), true);
        this.shareTypeComboBox.setSelectedItem(this.getQueryToolBar().getShareTypeComboBox().getSelectedItem());
        shareTypeLabContainer.setBoundEditor((JComponent)this.shareTypeComboBox);
        this.add((Component)shareTypeLabContainer);
        shareTypeLabContainer.setVisible(true);
        this.shareTypeComboBox.setVisible(true);
        if ("reNameAction".equalsIgnoreCase("" + this.getUIContext().get("RENAMEACTION"))) {
            this.shareTypeComboBox.setEnabled(false);
        }
    }

    protected JButton getDefaultButton() {
        return this.confirmButton;
    }
}

