/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.TableXMLHelper;
import com.kingdee.eas.base.commonquery.UserCustomConfigItemData;
import com.kingdee.eas.base.commonquery.UserPreferenceData;
import com.kingdee.eas.base.commonquery.client.ClientQueryFieldPermission;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.util.StringUtils;
import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class TableParamsUtil {
    private static final Logger logger = CoreUIObject.getLogger(TableParamsUtil.class);

    public static String getTableParamsByFieldPerm(String tableParams, MetaDataPK queryInfo, OrgUnitCollection mainOrgColl, KDTable kdt) {
        if (StringUtil.isEmpty((String)tableParams)) {
            return tableParams;
        }
        UserCustomConfigItemData itemData = null;
        try {
            itemData = TableXMLHelper.loadPreferenceData(tableParams).getTableCurrentSetting();
            ArrayList canNotViewField = TableParamsUtil.getCanNotViewField(queryInfo, mainOrgColl);
            if (canNotViewField == null || canNotViewField.size() <= 0) {
                return tableParams;
            }
            int j = kdt.getColumnCount();
            for (int i = 0; i < j; ++i) {
                IColumn col = kdt.getColumn(i);
                String key = col.getFieldName();
                String tableColName = col.getKey();
                if (StringUtils.isEmpty((String)key) || !canNotViewField.contains(key)) continue;
                itemData.getColumnData().remove(tableColName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"get tableparams error:", (Throwable)e);
        }
        try {
            UserPreferenceData userData = new UserPreferenceData();
            userData.setVersion(UserPreferenceData.VER_2_0_0);
            userData.getSolutions().put("solution", itemData);
            StringWriter writer = null;
            writer = new StringWriter();
            TableXMLHelper.saveData(userData, writer, "UTF-8");
            return writer.toString();
        }
        catch (Exception e) {
            logger.error((Object)"get tableparams error:", (Throwable)e);
            return null;
        }
    }

    private static ArrayList getCanNotViewField(MetaDataPK queryInfo, OrgUnitCollection mainOrgColl) {
        ArrayList canNotViewField = new ArrayList();
        if (mainOrgColl != null && mainOrgColl.size() > 0) {
            try {
                canNotViewField = ClientQueryFieldPermission.getCanNotViewField(queryInfo, mainOrgColl, false);
            }
            catch (Exception e) {
                logger.error((Object)("get view field error" + e));
            }
        }
        return canNotViewField;
    }
}

