/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.client;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.job.client.AbstractEveryDay;
import com.kingdee.eas.base.job.util.JobProcessUtil;
import com.kingdee.eas.base.job.util.ScheduleExpression;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class EveryDay
extends AbstractEveryDay {
    private static final Logger logger = CoreUIObject.getLogger(EveryDay.class);

    public EveryDay() throws Exception {
        this.initializeUI();
    }

    public String getSchedule() {
        String returnValue = "";
        Date beginTime = (Date)this.beginTimekDTimePicker.getValue();
        GregorianCalendar beginTimeC = new GregorianCalendar();
        beginTimeC.setTime(beginTime);
        returnValue = returnValue + String.valueOf(beginTimeC.get(13));
        returnValue = returnValue + " " + String.valueOf(beginTimeC.get(12));
        returnValue = returnValue + " " + String.valueOf(beginTimeC.get(11));
        if (this.everyDaykDRadioButton.isSelected()) {
            returnValue = returnValue + " *";
            returnValue = returnValue + " *";
            returnValue = returnValue + " ?";
        } else if (this.everyWorkingDaykDRadioButton.isSelected()) {
            returnValue = returnValue + " ?";
            returnValue = returnValue + " *";
            returnValue = returnValue + " 2-6";
        } else if (this.rangekDRadioButton.isSelected()) {
            returnValue = returnValue + " 1/" + String.valueOf((Integer)this.rangekDSpinner.getValue());
            returnValue = returnValue + " *";
            returnValue = returnValue + " ?";
        }
        return returnValue;
    }

    public boolean isUseCalendar() {
        return this.useCalendarKDCheckBox.isSelected();
    }

    public void setUseCalendar(boolean use) {
        this.useCalendarKDCheckBox.setSelected(use);
        this.selectOrgUnitKDBizPromptBox.setEnabled(use);
        this.workingDayRadioButton.setVisible(use);
        this.nonworkingDayRadioButton.setVisible(use);
    }

    public boolean isInWorkingDay() {
        return this.workingDayRadioButton.isSelected();
    }

    public void setInWorkingDay(boolean isInWorkingDay) {
        this.workingDayRadioButton.setSelected(isInWorkingDay);
        this.nonworkingDayRadioButton.setSelected(!isInWorkingDay);
    }

    public OrgUnitInfo getOrgUnit() {
        Object orgUnit = this.selectOrgUnitKDBizPromptBox.getData();
        return (OrgUnitInfo)orgUnit;
    }

    public void setOrgUnit(AdminOrgUnitInfo value) {
        this.selectOrgUnitKDBizPromptBox.setData((Object)value);
    }

    public void setSchedule(String value, boolean readOnly) {
        ScheduleExpression se = JobProcessUtil.parseSchedule(value);
        if (se != null) {
            this.beginTimekDTimePicker.setValue((Object)se.getBeginTime());
            String dayofmonth = se.getDayofmonth();
            if (dayofmonth.equalsIgnoreCase("*")) {
                this.everyDaykDRadioButton.setSelected(true);
            } else if (dayofmonth.equalsIgnoreCase("?")) {
                this.everyWorkingDaykDRadioButton.setSelected(true);
            } else {
                this.rangekDRadioButton.setSelected(true);
                String dayRange = dayofmonth.substring(se.getDayofmonth().indexOf("/") + 1);
                this.rangekDSpinner.setValue((Object)Integer.valueOf(dayRange));
            }
        }
        this.setEnable(!readOnly);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setEnable(boolean enable) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i <= componentArray.length - 1; ++i) {
            Component destComponent = componentArray[i];
            if (destComponent instanceof KDLabel) continue;
            destComponent.setEnabled(enable);
        }
    }

    private void initializeUI() {
        NewAdminF7 adminF7 = new NewAdminF7((IUIObject)this);
        adminF7.setIsCUFilter(false);
        this.workingDayRadioButton.setVisible(false);
        this.workingDayRadioButton.setSelected(true);
        this.nonworkingDayRadioButton.setVisible(false);
        this.selectOrgUnitKDBizPromptBox.setEditable(false);
        this.selectOrgUnitKDBizPromptBox.setSelector((KDPromptSelector)adminF7);
        this.useCalendarKDCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isSelected = EveryDay.this.useCalendarKDCheckBox.isSelected();
                EveryDay.this.workingDayRadioButton.setVisible(isSelected);
                EveryDay.this.nonworkingDayRadioButton.setVisible(isSelected);
                EveryDay.this.selectOrgUnitKDBizPromptBox.setEnabled(isSelected);
                EveryDay.this.selectOrgUnitKDBizPromptBox.setEditable(false);
            }
        });
        this.useCalendarKDCheckBox.setSelected(false);
        this.selectOrgUnitKDBizPromptBox.setEnabled(false);
        this.everyDaykDRadioButton.setSelected(true);
        this.setEveryDayState();
        this.setEveryWorkingDayState();
        this.setRangeState();
        this.rangekDSpinner.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 365, 1));
        this.rangekDSpinner.setEditable(false);
        this.everyDaykDRadioButton.addChangeListener((ChangeListener)new CommonChangeListener());
        this.everyWorkingDaykDRadioButton.addChangeListener((ChangeListener)new CommonChangeListener());
        this.rangekDRadioButton.addChangeListener((ChangeListener)new CommonChangeListener());
    }

    private void setEveryDayState() {
    }

    private void setEveryWorkingDayState() {
    }

    private void setRangeState() {
        this.rangekDSpinner.setEnabled(this.rangekDRadioButton.isSelected());
    }

    private class CommonChangeListener
    implements ChangeListener {
        private CommonChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            try {
                String tempRBAC = ((KDRadioButton)e.getSource()).getActionCommand();
                if ("everyday".equalsIgnoreCase(tempRBAC)) {
                    EveryDay.this.setEveryDayState();
                }
                if ("everyworkingday".equalsIgnoreCase(tempRBAC)) {
                    EveryDay.this.setEveryWorkingDayState();
                }
                if ("range".equalsIgnoreCase(tempRBAC)) {
                    EveryDay.this.setRangeState();
                }
            }
            catch (Exception error) {
                ExceptionHandler.handle((Throwable)error);
            }
        }
    }
}

