/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.workflow.metas.AdjustWfDataFactory;
import com.kingdee.bos.workflow.metas.IAdjustWfData;
import com.kingdee.bos.workflow.report.client.util.CompositeUtil;
import com.kingdee.bos.workflow.report.client.util.ReportResourceUtil;
import com.kingdee.eas.base.job.client.AbstractJobProcessDefineListUI;
import com.kingdee.eas.base.job.client.JobLogListUI;
import com.kingdee.eas.base.job.client.JobProcessInstanceListUI;
import com.kingdee.eas.base.job.util.JobResourceUtil;
import com.kingdee.eas.base.job.util.JobUtils;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class JobProcessDefineListUI
extends AbstractJobProcessDefineListUI {
    private static final long serialVersionUID = -7220324328954078025L;
    private int rowIndex;
    private int[] rowIndexs;

    public JobProcessDefineListUI() throws Exception {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
            }
        });
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        this.startProcess();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        if (this.tblMain.getRowCount3() > 0) {
            this.tblMain.getSelectManager().add(0, 0);
        }
    }

    @Override
    public void actionEnableProcess_actionPerformed(ActionEvent e) throws Exception {
        this.enableProcessDef(true);
    }

    @Override
    public void actionDisableProcess_actionPerformed(ActionEvent e) throws Exception {
        this.enableProcessDef(false);
    }

    @Override
    public void actionShowProcInst_actionPerformed(ActionEvent e) throws Exception {
        this.showProcInst();
    }

    public void actionView_actionPerformed(ActionEvent arg0) throws Exception {
        this.showProcInst();
    }

    public void showAllCropExpression() {
        try {
            IAdjustWfData adjustWfData = AdjustWfDataFactory.getRemoteInstance();
            String expression = adjustWfData.getAllCronExpression();
            JDialog dialog = new JDialog();
            dialog.setSize(600, 300);
            JTextArea area = new JTextArea(10, 50);
            area.setText(expression);
            JScrollPane scrollPane = new JScrollPane(area);
            dialog.getContentPane().add(scrollPane);
            dialog.setVisible(true);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getMainTable().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean shiftDown = e.isShiftDown();
                boolean controlDown = e.isControlDown();
                boolean isAltDown = e.isAltDown();
                int keyCode = e.getKeyCode();
                if (controlDown && shiftDown && isAltDown && 67 == keyCode) {
                    JobProcessDefineListUI.this.showAllCropExpression();
                }
            }
        });
        this.setButtonDefaultStyl(this.btnPageSetup);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnQuery);
        this.loadFields();
        this.getParameter();
        this.initializeUI();
        this.removeEditMenu();
        this.menuItemUpgrade.setEnabled(true);
        this.menuItemUpgrade.setVisible(false);
        this.btnStart.setEnabled(true);
        this.btnStart.setIcon(EASResource.getIcon((String)"imgTbtn_startupserve"));
        this.btnCheck.setEnabled(true);
        this.btnCheck.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.miCleanWasteJobs.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.btnLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.enableBtn.setEnabled(false);
        this.disableBtn.setEnabled(false);
        this.kDMenuItem1.setEnabled(false);
        this.kDMenuItem2.setEnabled(false);
        this.menuItemCancelCancel.setEnabled(false);
        this.menuItemCancel.setEnabled(false);
    }

    private void removeEditMenu() {
        this.menuBar.remove((Component)this.menuEdit);
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void kdtQueryProcDef_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    protected String getKeyFieldName() {
        return "jobdefid";
    }

    private void setColumnValue(int rowIndex, String columnTitle, Object value) {
        ICell cell;
        IRow row;
        if (this.tblMain != null && (row = this.tblMain.getRow(rowIndex)) != null && (cell = row.getCell(columnTitle)) != null) {
            cell.setValue(value);
        }
    }

    private void enableProcessDef(boolean enable) {
        try {
            HashMap<String, String> titleMap = new HashMap<String, String>();
            String[] triggerIds = new String[this.rowIndexs.length];
            for (int i = 0; i < this.rowIndexs.length; ++i) {
                triggerIds[i] = (String)this.tblMain.getRow(this.rowIndexs[i]).getCell("trigger.id").getValue();
                titleMap.put(triggerIds[i], (String)this.tblMain.getRow(this.rowIndexs[i]).getCell("title").getValue());
            }
            if (enable) {
                List<String> errorIds = JobUtils.getJobServiceFacade().enableTriggers(triggerIds);
                if (errorIds.size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < errorIds.size(); ++i) {
                        sb.append((String)titleMap.get(errorIds.get(i))).append("\uff1b");
                    }
                    MsgBox.showInfo((Component)((Object)this), (String)(sb.toString() + JobResourceUtil.getJobResource("EnableProcessDefFailure")));
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)JobResourceUtil.getJobResource("EnableJobProcessDefSuccess"));
                }
            } else {
                List<String> errorIds = JobUtils.getJobServiceFacade().disableTriggers(triggerIds);
                if (errorIds.size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < errorIds.size(); ++i) {
                        sb.append((String)titleMap.get(errorIds.get(i))).append("\uff1b");
                    }
                    MsgBox.showInfo((Component)((Object)this), (String)(sb.toString() + JobResourceUtil.getJobResource("DisableProcessDefFailure")));
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)JobResourceUtil.getJobResource("DisableJobProcessDefSuccess"));
                }
            }
            this.refreshList();
        }
        catch (Exception e) {
            String errorMessage = "";
            if (enable) {
                errorMessage = ReportResourceUtil.getReportMultiLanguageResource((String)"EnableProcessDefFailure");
                ExceptionHandler.handle((Component)((Object)this), (String)errorMessage, (Throwable)e);
            } else {
                errorMessage = ReportResourceUtil.getReportMultiLanguageResource((String)"DisableProcessDefFailure");
            }
            ExceptionHandler.handle((Component)((Object)this), (String)errorMessage, (Throwable)e);
        }
    }

    private void startProcess() {
        try {
            if (MsgBox.showConfirm2((String)JobResourceUtil.getJobResource("confirmStart")) != 0) {
                return;
            }
            String jobDefId = (String)this.tblMain.getRow(this.rowIndex).getCell(this.getKeyFieldName()).getValue();
            JobUtils.getJobServiceFacade().createJobInstance(jobDefId, null, null);
            MsgBox.showInfo((String)JobResourceUtil.getJobResource("startSuccess"));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void actionLog_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getSelectManager().select(this.rowIndex, 0);
        String jobDefId = (String)this.tblMain.getRow(this.rowIndex).getCell(this.getKeyFieldName()).getValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ownerid", (Object)jobDefId);
        String className = JobLogListUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(className, (Map)uiContext);
        uiWindow.show();
    }

    private void setButtonIco() {
        this.enableBtn.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.disableBtn.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.showProcInstBtn.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.kDMenuItem3.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
    }

    private void initializeUI() {
        this.tblMain.checkParsed();
        this.windowTitle = this.getWindowTitle();
        this.setButtonIco();
        CompositeUtil.setTableReadOnly((KDTable)this.tblMain);
    }

    private String getCurrentID(int rowIndex) {
        Object destValue;
        ICell destCell;
        this.checkSelected();
        IRow currentRow = this.tblMain.getRow(rowIndex);
        if (currentRow != null && (destCell = currentRow.getCell(0)) != null && (destValue = destCell.getValue()) != null) {
            return (String)destValue;
        }
        return "";
    }

    private Boolean getEnable(int rowIndex) {
        IRow currentRow = this.tblMain.getRow(rowIndex);
        if (currentRow != null) {
            ICell destCell = currentRow.getCell("title");
            if (destCell != null) {
                String s;
                Object o = destCell.getValue();
                String string = s = o == null ? "" : o.toString();
                if (s.startsWith("~")) {
                    return null;
                }
            }
            if ((destCell = currentRow.getCell("trigger.isValid")) != null) {
                Object destValue = destCell.getValue();
                if (destValue != null) {
                    if (destValue instanceof BizEnumValueDTO) {
                        String state = ((BizEnumValueDTO)destValue).getName();
                        if ("ENABLE".equals(state)) {
                            return Boolean.TRUE;
                        }
                        if ("DISABLE".equals(state)) {
                            return Boolean.FALSE;
                        }
                        return null;
                    }
                    if (destValue instanceof Boolean) {
                        return (Boolean)destValue;
                    }
                } else {
                    return null;
                }
            }
        }
        return Boolean.FALSE;
    }

    private void getParameter() {
    }

    private String getWindowTitle() {
        return ReportResourceUtil.getReportName((String)"ProcessDefine_Backgroundjob");
    }

    private void setProcessEnableButtonEnable(Boolean enable) {
        boolean e = enable != null ? enable : false;
        this.enableBtn.setEnabled(!e && enable != null);
        this.disableBtn.setEnabled(e && enable != null);
        this.kDMenuItem1.setEnabled(!e && enable != null);
        this.kDMenuItem2.setEnabled(e && enable != null);
        this.menuItemCancelCancel.setEnabled(!e && enable != null);
        this.menuItemCancel.setEnabled(e && enable != null);
    }

    private void synchronizeButtonState(int[] rowIndexs) {
        Boolean enable = null;
        for (int i = 0; i < rowIndexs.length; ++i) {
            if (i == 0) {
                enable = this.getEnable(rowIndexs[i]);
                continue;
            }
            if (this.getEnable(rowIndexs[i]) != null && this.getEnable(rowIndexs[i]).equals(enable)) continue;
            enable = null;
            break;
        }
        this.setProcessEnableButtonEnable(enable);
    }

    private void showProcInst() {
        try {
            int index = CompositeUtil.getCurrentRowIndex((KDTable)this.tblMain);
            if (index >= 0) {
                this.tblMain.getSelectManager().select(index, 0);
                String id = this.getCurrentID(index);
                if (id != null && id.length() > 0) {
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"ProcessDefineID", (Object)id);
                    String className = JobProcessInstanceListUI.class.getName();
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(className, (Map)uiContext);
                    uiWindow.show();
                }
            }
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)((Object)this), (String)"UIException", (Throwable)e);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent arg0) throws Exception {
        super.tblMain_tableClicked(arg0);
        if (arg0.getClickCount() == 2) {
            this.showProcInst();
        }
    }

    protected void setActionState() {
        Object o;
        super.setActionState();
        KDTRange selRang = this.tblMain.getSelectManager().toRange();
        if (selRang.isSingleRange() && (o = selRang.get(0)) instanceof KDTSelectBlock) {
            KDTSelectBlock selectBlock = (KDTSelectBlock)o;
            this.rowIndex = selectBlock.getBeginRow();
        }
        this.rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        this.synchronizeButtonState(this.rowIndexs);
    }

    @Override
    public void actionReleaseAgain_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionCleanWasteJobs_actionPerformed(ActionEvent e) throws Exception {
        if (0 == MsgBox.showConfirm2((Component)((Object)this), (String)JobResourceUtil.getJobResource("confirmClean"))) {
            JobUtils.getJobServiceFacade().cleanWasteJobDef();
            MsgBox.showInfo((String)JobResourceUtil.getJobResource("cleanSuccess"));
            this.refreshList();
        }
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"title", "description"};
        return locateNames;
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        String triggerId = (String)this.tblMain.getRow(this.rowIndex).getCell("trigger.id").getValue();
        if (triggerId != null) {
            String s = JobUtils.getJobServiceFacade().checkTrigger(triggerId);
            MsgBox.showConfirm3a((String)"\u540e\u53f0\u4e8b\u52a1\u68c0\u6d4b\uff0c\u70b9\u51fb\u201c\u8be6\u7ec6\u4fe1\u606f\u201d\u67e5\u770b\u3002", (String)s);
        }
    }
}

