/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IKDCommonPromptSelector;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.workflow.report.client.util.CompositeUtil;
import com.kingdee.bos.workflow.report.client.util.ReportUtil;
import com.kingdee.eas.base.job.IJobServiceUIFacade;
import com.kingdee.eas.base.job.JobDefInfo;
import com.kingdee.eas.base.job.client.AbstractJobProcessDefineRecordUI;
import com.kingdee.eas.base.job.client.JobProcessInstanceListUI;
import com.kingdee.eas.base.job.util.JobUtils;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class JobProcessDefineRecordUI
extends AbstractJobProcessDefineRecordUI {
    private static final Logger logger = CoreUIObject.getLogger(JobProcessDefineRecordUI.class);
    private static final String jobRes = "com.kingdee.eas.base.job.client.JobResource";
    private static final String maagRes = "com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource";
    private String COLUMNNAME_LONGESTTIME = "longestTime";
    private String COLUMNNAME_TOTALTIME = "totalTime";
    private String COLUMNNAME_AVERAGETIME = "averageTime";
    private String COLUMNNAME_JOBDEFID = "jobdefid";
    private String COLUMNNAME_TOTALCOUNT = "totalCount";
    private String COLUMNNAME_SUCCESSCOUNT = "successCount";
    private String COLUMNNAME_BLOCKCOUNT = "blockCount";
    private String COLUMNNAME_EXCEPTIONCOUNT = "exceptionCount";
    private String COLUMNNAME_RUNNEDCOUNT = "runnedCount";
    private boolean isHistoryData;
    private String queryServer;
    private Date queryExecuteTimeFrom;
    private Date queryExecuteTimeTo;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudFeed_actionPerformed(e);
    }

    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudShare_actionPerformed(e);
    }

    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudScreen_actionPerformed(e);
    }

    public void actionXunTongFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionXunTongFeed_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.showJobInstRecord();
    }

    private void showJobInstRecord() {
        try {
            int rowIndex = CompositeUtil.getCurrentRowIndex((KDTable)this.tblMain);
            int colIndex = this.tblMain.getSelectManager().getActiveColumnIndex();
            if (rowIndex >= 0 && colIndex >= 0) {
                String id = this.getProcessDeffID(rowIndex);
                String columnKey = this.tblMain.getColumnKey(colIndex);
                if (id != null && id.length() > 0 && (this.COLUMNNAME_TOTALCOUNT.equals(columnKey) || this.COLUMNNAME_SUCCESSCOUNT.equals(columnKey) || this.COLUMNNAME_BLOCKCOUNT.equals(columnKey) || this.COLUMNNAME_EXCEPTIONCOUNT.equals(columnKey) || this.COLUMNNAME_RUNNEDCOUNT.equals(columnKey) || this.COLUMNNAME_LONGESTTIME.equals(columnKey))) {
                    HashSet<String> set = new HashSet<String>();
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"jobdefid", (Object)id);
                    if (this.COLUMNNAME_SUCCESSCOUNT.equals(columnKey)) {
                        set.add("Complete");
                    }
                    if (this.COLUMNNAME_BLOCKCOUNT.equals(columnKey)) {
                        set.add("ReScheduled");
                        set.add("Waiting");
                        set.add("Ready");
                        set.add("Running");
                        set.add("Created");
                    }
                    if (this.COLUMNNAME_EXCEPTIONCOUNT.equals(columnKey)) {
                        set.add("Failed");
                        set.add("Suspended");
                        set.add("Aborted");
                        set.add("Missed");
                    }
                    if (this.COLUMNNAME_RUNNEDCOUNT.equals(columnKey)) {
                        uiContext.put((Object)"runned", (Object)true);
                    }
                    if (this.COLUMNNAME_LONGESTTIME.equals(columnKey)) {
                        uiContext.put((Object)"longestTime", (Object)this.getLongestTime(rowIndex));
                    }
                    uiContext.put((Object)"state", set);
                    if (this.queryServer != null) {
                        uiContext.put((Object)"server", (Object)this.queryServer);
                    }
                    uiContext.put((Object)"executeTimeFrom", (Object)this.queryExecuteTimeFrom);
                    uiContext.put((Object)"executeTimeTo", (Object)this.queryExecuteTimeTo);
                    uiContext.put((Object)"isHistoryData", (Object)this.isHistoryData);
                    String className = JobProcessInstanceListUI.class.getName();
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(className, (Map)uiContext);
                    uiWindow.show();
                }
            }
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)((Object)this), (String)"UIException", (Throwable)e);
        }
    }

    private String getProcessDeffID(int rowIndex) {
        Object destValue;
        ICell destCell;
        IRow currentRow = this.tblMain.getRow(rowIndex);
        if (currentRow != null && (destCell = currentRow.getCell(this.COLUMNNAME_JOBDEFID)) != null && (destValue = destCell.getValue()) != null && destValue instanceof String) {
            return (String)destValue;
        }
        return "";
    }

    private Integer getLongestTime(int rowIndex) {
        Object destValue;
        ICell destCell;
        IRow currentRow = this.tblMain.getRow(rowIndex);
        if (currentRow != null && (destCell = currentRow.getCell(this.COLUMNNAME_LONGESTTIME)) != null && (destValue = destCell.getUserObject()) != null && destValue instanceof Integer) {
            return (Integer)destValue;
        }
        return null;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionPublishReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublishReport_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryScheme_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    @Override
    protected void queryButton_actionPerformed(ActionEvent e) throws Exception {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        Object jobDeff = this.jobDeff.getValue();
        if (jobDeff instanceof JobDefInfo) {
            String jobdefid = ((JobDefInfo)jobDeff).getJobdefid();
            if (StringUtils.isEmpty((String)jobdefid)) {
                return;
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("jobdefid", (Object)jobdefid, CompareType.EQUALS));
        }
        if (jobDeff instanceof Object[]) {
            Object[] objects = (Object[])jobDeff;
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < objects.length; ++i) {
                if (!(objects[i] instanceof JobDefInfo)) continue;
                String jobdefid = ((JobDefInfo)objects[i]).getJobdefid();
                set.add(jobdefid);
            }
            if (set.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("jobdefid", set, CompareType.INCLUDE));
            }
        }
        if (this.executeServer.getSelectedIndex() != 0) {
            Object item = this.executeServer.getSelectedItem();
            String server = item.toString();
            filterInfo.getFilterItems().add(new FilterItemInfo("server", (Object)server, CompareType.EQUALS));
            this.queryServer = server;
        } else {
            this.queryServer = null;
        }
        Object executeTimeFrom = this.executeTimeFrom.getValue();
        if (executeTimeFrom instanceof Date) {
            filterInfo.getFilterItems().add(new FilterItemInfo("excuteTime", executeTimeFrom, CompareType.GREATER_EQUALS));
            this.queryExecuteTimeFrom = (Date)executeTimeFrom;
        } else {
            this.queryExecuteTimeFrom = null;
        }
        Object executeTimeTo = this.executeTimeTo.getValue();
        if (executeTimeTo instanceof Date) {
            long time = ((Date)executeTimeTo).getTime();
            ((Date)executeTimeTo).setTime(time += 86400000L);
            filterInfo.getFilterItems().add(new FilterItemInfo("excuteTime", executeTimeTo, CompareType.LESS));
            this.queryExecuteTimeTo = (Date)executeTimeTo;
        } else {
            this.queryExecuteTimeTo = null;
        }
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        String maskString = "";
        for (int i = 0; i < filterItems.size(); ++i) {
            maskString = i == 0 ? maskString + "#0" : maskString + " and #" + String.valueOf(i);
        }
        filterInfo.setMaskString(maskString);
        entityViewInfo.setFilter(filterInfo);
        this.mainQuery = entityViewInfo;
        this.refreshList();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getKeyFieldName() {
        return "jobdefid";
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        String[] servers = null;
        try {
            IJobServiceUIFacade iJobServiceUIFacade = JobUtils.getJobServiceFacade();
            servers = iJobServiceUIFacade.getJobServiceInstanceKeys_c();
            if (servers.length == 0) {
                this.kDLabelContainer5.setVisible(false);
            } else {
                this.executeServer.addItem((Object)EASResource.getString((String)jobRes, (String)"selectExecutionServer"));
                for (int i = 0; i < servers.length; ++i) {
                    if (servers[i].startsWith("cluster@")) continue;
                    this.executeServer.addItem((Object)servers[i]);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"getJobServiceFacade failed!", (Throwable)e);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor executor = super.getQueryExecutor(queryPK, viewInfo);
        executor.option().isAutoTranslateEnum = false;
        return executor;
    }

    public void onLoad() throws Exception {
        this.getUIContext().put("RequestModel", "0");
        super.onLoad();
        this.jobDeff.setEnabledMultiSelection(true);
        this.jobDeff.setDefaultF7UIName("com.kingdee.eas.base.job.client.JobDefF7PromtpDialog");
        this.jobDeff.setDisplayFormat("$title$");
        this.jobDeff.setEditFormat("$title$");
        this.jobDeff.setCommitFormat("$title$");
        this.jobDeff.setMyCommonUseEnabled(false);
        ReportUtil.setQueryHistoryState((KDWorkButton)this.queryHistoryBtn, (KDMenuItem)this.queryHistoryMnItm);
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.btnView.setVisible(false);
        this.btnQuery.setVisible(false);
        this.btnLocate.setVisible(false);
        this.menuItemView.setVisible(false);
        this.menuItemLocate.setVisible(false);
        this.menuItemQuery.setVisible(false);
        this.tblMain.getSelectManager().setSelectMode(1);
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        try {
            FilterInfo newfilterInfo = new FilterInfo();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String s = sdf.format(new Date());
            Date date1 = new Date(sdf.parse(s).getTime());
            Date date2 = new Date(sdf.parse(s).getTime() + 86400000L);
            newfilterInfo.getFilterItems().add(new FilterItemInfo("excuteTime", (Object)date1, CompareType.GREATER_EQUALS));
            newfilterInfo.getFilterItems().add(new FilterItemInfo("excuteTime", (Object)date2, CompareType.LESS));
            newfilterInfo.setMaskString("#0 and #1");
            filterInfo.mergeFilter(newfilterInfo, "and");
            this.queryExecuteTimeFrom = date1;
            this.queryExecuteTimeTo = date2;
        }
        catch (Exception e) {
            logger.error((Object)"getDefaultFilterForQuery error ", (Throwable)e);
        }
        return filterInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterTableFillData(KDTDataRequestEvent dre) {
        super.afterTableFillData(dre);
        int firstRow = dre.getFirstRow();
        int lastRow = dre.getLastRow();
        logger.debug((Object)("firstRow=" + firstRow + ",lastRow=" + lastRow));
        KDTable kDTable = this.tblMain;
        synchronized (kDTable) {
            if (lastRow - firstRow >= 0 && lastRow != -1) {
                Object longestTime = null;
                Object totalTime = null;
                Object averageTime = null;
                for (int i = firstRow; i <= lastRow; ++i) {
                    longestTime = this.tblMain.getRow(i).getCell(this.COLUMNNAME_LONGESTTIME).getValue();
                    this.changeTime(i, this.COLUMNNAME_LONGESTTIME, longestTime);
                    totalTime = this.tblMain.getRow(i).getCell(this.COLUMNNAME_TOTALTIME).getValue();
                    this.changeTime(i, this.COLUMNNAME_TOTALTIME, totalTime);
                    averageTime = this.tblMain.getRow(i).getCell(this.COLUMNNAME_AVERAGETIME).getValue();
                    this.changeTime(i, this.COLUMNNAME_AVERAGETIME, averageTime);
                }
            }
            this.tblMain.getColumn(this.COLUMNNAME_TOTALCOUNT).getStyleAttributes().setFontColor(Color.BLUE);
            this.tblMain.getColumn(this.COLUMNNAME_SUCCESSCOUNT).getStyleAttributes().setFontColor(Color.BLUE);
            this.tblMain.getColumn(this.COLUMNNAME_BLOCKCOUNT).getStyleAttributes().setFontColor(Color.BLUE);
            this.tblMain.getColumn(this.COLUMNNAME_EXCEPTIONCOUNT).getStyleAttributes().setFontColor(Color.BLUE);
            this.tblMain.getColumn(this.COLUMNNAME_RUNNEDCOUNT).getStyleAttributes().setFontColor(Color.BLUE);
            this.tblMain.getColumn(this.COLUMNNAME_LONGESTTIME).getStyleAttributes().setFontColor(Color.BLUE);
        }
    }

    private void changeTime(int i, String s, Object time) {
        if (time instanceof Integer) {
            int c = (Integer)time;
            String timeStr = "";
            if (c < 0) {
                timeStr = timeStr + "-";
                c = 0 - c;
            }
            if (c > 3600000) {
                timeStr = timeStr + c / 3600000 + EASResource.getString((String)maagRes, (String)"4_QuartzParser");
            }
            if (c > 60000) {
                timeStr = timeStr + c % 3600000 / 60000 + EASResource.getString((String)maagRes, (String)"5_QuartzParser");
            }
            timeStr = timeStr + (float)(c % 60000) / 1000.0f + EASResource.getString((String)maagRes, (String)"7_QuartzParser");
            this.tblMain.getRow(i).getCell(s).setUserObject(time);
            this.tblMain.getRow(i).getCell(s).setValue((Object)timeStr);
        }
    }

    @Override
    public void actionQueryHistoryData_actionPerformed(ActionEvent e) throws Exception {
        this.queryHistoryData(e);
    }

    private void queryHistoryData(ActionEvent e) throws Exception {
        String actionCommand = e.getActionCommand();
        if ("queryHistory".equalsIgnoreCase(actionCommand)) {
            ReportUtil.setQueryCurrentState((KDWorkButton)this.queryHistoryBtn, (KDMenuItem)this.queryHistoryMnItm);
            this.mainQueryPK = new MetaDataPK("com.kingdee.eas.base.job.app", "JobRecordHstQuery");
            this.refreshList();
            this.isHistoryData = true;
        } else if ("queryCurrent".equalsIgnoreCase(actionCommand)) {
            ReportUtil.setQueryHistoryState((KDWorkButton)this.queryHistoryBtn, (KDMenuItem)this.queryHistoryMnItm);
            this.mainQueryPK = new MetaDataPK("com.kingdee.eas.base.job.app", "JobRecordQuery");
            this.refreshList();
            this.isHistoryData = false;
        }
    }

    @Override
    protected void executeTimeFrom_dataChanged(DataChangeEvent e) throws Exception {
        long timeTo;
        long timeFrom;
        Object executeTimeFrom = this.executeTimeFrom.getValue();
        Object executeTimeTo = this.executeTimeTo.getValue();
        if (executeTimeFrom instanceof Date && executeTimeTo instanceof Date && (timeFrom = ((Date)executeTimeFrom).getTime()) > (timeTo = ((Date)executeTimeTo).getTime())) {
            this.executeTimeFrom.setValue(executeTimeTo);
        }
    }

    @Override
    protected void executeTimeTo_dataChanged(DataChangeEvent e) throws Exception {
        long timeTo;
        long timeFrom;
        Object executeTimeFrom = this.executeTimeFrom.getValue();
        Object executeTimeTo = this.executeTimeTo.getValue();
        if (executeTimeFrom instanceof Date && executeTimeTo instanceof Date && (timeFrom = ((Date)executeTimeFrom).getTime()) > (timeTo = ((Date)executeTimeTo).getTime())) {
            this.executeTimeTo.setValue(executeTimeFrom);
        }
    }

    protected KDPromptSelector createDefaultF7UIByName(String className) {
        KDPromptSelector sel = null;
        Window parent = SwingUtilities.getWindowAncestor((Component)this.jobDeff);
        Class[] params = null;
        try {
            Class<?> cl = Class.forName(className);
            if (parent instanceof Dialog) {
                params = new Class[]{Dialog.class};
                Constructor<?> ctr = cl.getConstructor(params);
                sel = (KDPromptSelector)ctr.newInstance(parent);
            } else if (parent instanceof Frame) {
                params = new Class[]{Frame.class};
                Constructor<?> ctr = cl.getConstructor(params);
                sel = (KDPromptSelector)ctr.newInstance(parent);
            } else {
                sel = (KDPromptSelector)cl.newInstance();
            }
            if (sel != null && sel instanceof IKDCommonPromptSelector) {
                ((IKDCommonPromptSelector)sel).setMaintainUIContext(new UIContext((Object)this));
            }
        }
        catch (SecurityException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return sel;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.jobDeff.setSelector(this.createDefaultF7UIByName("com.kingdee.eas.base.job.client.JobDefF7PromtpDialog"));
    }
}

