/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.workflow.report.client.util.CompositeUtil;
import com.kingdee.bos.workflow.report.client.util.ReportResourceUtil;
import com.kingdee.bos.workflow.report.client.util.ReportUtil;
import com.kingdee.eas.base.job.client.AbstractJobProcessInstanceListUI;
import com.kingdee.eas.base.job.client.JobDetailInformationUI;
import com.kingdee.eas.base.job.client.JobLogListUI;
import com.kingdee.eas.base.job.client.JobServiceStatusUI;
import com.kingdee.eas.base.job.client.JobState;
import com.kingdee.eas.base.job.client.JobThreadPool;
import com.kingdee.eas.base.job.util.JobResourceUtil;
import com.kingdee.eas.base.job.util.JobUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class JobProcessInstanceListUI
extends AbstractJobProcessInstanceListUI {
    private static final Logger logger = CoreUIObject.getLogger(JobProcessInstanceListUI.class);
    private static final String maagRes = "com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource";
    private static final long serialVersionUID = -4249791697670306934L;
    private String COLUMNNAME_PROCINSTID = "jobInstId";
    private String COLUMNNAME_STATE = "state";
    private String processDefID = "";
    private boolean isHistoryData;

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionQueryHistoryData_actionPerformed(ActionEvent e) throws Exception {
        this.queryHistoryData(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refreshList();
    }

    @Override
    public void actionShowProcessDiagram_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionShowLog_actionPerformed(ActionEvent e) throws Exception {
        this.showLog();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2 && this.actionException.isVisible()) {
            this.actionException_actionPerformed(null);
        }
    }

    @Override
    public void actionShowProcWithoutInst_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        String className = JobServiceStatusUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
        uiWindow.show();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.showJobDetail();
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        return postman;
    }

    public void onLoad() throws Exception {
        this.getParameter();
        super.onLoad();
        this.enableExportExcel(this.tblMain);
        this.loadFields();
        this.initializeUI();
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.actionAbort.setEnabled(false);
        this.actionSuspend.setEnabled(false);
        this.actionResume.setEnabled(false);
        this.actionRestart.setEnabled(false);
        this.actionMove.setEnabled(false);
        this.actionException.setVisible(false);
        this.actionShowLog.setEnabled(false);
        this.actionResult.setVisible(false);
        this.actionDelete.setEnabled(false);
        this.btnLocate.setVisible(true);
        this.actionView.setVisible(true);
        this.actionView.setEnabled(true);
        this.btnView.setVisible(true);
        this.btnView.setEnabled(true);
        this.btnRestart.setIcon(EASResource.getIcon((String)"imgTbtn_startupserve"));
        this.btnAbort.setIcon(EASResource.getIcon((String)"imgTbtn_abortinstance"));
        this.btnSuspend.setIcon(EASResource.getIcon((String)"imgTbtn_suspendinstance"));
        this.btnResume.setIcon(EASResource.getIcon((String)"imgTbtn_abolishsuspend"));
        this.btnMove.setIcon(EASResource.getIcon((String)"imgTbtn_movetier"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnCheck.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.btnThreadPool.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.btnStopHelp.setIcon(EASResource.getIcon((String)"imgTbtn_hyperlink"));
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        if (userInfo != null && UserType.SYSTEM.equals((Object)userInfo.getType())) {
            this.actionThreadPool.setVisible(true);
            this.actionThreadPool.setEnabled(true);
        } else {
            this.actionThreadPool.setVisible(false);
            this.actionThreadPool.setEnabled(false);
        }
        this.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl K"), "enableproperty");
        this.getActionMap().put("enableproperty", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobProcessInstanceListUI.this.actionThreadPool.setVisible(!JobProcessInstanceListUI.this.actionThreadPool.isVisible());
                JobProcessInstanceListUI.this.actionThreadPool.setEnabled(!JobProcessInstanceListUI.this.actionThreadPool.isEnabled());
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void kdtQueryProcInst_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1 || e.getClickCount() == 2) {
            // empty if block
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        Date executeTimeTo;
        Date executeTimeFrom;
        String server;
        Integer longestTime;
        Boolean runned;
        HashSet state;
        Boolean isHistoryData = (Boolean)this.getUIContext().get("isHistoryData");
        if (isHistoryData != null) {
            if (isHistoryData.booleanValue()) {
                this.isHistoryData = true;
                ReportUtil.setQueryCurrentState((KDWorkButton)this.queryHistoryBtn, (KDMenuItem)this.queryHistoryMnItm);
                this.mainQueryPK = new MetaDataPK("com.kingdee.eas.base.job.app", "JobInstHstQuery");
            } else {
                this.isHistoryData = false;
                ReportUtil.setQueryHistoryState((KDWorkButton)this.queryHistoryBtn, (KDMenuItem)this.queryHistoryMnItm);
                this.mainQueryPK = new MetaDataPK("com.kingdee.eas.base.job.app", "JobInstQuery");
            }
        }
        FilterInfo filter = new FilterInfo();
        String jobdefid = (String)this.getUIContext().get("jobdefid");
        if (jobdefid != null) {
            filter.getFilterItems().add(new FilterItemInfo("jobDefId", (Object)jobdefid, CompareType.EQUALS));
        }
        if ((state = (HashSet)this.getUIContext().get("state")) != null && state.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)state, CompareType.INCLUDE));
        }
        if ((runned = (Boolean)this.getUIContext().get("runned")) != null && runned.booleanValue()) {
            filter.getFilterItems().add(new FilterItemInfo("costTime", null, CompareType.ISNOT));
        }
        if ((longestTime = (Integer)this.getUIContext().get("longestTime")) != null) {
            filter.getFilterItems().add(new FilterItemInfo("costTime", (Object)longestTime, CompareType.EQUALS));
        }
        if ((server = (String)this.getUIContext().get("server")) != null) {
            filter.getFilterItems().add(new FilterItemInfo("holderId", (Object)server, CompareType.EQUALS));
        }
        if ((executeTimeFrom = (Date)this.getUIContext().get("executeTimeFrom")) != null) {
            filter.getFilterItems().add(new FilterItemInfo("createdTime", (Object)executeTimeFrom, CompareType.GREATER_EQUALS));
        }
        if ((executeTimeTo = (Date)this.getUIContext().get("executeTimeTo")) != null) {
            filter.getFilterItems().add(new FilterItemInfo("createdTime", (Object)executeTimeTo, CompareType.LESS));
        }
        FilterItemCollection filterItems = filter.getFilterItems();
        String maskString = "";
        for (int i = 0; i < filterItems.size(); ++i) {
            maskString = i == 0 ? maskString + "#0" : maskString + " and #" + String.valueOf(i);
        }
        filter.setMaskString(maskString);
        return filter;
    }

    protected String getKeyFieldName() {
        return "jobInstId";
    }

    private void queryHistoryData(ActionEvent e) throws Exception {
        String actionCommand = e.getActionCommand();
        if ("queryHistory".equalsIgnoreCase(actionCommand)) {
            ReportUtil.setQueryCurrentState((KDWorkButton)this.queryHistoryBtn, (KDMenuItem)this.queryHistoryMnItm);
            this.mainQueryPK = new MetaDataPK("com.kingdee.eas.base.job.app", "JobInstHstQuery");
            this.refreshList();
            this.isHistoryData = true;
        } else if ("queryCurrent".equalsIgnoreCase(actionCommand)) {
            ReportUtil.setQueryHistoryState((KDWorkButton)this.queryHistoryBtn, (KDMenuItem)this.queryHistoryMnItm);
            this.mainQueryPK = new MetaDataPK("com.kingdee.eas.base.job.app", "JobInstQuery");
            this.refreshList();
            this.isHistoryData = false;
        }
    }

    private void setButtonIco() {
        this.showProcessDiagramBtn.setIcon(EASResource.getIcon((String)"imgTbtn_flowstakeout"));
        this.showLogBtn.setIcon(EASResource.getIcon((String)"imgTbtn_flowstakeout"));
        this.showProcWithoutInstBtn.setIcon(EASResource.getIcon((String)"imgTbtn_suspendinstance"));
        this.showProcWithoutInstBtn.setEnabled(true);
        this.showLogMenuItem.setIcon(EASResource.getIcon((String)"imgTbtn_flowstakeout"));
        this.showMenuItem.setIcon(EASResource.getIcon((String)"imgTbtn_suspendinstance"));
    }

    private void initializeUI() throws Exception {
        this.tblMain.checkParsed();
        this.windowTitle = this.getWindowTitle();
        this.setButtonIco();
        if (!this.isHistoryData) {
            ReportUtil.setQueryHistoryState((KDWorkButton)this.queryHistoryBtn, (KDMenuItem)this.queryHistoryMnItm);
        }
        this.tblMain.getSelectManager().setSelectMode(10);
        CompositeUtil.setTableReadOnly((KDTable)this.tblMain);
        if (this.processDefID != null) {
            this.queryDataByProcDefId();
        }
        this.showProcWithoutInstBtn.setVisible(false);
    }

    private void queryDataByProcDefId() {
        if (this.processDefID != null) {
            FilterItemInfo fii = new FilterItemInfo("jobDefId", (Object)this.processDefID, CompareType.EQUALS);
            FilterInfo fi = this.mainQuery.getFilter();
            if (fi == null) {
                fi = new FilterInfo();
                this.mainQuery.setFilter(fi);
            }
            fi.getFilterItems().add(fii);
            fi.setMaskString("(#0)");
            this.setDataObject((IObjectValue)this.mainQuery);
        }
    }

    private String getProcessInstanceID(int rowIndex) {
        Object destValue;
        ICell destCell;
        IRow currentRow = this.tblMain.getRow(rowIndex);
        if (currentRow != null && (destCell = currentRow.getCell(this.COLUMNNAME_PROCINSTID)) != null && (destValue = destCell.getValue()) != null && destValue instanceof String) {
            return (String)destValue;
        }
        return "";
    }

    private void getParameter() {
        this.processDefID = (String)this.getUIContext().get("ProcessDefineID");
    }

    private String getWindowTitle() {
        return ReportResourceUtil.getReportName((String)"ProcessInstance_Backgroundjob");
    }

    private void showLog() {
        try {
            String id;
            int index = CompositeUtil.getCurrentRowIndex((KDTable)this.tblMain);
            if (index >= 0 && (id = this.getProcessInstanceID(index)) != null && id.length() > 0) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ownerid", (Object)id);
                String className = JobLogListUI.class.getName();
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(className, (Map)uiContext);
                uiWindow.show();
            }
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)((Object)this), (String)"UIException", (Throwable)e);
        }
    }

    private void showJobDetail() {
        try {
            String id;
            int index = CompositeUtil.getCurrentRowIndex((KDTable)this.tblMain);
            if (index >= 0 && (id = this.getProcessInstanceID(index)) != null && id.length() > 0) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ownerid", (Object)id);
                String className = JobDetailInformationUI.class.getName();
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(className, (Map)uiContext);
                if (uiWindow instanceof UINewFrame) {
                    UINewFrame frame = (UINewFrame)uiWindow;
                    frame.setResizable(false);
                }
                uiWindow.show();
            }
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)((Object)this), (String)"UIException", (Throwable)e);
        }
    }

    @Override
    public boolean isPrepareActionQueryHistoryData() {
        return super.isPrepareActionQueryHistoryData();
    }

    @Override
    public boolean isPrepareActionShowLog() {
        return super.isPrepareActionShowLog();
    }

    @Override
    public boolean isPrepareActionShowProcessDiagram() {
        return super.isPrepareActionShowProcessDiagram();
    }

    @Override
    public boolean isPrepareActionShowProcWithoutInst() {
        return super.isPrepareActionShowProcWithoutInst();
    }

    @Override
    public RequestContext prepareActionEdit(IItemAction itemAction) throws Exception {
        return super.prepareActionEdit(itemAction);
    }

    @Override
    public RequestContext prepareActionQueryHistoryData(IItemAction itemAction) throws Exception {
        return super.prepareActionQueryHistoryData(itemAction);
    }

    @Override
    public RequestContext prepareActionRemove(IItemAction itemAction) throws Exception {
        return super.prepareActionRemove(itemAction);
    }

    @Override
    public RequestContext prepareActionShowLog(IItemAction itemAction) throws Exception {
        return super.prepareActionShowLog(itemAction);
    }

    @Override
    public RequestContext prepareActionShowProcessDiagram(IItemAction itemAction) throws Exception {
        return super.prepareActionShowProcessDiagram(itemAction);
    }

    @Override
    public RequestContext prepareActionShowProcWithoutInst(IItemAction itemAction) throws Exception {
        return super.prepareActionShowProcWithoutInst(itemAction);
    }

    @Override
    public void actionRestart_actionPerformed(ActionEvent e) throws Exception {
        String[] jobInstIds = this.getSelectedIdValues().toArray(new String[0]);
        if (jobInstIds.length > 0) {
            try {
                int i = JobUtils.getJobServiceFacade().restart(jobInstIds);
                if (i != jobInstIds.length) {
                    MsgBox.showInfo((String)(JobResourceUtil.getJobResource("partOpRestart") + jobInstIds.length + JobResourceUtil.getJobResource("partOpMid") + i + JobResourceUtil.getJobResource("partOpSuffex")));
                } else {
                    MsgBox.showInfo((String)JobResourceUtil.getJobResource("restartSuccess"));
                }
                this.refreshList();
            }
            catch (Exception ex) {
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bao);
                ex.printStackTrace(ps);
                String msg = bao.toString();
                MsgBox.showConfirm3a((String)JobResourceUtil.getJobResource("restartFailed"), (String)msg);
            }
        }
    }

    @Override
    public void actionAbort_actionPerformed(ActionEvent e) throws Exception {
        String[] jobInstIds = this.getSelectedIdValues().toArray(new String[0]);
        if (jobInstIds.length > 0) {
            if (MsgBox.showConfirm2((String)JobResourceUtil.getJobResource("confirmAbort")) != 0) {
                return;
            }
            try {
                int i = JobUtils.getJobServiceFacade().abort(jobInstIds);
                if (i != jobInstIds.length) {
                    MsgBox.showInfo((String)(JobResourceUtil.getJobResource("partOpAbort") + jobInstIds.length + JobResourceUtil.getJobResource("partOpMid") + i + JobResourceUtil.getJobResource("partOpSuffex")));
                } else {
                    MsgBox.showInfo((String)JobResourceUtil.getJobResource("abortSuccess"));
                }
                this.refreshList();
            }
            catch (Exception ex) {
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bao);
                ex.printStackTrace(ps);
                String msg = bao.toString();
                MsgBox.showConfirm3a((String)JobResourceUtil.getJobResource("abortFailed"), (String)msg);
            }
        }
    }

    @Override
    public void actionSuspend_actionPerformed(ActionEvent e) throws Exception {
        String[] jobInstIds = this.getSelectedIdValues().toArray(new String[0]);
        if (jobInstIds.length > 0) {
            try {
                int i = JobUtils.getJobServiceFacade().suspend(jobInstIds);
                if (i != jobInstIds.length) {
                    MsgBox.showInfo((String)(JobResourceUtil.getJobResource("partOpSuspend") + jobInstIds.length + JobResourceUtil.getJobResource("partOpMid") + i + JobResourceUtil.getJobResource("partOpSuffex")));
                } else {
                    MsgBox.showInfo((String)JobResourceUtil.getJobResource("suspendSuccess"));
                }
                this.refreshList();
            }
            catch (Exception ex) {
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bao);
                ex.printStackTrace(ps);
                String msg = bao.toString();
                MsgBox.showConfirm3a((String)JobResourceUtil.getJobResource("suspendFailed"), (String)msg);
            }
        }
    }

    @Override
    public void actionResume_actionPerformed(ActionEvent e) throws Exception {
        String[] jobInstIds = this.getSelectedIdValues().toArray(new String[0]);
        if (jobInstIds.length > 0) {
            try {
                int i = JobUtils.getJobServiceFacade().resume(jobInstIds);
                if (i != jobInstIds.length) {
                    MsgBox.showInfo((String)(JobResourceUtil.getJobResource("partOpResume") + jobInstIds.length + JobResourceUtil.getJobResource("partOpMid") + i + JobResourceUtil.getJobResource("partOpSuffex")));
                } else {
                    MsgBox.showInfo((String)JobResourceUtil.getJobResource("resumeSuccess"));
                }
                this.refreshList();
            }
            catch (Exception ex) {
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bao);
                ex.printStackTrace(ps);
                String msg = bao.toString();
                MsgBox.showConfirm3a((String)JobResourceUtil.getJobResource("resumeFailed"), (String)msg);
            }
        }
    }

    @Override
    public void actionException_actionPerformed(ActionEvent e) throws Exception {
        String id = (String)this.getSelectedIdValues().get(0);
        String msg = JobUtils.getJobServiceFacade().getJobException(id);
        MsgBox.showConfirm3a((String)JobResourceUtil.getJobResource("exceptionTips"), (String)msg);
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        String[] jobInstIds = this.getSelectedIdValues().toArray(new String[0]);
        if (jobInstIds.length > 0) {
            if (MsgBox.showConfirm2((String)JobResourceUtil.getJobResource("confirmDelete")) != 0) {
                return;
            }
            try {
                int i = JobUtils.getJobServiceFacade().delete(jobInstIds);
                if (i != jobInstIds.length) {
                    MsgBox.showInfo((String)(JobResourceUtil.getJobResource("partOpDelete") + jobInstIds.length + JobResourceUtil.getJobResource("partOpMid") + i + JobResourceUtil.getJobResource("partOpSuffex")));
                } else {
                    MsgBox.showInfo((String)JobResourceUtil.getJobResource("deleteSuccess"));
                }
                this.refreshList();
            }
            catch (Exception ex) {
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bao);
                ex.printStackTrace(ps);
                String msg = bao.toString();
                MsgBox.showConfirm3a((String)JobResourceUtil.getJobResource("deleteFailed"), (String)msg);
            }
        }
    }

    @Override
    public void actionMove_actionPerformed(ActionEvent e) throws Exception {
        String[] jobInstIds = this.getSelectedIdValues().toArray(new String[0]);
        if (jobInstIds.length > 0) {
            if (MsgBox.showConfirm2((String)JobResourceUtil.getJobResource("confirmMove")) != 0) {
                return;
            }
            try {
                int i = JobUtils.getJobServiceFacade().moveToHistory(jobInstIds);
                if (i != jobInstIds.length) {
                    MsgBox.showInfo((String)(JobResourceUtil.getJobResource("partOpMove") + jobInstIds.length + JobResourceUtil.getJobResource("partOpMid") + i + JobResourceUtil.getJobResource("partOpSuffex")));
                } else {
                    MsgBox.showInfo((String)JobResourceUtil.getJobResource("moveSuccess"));
                }
                this.refreshList();
            }
            catch (Exception ex) {
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bao);
                ex.printStackTrace(ps);
                String msg = bao.toString();
                MsgBox.showConfirm3a((String)JobResourceUtil.getJobResource("moveFailed"), (String)msg);
            }
        }
    }

    @Override
    public void actionResult_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void setActionState() {
        super.setActionState();
        HashSet<String> s = new HashSet<String>();
        this.getSelectedIdValues();
        ArrayList list = this.getSelectList();
        if (list != null && !this.isHistoryData) {
            s.add("abort");
            s.add("move");
            s.add("restart");
            s.add("resume");
            s.add("suspend");
            s.add("exception");
            s.add("check");
            for (int i = 0; i < list.size(); ++i) {
                String str;
                HashSet<String> t = new HashSet<String>();
                int row = (Integer)list.get(i);
                Object v = this.tblMain.getRow(row).getCell("title").getValue();
                String string = str = v == null ? "" : v.toString();
                if (str.startsWith("~")) {
                    s.remove("abort");
                }
                if ((v = this.tblMain.getRow(row).getCell(this.COLUMNNAME_STATE).getValue()) instanceof BizEnumValueDTO) {
                    JobState state = JobState.find(((BizEnumValueDTO)v).getName());
                    String[] operations = state.getSupportedOperations();
                    for (int j = 0; j < operations.length; ++j) {
                        if (!s.contains(operations[j])) continue;
                        t.add(operations[j]);
                    }
                }
                s = t;
            }
        }
        this.actionAbort.setEnabled(s.contains("abort"));
        this.actionSuspend.setEnabled(s.contains("suspend"));
        this.actionResume.setEnabled(s.contains("resume"));
        this.actionRestart.setEnabled(s.contains("restart"));
        this.actionMove.setEnabled(s.contains("move"));
        this.actionException.setEnabled(s.contains("exception") && list.size() == 1);
        this.actionCheck.setEnabled(s.contains("check") && list.size() == 1);
        this.actionShowLog.setEnabled(list.size() == 1);
        this.actionView.setEnabled(list.size() == 1);
        this.btnView.setEnabled(list.size() == 1);
        this.actionResult.setVisible(false);
        this.actionDelete.setEnabled(this.isHistoryData);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"title"};
        return locateNames;
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        String[] jobInstIds = this.getSelectedIdValues().toArray(new String[0]);
        if (jobInstIds.length > 0) {
            String s = JobUtils.getJobServiceFacade().checkJob(jobInstIds[0]);
            MsgBox.showConfirm3a((String)"\u540e\u53f0\u4e8b\u52a1\u4efb\u52a1\u68c0\u6d4b\uff0c\u70b9\u51fb\u201c\u8be6\u7ec6\u4fe1\u606f\u201d\u67e5\u770b\u3002", (String)s);
        }
    }

    @Override
    public void actionThreadPool_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        String className = JobThreadPool.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
        uiWindow.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterTableFillData(KDTDataRequestEvent dre) {
        super.afterTableFillData(dre);
        int firstRow = dre.getFirstRow();
        int lastRow = dre.getLastRow();
        logger.debug((Object)("firstRow=" + firstRow + ",lastRow=" + lastRow));
        KDTable kDTable = this.tblMain;
        synchronized (kDTable) {
            if (lastRow - firstRow >= 0 && lastRow != -1) {
                Object costTime = null;
                for (int i = firstRow; i <= lastRow; ++i) {
                    costTime = this.tblMain.getRow(i).getCell("costTime").getValue();
                    if (!(costTime instanceof Integer)) continue;
                    int c = (Integer)costTime;
                    String costTimeStr = "";
                    if (c < 0) {
                        costTimeStr = costTimeStr + "-";
                        c = 0 - c;
                    }
                    if (c > 3600000) {
                        costTimeStr = costTimeStr + c / 3600000 + EASResource.getString((String)maagRes, (String)"4_QuartzParser");
                    }
                    if (c > 60000) {
                        costTimeStr = costTimeStr + c % 3600000 / 60000 + EASResource.getString((String)maagRes, (String)"5_QuartzParser");
                    }
                    costTimeStr = costTimeStr + (float)(c % 60000) / 1000.0f + EASResource.getString((String)maagRes, (String)"7_QuartzParser");
                    this.tblMain.getRow(i).getCell("costTime").setValue((Object)costTimeStr);
                }
            }
        }
    }

    @Override
    public void actionStopHelp_actionPerformed(ActionEvent e) throws Exception {
        String url = "https://vip.kingdee.com/article/479221940331353600";
        boolean b = false;
        try {
            URL url1 = new URL("https://vip.kingdee.com");
            HttpURLConnection openConnection = (HttpURLConnection)url1.openConnection();
            openConnection.setUseCaches(false);
            openConnection.setConnectTimeout(3000);
            int responseCode = openConnection.getResponseCode();
            if (200 == responseCode) {
                b = true;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (b) {
            FrameWorkUtils.openByDefaultBrowser((String)url);
        } else {
            MsgBox.showConfirm3a((String)JobResourceUtil.getJobResource("stopHelp"), (String)url);
        }
    }
}

