/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.client;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.MultiLangList;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataType;
import com.kingdee.bos.workflow.define.EventPolicyCollection;
import com.kingdee.bos.workflow.define.EventPolicyDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ExternalType;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ProcessType;
import com.kingdee.bos.workflow.define.PublicationStatus;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.eas.base.commonquery.client.DefaultPromptBoxFactory;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.job.IProcessDef;
import com.kingdee.eas.base.job.ProcessDefCollection;
import com.kingdee.eas.base.job.ProcessDefFactory;
import com.kingdee.eas.base.job.ProcessDefInfo;
import com.kingdee.eas.base.job.QuartzParser;
import com.kingdee.eas.base.job.client.AbstractJobProcessManager;
import com.kingdee.eas.base.job.client.ProcessReleaseDialog;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.base.job.client.SelectEntity;
import com.kingdee.eas.base.job.client.SelectTask;
import com.kingdee.eas.base.job.util.BusinessTreeUtil;
import com.kingdee.eas.base.job.util.Convertor;
import com.kingdee.eas.base.job.util.DataTypeUtil;
import com.kingdee.eas.base.job.util.JobProcessDef;
import com.kingdee.eas.base.job.util.JobProcessUtil;
import com.kingdee.eas.base.job.util.JobResourceUtil;
import com.kingdee.eas.base.job.util.JobUtils;
import com.kingdee.eas.base.job.util.PackageObject;
import com.kingdee.eas.base.job.util.ProcessDefObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgF7;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.IObjectBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JobProcessManager
extends AbstractJobProcessManager {
    private static final String GLOBEMUTEXSTR = "G::";
    private static final String JobResource = "com.kingdee.eas.base.job.client.JobResource";
    public static final String FAILURENOTICE = "failureNotice";
    public static final String COMPLETENOTICE = "completeNotice";
    public static final String ABORTNOTICE = "abortNotice";
    public static final String SLOWNOTICE = "slowNotice";
    public static final String OVERTIMENOTICE = "overtimeNotice";
    public static final String RUNTIMEOUT = "runTimeout";
    public static final String SENDSMS = "sendSMS";
    public static final String SENDMAIL = "sendMail";
    public static final String NOTICETIELE_L1 = "noticeTitle_L1";
    public static final String NOTICETIELE_L2 = "noticeTitle_L2";
    public static final String NOTICETIELE_L3 = "noticeTitle_L3";
    public static final String NOTICECONTENT_L1 = "noticeContent_L1";
    public static final String NOTICECONTENT_L2 = "noticeContent_L2";
    public static final String NOTICECONTENT_L3 = "noticeContent_L3";
    private static final long serialVersionUID = 1L;
    private String modifyState;
    private JobProcessDef jobProcess;
    private KDComboBox focusComboBox;
    boolean flag;
    int caretPo;
    public static final int MISFIRE_INSTRUCTION_FIRE_ONCE_NOW = 1;
    public static final int MISFIRE_INSTRUCTION_DO_NOTHING = 2;
    private static Map<String, OrgType> orgTypeMap = new HashMap<String, OrgType>();

    public JobProcessManager() throws Exception {
        this.focusComboBox = this.noticeTitleMultiLangBox;
        this.flag = false;
        this.noticeTitleMultiLangBox.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
        this.noticeContentMultiLangArea.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
        this.noticeTitleMultiLangBox.getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                JobProcessManager.this.focusComboBox = (KDComboBox)JobProcessManager.this.noticeTitleMultiLangBox;
                JobProcessManager.this.caretPo = ((JTextComponent)JobProcessManager.this.noticeTitleMultiLangBox.getEditorComponent()).getCaretPosition();
            }
        });
        this.noticeContentMultiLangArea.getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                JobProcessManager.this.focusComboBox = (KDComboBox)JobProcessManager.this.noticeContentMultiLangArea;
                JobProcessManager.this.caretPo = ((JTextComponent)JobProcessManager.this.noticeContentMultiLangArea.getEditorComponent()).getCaretPosition();
            }
        });
        this.focusComboBox = this.noticeContentMultiLangArea;
        this.kDPanel2.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(148, 145, 140)), EASResource.getString((String)JobResource, (String)"noticeBorderTitle")));
    }

    private void openProcessSchedulePlan() {
        try {
            String scheduleXML = KpdlParser.scheduleToString((ScheduleDef)this.jobProcess.getSchedule());
            scheduleXML = ProcessSchedulePlan.open((Object)this, scheduleXML);
            if (scheduleXML != null && scheduleXML.length() > 0) {
                ScheduleDef sdef = KpdlParser.parseSchedule((String)scheduleXML);
                this.jobProcess.setSchedule(sdef);
                QuartzParser quartzParser = new QuartzParser(sdef.getDefine());
                boolean useCalendar = sdef.isUseCalendar();
                boolean inWorkingDay = sdef.isInWorkingDay();
                boolean flag = sdef.getType().equals((Object)ScheduleType.ONETIME);
                StringBuilder scheduleText = new StringBuilder(quartzParser.parse());
                int index = scheduleText.indexOf(",") + 1;
                if (useCalendar) {
                    scheduleText.insert(index, inWorkingDay ? "\u5de5\u4f5c\u65e5," : "\u975e\u5de5\u4f5c\u65e5,");
                }
                if (flag) {
                    scheduleText.delete(0, index);
                }
                this.schedulekDTextField.setText(scheduleText.toString());
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void releaseProcressDef() {
        try {
            UIContext cntxt = new UIContext((Object)this);
            cntxt.put((Object)"jobprocessdef", (Object)this.jobProcess);
            String className = ProcessReleaseDialog.class.getName();
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)cntxt);
            uiWindow.show();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void convertAllJobProcess() {
        try {
            IProcessDef processDef = ProcessDefFactory.getRemoteInstance();
            ProcessDefCollection jobProcessCollection = JobProcessUtil.getPDEFC(ProcessType.BACKGROUNDJOB.getName());
            if (jobProcessCollection == null || jobProcessCollection.size() <= 0) {
                return;
            }
            int size = jobProcessCollection.size();
            for (int i = 0; i < size; ++i) {
                ProcessDefInfo jobProcess = jobProcessCollection.get(i);
                String xml = jobProcess.getProcessxml();
                xml = Convertor.convertProcess(xml);
                jobProcess.setProcessxml(xml);
                processDef.update((IObjectPK)new ObjectUuidPK(jobProcess.getProcessId()), jobProcess);
            }
        }
        catch (Exception e) {
            JobProcessManager.getLogger((String)((Object)((Object)this)).getClass().getName()).error((Object)"convertAllJobProcess()", (Throwable)e);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        RequestContext requestContext = (RequestContext)postman.getRequestContext();
        String oql = "WHERE procDefType = '" + ProcessType.BACKGROUNDJOB.getName() + "' ";
        requestContext.put("OQL", (Object)oql);
        postman.setRequestContext((Serializable)requestContext);
        return postman;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initializeUI();
        this.namdkDTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean shiftDown = e.isShiftDown();
                boolean controlDown = e.isControlDown();
                boolean isAltDown = e.isAltDown();
                int keyCode = e.getKeyCode();
                if (controlDown && shiftDown && isAltDown && 67 == keyCode) {
                    JobProcessManager.this.convertAllJobProcess();
                    MsgBox.showInfo((String)"Convert ok!!!");
                }
            }
        });
        this.dpValidateTo.setEditable(false);
        this.dpValidateForm.setEditable(false);
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        long date = cal.getTimeInMillis();
        this.dpValidateForm.setValue((Object)new Date(date));
        this.setButtonDefaultStyl(this.btnPageSetup);
        this.setButtonDefaultStyl(this.newkDWorkButton);
        this.setButtonDefaultStyl(this.modifykDWorkButton);
        this.setButtonDefaultStyl(this.savekDWorkButton);
        this.setButtonDefaultStyl(this.deletekDWorkButton);
        this.setButtonDefaultStyl(this.refreshkDWorkButton);
        Object[] jobServiceInstanceKeys = JobUtils.getJobServiceFacade().getJobServiceInstanceKeys_c();
        this.serversCombo.addItem((Object)EASResource.getString((String)JobResource, (String)"autoAssign"));
        this.serversCombo.addItems(jobServiceInstanceKeys);
        this.inParameterkDTable.getStyleAttributes();
        this.kDTreeView1.getTree().addTreePopupMenu(new TreePopupMenuListener(){

            public boolean popMenu(TreePopupMenuEvent event) {
                return true;
            }
        });
        this.updateButtons();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("Owner", (Object)this);
        ctx.put("All_Admins", "YES");
        PersonPromptBox ppBox = new PersonPromptBox(ctx);
        ppBox.showNoPositionPerson(false);
        ppBox.setEnabledMultiSelection(true);
        ppBox.setIsSingleSelect(false);
        this.prmpResponsible.setSelector((KDPromptSelector)ppBox);
        this.prmpResponsible.setEditable(false);
        this.prmpResponsible.setEnabledMultiSelection(true);
        this.chkPersistent.setVisible(false);
        this.packagekDTree.updateUI();
    }

    private void updateButtons() {
        Object lastPathComponent = null;
        if (this.kDTreeView1 != null && this.kDTreeView1.getTree() != null && this.kDTreeView1.getTree().getSelectionPath() != null) {
            lastPathComponent = this.kDTreeView1.getTree().getSelectionPath().getLastPathComponent();
        }
        if (lastPathComponent != null && lastPathComponent instanceof DefaultKingdeeTreeNode) {
            DefaultKingdeeTreeNode lastKingdeeTreeNode = (DefaultKingdeeTreeNode)lastPathComponent;
            Object userObject = lastKingdeeTreeNode.getUserObject();
            if (userObject instanceof ProcessDefObject) {
                ProcessDefObject tempPDEFO = (ProcessDefObject)userObject;
                this.viewProcessDef(tempPDEFO);
                this.releasekDWorkButton.setEnabled(true);
                this.modifykDWorkButton.setEnabled(true);
                this.savekDWorkButton.setEnabled(true);
                this.deletekDWorkButton.setEnabled(true);
                this.newkDWorkButton.setEnabled(false);
                this.actionTest.setEnabled(true);
            } else if (userObject instanceof PackageObject) {
                this.modifyState = "none";
                this.clearData();
                this.setContentEnable(false);
                this.releasekDWorkButton.setEnabled(false);
                this.modifykDWorkButton.setEnabled(false);
                this.savekDWorkButton.setEnabled(false);
                this.deletekDWorkButton.setEnabled(false);
                this.newkDWorkButton.setEnabled(true);
                this.actionTest.setEnabled(false);
            }
        }
    }

    private void openSelectTask() {
        try {
            Map uiContext = this.getUIContext();
            Object lastPathComponent = this.packagekDTree.getLastSelectedPathComponent();
            if (lastPathComponent != null && lastPathComponent instanceof DefaultKingdeeTreeNode) {
                DefaultKingdeeTreeNode lastKingdeeTreeNode = (DefaultKingdeeTreeNode)lastPathComponent;
                uiContext.put("treePath", lastKingdeeTreeNode.getPath());
            }
            SelectTask.open((Object)this, uiContext);
            Object tempObject1 = this.getUIContext().get("function");
            Object tempObject2 = this.getUIContext().get("operation");
            FunctionObjectInfo foi = null;
            OperationInfo oi = null;
            FacadeInfo tempFI = null;
            MethodInfo tempMI = null;
            if (tempObject1 != null && tempObject2 != null) {
                ParameterCollection tempParameterCollection = null;
                if (tempObject1 instanceof FunctionObjectInfo && tempObject2 instanceof OperationInfo) {
                    foi = (FunctionObjectInfo)tempObject1;
                    oi = (OperationInfo)tempObject2;
                    this.jobProcess.setTask(foi, oi);
                    this.taskkDTextField.setText(this.jobProcess.getTaskName());
                    this.mutexCtrl.setText(GLOBEMUTEXSTR + this.jobProcess.getFunctionName());
                    if (oi.getFacadeObjectRef() != null) {
                        if (oi.getFacadeMethodRef() != null) {
                            tempParameterCollection = oi.getFacadeMethodRef().getParameters();
                        } else {
                            MsgBox.showWarning((String)JobResourceUtil.getJobResource("job_warn1"));
                        }
                    } else if (oi.getEntityObjectRef() != null) {
                        if (oi.getEntityMethodRef() != null) {
                            tempParameterCollection = oi.getEntityMethodRef().getParameters();
                        } else {
                            MsgBox.showWarning((String)JobResourceUtil.getJobResource("job_warn1"));
                        }
                    }
                } else if (tempObject1 instanceof FacadeInfo && tempObject2 instanceof MethodInfo) {
                    tempFI = (FacadeInfo)tempObject1;
                    tempMI = (MethodInfo)tempObject2;
                    this.jobProcess.setTask(tempFI, tempMI);
                    this.taskkDTextField.setText(this.jobProcess.getTaskName());
                    this.mutexCtrl.setText(GLOBEMUTEXSTR + this.jobProcess.getFunctionName());
                    tempParameterCollection = tempMI.getParameters();
                } else {
                    MsgBox.showWarning((String)JobResourceUtil.getJobResource("job_warn2"));
                    return;
                }
                this.inParameterkDTable.removeRows();
                if (tempParameterCollection != null && tempParameterCollection.size() > 0) {
                    for (int i = 0; i < tempParameterCollection.size(); ++i) {
                        ParameterInfo pi = tempParameterCollection.get(i);
                        IRow row = this.inParameterkDTable.addRow();
                        row.getCell(0).setValue((Object)pi.getName());
                        row.getCell(1).setValue((Object)pi.getAlias());
                        row.getCell(2).setValue((Object)DataTypeUtil.getName(JobProcessUtil.convertTypeReferenceToDataType(pi.getDataType())));
                        row.getCell(3).setValue((Object)pi.getMetaDataRef());
                        if (!StringUtils.isEmpty((String)pi.getMetaDataRef())) {
                            String bosType;
                            EntityObjectInfo e;
                            KDTDefaultCellEditor editor;
                            if (ExternalType.ENUM.getTypeName().equalsIgnoreCase(pi.getDataType())) {
                                KDComboBox kdComboBox = new KDComboBox(EnumUtils.getEnumList((String)pi.getMetaDataRef()).toArray());
                                kdComboBox.setMaximumRowCount(10);
                                KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
                                row.getCell(4).setEditor((ICellEditor)kdtDefaultCellEditor);
                                kdComboBox.setCanSearch(true);
                                continue;
                            }
                            if (BasicType.OBJECTVALUE.getTypeName().equalsIgnoreCase(pi.getDataType())) {
                                editor = null;
                                e = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(pi.getMetaDataRef()));
                                bosType = e.getType().toString();
                                editor = orgTypeMap.containsKey(bosType) ? this.createOrgEditor(orgTypeMap.get(bosType), true) : this.createEditor(pi.getMetaDataRef());
                                if (editor == null) continue;
                                row.getCell(4).setEditor((ICellEditor)editor);
                                continue;
                            }
                            if (!ExternalType.OBJECTCOLLECTION.getTypeName().equalsIgnoreCase(pi.getDataType())) continue;
                            editor = null;
                            e = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(pi.getMetaDataRef()));
                            bosType = e.getType().toString();
                            editor = orgTypeMap.containsKey(bosType) ? this.createOrgEditor(orgTypeMap.get(bosType), true) : this.createEditor(pi.getMetaDataRef());
                            if (editor == null) continue;
                            KDBizPromptBox box = (KDBizPromptBox)editor.getComponent();
                            box.setEnabledMultiSelection(true);
                            box.setDisplayFormat("$name$");
                            box.setEditFormat("$number$");
                            ObjectValueRender box_OVR = new ObjectValueRender();
                            box_OVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
                            row.getCell(4).setRenderer((IBasicRender)box_OVR);
                            row.getCell(4).setEditor((ICellEditor)editor);
                            continue;
                        }
                        row.getCell(4).setValue((Object)"");
                    }
                }
                this.inParameterkDTable.getColumn(2).getStyleAttributes().setLocked(true);
                this.inParameterkDTable.getColumn(3).getStyleAttributes().setLocked(true);
                this.inParameterkDTable.getColumn(4).getStyleAttributes().setLocked(false);
            }
        }
        catch (Exception error) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)error);
        }
    }

    private void clearData() {
        this.jobProcess = null;
        this.namdkDTextField.setText("");
        this.createTimekDDatePicker.setValue((Object)new Date());
        this.createTimekDDatePicker.setEditable(false);
        this.failureCheckBox.setSelected(false);
        this.completeCheckBox.setSelected(false);
        this.abortCheckBox.setSelected(false);
        this.slowCheckBox.setSelected(false);
        this.overTimeCheckBox.setSelected(false);
        this.timeoutTimePicker.setVisible(false);
        this.timeoutTimePicker.setNullable(true);
        this.timeoutTimePicker.setValue(null);
        this.sendMailCheckBox.setSelected(false);
        this.sendSMSCheckBox.setSelected(false);
        List list = MultiLangList.getLanguageList();
        LanguageInfo info = null;
        for (int i = 0; i < list.size(); ++i) {
            info = (LanguageInfo)list.get(i);
            this.noticeTitleMultiLangBox.setItemData(info, null);
            this.noticeContentMultiLangArea.setItemData(info, null);
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(1, 50);
        this.dpValidateTo.setValue((Object)calendar.getTime());
        this.authorkDTextField.setText(SysContext.getSysContext().getUserName());
        this.descriptionkDTextArea.setItemData(info, null);
        this.taskkDTextField.setText("");
        this.mutexCtrl.setText("");
        this.serversCombo.setSelectedItem((Object)"\u81ea\u52a8\u5206\u914d");
        this.schedulekDTextField.setText("");
        this.jobExecutor.setValue(null);
        this.inParameterkDTable.removeRows();
        this.prmpResponsible.setValue(null);
        this.inParameterkDTable.getColumn(3).getStyleAttributes().setLocked(true);
        this.inParameterkDTable.getColumn(4).getStyleAttributes().setLocked(true);
    }

    private void newProcessDef() {
        try {
            this.clearData();
            this.jobProcess = new JobProcessDef();
            this.setContentEnable(true);
            this.savekDWorkButton.setEnabled(true);
            this.reInstructionkDRadioButton.setSelected(true);
            this.chkPersistent.setSelected(true);
            this.priorityLow.setSelected(true);
            this.modifyState = "new";
        }
        catch (Exception error) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)error);
        }
    }

    private void modifyProcessDef() {
        try {
            if ("processdef".equalsIgnoreCase(JobProcessUtil.getSelectedNodeType(this.packagekDTree))) {
                this.setContentEnable(true);
                this.savekDWorkButton.setEnabled(true);
                this.modifyState = "modify";
                this.inParameterkDTable.getColumn(2).getStyleAttributes().setLocked(true);
                this.inParameterkDTable.getColumn(3).getStyleAttributes().setLocked(true);
                this.inParameterkDTable.getColumn(4).getStyleAttributes().setLocked(false);
            }
        }
        catch (Exception error) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)error);
        }
    }

    private void deleteProcessDef() {
        try {
            if ("processdef".equalsIgnoreCase(JobProcessUtil.getSelectedNodeType(this.packagekDTree))) {
                DefaultKingdeeTreeNode skn = JobProcessUtil.getSelectedNode(this.packagekDTree);
                Object obj0 = skn.getUserObject();
                ProcessDefObject pso = (ProcessDefObject)obj0;
                String processId = pso.getInnerPDEFI().getProcessId();
                boolean isReleased = JobUtils.getJobServiceFacade().isReleased(processId);
                int confirm = isReleased ? MsgBox.showConfirm2((Component)((Object)this), (String)JobResourceUtil.getJobResource("deleteQuery2")) : MsgBox.showConfirm2((Component)((Object)this), (String)JobResourceUtil.getJobResource("deleteQuery"));
                if (confirm == 0) {
                    this.clearData();
                    this.setEnabled(false);
                    IProcessDef ps = ProcessDefFactory.getRemoteInstance();
                    ps.delete((IObjectPK)new ObjectUuidPK(pso.getInnerPDEFI().getProcessId()));
                    ((KingdeeTreeModel)this.packagekDTree.getModel()).removeNodeFromParent((MutableTreeNode)skn);
                    if (isReleased) {
                        MsgBox.showInfo((Component)((Object)this), (String)JobResourceUtil.getJobResource("tipsDelete"));
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)error);
        }
    }

    private boolean checkSaveCondition() {
        String jobName = this.namdkDTextField.getText();
        if (jobName == null || jobName.length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)JobResourceUtil.getJobResource("nameIsNull"));
            return false;
        }
        String task = this.taskkDTextField.getText();
        if (task == null || task.length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)JobResourceUtil.getJobResource("taskIsNull"));
            return false;
        }
        String schedule = this.schedulekDTextField.getText();
        if (schedule == null || schedule.length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)JobResourceUtil.getJobResource("scheduleIsNull"));
            return false;
        }
        Date validFrom = (Date)this.dpValidateForm.getValue(Date.class);
        Date validTo = (Date)this.dpValidateTo.getValue(Date.class);
        if (validFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)JobResourceUtil.getJobResource("validFromIsNull"));
            return false;
        }
        if (validTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)JobResourceUtil.getJobResource("validToIsNull"));
            return false;
        }
        if (DateTimeUtils.dayBefore((Date)validTo, (Date)validFrom)) {
            MsgBox.showInfo((Component)((Object)this), (String)JobResourceUtil.getJobResource("validateToIsSmallerThanValidateFrom"));
            return false;
        }
        if (DateTimeUtils.dayBefore((Date)validTo, (Date)new Date())) {
            MsgBox.showInfo((Component)((Object)this), (String)JobResourceUtil.getJobResource("validateToIsSmallerThanCurrentdate"));
            return false;
        }
        return true;
    }

    private void saveProcessDef() {
        try {
            IProcessDef processDef = ProcessDefFactory.getRemoteInstance();
            DefaultKingdeeTreeNode selectedNode = JobProcessUtil.getSelectedNode(this.packagekDTree);
            if (selectedNode == null) {
                selectedNode = (DefaultKingdeeTreeNode)this.packagekDTree.getModel().getRoot();
            }
            Object object = selectedNode.getUserObject();
            if (!this.checkSaveCondition()) {
                return;
            }
            if (selectedNode == null || selectedNode.isRoot()) {
                MsgBox.showInfo((Component)((Object)this), (String)JobResourceUtil.getJobResource("selectedNodeError"));
                return;
            }
            if (this.hasSameNameNode(selectedNode, this.namdkDTextField.getText())) {
                MsgBox.showInfo((Component)((Object)this), (String)JobResourceUtil.getJobResource("savefail"));
                return;
            }
            this.saveNoticeExtendAttribute();
            this.saveMutexAndServerProperty();
            this.saveJobExecutor();
            if ("new".equalsIgnoreCase(this.modifyState)) {
                DefaultKingdeeTreeNode parentKingdeeTreeNode = object instanceof PackageObject ? selectedNode : (object instanceof ProcessDefObject ? (DefaultKingdeeTreeNode)selectedNode.getParent() : (DefaultKingdeeTreeNode)this.packagekDTree.getModel().getRoot());
                this.setJobProcessProperty(this.jobProcess, parentKingdeeTreeNode);
                ProcessDefInfo pdefi = new ProcessDefInfo();
                this.setPDEFOP_New(pdefi);
                this.jobProcess.setProcessValidateFromDate((Date)this.dpValidateForm.getValue());
                this.jobProcess.setProcessValidateToDate((Date)this.dpValidateTo.getValue(Date.class));
                processDef.addnew(pdefi);
                int newIndex = parentKingdeeTreeNode.getChildCount();
                ProcessDefObject pdefobj = new ProcessDefObject(pdefi);
                DefaultKingdeeTreeNode node = this.createNewNode(pdefobj);
                ((KingdeeTreeModel)this.packagekDTree.getModel()).insertNodeInto((MutableTreeNode)node, (MutableTreeNode)parentKingdeeTreeNode, newIndex);
                this.packagekDTree.setSelectionPath(new TreePath(node.getPath()));
                this.modifyState = "modify";
            } else if ("modify".equalsIgnoreCase(this.modifyState) && object instanceof ProcessDefObject) {
                this.setJobProcessProperty(this.jobProcess, null);
                ProcessDefObject prcso = this.getPDEFOFromNode(selectedNode);
                ProcessDefInfo prcsi = prcso.getInnerPDEFI();
                this.setPDEFOP_Modify(prcsi);
                processDef.update((IObjectPK)new ObjectUuidPK(prcsi.getProcessId()), prcsi);
                selectedNode.setText(this.namdkDTextField.getText());
                prcso.setInnerPDEFI(prcsi);
            }
            this.setContentEnable(false);
            this.savekDWorkButton.setEnabled(false);
            this.noticeTitleMultiLangBox.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
            this.noticeContentMultiLangArea.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
            MsgBox.showInfo((Component)((Object)this), (String)JobResourceUtil.getJobResource("saveSuccess"));
            this.inParameterkDTable.getColumn(3).getStyleAttributes().setLocked(true);
            this.inParameterkDTable.getColumn(4).getStyleAttributes().setLocked(true);
        }
        catch (Exception error) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)error);
        }
    }

    private void saveJobExecutor() {
        Object jobExecutor = this.jobExecutor.getValue();
        if (jobExecutor instanceof UserInfo) {
            String jobExecutorId = ((UserInfo)jobExecutor).getId().toString();
            if (StringUtils.isEmpty((String)jobExecutorId)) {
                return;
            }
            ProcessDef relatedProcess = this.jobProcess.getRelatedProcess();
            if (relatedProcess != null) {
                ExtendedAttributeCollection extendedAttributes = relatedProcess.getExtendedAttributes();
                ExtendedAttributeDef extendedAttributeDef = new ExtendedAttributeDef();
                extendedAttributeDef.setName("jobExecutorId");
                extendedAttributeDef.setValue(jobExecutorId);
                extendedAttributes.setObject("jobExecutorId", (Object)extendedAttributeDef);
            }
        } else {
            ProcessDef relatedProcess = this.jobProcess.getRelatedProcess();
            if (relatedProcess != null) {
                ExtendedAttributeCollection extendedAttributes = relatedProcess.getExtendedAttributes();
                ExtendedAttributeDef extendedAttributeDef = new ExtendedAttributeDef();
                extendedAttributeDef.setName("jobExecutorId");
                extendedAttributeDef.setValue(null);
                extendedAttributes.setObject("jobExecutorId", (Object)extendedAttributeDef);
            }
        }
    }

    private void saveMutexAndServerProperty() {
        ProcessDef relatedProcess = this.jobProcess.getRelatedProcess();
        if (relatedProcess != null) {
            ExtendedAttributeCollection extendedAttributes = relatedProcess.getExtendedAttributes();
            String mutexCtrl = this.mutexCtrl.getText();
            if (StringUtils.isEmpty((String)mutexCtrl)) {
                extendedAttributes.remove("mutexCtrl");
                ExtendedAttributeDef extendedAttributeDef1 = new ExtendedAttributeDef();
                extendedAttributeDef1.setName("nonMutexCtrl");
                extendedAttributeDef1.setValue("true");
                extendedAttributes.setObject("nonMutexCtrl", (Object)extendedAttributeDef1);
            } else {
                extendedAttributes.remove("nonMutexCtrl");
                if (!mutexCtrl.startsWith(GLOBEMUTEXSTR)) {
                    mutexCtrl = GLOBEMUTEXSTR + mutexCtrl;
                }
                ExtendedAttributeDef extendedAttributeDef = new ExtendedAttributeDef();
                extendedAttributeDef.setName("mutexCtrl");
                extendedAttributeDef.setValue(mutexCtrl);
                extendedAttributes.setObject("mutexCtrl", (Object)extendedAttributeDef);
            }
            String selectedServer = String.valueOf(this.serversCombo.getSelectedItem());
            ExtendedAttributeDef extendedAttributeDef1 = new ExtendedAttributeDef();
            extendedAttributeDef1.setName("selectedServer");
            if (!StringUtils.isEmpty((String)selectedServer) && !"\u81ea\u52a8\u5206\u914d".equals(selectedServer)) {
                extendedAttributeDef1.setValue(selectedServer);
            } else {
                extendedAttributeDef1.setValue(null);
            }
            extendedAttributes.setObject("selectedServer", (Object)extendedAttributeDef1);
        }
    }

    private DefaultKingdeeTreeNode createNewNode(ProcessDefObject pdefobj) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)pdefobj);
        node.setCustomIcon(EASResource.getIcon((String)"imgTree_bgaffairdefine"));
        node.setAllowsChildren(false);
        return node;
    }

    private boolean hasSameNameNode(DefaultKingdeeTreeNode selectedNode, String name) {
        try {
            DefaultKingdeeTreeNode selectedNodeParent = (DefaultKingdeeTreeNode)selectedNode.getParent();
            if (selectedNodeParent == null) {
                return false;
            }
            int index = selectedNodeParent.getIndex((TreeNode)selectedNode);
            int count = selectedNodeParent.getChildCount();
            for (int i = 0; i < count; ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)selectedNodeParent.getChildAt(i);
                Object obj = node.getUserObject();
                if (i == index || !(obj instanceof ProcessDefObject) || !((ProcessDefObject)obj).toString().equals(name)) continue;
                return true;
            }
            int childCount = selectedNode.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)selectedNode.getChildAt(i);
                Object childObj = childNode.getUserObject();
                if (!(childObj instanceof ProcessDefObject) || !((ProcessDefObject)childObj).toString().equals(name)) continue;
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    private Map getParameterValue(KDTable destTable) {
        HashMap<Object, Object> hm = new HashMap<Object, Object>();
        int rowCount = destTable.getRowCount();
        FormalParameterCollection fpc = this.jobProcess.getFormalParameters();
        if (destTable != null && rowCount >= 1) {
            for (int i = 0; i < rowCount; ++i) {
                IRow tempRow = destTable.getRow(i);
                Object value = tempRow.getCell(4).getValue();
                if (value instanceof CoreBaseInfo) {
                    value = ((CoreBaseInfo)value).getId().toString();
                } else if (value instanceof Enum) {
                    value = ((Enum)value).getName();
                } else if (value instanceof Object[]) {
                    Object[] objs = (Object[])value;
                    StringBuffer valueStr = new StringBuffer();
                    int k = objs.length;
                    for (int j = 0; j < k; ++j) {
                        if (!(objs[j] instanceof CoreBaseInfo)) continue;
                        valueStr.append(((CoreBaseInfo)objs[j]).getId().toString()).append(",");
                    }
                    value = valueStr.substring(0, valueStr.lastIndexOf(","));
                }
                hm.put(tempRow.getCell(0).getValue(), value);
                FormalParameterDef fp = fpc.get(i);
                fp.setEntityType((String)tempRow.getCell(3).getValue());
            }
        }
        return hm;
    }

    private ProcessDefObject getPDEFOFromNode(DefaultKingdeeTreeNode destNode) {
        Object tempObject = destNode.getUserObject();
        if (tempObject != null && tempObject instanceof ProcessDefObject) {
            return (ProcessDefObject)tempObject;
        }
        return null;
    }

    private String getPackageFromNode(DefaultKingdeeTreeNode destNode) {
        Object tempObject = destNode.getUserObject();
        if (tempObject != null) {
            if (tempObject instanceof PackageObject) {
                PackageObject tempPO = (PackageObject)tempObject;
                return tempPO.getAbsoluteName();
            }
            if (tempObject instanceof ProcessDefObject) {
                return this.getPackageFromNode((DefaultKingdeeTreeNode)destNode.getParent());
            }
        }
        return "";
    }

    private void setJobProcessProperty(JobProcessDef value, DefaultKingdeeTreeNode parentTreeNode) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object obj;
            this.jobProcess.setName(this.namdkDTextField.getText());
            this.jobProcess.setCreated((Date)this.createTimekDDatePicker.getValue());
            this.jobProcess.setDescription("" + ((MultiLangItem)this.descriptionkDTextArea.getSelectedItem()).getData());
            this.jobProcess.setParameterValue(this.getParameterValue(this.inParameterkDTable));
            this.jobProcess.setAuthor(this.authorkDTextField.getText());
            this.jobProcess.setProcessValidateFromDate((Date)this.dpValidateForm.getValue());
            this.jobProcess.setProcessValidateToDate((Date)this.dpValidateTo.getValue(Date.class));
            this.jobProcess.setInstructionType(this.getRadioGroupValue());
            if (parentTreeNode != null && (obj = parentTreeNode.getUserObject()) != null && obj instanceof PackageObject) {
                PackageObject packageObject = (PackageObject)obj;
                this.jobProcess.setPackage(packageObject.getAbsoluteName());
                this.jobProcess.setBizPackage(packageObject.getName());
            }
        }
        catch (Exception error) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)error);
        }
    }

    private void saveNoticeExtendAttribute() {
        ExtendedAttributeCollection eac = this.jobProcess.getRelatedProcess().getExtendedAttributes();
        ExtendedAttributeDef def = null;
        Object pvalue = this.prmpResponsible.getValue();
        if (eac.get(FAILURENOTICE) == null) {
            def = new ExtendedAttributeDef();
            def.setName(FAILURENOTICE);
            if (pvalue != null && pvalue instanceof Object[] && ((Object[])pvalue).length > 0) {
                def.setValue(String.valueOf(true));
            } else {
                def.setValue(String.valueOf(this.failureCheckBox.isSelected()));
            }
            eac.add(FAILURENOTICE, def);
        } else if (pvalue != null && pvalue instanceof Object[] && ((Object[])pvalue).length > 0) {
            eac.get(FAILURENOTICE).setValue(String.valueOf(true));
        } else {
            eac.get(FAILURENOTICE).setValue(String.valueOf(this.failureCheckBox.isSelected()));
        }
        if (eac.get(COMPLETENOTICE) == null) {
            def = new ExtendedAttributeDef();
            def.setName(COMPLETENOTICE);
            def.setValue(String.valueOf(this.completeCheckBox.isSelected()));
            eac.add(COMPLETENOTICE, def);
        } else {
            eac.get(COMPLETENOTICE).setValue(String.valueOf(this.completeCheckBox.isSelected()));
        }
        if (eac.get(ABORTNOTICE) == null) {
            def = new ExtendedAttributeDef();
            def.setName(ABORTNOTICE);
            def.setValue(String.valueOf(this.abortCheckBox.isSelected()));
            eac.add(ABORTNOTICE, def);
        } else {
            eac.get(ABORTNOTICE).setValue(String.valueOf(this.abortCheckBox.isSelected()));
        }
        if (eac.get(SLOWNOTICE) == null) {
            def = new ExtendedAttributeDef();
            def.setName(SLOWNOTICE);
            def.setValue(String.valueOf(this.slowCheckBox.isSelected()));
            eac.add(SLOWNOTICE, def);
        } else {
            eac.get(SLOWNOTICE).setValue(String.valueOf(this.slowCheckBox.isSelected()));
        }
        if (eac.get(OVERTIMENOTICE) == null) {
            def = new ExtendedAttributeDef();
            def.setName(OVERTIMENOTICE);
            def.setValue(String.valueOf(this.overTimeCheckBox.isSelected()));
            eac.add(OVERTIMENOTICE, def);
        } else {
            eac.get(OVERTIMENOTICE).setValue(String.valueOf(this.overTimeCheckBox.isSelected()));
        }
        if (this.overTimeCheckBox.isSelected()) {
            Date dateTime;
            if (eac.get(RUNTIMEOUT) == null) {
                def = new ExtendedAttributeDef();
                def.setName(RUNTIMEOUT);
                dateTime = (Date)this.timeoutTimePicker.getValue();
                def.setValue(String.valueOf(dateTime.getHours() * 3600 + dateTime.getMinutes() * 60 + dateTime.getSeconds()));
                eac.add(RUNTIMEOUT, def);
            } else {
                dateTime = (Date)this.timeoutTimePicker.getValue();
                eac.get(RUNTIMEOUT).setValue(String.valueOf(dateTime.getHours() * 3600 + dateTime.getMinutes() * 60 + dateTime.getSeconds()));
            }
        }
        if (eac.get(SENDSMS) == null) {
            def = new ExtendedAttributeDef();
            def.setName(SENDSMS);
            def.setValue(String.valueOf(this.sendSMSCheckBox.isSelected()));
            eac.add(SENDSMS, def);
        } else {
            eac.get(SENDSMS).setValue(String.valueOf(this.sendSMSCheckBox.isSelected()));
        }
        if (eac.get(SENDMAIL) == null) {
            def = new ExtendedAttributeDef();
            def.setName(SENDMAIL);
            def.setValue(String.valueOf(this.sendMailCheckBox.isSelected()));
            eac.add(SENDMAIL, def);
        } else {
            eac.get(SENDMAIL).setValue(String.valueOf(this.sendMailCheckBox.isSelected()));
        }
        List list = MultiLangList.getLanguageList();
        LanguageInfo info = null;
        for (int i = 0; i < list.size(); ++i) {
            info = (LanguageInfo)list.get(i);
            if (info.getLocale().equals(new Locale("l1"))) {
                if (eac.get(NOTICETIELE_L1) == null) {
                    def = new ExtendedAttributeDef();
                    def.setName(NOTICETIELE_L1);
                    def.setValue(this.noticeTitleMultiLangBox.getItemDataByLang(info).toString());
                    eac.add(NOTICETIELE_L1, def);
                } else {
                    eac.get(NOTICETIELE_L1).setValue(this.noticeTitleMultiLangBox.getItemDataByLang(info).toString());
                }
                if (eac.get(NOTICECONTENT_L1) == null) {
                    def = new ExtendedAttributeDef();
                    def.setName(NOTICECONTENT_L1);
                    def.setValue(this.noticeContentMultiLangArea.getItemDataByLang(info).toString());
                    eac.add(NOTICECONTENT_L1, def);
                } else {
                    eac.get(NOTICECONTENT_L1).setValue(this.noticeContentMultiLangArea.getItemDataByLang(info).toString());
                }
            }
            if (info.getLocale().equals(new Locale("l2"))) {
                if (eac.get(NOTICETIELE_L2) == null) {
                    def = new ExtendedAttributeDef();
                    def.setName(NOTICETIELE_L2);
                    def.setValue(this.noticeTitleMultiLangBox.getItemDataByLang(info).toString());
                    eac.add(NOTICETIELE_L2, def);
                } else {
                    eac.get(NOTICETIELE_L2).setValue(this.noticeTitleMultiLangBox.getItemDataByLang(info).toString());
                }
                if (eac.get(NOTICECONTENT_L2) == null) {
                    def = new ExtendedAttributeDef();
                    def.setName(NOTICECONTENT_L2);
                    def.setValue(this.noticeContentMultiLangArea.getItemDataByLang(info).toString());
                    eac.add(NOTICECONTENT_L2, def);
                } else {
                    eac.get(NOTICECONTENT_L2).setValue(this.noticeContentMultiLangArea.getItemDataByLang(info).toString());
                }
            }
            if (!info.getLocale().equals(new Locale("l3"))) continue;
            if (eac.get(NOTICETIELE_L3) == null) {
                def = new ExtendedAttributeDef();
                def.setName(NOTICETIELE_L3);
                def.setValue(this.noticeTitleMultiLangBox.getItemDataByLang(info).toString());
                eac.add(NOTICETIELE_L3, def);
            } else {
                eac.get(NOTICETIELE_L3).setValue(this.noticeTitleMultiLangBox.getItemDataByLang(info).toString());
            }
            if (eac.get(NOTICECONTENT_L3) == null) {
                def = new ExtendedAttributeDef();
                def.setName(NOTICECONTENT_L3);
                def.setValue(this.noticeContentMultiLangArea.getItemDataByLang(info).toString());
                eac.add(NOTICECONTENT_L3, def);
                continue;
            }
            eac.get(NOTICECONTENT_L3).setValue(this.noticeContentMultiLangArea.getItemDataByLang(info).toString());
        }
    }

    private void setPDEFOP_New(ProcessDefInfo value) {
        try {
            this.setResponsibles();
            value.setProcessId(this.jobProcess.getID());
            value.setCode("zh");
            value.setName(this.namdkDTextField.getText());
            value.setCreatetime((Date)this.createTimekDDatePicker.getValue());
            value.setDescription("" + ((MultiLangItem)this.descriptionkDTextArea.getSelectedItem()).getData());
            value.setProcessxml(this.jobProcess.toXml());
            value.setPublishStatus(PublicationStatus.RELEASED.getValue());
            value.setAuthorId(SysContext.getSysContext().getUserName());
            value.setVersion("V5.4");
            value.setValidFrom((Date)this.dpValidateForm.getValue());
            value.setValidTo((Date)this.dpValidateTo.getValue(Date.class));
            value.setSystemVersion("5.4");
            value.setPackageName(this.getPackageFromNode(JobProcessUtil.getSelectedNode(this.packagekDTree)));
            value.setFileName(this.jobProcess.getName() + ".kdwf");
            value.setProcDefType(ProcessType.BACKGROUNDJOB.getName());
            value.setUserId(SysContext.getSysContext().getUserName());
            value.setInstructionType(this.getRadioGroupValue());
        }
        catch (Exception error) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)error);
        }
    }

    private int getRadioGroupValue() {
        if (this.reInstructionkDRadioButton.isSelected()) {
            return 1;
        }
        if (this.noopInstructionkDRadioButton.isSelected()) {
            return 2;
        }
        return 1;
    }

    private void setRadioGroupValue(int radioValue) {
        switch (radioValue) {
            case 1: {
                this.reInstructionkDRadioButton.setSelected(true);
                break;
            }
            case 0: {
                this.noopInstructionkDRadioButton.setSelected(true);
                break;
            }
            default: {
                this.noopInstructionkDRadioButton.setSelected(true);
            }
        }
    }

    private void setPDEFOP_Modify(ProcessDefInfo value) {
        try {
            this.setResponsibles();
            value.setName(this.namdkDTextField.getText());
            value.setCreatetime((Date)this.createTimekDDatePicker.getValue());
            value.setDescription("" + ((MultiLangItem)this.descriptionkDTextArea.getSelectedItem()).getData());
            value.setProcessxml(this.jobProcess.toXml());
            value.setProcDefType(ProcessType.BACKGROUNDJOB.getName());
            value.setValidTo((Date)this.dpValidateTo.getValue(Date.class));
            value.setValidFrom((Date)this.dpValidateForm.getValue());
            value.setInstructionType(this.getRadioGroupValue());
        }
        catch (Exception error) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)error);
        }
    }

    public void initNotice(ProcessDef pdef) {
        ExtendedAttributeCollection eac = pdef.getExtendedAttributes();
        if (eac != null && eac.size() > 0) {
            ExtendedAttributeDef def = null;
            def = eac.get(FAILURENOTICE);
            if (def != null && Boolean.valueOf(def.getValue()).booleanValue()) {
                this.failureCheckBox.setSelected(true);
            }
            if ((def = eac.get(COMPLETENOTICE)) != null && Boolean.valueOf(def.getValue()).booleanValue()) {
                this.completeCheckBox.setSelected(true);
            }
            if ((def = eac.get(ABORTNOTICE)) != null && Boolean.valueOf(def.getValue()).booleanValue()) {
                this.abortCheckBox.setSelected(true);
            }
            if ((def = eac.get(SLOWNOTICE)) != null && Boolean.valueOf(def.getValue()).booleanValue()) {
                this.slowCheckBox.setSelected(true);
            }
            if ((def = eac.get(OVERTIMENOTICE)) != null && Boolean.valueOf(def.getValue()).booleanValue()) {
                GregorianCalendar gc;
                this.overTimeCheckBox.setSelected(true);
                this.timeoutTimePicker.setVisible(true);
                def = eac.get(RUNTIMEOUT);
                if (def != null && !StringUtils.isEmpty((String)def.getValue())) {
                    gc = new GregorianCalendar();
                    gc.set(13, Integer.valueOf(def.getValue()) % 60);
                    gc.set(12, Integer.valueOf(def.getValue()) / 60 % 60);
                    gc.set(11, Integer.valueOf(def.getValue()) / 3600);
                    this.timeoutTimePicker.setValue((Object)gc.getTime());
                } else {
                    gc = new GregorianCalendar();
                    gc.set(13, 0);
                    gc.set(12, 10);
                    gc.set(11, 0);
                    this.timeoutTimePicker.setValue((Object)gc.getTime());
                }
            }
            if ((def = eac.get(SENDMAIL)) != null && Boolean.valueOf(def.getValue()).booleanValue()) {
                this.sendMailCheckBox.setSelected(true);
            }
            if ((def = eac.get(SENDSMS)) != null && Boolean.valueOf(def.getValue()).booleanValue()) {
                this.sendSMSCheckBox.setSelected(true);
            }
            List list = MultiLangList.getLanguageList();
            LanguageInfo info = null;
            for (int i = 0; i < list.size(); ++i) {
                info = (LanguageInfo)list.get(i);
                if (info.getLocale().equals(new Locale("L1"))) {
                    def = eac.get(NOTICETIELE_L1);
                    if (def != null && !StringUtils.isEmpty((String)def.getValue())) {
                        this.noticeTitleMultiLangBox.setItemData(info, (Object)def.getValue());
                    }
                    if ((def = eac.get(NOTICECONTENT_L1)) == null || StringUtils.isEmpty((String)def.getValue())) continue;
                    this.noticeContentMultiLangArea.setItemData(info, (Object)def.getValue());
                    continue;
                }
                if (info.getLocale().equals(new Locale("L2"))) {
                    def = eac.get(NOTICETIELE_L2);
                    if (def != null && !StringUtils.isEmpty((String)def.getValue())) {
                        this.noticeTitleMultiLangBox.setItemData(info, (Object)def.getValue());
                    }
                    if ((def = eac.get(NOTICECONTENT_L2)) == null || StringUtils.isEmpty((String)def.getValue())) continue;
                    this.noticeContentMultiLangArea.setItemData(info, (Object)def.getValue());
                    this.flag = true;
                    continue;
                }
                if (!info.getLocale().equals(new Locale("L3"))) continue;
                def = eac.get(NOTICETIELE_L3);
                if (def != null && !StringUtils.isEmpty((String)def.getValue())) {
                    this.noticeTitleMultiLangBox.setItemData(info, (Object)def.getValue());
                }
                if ((def = eac.get(NOTICECONTENT_L3)) == null || StringUtils.isEmpty((String)def.getValue())) continue;
                this.noticeContentMultiLangArea.setItemData(info, (Object)def.getValue());
            }
        }
    }

    private void viewProcessDef(ProcessDefObject destpDEF) {
        try {
            ExtendedAttributeCollection eac;
            ExtendedAttributeDef def;
            IProcessDef pdef;
            this.clearData();
            this.noticeTitleMultiLangBox.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
            this.noticeContentMultiLangArea.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
            ProcessDefInfo pi = destpDEF.getInnerPDEFI();
            String procXML = pi.getProcessxml();
            if (procXML == null) {
                pdef = ProcessDefFactory.getRemoteInstance();
                StringBuffer buffer = new StringBuffer();
                buffer.append("where ");
                buffer.append(" (processId='" + pi.getProcessId() + "')");
                String oql = buffer.toString();
                ProcessDefCollection pc = pdef.getCollection(oql);
                pi = pc.get(0);
                destpDEF.setInnerPDEFI(pi);
                procXML = pi.getProcessxml();
            }
            pdef = KpdlParser.parseKpdl((String)procXML);
            this.initNotice((ProcessDef)pdef);
            pdef.setLocale(JobProcessUtil.getCurrentLocale());
            this.jobProcess = new JobProcessDef((ProcessDef)pdef);
            this.namdkDTextField.setText(pi.getName());
            this.createTimekDDatePicker.setValue((Object)pi.getCreatetime());
            this.dpValidateTo.setValue((Object)pi.getValidTo());
            this.dpValidateForm.setValue((Object)pi.getValidFrom());
            this.descriptionkDTextArea.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
            this.descriptionkDTextArea.setItemData(new LanguageInfo(this.getCurrentLocale()), (Object)pi.getDescription());
            this.taskkDTextField.setText(this.jobProcess.getTaskName());
            ExtendedAttributeCollection extendedAttributes = this.jobProcess.getRelatedProcess().getExtendedAttributes();
            if (extendedAttributes.get("mutexCtrl") != null) {
                this.mutexCtrl.setText(extendedAttributes.get("mutexCtrl").getValue());
            } else if (extendedAttributes.get("nonMutexCtrl") == null || !"true".equals(extendedAttributes.get("nonMutexCtrl").getValue())) {
                this.mutexCtrl.setText(GLOBEMUTEXSTR + this.jobProcess.getFunctionName());
            } else {
                this.mutexCtrl.setText(null);
            }
            if (extendedAttributes.get("selectedServer") != null) {
                this.serversCombo.setSelectedItem((Object)extendedAttributes.get("selectedServer").getValue());
            } else {
                this.serversCombo.setSelectedItem((Object)"\u81ea\u52a8\u5206\u914d");
            }
            if (extendedAttributes.get("jobExecutorId") != null) {
                try {
                    CoreBaseInfo info = this.getObjectValue("com.kingdee.eas.base.permission.app.User", extendedAttributes.get("jobExecutorId").getValue());
                    this.jobExecutor.setValue((Object)info);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            } else {
                this.jobExecutor.setValue(null);
            }
            QuartzParser quartzParser = new QuartzParser(this.jobProcess.getScheduleExpression());
            boolean useCalendar = this.jobProcess.getSchedule().isUseCalendar();
            boolean inWorkingDay = this.jobProcess.getSchedule().isInWorkingDay();
            boolean flag = this.jobProcess.getSchedule().getType().equals((Object)ScheduleType.ONETIME);
            StringBuilder scheduleText = new StringBuilder(quartzParser.parse());
            int index = scheduleText.indexOf(",") + 1;
            if (useCalendar) {
                scheduleText.insert(index, inWorkingDay ? "\u5de5\u4f5c\u65e5," : "\u975e\u5de5\u4f5c\u65e5,");
            }
            if (flag) {
                scheduleText.delete(0, index);
            }
            this.schedulekDTextField.setText(scheduleText.toString());
            this.authorkDTextField.setText(pi.getAuthorId());
            this.setRadioGroupValue(pi.getInstructionType());
            this.prmpResponsible.setValue((Object)JobProcessUtil.getResponsibles((ProcessDef)pdef));
            FormalParameterCollection fpc = this.jobProcess.getFormalParameters();
            int count = fpc.size();
            if (fpc != null && count > 0) {
                for (int i = 0; i <= count - 1; ++i) {
                    String dataFieldValue;
                    FormalParameterDef fp = fpc.get(i);
                    IRow row = this.inParameterkDTable.addRow();
                    row.getCell(0).setValue((Object)fp.getName());
                    row.getCell(1).setValue((Object)fp.getDescriptionResource().getValue(JobProcessUtil.getCurrentLocale()));
                    row.getCell(2).setValue((Object)DataTypeUtil.getName(fp.getDataType()));
                    row.getCell(3).setValue((Object)fp.getEntityType());
                    if (!StringUtils.isEmpty((String)fp.getEntityType())) {
                        String bosType;
                        EntityObjectInfo e;
                        KDTDefaultCellEditor editor;
                        if (ExternalType.ENUM.getTypeName().equalsIgnoreCase(fp.getDataType().toString())) {
                            KDComboBox kdComboBox = new KDComboBox(EnumUtils.getEnumList((String)fp.getEntityType()).toArray());
                            kdComboBox.setMaximumRowCount(10);
                            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
                            row.getCell(4).setEditor((ICellEditor)kdtDefaultCellEditor);
                            kdComboBox.setCanSearch(true);
                        } else if (BasicType.OBJECTVALUE.getTypeName().equalsIgnoreCase(fp.getDataType().toString())) {
                            editor = null;
                            e = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(fp.getEntityType()));
                            bosType = e.getType().toString();
                            editor = orgTypeMap.containsKey(bosType) ? this.createOrgEditor(orgTypeMap.get(bosType), true) : this.createEditor(fp.getEntityType());
                            if (editor != null) {
                                row.getCell(4).setEditor((ICellEditor)editor);
                            }
                        } else if (ExternalType.OBJECTCOLLECTION.getTypeName().equalsIgnoreCase(fp.getDataType().toString())) {
                            editor = null;
                            e = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(fp.getEntityType()));
                            bosType = e.getType().toString();
                            editor = orgTypeMap.containsKey(bosType) ? this.createOrgEditor(orgTypeMap.get(bosType), true) : this.createEditor(fp.getEntityType());
                            if (editor != null) {
                                KDBizPromptBox box = (KDBizPromptBox)editor.getComponent();
                                box.setEnabledMultiSelection(true);
                                box.setDisplayFormat("$name$");
                                box.setEditFormat("$number$");
                                ObjectValueRender box_OVR = new ObjectValueRender();
                                box_OVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
                                row.getCell(4).setEditor((ICellEditor)editor);
                                row.getCell(4).setRenderer((IBasicRender)box_OVR);
                            }
                        }
                    }
                    if (StringUtils.isEmpty((String)(dataFieldValue = this.jobProcess.getDataFieldValue(fp.getName())))) continue;
                    if (ExternalType.ENUM.getTypeName().equalsIgnoreCase(fp.getDataType().toString())) {
                        Enum value = EnumUtils.getEnum(Class.forName(fp.getEntityType()), (String)dataFieldValue);
                        row.getCell(4).setValue((Object)value);
                        continue;
                    }
                    if (BasicType.OBJECTVALUE.getTypeName().equalsIgnoreCase(fp.getDataType().toString())) {
                        try {
                            CoreBaseInfo info = this.getObjectValue(fp.getEntityType(), dataFieldValue);
                            row.getCell(4).setValue((Object)info);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (ExternalType.OBJECTCOLLECTION.getTypeName().equalsIgnoreCase(fp.getDataType().toString())) {
                        try {
                            CoreBaseCollection collection = this.getObjectCollection(fp.getEntityType(), dataFieldValue);
                            Object[] results = null;
                            if (collection != null && collection.size() > 0) {
                                results = new Object[collection.size()];
                                int k = collection.size();
                                for (int j = 0; j < k; ++j) {
                                    results[j] = collection.get(j);
                                }
                            }
                            row.getCell(4).setValue(results);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    row.getCell(4).setValue((Object)dataFieldValue);
                }
            }
            if ((def = (eac = this.jobProcess.getJobActivity().getActivityHeader().getExtendedAttributes()).get("isPersistent")) != null) {
                this.chkPersistent.setSelected("true".equals(def.getValue()));
            } else {
                this.chkPersistent.setSelected(true);
            }
            def = eac.get("priority");
            if (def == null) {
                this.priorityLow.setSelected(true);
            } else {
                int i = Integer.parseInt(def.getValue());
                if (i < 0) {
                    this.priorityMajor.setSelected(true);
                } else if (i < 400) {
                    this.priorityHigh.setSelected(true);
                } else if (i > 600) {
                    this.priorityLow.setSelected(true);
                } else {
                    this.priorityNormal.setSelected(true);
                }
            }
            this.setContentEnable(false);
            this.modifyState = "view";
        }
        catch (Exception error) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)error);
        }
    }

    private CoreBaseCollection getObjectCollection(String entityMetaName, String ids) throws Throwable {
        EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(entityMetaName));
        IObjectBase iObjectBase = (IObjectBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)entity.getType(), IObjectBase.class);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filter);
        return iObjectBase.getCollection(view);
    }

    private CoreBaseInfo getObjectValue(String entityMetaName, String id) throws Throwable {
        EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(entityMetaName));
        IObjectBase iObjectBase = (IObjectBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)entity.getType(), IObjectBase.class);
        ObjectUuidPK pk = new ObjectUuidPK(id);
        return iObjectBase.getValue((IObjectPK)pk);
    }

    private void setContentEnable(boolean destEnable) {
        boolean isSystem;
        this.namdkDTextField.setEnabled(destEnable);
        this.dpValidateTo.setEnabled(destEnable);
        this.dpValidateForm.setEnabled(destEnable);
        this.descriptionkDTextArea.setEnabled(destEnable);
        this.selectTaskkDWorkButton.setEnabled(destEnable);
        this.processSchedulekDWorkButton.setEnabled(destEnable);
        IColumn col2 = this.inParameterkDTable.getColumn(2);
        if (col2 != null) {
            col2.getStyleAttributes().setLocked(!destEnable);
        }
        this.failureCheckBox.setEnabled(destEnable);
        this.completeCheckBox.setEnabled(destEnable);
        this.abortCheckBox.setEnabled(destEnable);
        this.slowCheckBox.setEnabled(destEnable);
        this.overTimeCheckBox.setEnabled(destEnable);
        this.timeoutTimePicker.setEnabled(destEnable);
        this.sendMailCheckBox.setEnabled(destEnable);
        this.sendSMSCheckBox.setEnabled(destEnable);
        this.noticeTitleMultiLangBox.setEnabled(destEnable);
        this.noticeContentMultiLangArea.setEnabled(destEnable);
        this.insertVaribleButton.setEnabled(destEnable);
        this.taskkDTextField.setEnabled(destEnable);
        this.schedulekDTextField.setEnabled(destEnable);
        this.reInstructionkDRadioButton.setEnabled(destEnable);
        this.noopInstructionkDRadioButton.setEnabled(destEnable);
        this.mutexCtrl.setEnabled(destEnable);
        this.serversCombo.setEnabled(destEnable);
        this.jobExecutor.setEnabled(destEnable);
        this.namdkDTextField.setRequired(destEnable);
        this.dpValidateForm.setRequired(destEnable);
        this.dpValidateTo.setRequired(destEnable);
        this.taskkDTextField.setRequired(destEnable);
        this.schedulekDTextField.setRequired(destEnable);
        if (destEnable) {
            this.taskkDTextField.setCustomBackgroundColor(new Color(255, 255, 255));
            this.schedulekDTextField.setCustomBackgroundColor(new Color(255, 255, 255));
        } else {
            this.taskkDTextField.setCustomBackgroundColor(new Color(0xE8E8E3));
            this.schedulekDTextField.setCustomBackgroundColor(new Color(0xE8E8E3));
        }
        this.priorityMajor.setEnabled(destEnable);
        this.priorityHigh.setEnabled(destEnable);
        this.priorityLow.setEnabled(destEnable);
        this.priorityNormal.setEnabled(destEnable);
        this.prmpResponsible.setEnabled(destEnable);
        this.chkPersistent.setEnabled(destEnable);
        String s = this.namdkDTextField.getText();
        if (s == null) {
            s = "";
        }
        if (isSystem = s.startsWith("~")) {
            this.namdkDTextField.setEnabled(false);
            this.selectTaskkDWorkButton.setEnabled(false);
            this.processSchedulekDWorkButton.setEnabled(false);
        }
    }

    private void setButtonIco() {
        this.newkDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.deletekDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.refreshkDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.modifykDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.savekDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.releasekDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.btnTest.setIcon(EASResource.getIcon((String)"imgTbtn_testdatacenter"));
        this.newKDMenuItem.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.saveKDMenuItem.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.delKDMenuItem.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.refreshKDMenuItem.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.modifyKDMenuItem.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.promKDMenuItem.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
    }

    private void initalNoticeContentText() {
        Locale locale = null;
        LanguageInfo info = null;
        List list = MultiLangList.getLanguageList();
        for (int i = 0; i < list.size(); ++i) {
            info = (LanguageInfo)list.get(i);
            locale = info.getLocale();
            this.noticeTitleMultiLangBox.setItemData(info, (Object)EASCommonResource.getString((String)JobResource, (String)"job_MsgTitle", (Locale)locale));
            this.noticeContentMultiLangArea.setItemData(info, (Object)EASCommonResource.getString((String)JobResource, (String)"job_MsgContent", (Locale)locale));
        }
        this.noticeTitleMultiLangBox.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
        this.noticeContentMultiLangArea.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
    }

    private void initInsertVeriableKDButton() {
        KDMenuItem title = new KDMenuItem(JobResourceUtil.getJobResource("var_title"));
        KDMenuItem scheduledtime = new KDMenuItem(JobResourceUtil.getJobResource("var_schedulerTime"));
        KDMenuItem startedtime = new KDMenuItem(JobResourceUtil.getJobResource("var_startTime"));
        KDMenuItem createdtime = new KDMenuItem(JobResourceUtil.getJobResource("var_createdTime"));
        KDMenuItem exception = new KDMenuItem(JobResourceUtil.getJobResource("var_exception"));
        KDMenuItem holderid = new KDMenuItem(JobResourceUtil.getJobResource("var_server"));
        KDMenuItem state = new KDMenuItem(JobResourceUtil.getJobResource("var_state"));
        title.addActionListener((ActionListener)new insertVeriableActionListener());
        scheduledtime.addActionListener((ActionListener)new insertVeriableActionListener());
        startedtime.addActionListener((ActionListener)new insertVeriableActionListener());
        createdtime.addActionListener((ActionListener)new insertVeriableActionListener());
        exception.addActionListener((ActionListener)new insertVeriableActionListener());
        holderid.addActionListener((ActionListener)new insertVeriableActionListener());
        state.addActionListener((ActionListener)new insertVeriableActionListener());
        this.insertVaribleButton.addAssistMenuItem((JMenuItem)title);
        this.insertVaribleButton.addAssistMenuItem((JMenuItem)state);
        this.insertVaribleButton.addAssistMenuItem((JMenuItem)exception);
        this.insertVaribleButton.addAssistMenuItem((JMenuItem)createdtime);
        this.insertVaribleButton.addAssistMenuItem((JMenuItem)scheduledtime);
        this.insertVaribleButton.addAssistMenuItem((JMenuItem)startedtime);
        this.insertVaribleButton.addAssistMenuItem((JMenuItem)holderid);
        this.insertVaribleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobProcessManager.this.insertVaribleButton.getAssistPopup().show((Component)((JComponent)e.getSource()), 0, ((JComponent)e.getSource()).getHeight());
            }
        });
    }

    private void initializeUI() throws Exception {
        this.inParameterkDTable.checkParsed();
        this.windowTitle = JobResourceUtil.getJobResource("backgroundTaskManager");
        this.setButtonIco();
        this.clearData();
        this.initInsertVeriableKDButton();
        this.authorkDTextField.setEnabled(false);
        this.taskkDTextField.setEnabled(false);
        this.taskkDTextField.setEditable(false);
        this.schedulekDTextField.setEnabled(false);
        this.schedulekDTextField.setEditable(false);
        this.failureCheckBox.setEnabled(false);
        this.completeCheckBox.setEnabled(false);
        this.abortCheckBox.setEnabled(false);
        this.slowCheckBox.setEnabled(false);
        this.overTimeCheckBox.setEnabled(false);
        this.timeoutTimePicker.setEnabled(false);
        this.sendMailCheckBox.setEnabled(false);
        this.sendSMSCheckBox.setEnabled(false);
        this.noticeTitleMultiLangBox.setEnabled(false);
        this.noticeContentMultiLangArea.setEnabled(false);
        this.insertVaribleButton.setEnabled(false);
        this.mutexCtrl.setEnabled(false);
        this.serversCombo.setEnabled(false);
        this.mutexCtrl.setToolTipText("\u9ed8\u8ba4\u540c\u4e00facade\u7684\u4e92\u65a5\u9501\u4e00\u6837\u6765\u4fdd\u8bc1\u4e8b\u52a1\u5b8c\u6574\u6027\uff0c\u82e5\u60f3\u540c\u4e00facade\u4e0d\u540c\u4e8b\u52a1\u53ef\u4ee5\u540c\u65f6\u8fd0\u884c\uff0c\u5219\u5b9a\u4e49\u4e0d\u540c\u7684\u4e92\u65a5\u63a7\u5236\u503c\uff0c\u6e05\u7a7a\u5219\u4e0d\u505a\u4efb\u4f55\u63a7\u5236\uff0c\u8bf7\u54a8\u8be2\u4e1a\u52a1\u5f00\u53d1\u540e\u8c28\u614e\u4f7f\u7528\uff01");
        this.serversCombo.setToolTipText("\u6307\u5b9a\u670d\u52a1\u5668\u6267\u884c\u8be5\u540e\u53f0\u4e8b\u52a1\uff0c\u9ed8\u8ba4\u4e3a\u81ea\u52a8\u5206\u914d\u670d\u52a1\u5668");
        this.createTimekDDatePicker.setEnabled(false);
        this.setContentEnable(false);
        IColumn col0 = this.inParameterkDTable.getColumn(0);
        if (col0 != null) {
            col0.getStyleAttributes().setLocked(true);
        }
        IColumn col1 = this.inParameterkDTable.getColumn(1);
        col1.getStyleAttributes().setLocked(true);
        BusinessTreeUtil tempPTU = new BusinessTreeUtil(0);
        ((KingdeeTreeModel)this.packagekDTree.getModel()).setRoot(null);
        JobUtils.resetStartTimeMillis();
        tempPTU.initialBusinessTreeView(this.packagekDTree, true);
        JobUtils.printTimeMillis("initialBusinessTreeView");
        this.packagekDTree.addTreeSelectionListener((TreeSelectionListener)new InnerTreeSelectionListener());
        this.selectTaskkDWorkButton.addActionListener((ActionListener)new CommonActionListener());
        this.processSchedulekDWorkButton.addActionListener((ActionListener)new CommonActionListener());
        this.inParameterkDTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                JobProcessManager.this.inParameterkDTable_tableClicked(e);
            }
        });
        this.overTimeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JobProcessManager.this.overTimeCheckBox.isSelected()) {
                    JobProcessManager.this.timeoutTimePicker.setVisible(true);
                    if (JobProcessManager.this.timeoutTimePicker.getValue() == null) {
                        GregorianCalendar gc = new GregorianCalendar();
                        gc.set(13, 0);
                        gc.set(12, 10);
                        gc.set(11, 0);
                        JobProcessManager.this.timeoutTimePicker.setValue((Object)gc.getTime());
                    }
                } else {
                    JobProcessManager.this.timeoutTimePicker.setVisible(false);
                }
            }
        });
    }

    private void inParameterkDTable_tableClicked(KDTMouseEvent e) {
        if (e.getType() == 1 && e.getClickCount() == 1) {
            int row = e.getRowIndex();
            int col = e.getColIndex();
            if (col == 3) {
                if (this.inParameterkDTable.getColumn(4).getStyleAttributes().isLocked()) {
                    return;
                }
                HashMap ctx = new HashMap();
                SelectEntity.open((Object)this, ctx);
                if (ctx.get("$CLEAR_KEY$") != null) {
                    this.inParameterkDTable.getRow(row).getCell(3).setValue((Object)"");
                    this.inParameterkDTable.getRow(row).getCell(4).setEditor(null);
                    this.inParameterkDTable.getRow(row).getCell(4).setValue((Object)"");
                    return;
                }
                String dataTypeName = this.inParameterkDTable.getRow(row).getCell(2).getValue().toString();
                DataType dataType = DataTypeUtil.getDataType(dataTypeName);
                Object o = ctx.get("entity");
                if (o != null) {
                    EntityObjectInfo tempFOI = (EntityObjectInfo)o;
                    String bosType = tempFOI.getType().toString();
                    KDTDefaultCellEditor editor = null;
                    editor = orgTypeMap.containsKey(bosType) ? this.createOrgEditor(orgTypeMap.get(bosType), ExternalType.OBJECTCOLLECTION.equals((Object)dataType)) : this.createEditor(tempFOI);
                    if (editor != null) {
                        KDBizPromptBox box = (KDBizPromptBox)editor.getComponent();
                        box.setEnabledMultiSelection(true);
                        box.setDisplayFormat("$name$");
                        box.setEditFormat("$number$");
                        ObjectValueRender box_OVR = new ObjectValueRender();
                        box_OVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
                        this.inParameterkDTable.getRow(row).getCell(4).setRenderer((IBasicRender)box_OVR);
                        this.inParameterkDTable.getRow(row).getCell(4).setEditor((ICellEditor)editor);
                        this.inParameterkDTable.getRow(row).getCell(3).setValue((Object)(tempFOI.getPackage() + "." + tempFOI.getName()));
                        this.inParameterkDTable.getRow(row).getCell(4).setValue(null);
                    }
                }
            }
        }
    }

    private KDTDefaultCellEditor createOrgEditor(OrgType orgType, boolean multipleSelect) {
        KDBizPromptBox f7Ctrl = new KDBizPromptBox();
        NewOrgF7 comp = new NewOrgF7((IUIObject)this);
        comp.setOrgTypes(new OrgType[]{orgType});
        comp.setMultiSelect(multipleSelect);
        comp.setNeedAddAssistant(Boolean.valueOf(true).booleanValue());
        comp.setNeedAddOrgRange(false);
        f7Ctrl.setSelector((KDPromptSelector)comp);
        f7Ctrl.setDisplayFormat("$name$");
        f7Ctrl.setEditFormat("$number$");
        f7Ctrl.setCommitFormat("$number$");
        f7Ctrl.setEditable(false);
        return new KDTDefaultCellEditor((IKDEditor)f7Ctrl);
    }

    private KDTDefaultCellEditor createEditor(Object entity) {
        try {
            EntityObjectInfo e;
            if (entity instanceof String) {
                String name = (String)entity;
                if (name.length() == 0) {
                    return null;
                }
                e = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(name));
            } else {
                e = (EntityObjectInfo)entity;
            }
            String query = Util.getDefaultF7Query((EntityObjectInfo)e);
            String ui = Util.getDefaultF7UI((EntityObjectInfo)e);
            if (StringUtils.isEmpty((String)query) && StringUtils.isEmpty((String)ui)) {
                MsgBox.showInfo((String)JobResourceUtil.getJobResource("job_warn3"));
                return null;
            }
            KDPromptBox box = new DefaultPromptBoxFactory().create(null, e, "number");
            box.setEditable(false);
            return new KDTDefaultCellEditor((IKDEditor)box);
        }
        catch (Exception ex) {
            MsgBox.showConfirm3a((String)(JobResourceUtil.getJobResource("job_warn4") + entity + JobResourceUtil.getJobResource("job_warn5")), (String)JobProcessManager.dump(ex));
            return null;
        }
    }

    @Override
    public void actionNew_actionPerformed(ActionEvent e) throws Exception {
        this.newProcessDef();
        this.initalNoticeContentText();
        this.savekDWorkButton.setEnabled(true);
        this.namdkDTextField.requestFocus();
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        this.deleteProcessDef();
    }

    @Override
    public void actionModify_actionPerformed(ActionEvent e) throws Exception {
        if (!this.flag) {
            this.initalNoticeContentText();
        }
        this.modifyProcessDef();
    }

    @Override
    public void actionRelease_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkSaveCondition()) {
            this.releaseProcressDef();
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.saveProcessDef();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionTest_actionPerformed(ActionEvent e) throws Exception {
        super.actionTest_actionPerformed(e);
        try {
            String title = JobUtils.getJobServiceFacade().testJobDef(this.jobProcess.getRelatedProcess());
            MsgBox.showInfo((Component)((Object)this), (String)(JobResourceUtil.getJobResource("testSuccess") + "\r\n\r\n" + JobResourceUtil.getJobResource("job_info1") + "\r\n\t" + title));
        }
        catch (Exception ex) {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bao);
            ex.printStackTrace(ps);
            String msg = bao.toString();
            MsgBox.showConfirm3a((String)JobResourceUtil.getJobResource("job_info2"), (String)msg);
        }
    }

    @Override
    protected void inParameterkDTable_editStopping(KDTEditEvent e) throws Exception {
        super.inParameterkDTable_editStopping(e);
        int index = e.getRowIndex();
        String value = e.getValue() != null ? e.getValue().toString() : "";
        String dataTypeName = this.inParameterkDTable.getRow(index).getCell(2).getValue().toString();
        DataType dataType = DataTypeUtil.getDataType(dataTypeName);
        if (value.length() == 0) {
            return;
        }
        if (dataType.equals(BasicType.INTEGER) || dataType.equals(BasicType.FLOAT) || dataType.equals(BasicType.INTEGER)) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e1) {
                MsgBox.showWarning((Component)((Object)this), (String)JobResourceUtil.getJobResource("job_warn6"));
                e.setCancel(true);
            }
        } else if (dataType.equals(BasicType.BOOLEAN)) {
            if (!"true".equals(value) && !"false".equals(value)) {
                MsgBox.showWarning((Component)((Object)this), (String)JobResourceUtil.getJobResource("job_warn6"));
                e.setCancel(true);
            }
        } else if (dataType.equals(BasicType.DATETIME)) {
            try {
                DateTimeUtils.parseDate((String)value);
            }
            catch (ParseException e1) {
                MsgBox.showWarning((Component)((Object)this), (String)JobResourceUtil.getJobResource("job_warn6"));
                e.setCancel(true);
            }
        }
    }

    private void setResponsibles() {
        ExtendedAttributeCollection eac = this.jobProcess.getJobActivity().getActivityHeader().getExtendedAttributes();
        ExtendedAttributeDef isPersistent = eac.get("isPersistent");
        if (isPersistent == null) {
            isPersistent = new ExtendedAttributeDef();
            isPersistent.setName("isPersistent");
            eac.add("isPersistent", isPersistent);
        }
        isPersistent.setValue(Boolean.valueOf(this.chkPersistent.isSelected()).toString());
        ExtendedAttributeDef priority = eac.get("priority");
        if (priority == null) {
            priority = new ExtendedAttributeDef();
            priority.setName("priority");
            eac.add("priority", priority);
        }
        if (this.priorityLow.isSelected()) {
            priority.setValue("1000");
        } else if (this.priorityNormal.isSelected()) {
            priority.setValue("500");
        } else if (this.priorityHigh.isSelected()) {
            priority.setValue("0");
        } else if (this.priorityMajor.isSelected()) {
            priority.setValue("-100");
        }
        eac.add("priority", priority);
        this.jobProcess.getRelatedProcess().getProcessHeader().getResponsibles().clear();
        EventPolicyCollection events = this.jobProcess.getRelatedProcess().getProcessHeader().getEventPolicies();
        events.clear();
        Object[] persons = (Object[])this.prmpResponsible.getData();
        if (persons == null) {
            return;
        }
        EventPolicyDef event = new EventPolicyDef();
        event.setEventType("PROCESS_SUSPENDED");
        event.setEventAction(7);
        ParticipantCollection participants = new ParticipantCollection();
        event.setParticipants(participants);
        for (int i = 0; i < persons.length; ++i) {
            PersonInfo p = (PersonInfo)persons[i];
            if (p == null) continue;
            ParticipantDef part = new ParticipantDef((ActivityDef)null);
            String tmp = p.getName(this.getLocale());
            if (tmp == null) {
                tmp = "unknow Person";
            }
            part.setName(tmp);
            part.setParticipantValue(p.getId().toString());
            part.setParticipantType(ParticipantType.HUMAN);
            participants.add(part.getID(), part);
        }
        try {
            events.add(event);
        }
        catch (WfException wfException) {
            // empty catch block
        }
    }

    public static String dump(Throwable t) {
        if (t == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.print("Error message:");
        pw.print(t.getMessage());
        pw.print("\r\nStack trace:\r\n");
        t.printStackTrace(pw);
        pw.flush();
        return baos.toString();
    }

    static {
        orgTypeMap.put("6A6435BE", OrgType.Admin);
        orgTypeMap.put("16FD9F90", OrgType.Company);
        orgTypeMap.put("6F9FB21C", OrgType.Sale);
        orgTypeMap.put("DF1A22A2", OrgType.Purchase);
        orgTypeMap.put("EB1F7FD2", OrgType.Storage);
        orgTypeMap.put("7FAFDF41", OrgType.CostCenter);
        orgTypeMap.put("A70FCF6A", OrgType.ProfitCenter);
        orgTypeMap.put("3525AA94", OrgType.ControlUnit);
        orgTypeMap.put("58B332D9", OrgType.HRO);
        orgTypeMap.put("5CEBCE24", OrgType.Transport);
        orgTypeMap.put("743064CE", OrgType.Quality);
    }

    private class CommonActionListener
    implements ActionListener {
        private CommonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("selecttask".equalsIgnoreCase(e.getActionCommand())) {
                JobProcessManager.this.openSelectTask();
            }
            if ("schedule".equalsIgnoreCase(e.getActionCommand())) {
                JobProcessManager.this.openProcessSchedulePlan();
            }
        }
    }

    private class InnerTreeSelectionListener
    implements TreeSelectionListener {
        private InnerTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object lastPathComponent;
            TreePath currentTreePath = e.getNewLeadSelectionPath();
            if (currentTreePath != null && (lastPathComponent = currentTreePath.getLastPathComponent()) instanceof DefaultKingdeeTreeNode) {
                DefaultKingdeeTreeNode lastKingdeeTreeNode = (DefaultKingdeeTreeNode)lastPathComponent;
                Object userObject = lastKingdeeTreeNode.getUserObject();
                if (userObject instanceof ProcessDefObject) {
                    ProcessDefObject tempPDEFO = (ProcessDefObject)userObject;
                    JobProcessManager.this.viewProcessDef(tempPDEFO);
                    JobProcessManager.this.releasekDWorkButton.setEnabled(true);
                    JobProcessManager.this.modifykDWorkButton.setEnabled(true);
                    JobProcessManager.this.savekDWorkButton.setEnabled(false);
                    JobProcessManager.this.deletekDWorkButton.setEnabled(true);
                    JobProcessManager.this.actionTest.setEnabled(true);
                    JobProcessManager.this.newkDWorkButton.setEnabled(false);
                } else if (userObject instanceof PackageObject) {
                    JobProcessManager.this.modifyState = "none";
                    JobProcessManager.this.clearData();
                    JobProcessManager.this.setContentEnable(false);
                    JobProcessManager.this.releasekDWorkButton.setEnabled(false);
                    JobProcessManager.this.modifykDWorkButton.setEnabled(false);
                    JobProcessManager.this.savekDWorkButton.setEnabled(false);
                    JobProcessManager.this.deletekDWorkButton.setEnabled(false);
                    JobProcessManager.this.newkDWorkButton.setEnabled(true);
                    JobProcessManager.this.actionTest.setEnabled(false);
                }
            }
        }
    }

    private class ModifyState {
        public static final String NEW = "new";
        public static final String MODIFY = "modify";
        public static final String VIEW = "view";
        public static final String NONE = "none";

        private ModifyState() {
        }
    }

    private class insertVeriableActionListener
    implements ActionListener {
        private insertVeriableActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDMenuItem item = (KDMenuItem)e.getSource();
            LanguageInfo info = null;
            if (JobProcessManager.this.focusComboBox instanceof KDBizMultiLangArea) {
                MultiLangItem selectedItem = (MultiLangItem)JobProcessManager.this.noticeContentMultiLangArea.getSelectedItem();
                info = selectedItem.getLang();
                String former = (String)selectedItem.getData();
                String ver = "<%" + item.getText() + "%>";
                StringBuffer sb = new StringBuffer();
                int carePosition = 0;
                if (!StringUtils.isEmpty((String)former)) {
                    if (former.length() < JobProcessManager.this.caretPo) {
                        JobProcessManager.this.caretPo = 0;
                    }
                    sb.append(former.substring(0, JobProcessManager.this.caretPo));
                    sb.append(ver);
                    sb.append(former.substring(JobProcessManager.this.caretPo));
                    carePosition = JobProcessManager.this.caretPo + ver.length();
                } else {
                    sb.append(ver);
                    carePosition = ver.length();
                }
                JobProcessManager.this.noticeContentMultiLangArea.setItemData(info, (Object)sb.toString());
                JobProcessManager.this.noticeContentMultiLangArea.requestFocus();
                JobProcessManager.this.noticeContentMultiLangArea.setSelectAllOnFocus(false);
                JobProcessManager.this.noticeContentMultiLangArea.updateText();
                ((JTextComponent)JobProcessManager.this.noticeContentMultiLangArea.getEditorComponent()).setCaretPosition(carePosition);
            } else if (JobProcessManager.this.focusComboBox instanceof KDBizMultiLangBox) {
                MultiLangItem selectedItem = (MultiLangItem)JobProcessManager.this.noticeTitleMultiLangBox.getSelectedItem();
                info = selectedItem.getLang();
                String former = (String)selectedItem.getData();
                String ver = "<%" + item.getText() + "%>";
                StringBuffer sb = new StringBuffer();
                int carePosition = 0;
                if (!StringUtils.isEmpty((String)former)) {
                    if (former.length() < JobProcessManager.this.caretPo) {
                        JobProcessManager.this.caretPo = 0;
                    }
                    sb.append(former.substring(0, JobProcessManager.this.caretPo));
                    sb.append(ver);
                    sb.append(former.substring(JobProcessManager.this.caretPo));
                    carePosition = JobProcessManager.this.caretPo + ver.length();
                } else {
                    sb.append(ver);
                    carePosition = ver.length();
                }
                JobProcessManager.this.noticeTitleMultiLangBox.setItemData(info, (Object)sb.toString());
                JobProcessManager.this.noticeTitleMultiLangBox.requestFocus();
                JobProcessManager.this.noticeTitleMultiLangBox.setSelectAllOnFocus(false);
                JobProcessManager.this.noticeTitleMultiLangBox.updateText();
                ((JTextComponent)JobProcessManager.this.noticeTitleMultiLangBox.getEditorComponent()).setCaretPosition(carePosition);
            }
        }
    }
}

