/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.job.IJobServiceUIFacade;
import com.kingdee.eas.base.job.client.AbstractJobServiceStatusUI;
import com.kingdee.eas.base.job.util.JobUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.apache.log4j.Logger;

public class JobServiceStatusUI
extends AbstractJobServiceStatusUI {
    private static final long serialVersionUID = 7816620054909302958L;
    private static final Logger logger = CoreUIObject.getLogger(JobServiceStatusUI.class);
    private String serverJobsInfo = "";
    private String serverConfigInfo = "";

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        String[] servers = null;
        this.ServerJobsInfo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JobServiceStatusUI.this.InfoTextArea.setText(JobServiceStatusUI.this.serverJobsInfo);
                }
            }
        });
        this.ServerConfigInfo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JobServiceStatusUI.this.InfoTextArea.setText(JobServiceStatusUI.this.serverConfigInfo);
                }
            }
        });
        this.ServerJobsInfo.setSelected(true);
        this.InfoTextArea.setEditable(false);
        try {
            IJobServiceUIFacade iJobServiceUIFacade = JobUtils.getJobServiceFacade();
            servers = iJobServiceUIFacade.getJobServiceInstanceKeys_c();
            if (servers.length == 0) {
                this.ServerLabelContainer.setVisible(false);
                String[] serviceStatus = iJobServiceUIFacade.getServiceStatusInfo();
                this.serverJobsInfo = serviceStatus[0];
                this.serverConfigInfo = serviceStatus[1];
                if (this.ServerJobsInfo.isSelected()) {
                    this.InfoTextArea.setText(this.serverJobsInfo);
                } else {
                    this.InfoTextArea.setText(this.serverConfigInfo);
                }
            } else {
                this.ServerComboBox.addItem((Object)"--\u9009\u62e9\u5b9e\u4f8b--");
                for (int i = 0; i < servers.length; ++i) {
                    if (servers[i].startsWith("cluster@")) continue;
                    this.ServerComboBox.addItem((Object)servers[i]);
                }
                this.ServerComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent paramActionEvent) {
                        if (JobServiceStatusUI.this.ServerComboBox.getSelectedIndex() != 0) {
                            Object item = JobServiceStatusUI.this.ServerComboBox.getSelectedItem();
                            String server = item.toString();
                            try {
                                String[] serviceStatus = JobUtils.getJobServiceFacade().getServiceStatusInfo(server);
                                JobServiceStatusUI.this.serverJobsInfo = serviceStatus[0];
                                JobServiceStatusUI.this.serverConfigInfo = serviceStatus[1];
                            }
                            catch (BOSException ex) {
                                logger.error((Object)("getServiceStatusInfo failed! " + server), (Throwable)ex);
                                JobServiceStatusUI.this.serverJobsInfo = "";
                                JobServiceStatusUI.this.serverConfigInfo = "";
                            }
                        } else {
                            JobServiceStatusUI.this.serverJobsInfo = "";
                            JobServiceStatusUI.this.serverConfigInfo = "";
                        }
                        if (JobServiceStatusUI.this.ServerJobsInfo.isSelected()) {
                            JobServiceStatusUI.this.InfoTextArea.setText(JobServiceStatusUI.this.serverJobsInfo);
                        } else {
                            JobServiceStatusUI.this.InfoTextArea.setText(JobServiceStatusUI.this.serverConfigInfo);
                        }
                    }
                });
            }
        }
        catch (BOSException e) {
            logger.error((Object)"getJobServiceFacade failed!", (Throwable)e);
        }
    }
}

