/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.client;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public abstract class JobState
implements Serializable {
    public static final String SYSTEM_JOB_TITLE_PREFIX = "~";
    public static final String OP_ABORT = "abort";
    public static final String OP_RESTART = "restart";
    public static final String OP_SUSPEND = "suspend";
    public static final String OP_RESUME = "resume";
    public static final String OP_MOVE_TO_HIS = "move";
    public static final String OP_EXCEPTION = "exception";
    public static final String OP_CHECK = "check";
    private static final long serialVersionUID = -7497796945012941555L;
    private static HashMap objects = new HashMap();
    private String name;
    public static final JobState Created = new Created();
    public static final JobState ReScheduled = new ReScheduled();
    public static final JobState Waiting = new Waiting();
    public static final JobState Ready = new Ready();
    public static final JobState Running = new Running();
    public static final JobState Suspended = new Suspended();
    public static final JobState Failed = new Failed();
    public static final JobState Complete = new Complete();
    public static final JobState Aborted = new Aborted();
    public static final JobState Missed = new Missed();

    protected JobState(String name) {
        this.name = name;
        objects.put(name, this);
    }

    public String toString() {
        return this.name;
    }

    public static JobState valueOf(String name) {
        return (JobState)objects.get(name);
    }

    public static Collection all() {
        return objects.values();
    }

    public static JobState find(String name) {
        Iterator it = objects.keySet().iterator();
        String key = null;
        while (it.hasNext() && !name.equalsIgnoreCase(key = (String)it.next())) {
        }
        return JobState.valueOf(key);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JobState)) {
            return false;
        }
        return this.name.equals(((JobState)o).name);
    }

    public abstract String[] getSupportedOperations();

    private static class Missed
    extends JobState {
        private static final long serialVersionUID = 7242253574736738623L;

        public Missed() {
            super("Missed");
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_RESTART, JobState.OP_MOVE_TO_HIS};
        }
    }

    private static class Aborted
    extends JobState {
        private static final long serialVersionUID = 7190088098239744848L;

        public Aborted() {
            super("Aborted");
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_MOVE_TO_HIS};
        }
    }

    private static class Complete
    extends JobState {
        private static final long serialVersionUID = 1792376812113695955L;

        public Complete() {
            super("Complete");
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_MOVE_TO_HIS};
        }
    }

    private static class Failed
    extends JobState {
        private static final long serialVersionUID = -1960253852627137383L;

        public Failed() {
            super("Failed");
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_RESTART, JobState.OP_MOVE_TO_HIS, JobState.OP_EXCEPTION};
        }
    }

    private static class Suspended
    extends JobState {
        private static final long serialVersionUID = -6663650364110878697L;

        public Suspended() {
            super("Suspended");
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_RESUME};
        }
    }

    private static class Running
    extends JobState {
        private static final long serialVersionUID = -2428699051058453611L;

        public Running() {
            super("Running");
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_CHECK};
        }
    }

    private static class Ready
    extends JobState {
        private static final long serialVersionUID = 4360212803794658727L;

        public Ready() {
            super("Ready");
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_ABORT, JobState.OP_SUSPEND, JobState.OP_CHECK};
        }
    }

    private static class Waiting
    extends JobState {
        private static final long serialVersionUID = -4353760578200748988L;

        public Waiting() {
            super("Waiting");
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_ABORT, JobState.OP_SUSPEND, JobState.OP_CHECK};
        }
    }

    private static class ReScheduled
    extends JobState {
        private static final long serialVersionUID = -8997328492312143185L;

        public ReScheduled() {
            super("ReScheduled");
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_ABORT, JobState.OP_SUSPEND, JobState.OP_CHECK};
        }
    }

    private static class Created
    extends JobState {
        private static final long serialVersionUID = -2484118897782438172L;

        public Created() {
            super("Created");
        }

        @Override
        public String[] getSupportedOperations() {
            return new String[]{JobState.OP_ABORT, JobState.OP_SUSPEND, JobState.OP_CHECK};
        }
    }
}

