/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.job.IJobServiceUIFacade;
import com.kingdee.eas.base.job.client.AbstractJobThreadPool;
import com.kingdee.eas.base.job.util.JobUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class JobThreadPool
extends AbstractJobThreadPool {
    private static final Logger logger = CoreUIObject.getLogger(JobThreadPool.class);
    private static final String jobRes = "com.kingdee.eas.base.job.client.JobResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.actionSave.setEnabled(true);
        this.actionClose.setEnabled(true);
        this.setSizeLimit(this.majorJobSize, 1, 20);
        this.setSizeLimit(this.bigJobSize, 1, 30);
        this.setSizeLimit(this.wfJobSize, 1, 20);
        try {
            this.server.addItem((Object)EASResource.getString((String)jobRes, (String)"selectServer"));
            IJobServiceUIFacade iJobServiceUIFacade = JobUtils.getJobServiceFacade();
            String[] servers = iJobServiceUIFacade.getJobServiceInstanceKeys_c();
            for (int i = 0; i < servers.length; ++i) {
                if (servers[i].startsWith("cluster@")) continue;
                this.server.addItem((Object)servers[i]);
            }
            this.server.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent paramActionEvent) {
                    if (JobThreadPool.this.server.getSelectedIndex() != 0) {
                        try {
                            IJobServiceUIFacade iJobServiceUIFacade = JobUtils.getJobServiceFacade();
                            Map<String, Object> rs = iJobServiceUIFacade.getThreadPoolSize(JobThreadPool.this.server.getSelectedItem().toString());
                            JobThreadPool.this.majorJobSize.setValue(rs.get("majorJobSize"));
                            JobThreadPool.this.bigJobSize.setValue(rs.get("bigJobSize"));
                            JobThreadPool.this.wfJobSize.setValue(rs.get("wfJobSize"));
                            if (rs.get("nextAdjustTime") instanceof Date) {
                                JobThreadPool.this.adjustTime.setValue(rs.get("nextAdjustTime"));
                            }
                            JobThreadPool.this.kDButton1.setEnabled(true);
                        }
                        catch (BOSException e) {
                            logger.error((Object)"getJobService failed!", (Throwable)e);
                            MsgBox.showInfo((String)EASResource.getString((String)JobThreadPool.jobRes, (String)"connectToOtherServerFail", (Object[])new Object[]{JobThreadPool.this.server.getSelectedItem().toString()}));
                            JobThreadPool.this.kDButton1.setEnabled(false);
                        }
                    } else {
                        JobThreadPool.this.majorJobSize.setValue(null);
                        JobThreadPool.this.bigJobSize.setValue(null);
                        JobThreadPool.this.wfJobSize.setValue(null);
                    }
                }
            });
        }
        catch (BOSException e) {
            logger.error((Object)"getJobService failed!", (Throwable)e);
        }
        this.description.setBorder((Border)new LineBorder(null, 0));
        this.description.setText(EASResource.getString((String)jobRes, (String)"jobThreadPoolNotice"));
    }

    public void setSizeLimit(final KDNumberTextField kntf, final int i, final int j) {
        kntf.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent dce) {
                Object newValue = dce.getNewValue();
                if (newValue != null && newValue instanceof BigDecimal) {
                    BigDecimal b = (BigDecimal)newValue;
                    if (b.compareTo(new BigDecimal(i)) == -1) {
                        kntf.setValue((Object)i);
                    } else if (b.compareTo(new BigDecimal(j)) == 1) {
                        kntf.setValue((Object)j);
                    }
                }
            }
        });
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.server.getSelectedIndex() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)jobRes, (String)"chooseServer"));
        } else if (this.majorJobSize == null || this.majorJobSize.getIntegerValue() == null || this.majorJobSize.getIntegerValue() < 1 || this.majorJobSize.getIntegerValue() > 20) {
            MsgBox.showInfo((String)EASResource.getString((String)jobRes, (String)"majorJobNotice"));
        } else if (this.bigJobSize == null || this.bigJobSize.getIntegerValue() == null || this.bigJobSize.getIntegerValue() < 1 || this.bigJobSize.getIntegerValue() > 30) {
            MsgBox.showInfo((String)EASResource.getString((String)jobRes, (String)"bigJobNotice"));
        } else if (this.wfJobSize == null || this.wfJobSize.getIntegerValue() == null || this.wfJobSize.getIntegerValue() < 1 || this.wfJobSize.getIntegerValue() > 20) {
            MsgBox.showInfo((String)EASResource.getString((String)jobRes, (String)"wfJobNotice"));
        } else if (this.adjustTime.getValue() == null || !this.adjustTime.getTimestamp().after(new Date())) {
            MsgBox.showInfo((String)EASResource.getString((String)jobRes, (String)"validateToIsSmallerThanCurrentdate"));
        } else {
            try {
                int[] size = new int[]{this.majorJobSize.getIntegerValue(), this.bigJobSize.getIntegerValue(), this.wfJobSize.getIntegerValue()};
                IJobServiceUIFacade iJobServiceUIFacade = JobUtils.getJobServiceFacade();
                iJobServiceUIFacade.setThreadPoolSize(this.server.getSelectedItem().toString(), size, this.adjustTime.getTimestamp().getTime());
                MsgBox.showInfo((String)EASResource.getString((String)jobRes, (String)"saveSuccess"));
                this.disposeUIWindow();
            }
            catch (BOSException ex) {
                logger.error((Object)"setJobThreadPool failed!", (Throwable)ex);
                MsgBox.showConfirm3a((String)EASResource.getString((String)jobRes, (String)"saveFailDetail"), (String)ex.getMessage());
            }
        }
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }
}

