/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.client;

import com.kingdee.eas.base.job.client.AbstractProcessReleaseDialog;
import com.kingdee.eas.base.job.util.IReleaseObserver;
import com.kingdee.eas.base.job.util.JobProcessDef;
import com.kingdee.eas.base.job.util.JobResourceUtil;
import com.kingdee.eas.base.job.util.ReleaseJobProgress;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ProcessReleaseDialog
extends AbstractProcessReleaseDialog
implements IReleaseObserver {
    private static final long serialVersionUID = -3535524488131849013L;
    private JobProcessDef job;

    public ProcessReleaseDialog() throws Exception {
        this.releaseKDButton.setEnabled(true);
    }

    private void release() {
        try {
            ReleaseJobProgress rp = new ReleaseJobProgress(this.job.getRelatedProcess(), this);
            boolean isSuccess = rp.releaseProcess();
            if (isSuccess) {
                this.releaseKDButton.setEnabled(false);
            } else {
                this.releaseKDButton.setEnabled(true);
            }
            this.releaseKDButton.setEnabled(false);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void cancle() {
        this.getUIWindow().close();
    }

    private void getParameter() {
        Object obj = this.getUIContext().get("jobprocessdef");
        if (obj instanceof JobProcessDef) {
            this.job = (JobProcessDef)obj;
        }
    }

    private void initializeUI() {
        try {
            this.windowTitle = JobResourceUtil.getJobResource("releaseJobProcess");
            this.releaseInfokDTextArea.setEditable(false);
            this.releaseKDButton.addActionListener((ActionListener)new CommonActionListener());
            this.cancelKDButton.addActionListener((ActionListener)new CommonActionListener());
            this.addInfo(JobResourceUtil.getReleaseStringResource("WaitToRelease"));
            this.addInfo("\n");
            this.addInfo(JobResourceUtil.getReleaseStringResource("WaitToReleaseJob") + this.job.getName());
        }
        catch (Exception error) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)error);
        }
    }

    @Override
    public void addInfo(String info) {
        this.releaseInfokDTextArea.setText(this.releaseInfokDTextArea.getText() + info);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadFields();
        this.getParameter();
        this.initializeUI();
    }

    private class CommonActionListener
    implements ActionListener {
        private CommonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if ("release".equalsIgnoreCase(e.getActionCommand())) {
                    ProcessReleaseDialog.this.release();
                } else if ("cancel".equalsIgnoreCase(e.getActionCommand())) {
                    ProcessReleaseDialog.this.cancle();
                }
            }
            catch (Exception error) {
                ExceptionHandler.handle((Throwable)error);
            }
        }
    }
}

