/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.metas.IWFRProcessInstLog;
import com.kingdee.bos.workflow.metas.WFRProcessInstLogCollection;
import com.kingdee.bos.workflow.metas.WFRProcessInstLogFactory;
import com.kingdee.eas.base.job.client.AbstractShowLogListUI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ShowLogListUI
extends AbstractShowLogListUI {
    private static final Logger logger = CoreUIObject.getLogger(ShowLogListUI.class);
    private EASWfServiceClient workflowClient = new EASWfServiceClient();
    Map processIdToName = new HashMap();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.setButtonDefaultStyl(this.btnPrint);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.initData();
    }

    private void initData() throws BOSException {
        String processInstId = (String)this.getUIContext().get("processInstId");
        IWFRProcessInstLog IWFLog = WFRProcessInstLogFactory.getRemoteInstance();
        String oql = "select id, processDefID, processVersion, processInstID, logType, event, description,longDescription, extendedDescription, server, time where processInstID ='" + processInstId + "' ordre by time desc";
        WFRProcessInstLogCollection wfLogs = IWFLog.getCollection(oql);
        this.fillTable(wfLogs);
    }

    public void initTable() {
        this.tblLogList.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                Object msg;
                int colIndex = e.getRowIndex();
                int rowIndex = e.getColIndex();
                if (e.getClickCount() == 2 && e.getType() == 1 && (msg = ShowLogListUI.this.tblLogList.getCell(colIndex, rowIndex).getValue()) != null && msg.toString().length() > 0) {
                    MsgBox.showInfo((String)msg.toString());
                }
            }
        });
    }

    public void fillTable(WFRProcessInstLogCollection logs) {
        int count = logs.size();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblLogList.addRow(i);
            ICell cell = row.getCell(0);
            cell.setValue((Object)logs.get(i).getProcessDefID());
            cell.getStyleAttributes().setLocked(true);
            String name = (String)this.processIdToName.get(logs.get(i).getProcessDefID().toString());
            if (name == null) {
                try {
                    name = this.workflowClient.getProcessDefInfo(logs.get(i).getProcessDefID().toString()).getProcDefName(SysContext.getSysContext().getLocale());
                    this.processIdToName.put(logs.get(i).getProcessDefID().toString(), name);
                }
                catch (WfException e) {
                    ShowLogListUI.getLogger((String)((Object)((Object)this)).getClass().getName()).error((Object)"fillTable(WFRProcessInstLogCollection logs)", (Throwable)e);
                }
            }
            cell = row.getCell(1);
            cell.setValue((Object)name);
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(2);
            cell.setValue((Object)Integer.toString(logs.get(i).getProcessVersion()));
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(3);
            cell.setValue((Object)logs.get(i).getProcessInstID());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(4);
            cell.setValue((Object)logs.get(i).getLogType());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(5);
            cell.setValue((Object)logs.get(i).getEvent());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(6);
            cell.setValue((Object)logs.get(i).getDescription());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(7);
            cell.setValue((Object)logs.get(i).getLongDescription());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(8);
            cell.setValue((Object)logs.get(i).getExtendedDescription());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(9);
            cell.setValue((Object)logs.get(i).getServer());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(10);
            cell.setValue((Object)logs.get(i).getTime());
            cell.getStyleAttributes().setLocked(true);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblLogList);
        this.tblLogList.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblLogList);
        this.tblLogList.getPrintManager().printPreview();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        this.tblLogList.getPrintManager().pageSetup();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.tblLogList.refresh();
        this.initData();
    }

    protected void checkTableParsed() {
        this.tblLogList.checkParsed();
    }

    protected KDTable getTableForCommon() {
        return this.tblLogList;
    }
}

