/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.client;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.job.client.AbstractUserDefine;
import com.kingdee.eas.base.job.util.JobResourceUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import java.util.Date;
import org.quartz.impl.triggers.CronTriggerImpl;

public class UserDefine
extends AbstractUserDefine {
    public UserDefine() throws Exception {
        this.initializeUI();
    }

    private void initializeUI() {
        NewAdminF7 adminF7 = new NewAdminF7((IUIObject)this);
        adminF7.setIsCUFilter(false);
        this.workingDayRadioButton.setVisible(false);
        this.workingDayRadioButton.setSelected(true);
        this.nonworkingDayRadioButton.setVisible(false);
        this.selectOrgUnitKDBizPromptBox.setSelector((KDPromptSelector)adminF7);
        this.useCalendarKDCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isSelected = UserDefine.this.useCalendarKDCheckBox.isSelected();
                UserDefine.this.workingDayRadioButton.setVisible(isSelected);
                UserDefine.this.nonworkingDayRadioButton.setVisible(isSelected);
                UserDefine.this.selectOrgUnitKDBizPromptBox.setEnabled(isSelected);
                UserDefine.this.selectOrgUnitKDBizPromptBox.setEditable(false);
            }
        });
        this.useCalendarKDCheckBox.setSelected(false);
        this.selectOrgUnitKDBizPromptBox.setEnabled(false);
        this.testCron.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String schedule = UserDefine.this.getSchedule();
                if (schedule != null && schedule.trim().length() > 0) {
                    try {
                        CronTriggerImpl trigger = new CronTriggerImpl();
                        trigger.setCronExpression(schedule);
                        Date one = trigger.getFireTimeAfter(null);
                        Date two = trigger.getFireTimeAfter(one);
                        Date three = trigger.getFireTimeAfter(two);
                        Date four = trigger.getFireTimeAfter(three);
                        Date five = trigger.getFireTimeAfter(four);
                        MsgBox.showInfo((String)(JobResourceUtil.getJobResource("testCronSuccess") + "\n" + DateTimeUtils.format((Date)one) + "\n" + DateTimeUtils.format((Date)two) + "\n" + DateTimeUtils.format((Date)three) + "\n" + DateTimeUtils.format((Date)four) + "\n" + DateTimeUtils.format((Date)five)));
                        return;
                    }
                    catch (ParseException pe) {
                        MsgBox.showInfo((String)JobResourceUtil.getJobResource("ScheduleFormatIsError"));
                        return;
                    }
                }
                MsgBox.showInfo((String)JobResourceUtil.getJobResource("ScheduleFormatIsError"));
            }
        });
    }

    private void setEnable(boolean enable) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i <= componentArray.length - 1; ++i) {
            Component destComponent = componentArray[i];
            if (destComponent instanceof KDLabel) continue;
            destComponent.setEnabled(enable);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getSchedule() {
        return this.scheduleExprKDTextArea.getText().trim();
    }

    public void setSchedule(String value, boolean readOnly) {
        if (value == null || value.length() == 0) {
            this.scheduleExprKDTextArea.setText("");
        } else {
            this.scheduleExprKDTextArea.setText(value);
        }
        this.setEnable(!readOnly);
    }

    public boolean isUseCalendar() {
        return this.useCalendarKDCheckBox.isSelected();
    }

    public void setUseCalendar(boolean use) {
        this.useCalendarKDCheckBox.setSelected(use);
        this.selectOrgUnitKDBizPromptBox.setEnabled(use);
        this.workingDayRadioButton.setVisible(use);
        this.nonworkingDayRadioButton.setVisible(use);
    }

    public boolean isInWorkingDay() {
        return this.workingDayRadioButton.isSelected();
    }

    public void setInWorkingDay(boolean isInWorkingDay) {
        this.workingDayRadioButton.setSelected(isInWorkingDay);
        this.nonworkingDayRadioButton.setSelected(!isInWorkingDay);
    }

    public OrgUnitInfo getOrgUnit() {
        Object orgUnit = this.selectOrgUnitKDBizPromptBox.getValue();
        return (OrgUnitInfo)orgUnit;
    }

    public void setOrgUnit(AdminOrgUnitInfo value) {
        this.selectOrgUnitKDBizPromptBox.setValue((Object)value);
    }
}

