/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.monitor.PostParticipantUtil;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.InputType;
import com.kingdee.eas.base.multiapprove.MultiApproveException;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.multiapprove.app.MultiApproveControllerBean;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiApproveControllerBeanUtil {
    static final Logger logger = Logger.getLogger((String)MultiApproveControllerBeanUtil.class.getName());

    public static String checkPostParticipants(IEnactmentService svc, AssignmentInfo[] assigns, String[] billNumbers) throws WfException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < assigns.length; ++i) {
            String msg = PostParticipantUtil.checkNextParticipants((String)assigns[i].getActInstId(), (IEnactmentService)svc);
            if (msg == null || msg.length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append("\r\n");
            }
            if (billNumbers != null && billNumbers.length == assigns.length) {
                String number = billNumbers[i];
                if (number != null && number.length() > 0) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"166_MultiApproveControllerBeanUtil") + number + "]: ");
                } else {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"167_MultiApproveControllerBeanUtil"));
                }
            }
            sb.append(msg);
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private static boolean checkesignature(String procdefId, Context ctx) throws BOSException, SQLException {
        boolean isEsignature = false;
        String sqlStr = "select fisActAllProcess from t_wfr_PermissionParam where fparam='esignature'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
        rs.next();
        if (rs.getString("fisActAllProcess").equals("1")) {
            isEsignature = true;
        } else {
            sqlStr = "select * from t_wfr_ParamProcdef where fprocdefId='" + procdefId + "' and fparam='esignature'";
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            if (rs.next()) {
                isEsignature = true;
            }
        }
        rs.close();
        return isEsignature;
    }

    public static String[] submit(Context ctx, String[] billIds, String[] assignmentIds, ApproveResult isPass, String handlerOption, String handlerContent, Object approveContent, boolean sendMail, boolean sendSMS, MultiApproveControllerBean service) throws BOSException {
        MultiApproveInfo info = new MultiApproveInfo();
        info.setExtendedProperty("isAddNew", "isAddNew");
        info.setIsMailNotifyNext(sendMail);
        info.setIsMobelNotifyNext(sendSMS);
        info.setInputType(InputType.MSG_CENTER);
        if (approveContent == null) {
            approveContent = "";
        }
        if (approveContent instanceof Map) {
            Map opinions = (Map)approveContent;
            for (Locale l : opinions.keySet()) {
                String comment = (String)opinions.get(l);
                info.setOpinion(comment, l);
            }
        } else {
            info.setOpinion(approveContent.toString());
        }
        info.setIsPass(isPass);
        if (handlerOption == null || handlerOption.length() == 0) {
            handlerOption = "0";
        }
        if (handlerOption.indexOf(43) <= 0) {
            int decisionKey = Integer.parseInt(handlerOption);
            info.setHandlerOpinion(decisionKey);
        }
        info.setMultiHandleOpinion(handlerOption);
        info.setHandlerContent(handlerContent);
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            AssignmentInfo assignmentInfo = svc.getAssignmentById(assignmentIds[0]);
            boolean isEsignature = MultiApproveControllerBeanUtil.checkesignature(assignmentInfo.getProcDefId(), ctx);
            if (isEsignature) {
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                PersonInfo currentPerson = userInfo.getPerson();
                String personid = "";
                personid = currentPerson == null ? userInfo.getId().toString() : currentPerson.getId().toString();
                String sql = "select fid from T_WFR_ESIGNATURE where fpersonid = '" + personid + "'";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rs.next()) {
                    info.setEsignatureId(rs.getString("fid"));
                }
            }
        }
        catch (Exception svc) {
            // empty catch block
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < billIds.length; ++i) {
            BOSUuid uuid = BOSUuid.read((String)billIds[i]);
            info.setId(null);
            info.setAssignment(assignmentIds[i]);
            info.setBillId(uuid);
            info.setExtendedProperty("businuessObjectId", billIds[i]);
            info.setExtendedProperty("assignmentID", assignmentIds[i]);
            try {
                service.submit(ctx, (CoreBaseInfo)info);
                result.add(billIds[i]);
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)("submit approve assignment {" + assignmentIds[i] + "} failed!the bill's id is {" + billIds[i] + "}"), (Throwable)e);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] batchSubmit(Context ctx, String[] billIds, String[] assignmentIds, ApproveResult isPass, String handlerOption, String handlerContent, Object approveContent, boolean sendMail, boolean sendSMS, MultiApproveControllerBean service) throws BOSException {
        MultiApproveInfo info = new MultiApproveInfo();
        info.setExtendedProperty("isAddNew", "isAddNew");
        info.setExtendedProperty("workflowLog_batchSubmit", "true");
        info.setIsMailNotifyNext(sendMail);
        info.setIsMobelNotifyNext(sendSMS);
        info.setInputType(InputType.MSG_CENTER);
        if (approveContent == null) {
            approveContent = "";
        }
        if (approveContent instanceof Map) {
            Map opinions = (Map)approveContent;
            for (Locale l : opinions.keySet()) {
                String comment = (String)opinions.get(l);
                info.setOpinion(comment, l);
            }
        } else {
            info.setOpinion(approveContent.toString());
        }
        info.setIsPass(isPass);
        if (handlerOption == null || handlerOption.length() == 0) {
            handlerOption = "0";
        }
        if (handlerOption.indexOf(43) <= 0) {
            int decisionKey = Integer.parseInt(handlerOption);
            info.setHandlerOpinion(decisionKey);
        }
        info.setMultiHandleOpinion(handlerOption);
        info.setHandlerContent(handlerContent);
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            AssignmentInfo assignmentInfo = svc.getAssignmentById(assignmentIds[0]);
            boolean isEsignature = MultiApproveControllerBeanUtil.checkesignature(assignmentInfo.getProcDefId(), ctx);
            if (isEsignature) {
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                PersonInfo currentPerson = userInfo.getPerson();
                String personid = "";
                personid = currentPerson == null ? userInfo.getId().toString() : currentPerson.getId().toString();
                String sql = "select fid from T_WFR_ESIGNATURE where fpersonid = '" + personid + "'";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rs.next()) {
                    info.setEsignatureId(rs.getString("fid"));
                }
            }
        }
        catch (Exception svc) {
            // empty catch block
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < billIds.length; ++i) {
            BOSUuid uuid = BOSUuid.read((String)billIds[i]);
            info.setId(null);
            info.setAssignment(assignmentIds[i]);
            info.setBillId(uuid);
            info.setExtendedProperty("businuessObjectId", billIds[i]);
            info.setExtendedProperty("assignmentID", assignmentIds[i]);
            try {
                service.submit(ctx, (CoreBaseInfo)info);
                result.add(billIds[i]);
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)("submit approve assignment {" + assignmentIds[i] + "} failed!the bill's id is {" + billIds[i] + "}"), (Throwable)e);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static void checkAssignmentState(AssignmentInfo assign) throws EASBizException {
        if (assign == null) {
            throw new MultiApproveException(MultiApproveException.ASSIGNMENTINFO_NULL);
        }
        if (assign.getState().equals((Object)WfAssignmentState.CANCELED)) {
            throw new MultiApproveException(MultiApproveException.ASSIGNMENTSTATE_CANCELED);
        }
        if (assign.getState().equals((Object)WfAssignmentState.COMPLETED)) {
            throw new MultiApproveException(MultiApproveException.ASSIGNMENTSTATE_COMPLETED);
        }
        if (assign.getState().equals((Object)WfAssignmentState.REJECTED)) {
            throw new MultiApproveException(MultiApproveException.ASSIGNMENTSTATE_REJECTED);
        }
    }
}

