/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.ext.IApproveActivityTableUI;
import com.kingdee.bos.workflow.monitor.client.ActivityTableUI;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ApproveActivityTableStdUI
implements IApproveActivityTableUI {
    private static final Logger logger = CoreUIObject.getLogger(ApproveActivityTableStdUI.class);

    public CoreUIObject getApproveActivityTable(String billId) throws UIException {
        IEnactmentService service = null;
        ProcessInstInfo[] instInfoArray = null;
        String procInstId = null;
        try {
            service = EnactmentServiceFactory.createRemoteEnactService();
            instInfoArray = service.getAllProcessInstancesByBizobjId(billId);
        }
        catch (WfException e) {
            logger.error((Object)("\u83b7\u53d6IEnactmentService\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)("\u6839\u636e\u5355\u636eid\u83b7\u53d6\u6240\u6709\u6d41\u7a0b\u5b9e\u4f8b\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        if (instInfoArray != null && instInfoArray.length > 0) {
            procInstId = instInfoArray.length == 1 ? instInfoArray[0].getProcInstId() : this.getLatestProcInstIdByInstInfoArray(instInfoArray);
        }
        HashMap<String, String> uiContext = new HashMap<String, String>();
        uiContext.put("processInstId", procInstId);
        ActivityTableUI grid = (ActivityTableUI)UIFactoryHelper.initUIObject((String)ActivityTableUI.class.getName(), uiContext, new HashMap(), null);
        grid.hideBtnClose();
        return grid;
    }

    private String getLatestProcInstIdByInstInfoArray(ProcessInstInfo[] instInfoArray) {
        String procInstId = null;
        int latestSign = 0;
        Timestamp latest = instInfoArray[0].getCreatedTime();
        for (int i = 0; i < instInfoArray.length; ++i) {
            Timestamp time = instInfoArray[i].getCreatedTime();
            if (time.compareTo(latest) <= 0) continue;
            latest = time;
            latestSign = i;
        }
        procInstId = instInfoArray[latestSign].getProcInstId();
        return procInstId;
    }
}

