/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.multiapprove.MultiapproveUtils;
import com.kingdee.eas.base.multiapprove.client.AbstractCounterSignUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class CounterSignUI
extends AbstractCounterSignUI {
    private static final long serialVersionUID = 3681010842710489901L;
    private static final Logger logger = CoreUIObject.getLogger(CounterSignUI.class);
    private boolean isHistory = false;
    private String procInstId;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setSize(new Dimension(947, 650));
        this.kDTable1.setSize(new Dimension(947, 650));
        this.isHistory = false;
        this.kDTable1.getGroupManager().setGroup(true);
        this.procInstId = (String)this.getUIContext().get("procInstId");
        if (this.getUIContext().get("history") != null) {
            this.isHistory = Boolean.valueOf(this.getUIContext().get("history").toString());
        }
        this.fillTable(this.procInstId, this.isHistory);
    }

    private void fillTable(String procInstId, boolean isHistory) throws BOSException, SQLException {
        IRowSet rowSet = MultiapproveUtils.executeCounterSignQuery(procInstId, isHistory, this.getCurrentLocale());
        this.kDTable1.checkParsed();
        this.kDTable1.removeRows();
        this.kDTable1.setEditable(false);
        this.kDTable1.getColumn(2).setWidth(350);
        this.kDTable1.getColumn(6).setWidth(350);
        this.kDTable1.getMergeManager().setMergeMode(4);
        this.kDTable1.getColumn(2).getStyleAttributes().setWrapText(true);
        this.kDTable1.getColumn(2).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.kDTable1.getColumn(6).getStyleAttributes().setWrapText(true);
        this.kDTable1.getColumn(6).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        if (rowSet == null) {
            return;
        }
        ArrayList list = MultiApproveUtil.recordSet2ArrayList(rowSet);
        TreeMap treeMap = MultiapproveUtils.counterSignSortByGroup(list);
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            ArrayList signList = (ArrayList)treeMap.get(iterator.next());
            this.addAndMergerCounterSignRow(this.kDTable1, signList);
        }
    }

    private void addAndMergerCounterSignRow(KDTable table, ArrayList list) {
        ArrayList addList = MultiapproveUtils.filterCounterSign(list, this.getCurrentLocale());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int length = addList.size();
        int rowIndex = table.getRowCount();
        for (int i = 0; i < addList.size(); ++i) {
            Map item = (Map)addList.get(i);
            IRow row = this.kDTable1.addRow();
            row.getCell("initiator").setValue(item.get("FINITIATORNAME"));
            row.getCell("taskName").setValue(item.get("FACTDEFNAME"));
            row.getCell("initialOpinion").setValue(item.get("FASSIGNOPINION"));
            String initTime = sdf.format(item.get("FCREATEDTIME"));
            row.getCell("initialTime").setValue((Object)initTime);
            row.getCell("receiver").setValue(item.get("FPERSONEMPNAME"));
            row.getCell("approveResult").setValue(item.get("FISPASS"));
            row.getCell("approveOpinion").setValue(item.get("FOPINION"));
            row.getCell("approveTime").setValue(item.get("FAPPROVETIME"));
            KDTableHelper.autoFitRowHeight((KDTable)this.kDTable1, (int)row.getRowIndex());
        }
        table.getMergeManager().mergeBlock(rowIndex, 0, rowIndex + length - 1, 0);
        table.getMergeManager().mergeBlock(rowIndex, 1, rowIndex + length - 1, 1);
        table.getMergeManager().mergeBlock(rowIndex, 2, rowIndex + length - 1, 2);
        table.getMergeManager().mergeBlock(rowIndex, 3, rowIndex + length - 1, 3);
    }

    @Override
    public void actionViewHistory_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewHistory_actionPerformed(e);
        boolean bl = this.isHistory = !this.isHistory;
        if (this.isHistory) {
            this.btnViewHistory.setText(EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"82_CounterSignUI"));
        } else {
            this.btnViewHistory.setText(EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"83_CounterSignUI"));
        }
        this.fillTable(this.procInstId, this.isHistory);
    }
}

