/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ReferenceHumanType;
import com.kingdee.bos.workflow.define.RelationType;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.exception.WfParticipantException;
import com.kingdee.bos.workflow.participant.ParticipantUtils;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.multiapprove.MultiapproveUtils;
import com.kingdee.eas.base.multiapprove.client.AbstractDesignateNextActivityPerformerUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.uiframe.client.MainFrame;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.apache.log4j.Logger;

public class DesignateNextActivityPerformerUI
extends AbstractDesignateNextActivityPerformerUI {
    public static final String ACTIVITYINSTINFOMAP = "ActivityInstInfoMap";
    private static final Logger logger = CoreUIObject.getLogger(DesignateNextActivityPerformerUI.class);
    private IEnactmentService service;
    private List postActivities;
    private Map designatedPerformersMap;
    private Map objNameCache = new HashMap();
    private Map processInstInfoCache = new HashMap();
    private Map processDefCache = new HashMap();

    public static void designateNextActivityPerformer(CoreUIObject parent, String assignmentId) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isEmpty((String)assignmentId)) {
            throw new IllegalArgumentException();
        }
        try {
            EASWfServiceClient easWfServiceClient = new EASWfServiceClient();
            IEnactmentService service = easWfServiceClient.getService();
            AssignmentInfo assignmentInfo = service.getAssignmentById(assignmentId);
            String activityInstId = assignmentInfo.getActInstId();
            ActivityInstInfo activityInstInfo = service.getActivityInstByActInstId(activityInstId);
            if (activityInstInfo.getState().startsWith("closed")) {
                String msg = MultiApproveUtil.getMultiApproveResource("HAVENO_WORKFLOWACTIVITY");
                MsgBox.showInfo((Component)parent, (String)msg);
                return;
            }
            HashMap<String, ActivityInstInfo> activityInstInfoMap = new HashMap<String, ActivityInstInfo>();
            activityInstInfoMap.put(activityInstInfo.getActDefId().toString(), activityInstInfo);
            DesignateNextActivityPerformerUI.designateNextActivityPerformer(parent, activityInstInfoMap);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ExceptionHandler.handle((Component)parent, (Throwable)e);
        }
    }

    public static void designateNextActivityPerformer(CoreUIObject parent, Map activityInstInfoMap) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        if (activityInstInfoMap == null || activityInstInfoMap.size() <= 0) {
            throw new IllegalArgumentException();
        }
        try {
            EASWfServiceClient easWfServiceClient = new EASWfServiceClient();
            IEnactmentService service = easWfServiceClient.getService();
            Collection activityInstInfoCollection = activityInstInfoMap.values();
            Iterator iterator = activityInstInfoCollection.iterator();
            while (iterator.hasNext()) {
                ManpowerActivityDef activityDef;
                ActivityInstInfo activityInstInfo = (ActivityInstInfo)iterator.next();
                String actDefId = activityInstInfo.getActDefId();
                ProcessDef processDef = null;
                if (processDef == null) {
                    String procInstId = activityInstInfo.getProcInstId();
                    ProcessInstInfo processInstInfo = service.getProcessInstInfo(procInstId);
                    processDef = ApplicationUtil.getProcessDefByDefHashValue((String)processInstInfo.getProcDefHashValue());
                }
                if ((activityDef = (ManpowerActivityDef)processDef.getActivityDef(actDefId)).canSpecifyNextActivityPerformer()) continue;
                iterator.remove();
            }
            if (activityInstInfoMap.size() <= 0) {
                String msg = MultiApproveUtil.getMultiApproveResource("CANNOT_DESIGNATENEXTPERFORMER");
                MsgBox.showInfo((Component)parent, (String)msg);
                return;
            }
            UIContext uiContext = new UIContext((Object)parent);
            uiContext.put((Object)ACTIVITYINSTINFOMAP, (Object)activityInstInfoMap);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow window = uiFactory.create(DesignateNextActivityPerformerUI.class.getName(), (Map)uiContext);
            window.show();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)parent, (Throwable)e);
        }
    }

    public static void designateNextActivityPerformerByBillId(CoreUIObject parent, String businessObjId) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isEmpty((String)businessObjId)) {
            throw new IllegalArgumentException();
        }
        try {
            EASWfServiceClient easWfServiceClient = new EASWfServiceClient();
            IEnactmentService service = easWfServiceClient.getService();
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            HashMap<String, ActivityInstInfo> activityInstInfoMap = new HashMap<String, ActivityInstInfo>();
            AssignmentInfo[] assignmentInfoArray = service.checkAssignmentInfos(businessObjId, userId);
            for (int i = 0; i <= assignmentInfoArray.length - 1; ++i) {
                String activityInstId = assignmentInfoArray[i].getActInstId();
                ActivityInstInfo activityInstInfo = service.getActivityInstByActInstId(activityInstId);
                if (activityInstInfo.getState().startsWith("closed")) continue;
                activityInstInfoMap.put(activityInstInfo.getActDefId().toString(), activityInstInfo);
            }
            if (activityInstInfoMap.size() <= 0) {
                String msg = MultiApproveUtil.getMultiApproveResource("HAVENO_WORKFLOWACTIVITY");
                MsgBox.showInfo((Component)parent, (String)msg);
                return;
            }
            DesignateNextActivityPerformerUI.designateNextActivityPerformer(parent, activityInstInfoMap);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)parent, (Throwable)e);
        }
    }

    public DesignateNextActivityPerformerUI() throws Exception {
        EASWfServiceClient wfServiceClient = new EASWfServiceClient();
        this.service = wfServiceClient.getService();
        this.postActivities = new ArrayList();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiContext = this.getUIContext();
        Map activityInstInfoMap = (Map)uiContext.get(ACTIVITYINSTINFOMAP);
        this.initializeData(activityInstInfoMap);
        this.postActDefCmbBx.addItemListener((ItemListener)new PostActivityDefItemListener());
        this.postActDefCmbBx.setRenderer((ListCellRenderer)new PostAcivityDefRenderer());
        this.postActDefCmbBx.setModel((ComboBoxModel)new PostActivityDefComboBoxModel(this.postActivities));
        this.prtcpntCmbBx.addItemListener((ItemListener)new ParticipantDefItemListener());
        this.prtcpntCmbBx.setRenderer((ListCellRenderer)new ParticipantDefRender());
        this.designatedPerformersMap = new HashMap();
        int itemCount = this.postActDefCmbBx.getItemCount();
        for (int i = 0; i <= itemCount - 1; ++i) {
            PostActivity postActivity = (PostActivity)this.postActDefCmbBx.getItemAt(i);
            String procInstId = postActivity.getProcInstId();
            ManpowerActivityDef postActDef = postActivity.getActivityDef();
            String dataFieldName = this.getDataFieldName(postActDef);
            Object dataFieldValueObj = this.service.getProcessContext(procInstId, dataFieldName);
            List performerList = new ArrayList();
            if (dataFieldValueObj != null) {
                if (dataFieldValueObj instanceof List) {
                    try {
                        performerList = this.convertToPersonInfoList((List)dataFieldValueObj);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("convertToPersonInfoList failed", e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
            this.designatedPerformersMap.put(dataFieldName, performerList);
        }
        this.prfrmrLst.setCellRenderer((ListCellRenderer)new PerformerRender());
        this.postActDefCmbBx.setSelectedIndex(-1);
        this.postActDefCmbBx.setSelectedIndex(0);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.addBtn.setText(null);
        this.addBtn.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.deleteBtn.setText(null);
        this.deleteBtn.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void confirmAction_actionPerformed(ActionEvent e) throws Exception {
        if (this.designatedPerformersMap == null) {
            throw new IllegalArgumentException();
        }
        boolean empty = true;
        for (ArrayList value : this.designatedPerformersMap.values()) {
            if (value == null || value.size() <= 0) continue;
            empty = false;
        }
        if (empty) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"NO_NEXT_PERSON"));
            return;
        }
        for (int i = 0; i < this.postActivities.size(); ++i) {
            PostActivity postActivity = (PostActivity)this.postActivities.get(i);
            String procInstId = postActivity.getProcInstId();
            String dtFldNm = this.getDataFieldName(postActivity.getActivityDef());
            List prfrmrLst = (List)this.designatedPerformersMap.get(dtFldNm);
            if (prfrmrLst == null || prfrmrLst.size() <= 0) continue;
            List prsnIdLst = MultiapproveUtils.convertToPersonIdList(prfrmrLst);
            this.service.setProcessContext(procInstId, dtFldNm, (Object)prsnIdLst);
        }
        this.getUIWindow().close();
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    public void addPerformerAction_actionPerformed(ActionEvent e) throws Exception {
        Object data = this.prfrmrPrmptBx.getData();
        if (data instanceof PersonInfo) {
            PersonInfo performer = (PersonInfo)data;
            this.prfrmrLst.addElement((Object)performer);
        }
    }

    @Override
    public void deletePerformerAction_actionPerformed(ActionEvent e) throws Exception {
        int selectedIndex = this.prfrmrLst.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        this.prfrmrLst.removeElementAt(selectedIndex);
    }

    private ProcessInstInfo getProcessInstInfo(String procInstId) throws WfException {
        if (procInstId == null || procInstId.length() == 0) {
            throw new IllegalArgumentException();
        }
        ProcessInstInfo processInstInfo = (ProcessInstInfo)this.processInstInfoCache.get(procInstId);
        if (processInstInfo == null) {
            processInstInfo = this.service.getProcessInstInfo(procInstId);
            this.processInstInfoCache.put(procInstId, processInstInfo);
        }
        return processInstInfo;
    }

    private String getProcessInstId() {
        PostActivity postActivity = (PostActivity)this.postActDefCmbBx.getSelectedItem();
        return postActivity.getProcInstId();
    }

    private ProcessDef getProcessDef(String procInstId) throws WfException {
        if (procInstId == null || procInstId.length() == 0) {
            throw new IllegalArgumentException();
        }
        try {
            ProcessInstInfo processInstInfo = this.getProcessInstInfo(procInstId);
            String procDefId = processInstInfo.getProcDefId();
            ProcessDef processDef = (ProcessDef)this.processDefCache.get(procDefId);
            if (processDef == null) {
                processDef = ApplicationUtil.getProcessDefByDefHashValue((String)processInstInfo.getProcDefHashValue());
                this.processDefCache.put(procDefId, processDef);
            }
            return processDef;
        }
        catch (BOSException ex) {
            throw new WfException((Throwable)ex);
        }
    }

    private ProcessDef getProcessDef(ActivityInstInfo activityInstInfo) throws WfException {
        if (activityInstInfo == null) {
            throw new IllegalArgumentException();
        }
        String procInstId = activityInstInfo.getProcInstId();
        ProcessDef processDef = this.getProcessDef(procInstId);
        return processDef;
    }

    private Map getPostActivities(ActivityInstInfo activityInstInfo) throws WfException {
        if (activityInstInfo == null) {
            throw new IllegalArgumentException();
        }
        ProcessDef processDef = this.getProcessDef(activityInstInfo);
        String activityDefId = activityInstInfo.getActDefId();
        ManpowerActivityDef activityDef = (ManpowerActivityDef)processDef.getActivityDef(activityDefId);
        String procInstId = activityInstInfo.getProcInstId().toString();
        return this.getPostActivities0(procInstId, (ActivityDef)activityDef);
    }

    private Map getPostActivities0(String procInstId, ActivityDef activityDef) throws WfException {
        if (procInstId == null || procInstId.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (activityDef == null) {
            throw new IllegalArgumentException();
        }
        HashMap<PostActivityKey, PostActivity> postActivities = new HashMap<PostActivityKey, PostActivity>();
        ActivityCollection activities = activityDef.getPostActivities();
        if (activities == null || activities.size() == 0) {
            return postActivities;
        }
        for (ActivityDef activity : activities) {
            if (activity instanceof ManpowerActivityDef) {
                ManpowerActivityDef manpowerActivityDef = (ManpowerActivityDef)activity;
                if (!manpowerActivityDef.canSpecifyNextActivityPerformer()) continue;
                PostActivityKey key = new PostActivityKey(procInstId, activity.getID().toString());
                PostActivity postActivity = new PostActivity(procInstId, (ManpowerActivityDef)activity);
                postActivities.put(key, postActivity);
                continue;
            }
            if (!(activity instanceof ToolActivityDef) && !(activity instanceof RouterActivityDef)) continue;
            postActivities.putAll(this.getPostActivities0(procInstId, activity));
        }
        return postActivities;
    }

    private void initializeData(Map activityInstInfoMap) throws WfException {
        if (activityInstInfoMap == null || activityInstInfoMap.size() <= 0) {
            throw new IllegalArgumentException();
        }
        EASWfServiceClient easWfServiceClient = new EASWfServiceClient();
        this.service = easWfServiceClient.getService();
        HashMap postActivities = new HashMap();
        for (Map.Entry entry : activityInstInfoMap.entrySet()) {
            ActivityInstInfo activityInstInfo = (ActivityInstInfo)entry.getValue();
            postActivities.putAll(this.getPostActivities(activityInstInfo));
        }
        this.postActivities.addAll(postActivities.values());
        if (this.postActivities.size() <= 0) {
            String msg = MultiApproveUtil.getMultiApproveResource("HAVENOSUITPWORKFLOWACTIVITY");
            MsgBox.showInfo((Component)this.getOwner(), (String)msg);
            this.abort();
        }
    }

    private Component getOwner() {
        return (Component)this.getUIContext().get("Owner");
    }

    private String getParticipantName(String procInstId, ParticipantDef prtcpntDef) throws BOSException, EASBizException {
        if (prtcpntDef == null) {
            String msg = "\"prtcpntDef\" is null!";
            throw new IllegalArgumentException(msg);
        }
        String prtcpntName = this.getObjNameFromCache(prtcpntDef.getID());
        if (!StringUtils.isEmpty((String)prtcpntName)) {
            return prtcpntName;
        }
        String result = "";
        ParticipantType participantType = prtcpntDef.getParticipantType();
        if (ParticipantType.ALL.equals((Object)participantType)) {
            result = MultiapproveUtils.getResString("PARTICIPANT_ALL");
        } else if (ParticipantType.HUMAN.equals((Object)participantType)) {
            result = MultiapproveUtils.getResString("PARTICIPANT_HUMAN");
        } else if (ParticipantType.ORGANIZATIONAL_UNIT_ALLMEMBER.equals((Object)participantType)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(MultiapproveUtils.getResString("PARTICIPANT_ORGANIZATIONAL_UNIT_ALLMEMBER"));
            buffer.append("-");
            String orgName = MultiapproveUtils.getParticipantOrgName(prtcpntDef);
            buffer.append(orgName);
            result = buffer.toString();
        } else if (ParticipantType.ORGANIZATIONAL_UNIT_MEMBER.equals((Object)participantType)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(MultiapproveUtils.getResString("PARTICIPANT_ORGANIZATIONAL_UNIT_MEMBER"));
            buffer.append("-");
            String orgName = MultiapproveUtils.getParticipantOrgName(prtcpntDef);
            buffer.append(orgName);
            result = buffer.toString();
        } else if (ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER.equals((Object)participantType)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(MultiapproveUtils.getResString("PARTICIPANT_ORGANIZATIONAL_UNIT_PERMISSION_OWNER"));
            buffer.append("-");
            String orgName = MultiapproveUtils.getParticipantOrgName(prtcpntDef);
            buffer.append(orgName);
            result = buffer.toString();
        } else if (ParticipantType.ORGANIZATIONAL_UNIT_PRINCIPAL.equals((Object)participantType)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(MultiapproveUtils.getResString("PARTICIPANT_ORGANIZATIONAL_UNIT_PRINCIPAL"));
            buffer.append("-");
            String orgName = MultiapproveUtils.getParticipantOrgName(prtcpntDef);
            buffer.append(orgName);
            result = buffer.toString();
        } else {
            if (ParticipantType.PERMISSION_OWNER.equals((Object)participantType)) {
                throw new UnsupportedOperationException();
            }
            if (ParticipantType.ORGANIZATIONAL_UNIT_JOB.equals((Object)participantType)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(MultiapproveUtils.getResString("PARTICIPANT_JOB"));
                buffer.append("-" + prtcpntDef.getOrgName());
                buffer.append("-" + prtcpntDef.getName());
                result = buffer.toString();
            } else if (ParticipantType.POSITION.equals((Object)participantType)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(MultiapproveUtils.getResString("PARTICIPANT_POSITION"));
                buffer.append("-" + prtcpntDef.getOrgID());
                String positionId = prtcpntDef.getParticipantValue();
                String positionName = MultiapproveUtils.getPositionInfo(positionId).getName();
                buffer.append("-");
                buffer.append(positionName);
                result = buffer.toString();
            } else if (ParticipantType.PROCESS_RESPONSIBILITY.equals((Object)participantType)) {
                result = MultiapproveUtils.getResString("PARTICIPANT_PROCESS_RESPONSIBILITY");
            } else if (ParticipantType.RELATION.equals((Object)participantType)) {
                ReferenceHumanType referenceHumanType = prtcpntDef.getReferenceHumanType();
                String referenceHumanTypeName = MultiapproveUtils.getReferenceHumanTypeName(referenceHumanType);
                RelationType relationType = prtcpntDef.getRelationType();
                String relationTypeName = MultiapproveUtils.getRelationTypeName(relationType);
                StringBuffer buffer = new StringBuffer();
                buffer.append(MultiapproveUtils.getResString("PARTICIPANT_RELATION"));
                buffer.append("-" + referenceHumanTypeName);
                buffer.append("-" + relationTypeName);
                buffer.append("-" + this.getRelationParticipantName(procInstId, prtcpntDef));
                result = buffer.toString();
            } else if (ParticipantType.GROUP.equals((Object)participantType)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(MultiapproveUtils.getResString("PARTICIPANT_GROUP"));
                buffer.append("-" + prtcpntDef.getName());
                result = buffer.toString();
            } else if (ParticipantType.ORGANIZATIONAL_UNIT_SCOPE.equals((Object)participantType)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(MultiapproveUtils.getResString("PARTICIPANT_ORGSCOPE"));
                buffer.append("-" + prtcpntDef.getName());
            } else {
                if (ParticipantType.RESOURCE.equals((Object)participantType)) {
                    throw new UnsupportedOperationException();
                }
                if (ParticipantType.RESOURCE_SET.equals((Object)participantType)) {
                    throw new UnsupportedOperationException();
                }
                if (ParticipantType.ROLE.equals((Object)participantType)) {
                    throw new UnsupportedOperationException();
                }
                if (ParticipantType.SYSTEM.equals((Object)participantType)) {
                    throw new UnsupportedOperationException();
                }
                if (ParticipantType.USER.equals((Object)participantType)) {
                    throw new UnsupportedOperationException();
                }
                if (ParticipantType.VARIANT.equals((Object)participantType)) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(MultiapproveUtils.getResString("PARTICIPANT_VARIANT"));
                    String dataFieldId = prtcpntDef.getPerformDatafieldId();
                    ProcessDef processDef = this.getProcessDef(procInstId);
                    String dataFieldName = processDef.getDataFieldDef(dataFieldId).getName();
                    buffer.append("-" + dataFieldName);
                    result = buffer.toString();
                } else {
                    throw new UnsupportedOperationException();
                }
            }
        }
        if (!StringUtils.isEmpty((String)result)) {
            this.addObjNameToCache(prtcpntDef.getID(), result);
        }
        return result;
    }

    private String getRelationParticipantName(String procInstId, ParticipantDef participantDef) throws BOSException, EASBizException {
        if (participantDef == null) {
            throw new IllegalArgumentException();
        }
        ProcessInstInfo processInstInfo = this.getProcessInstInfo(procInstId);
        ProcessDef processDef = this.getProcessDef(procInstId);
        ReferenceHumanType referenceHumanType = participantDef.getReferenceHumanType();
        if (ReferenceHumanType.ACTIVITY_PERFORMER.equals((Object)referenceHumanType)) {
            String activityDefId = participantDef.getReferenceHumanId();
            ActivityDef activityDef = processDef.getActivityDef(activityDefId);
            String activityDefName = activityDef.getName(this.getCurrentLocale());
            return activityDefName;
        }
        if (ReferenceHumanType.EMPLOYEE.equals((Object)referenceHumanType)) {
            String personId = participantDef.getReferenceHumanId();
            String personName = MultiApproveUtil.getPersonInfo(personId).getName();
            return personName;
        }
        if (ReferenceHumanType.POSITION.equals((Object)referenceHumanType)) {
            String positionId = participantDef.getReferenceHumanId();
            String positionName = MultiapproveUtils.getPositionInfo(positionId).getName();
            return positionName;
        }
        if (ReferenceHumanType.PROCESS_INITIATOR.equals((Object)referenceHumanType)) {
            String initiatorId = processInstInfo.getInitiatorId();
            String initiatorName = MultiapproveUtils.getUserInfo(initiatorId).getName();
            return initiatorName;
        }
        if (ReferenceHumanType.PROCESS_VARIABLE.equals((Object)referenceHumanType)) {
            String dataFieldId = participantDef.getReferenceHumanId();
            String dataFieldName = processDef.getDataFieldDef(dataFieldId).getName();
            return dataFieldName;
        }
        if (ReferenceHumanType.ORGNIZATION.equals((Object)referenceHumanType)) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    private String getObjNameFromCache(String key) {
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException();
        }
        return (String)this.objNameCache.get(key);
    }

    private void addObjNameToCache(String key, String name) {
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException();
        }
        this.objNameCache.put(key, name);
    }

    private void configPerformerSelector(String procInstId, ParticipantDef participantDef) {
        if (participantDef == null) {
            throw new IllegalArgumentException();
        }
        this.prfrmrPrmptBx.setEnabled(true);
        this.prfrmrPrmptBx.setData(null);
        try {
            Frame frame = (Frame)Util.getComponent((Component)((Object)this), (String)MainFrame.class.getName());
            KDCommonPromptDialog dialog = new KDCommonPromptDialog(frame);
            ParticipantType participantType = participantDef.getParticipantType();
            if (ParticipantType.ALL.equals((Object)participantType)) {
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                this.prfrmrPrmptBx.setSelector((KDPromptSelector)dialog);
                this.prfrmrPrmptBx.setQueryInfo("com.kingdee.eas.basedata.person.app.AllPersonQuery");
                this.prfrmrPrmptBx.setEntityViewInfo(entityViewInfo);
            } else {
                this.configPerformerSelectorByWf(procInstId, participantDef);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void addPersonsFilter(FilterInfo filterInfo, String property, List personIdList) {
        if (filterInfo == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isEmpty((String)property)) {
            throw new IllegalArgumentException();
        }
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        if (personIdList == null || personIdList.size() == 0) {
            FilterItemInfo filterItem = new FilterItemInfo();
            filterItem.setPropertyName(property);
            filterItem.setCompareType(CompareType.EQUALS);
            filterItem.setCompareValue((Object)"");
            filterItems.add(filterItem);
            return;
        }
        int index = 0;
        String mask = "";
        Iterator iterator = personIdList.iterator();
        while (iterator.hasNext()) {
            if (index > 0) {
                mask = mask + " or ";
            }
            mask = mask + "(#" + index + ")";
            String personId = (String)iterator.next();
            FilterItemInfo filterItem = new FilterItemInfo();
            filterItem.setPropertyName(property);
            filterItem.setCompareType(CompareType.EQUALS);
            filterItem.setCompareValue((Object)personId);
            filterItems.add(filterItem);
            ++index;
        }
        filterInfo.setMaskString(mask);
    }

    private List getPersonIdList(String procInstId, String activityDefId, ParticipantDef participantDef) throws WfException {
        ArrayList<String> participantIdList = new ArrayList<String>();
        participantIdList.add(participantDef.getID());
        List participants = new ArrayList();
        try {
            participants = this.service.getPersonsByParticipants(procInstId, activityDefId, participantIdList);
        }
        catch (Exception e) {
            String msg;
            if (e.getCause() instanceof WfParticipantException) {
                if (e.getCause().getMessage().equals("have no such adminOrg!")) {
                    msg = EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"88_DesignateNextActivityPerformerUI");
                    MsgBox.showInfo((Component)((Object)this), (String)msg);
                }
            }
            if (e.getCause() instanceof ObjectNotFoundException) {
                msg = EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"89_DesignateNextActivityPerformerUI");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
            }
            msg = EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"89_DesignateNextActivityPerformerUI");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
        }
        ArrayList<String> personIdList = new ArrayList<String>();
        Iterator iterator = participants.iterator();
        while (iterator.hasNext()) {
            String personId = ((Person)iterator.next()).getEmployeeId();
            personIdList.add(personId);
        }
        return personIdList;
    }

    private void configPerformerSelectorByWf(String procInstId, ParticipantDef participantDef) throws WfException {
        PostActivity postActivity = (PostActivity)this.postActDefCmbBx.getSelectedItem();
        ManpowerActivityDef postAcDef = postActivity.getActivityDef();
        String actDefId = postAcDef.getID();
        List personIdList = this.getPersonIdList(procInstId, actDefId, participantDef);
        FilterInfo filterInfo = new FilterInfo();
        this.addPersonsFilter(filterInfo, "id", personIdList);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        Frame frame = (Frame)Util.getComponent((Component)((Object)this), (String)MainFrame.class.getName());
        KDCommonPromptDialog dialog = new KDCommonPromptDialog(frame);
        this.prfrmrPrmptBx.setSelector((KDPromptSelector)dialog);
        this.prfrmrPrmptBx.setQueryInfo("com.kingdee.eas.basedata.person.app.AllPersonQuery");
        this.prfrmrPrmptBx.setEntityViewInfo(entityViewInfo);
    }

    private List convertToPersonInfoList(List personIdList) throws BOSException, EASBizException {
        ArrayList<PersonInfo> result = new ArrayList<PersonInfo>();
        if (personIdList == null || personIdList.size() <= 0) {
            return result;
        }
        for (String personId : personIdList) {
            PersonInfo personInfo = MultiApproveUtil.getPersonInfo(personId);
            result.add(personInfo);
        }
        return result;
    }

    private String getCurrentDataFieldName() {
        PostActivity postActivity = (PostActivity)this.postActDefCmbBx.getSelectedItem();
        ManpowerActivityDef postActDef = postActivity.getActivityDef();
        if (postActDef == null) {
            return "";
        }
        return this.getDataFieldName(postActDef);
    }

    private String getDataFieldName(ManpowerActivityDef postActivity) {
        String dataFieldName = ParticipantUtils.createDesignatePerformerKey((ActivityDef)postActivity);
        return dataFieldName;
    }

    private List getDesignatedPerformerList() {
        String dataFieldName = this.getCurrentDataFieldName();
        if (StringUtils.isEmpty((String)dataFieldName)) {
            return null;
        }
        List performerList = (List)this.designatedPerformersMap.get(dataFieldName);
        return performerList;
    }

    private class PostActivityKey {
        private String procInstId;
        private String postActDefId;

        public PostActivityKey(String procInstId, String postActDefId) {
            if (procInstId == null || procInstId.length() == 0) {
                throw new IllegalArgumentException();
            }
            if (postActDefId == null || postActDefId.length() == 0) {
                throw new IllegalArgumentException();
            }
            this.procInstId = procInstId;
            this.postActDefId = postActDefId;
        }

        public String getPostActDefId() {
            return this.postActDefId;
        }

        public String getProcInstId() {
            return this.procInstId;
        }

        public int hashCode() {
            String keyStr = this.getProcInstId() + this.getPostActDefId();
            return keyStr.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PostActivityKey)) {
                return false;
            }
            PostActivityKey key = (PostActivityKey)obj;
            return key.getProcInstId().equals(this.getProcInstId()) && key.getPostActDefId().equals(this.getPostActDefId());
        }
    }

    private class PostActivity {
        private String procInstId;
        private ManpowerActivityDef activityDef;

        public PostActivity(String procInstId, ManpowerActivityDef activityDef) {
            if (procInstId == null || procInstId.length() == 0) {
                throw new IllegalArgumentException();
            }
            if (activityDef == null) {
                throw new IllegalArgumentException();
            }
            this.procInstId = procInstId;
            this.activityDef = activityDef;
        }

        public ManpowerActivityDef getActivityDef() {
            return this.activityDef;
        }

        public String getProcInstId() {
            return this.procInstId;
        }
    }

    private class PerformerRender
    extends DefaultListCellRenderer {
        private PerformerRender() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof PersonInfo)) {
                return this;
            }
            PersonInfo person = (PersonInfo)value;
            String number = person.getNumber();
            String name = person.getName();
            this.setText(number + "-" + name);
            return this;
        }
    }

    private class PerformersModel
    extends DefaultListModel {
        private List performers;

        public PerformersModel(List prfrmrs) {
            if (prfrmrs == null) {
                throw new IllegalArgumentException();
            }
            this.performers = prfrmrs;
        }

        @Override
        public boolean contains(Object elem) {
            if (this.performers == null) {
                return false;
            }
            return this.performers.contains(elem);
        }

        public void add(int index, Object element) {
            if (this.performers == null) {
                return;
            }
            this.performers.add(index, element);
            this.fireIntervalAdded(this, index, index);
        }

        public Object remove(int index) {
            if (this.performers == null) {
                return null;
            }
            Object result = this.performers.remove(index);
            this.fireIntervalRemoved(this, index, index);
            return result;
        }

        @Override
        public void removeAllElements() {
            if (this.performers == null) {
                return;
            }
            int size = this.getSize();
            this.performers.clear();
            if (size >= 0) {
                this.fireIntervalRemoved(this, 0, size);
            }
        }

        @Override
        public boolean removeElement(Object obj) {
            if (this.performers == null) {
                return false;
            }
            int index = this.indexOf(obj);
            boolean result = this.performers.remove(obj);
            if (index >= 0) {
                this.fireIntervalRemoved(this, index, index);
            }
            return result;
        }

        @Override
        public void removeElementAt(int index) {
            if (this.performers == null) {
                return;
            }
            this.performers.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }

        @Override
        public Object getElementAt(int index) {
            if (this.performers == null) {
                return null;
            }
            return this.performers.get(index);
        }

        public void addElement(Object obj) {
            if (this.performers == null) {
                return;
            }
            if (this.contains(obj)) {
                return;
            }
            int size = this.getSize();
            this.performers.add(obj);
            this.fireIntervalAdded(this, size, size);
        }

        @Override
        public int getSize() {
            if (this.performers == null) {
                return 0;
            }
            return this.performers.size();
        }

        @Override
        public int indexOf(Object elem) {
            if (this.performers == null) {
                return -1;
            }
            return this.performers.indexOf(elem);
        }
    }

    private class ParticipantDefItemListener
    implements ItemListener {
        private ParticipantDefItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            int stateChange = e.getStateChange();
            if (1 != stateChange) {
                return;
            }
            ParticipantDef participantDef = (ParticipantDef)e.getItem();
            DesignateNextActivityPerformerUI.this.configPerformerSelector(DesignateNextActivityPerformerUI.this.getProcessInstId(), participantDef);
        }
    }

    private class ParticipantDefRender
    extends BasicComboBoxRenderer {
        private ParticipantDefRender() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return this;
            }
            try {
                this.setText(DesignateNextActivityPerformerUI.this.getParticipantName(DesignateNextActivityPerformerUI.this.getProcessInstId(), (ParticipantDef)value));
                this.setToolTipText(DesignateNextActivityPerformerUI.this.getParticipantName(DesignateNextActivityPerformerUI.this.getProcessInstId(), (ParticipantDef)value));
                return this;
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)DesignateNextActivityPerformerUI.this), (Throwable)e);
                return this;
            }
        }
    }

    private class ParticipantDefComboBoxModel
    extends DefaultComboBoxModel {
        ParticipantDefComboBoxModel(ManpowerActivityDef activityDef) {
            ParticipantCollection participants = activityDef.getParticipants();
            for (Object participantDefObj : participants) {
                if (!(participantDefObj instanceof ParticipantDef)) continue;
                this.addElement(participantDefObj);
            }
        }
    }

    private class PostActivityDefItemListener
    implements ItemListener {
        private PostActivityDefItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            int stateChange = e.getStateChange();
            if (1 != stateChange) {
                return;
            }
            PostActivity postActivity = (PostActivity)e.getItem();
            ManpowerActivityDef postActivityDef = postActivity.getActivityDef();
            DesignateNextActivityPerformerUI.this.prtcpntCmbBx.setModel((ComboBoxModel)new ParticipantDefComboBoxModel(postActivityDef));
            DesignateNextActivityPerformerUI.this.prtcpntCmbBx.setSelectedIndex(-1);
            DesignateNextActivityPerformerUI.this.prtcpntCmbBx.setSelectedIndex(0);
            List performers = DesignateNextActivityPerformerUI.this.getDesignatedPerformerList();
            PerformersModel model = new PerformersModel(performers);
            DesignateNextActivityPerformerUI.this.prfrmrLst.setModel((ListModel)model);
        }
    }

    private class PostAcivityDefRenderer
    extends BasicComboBoxRenderer {
        private PostAcivityDefRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return this;
            }
            PostActivity postActivity = (PostActivity)value;
            ManpowerActivityDef postActivityDef = postActivity.getActivityDef();
            Locale locale = DesignateNextActivityPerformerUI.this.getCurrentLocale();
            String postActivityName = postActivityDef.getName(locale);
            this.setText(postActivityName);
            this.setToolTipText(postActivityName);
            return this;
        }
    }

    private class PostActivityDefComboBoxModel
    extends DefaultComboBoxModel {
        PostActivityDefComboBoxModel(List sbsqnts) {
            super(new Vector(sbsqnts));
        }
    }
}

