/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.bos.workflow.monitor.IDynamicWfServiceFacade;
import com.kingdee.bos.workflow.monitor.IWfUtil;
import com.kingdee.bos.workflow.monitor.WfFacadeUtilFactory;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.bos.workflow.monitor.client.WfMonitorUtils;
import com.kingdee.bos.workflow.service.IDynamicWfService;
import com.kingdee.eas.base.multiapprove.client.AbstractJumpToUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class JumpToUI
extends AbstractJumpToUI {
    private static final Logger logger = CoreUIObject.getLogger(JumpToUI.class);
    private static final String multiApproveResourcefile = "com.kingdee.eas.base.multiapprove.MultiApproveResource";
    public static final String ASSIGN_ID = "assignId";
    public static final String PROCINST_ID = "procInstId";
    public static final String COMMENT = "comment";
    public static final String SEND_MAIL = "sendMail";
    public static final String SEND_SMS = "sendSMS";
    public static final String JUMP_RESULT = "jumpResult";
    public static final String JUMP_UI_CONTEXT_MAP = "jumpUIContextMap";
    private String assignId;
    private String procInstId;
    private HashMap jumpMap;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnViewWorkFlow.setIcon(EASResource.getIcon((String)"imgTbtn_flowstakeout"));
        this.jumpMap = (HashMap)this.getUIContext().get(JUMP_UI_CONTEXT_MAP);
        this.assignId = (String)this.jumpMap.get(ASSIGN_ID);
        this.procInstId = (String)this.jumpMap.get(PROCINST_ID);
        if (!StringUtils.isEmpty((String)this.assignId)) {
            IDynamicWfServiceFacade svc = WfFacadeUtilFactory.createRemoteDynamicWfService();
            IDynamicWfService.JumpTarget[] targets = svc.getJumpToTargets(this.assignId);
            if (targets.length == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)multiApproveResourcefile, (String)"noTargetJump"));
                SysUtil.abort();
            }
            this.fillTable(targets);
        }
    }

    private void fillTable(IDynamicWfService.JumpTarget[] targets) {
        this.kDTable1.removeRows();
        this.kDTable1.checkParsed();
        this.kDTable1.getSelectManager().setSelectMode(2);
        IRow row = null;
        IDynamicWfService.JumpTarget activity = null;
        for (int i = 0; i < targets.length; ++i) {
            activity = targets[i];
            row = this.kDTable1.addRow(i);
            ICell cellName = row.getCell(0);
            cellName.setValue((Object)activity.actDefName);
            ICell cellParticipant = row.getCell(1);
            cellParticipant.setValue((Object)activity.participants);
            row.setUserObject((Object)activity);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void viewWorkFlowAction_actionPerformed(ActionEvent e) throws Exception {
        WfMonitorUtils.showWfDiagram((Component)((Object)this), (String)this.procInstId);
    }

    @Override
    public void jumpToAction_actionPerformed(ActionEvent e) {
        boolean flag = false;
        IRow row = this.kDTable1.getRow(this.kDTable1.getSelectManager().getActiveRowIndex());
        if (row == null) {
            MsgBox.showWarning((String)EASResource.getString((String)multiApproveResourcefile, (String)"selectTarget"));
            return;
        }
        int result = MsgBox.showConfirm2((String)EASResource.getString((String)multiApproveResourcefile, (String)"confirmToJump"));
        if (result != 0) {
            return;
        }
        try {
            String comment;
            IDynamicWfService.JumpTarget target = (IDynamicWfService.JumpTarget)row.getUserObject();
            IDynamicWfServiceFacade svc = WfFacadeUtilFactory.createRemoteDynamicWfService();
            String opinion = this.txtOpinion.getText().trim() + "jumpto";
            target.comment = comment = (String)this.jumpMap.get(COMMENT);
            target.sendMail = "true".equals(this.jumpMap.get(SEND_MAIL));
            target.sendSMS = "true".equals(this.jumpMap.get(SEND_SMS));
            target.handlerOpinion = 0;
            target.handlerContent = EASResource.getString((String)multiApproveResourcefile, (String)"jumpHandlerContent");
            IWfUtil util = (IWfUtil)RpcProxy.wrapRequired(IWfUtil.class, (String)WfUtil.class.getName());
            util.jumpTo(this.procInstId, target.actDefId, opinion);
            MsgBox.showInfo((String)EASResource.getString((String)multiApproveResourcefile, (String)"jumpSuccess"));
            flag = true;
        }
        catch (Exception ex) {
            logger.error((Object)"jumpToAction_actionPerformed error", (Throwable)ex);
            MsgBox.showInfo((String)EASResource.getString((String)multiApproveResourcefile, (String)"jumpFail"));
        }
        this.getUIWindow().close();
        this.getUIContext().put(JUMP_RESULT, String.valueOf(flag));
    }

    @Override
    public void cancleAction_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

