/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.monitor.IDynamicWfServiceFacade;
import com.kingdee.bos.workflow.monitor.IWfUtil;
import com.kingdee.bos.workflow.monitor.WfFacadeUtilFactory;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.bos.workflow.monitor.client.WfMonitorUtils;
import com.kingdee.bos.workflow.participant.ParticipantUtils;
import com.kingdee.bos.workflow.service.IDynamicWfService;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.KickBackUtils;
import com.kingdee.eas.base.multiapprove.client.AbstractKickBackUI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class KickBackUI
extends AbstractKickBackUI {
    private static final Logger logger = CoreUIObject.getLogger(KickBackUI.class);
    private static final String multiApproveResourcefile = "com.kingdee.eas.base.multiapprove.MultiApproveResource";
    public static final String KICKBACK_UI_CONTEXT_MAP = "kickBackUIContextMap";
    public static final String KICKBACK_RESULT = "kickBackResult";
    public static final String ASSIGN_ID = "assignId";
    public static final String PROCINST_ID = "procInstId";
    public static final String COMMENT = "comment";
    private String procInstId;
    private String assignId;
    private HashMap kickBakMap;
    private IDynamicWfService.JumpTarget[] targets;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnViewWorkFlow.setIcon(EASResource.getIcon((String)"imgTbtn_flowstakeout"));
        this.kickBakMap = (HashMap)this.getUIContext().get(KICKBACK_UI_CONTEXT_MAP);
        this.assignId = (String)this.kickBakMap.get(ASSIGN_ID);
        this.procInstId = (String)this.kickBakMap.get(PROCINST_ID);
        if (!StringUtils.isEmpty((String)this.assignId)) {
            IDynamicWfServiceFacade svc = WfFacadeUtilFactory.createRemoteDynamicWfService();
            this.targets = svc.getKickBackTargets(this.assignId);
            if (this.targets.length == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)multiApproveResourcefile, (String)"noKickBackTarget"));
                SysUtil.abort();
            }
            this.fillTable(this.targets);
        }
        this.kicktype1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KickBackUI.this.setRadioButton();
            }
        });
        this.kicktype2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KickBackUI.this.setRadioButton();
            }
        });
    }

    private void fillTable(IDynamicWfService.JumpTarget[] targets) {
        this.kDTable1.removeRows();
        this.kDTable1.checkParsed();
        this.kDTable1.getSelectManager().setSelectMode(2);
        IRow row = null;
        IDynamicWfService.JumpTarget activity = null;
        for (int i = 0; i < targets.length; ++i) {
            activity = targets[i];
            row = this.kDTable1.addRow(i);
            ICell cell = row.getCell(0);
            cell.setValue((Object)activity.actDefName);
            cell = row.getCell(1);
            cell.setValue((Object)activity.participants);
            cell = row.getCell(2);
            cell.setValue((Object)activity.performerPersonNames);
            cell = row.getCell(3);
            cell.setValue((Object)activity.completeTime);
            row.setUserObject((Object)activity);
        }
    }

    @Override
    public void viewFlowDiagramAction_actionPerformed(ActionEvent e) throws Exception {
        WfMonitorUtils.showWfDiagram((Component)((Object)this), (String)this.procInstId);
    }

    @Override
    public void kickBackAction_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = false;
        int index = this.kDTable1.getSelectManager().getActiveRowIndex();
        IRow row = this.kDTable1.getRow(index);
        if (this.kicktype2.isSelected()) {
            if (row == null) {
                MsgBox.showWarning((String)EASResource.getString((String)multiApproveResourcefile, (String)"selectTarget"));
                return;
            }
            int result = MsgBox.showConfirm2((String)EASResource.getString((String)multiApproveResourcefile, (String)"confirmToKickBack"));
            if (result != 0) {
                return;
            }
        }
        try {
            String opinion = this.txtOpinion.getText().trim() + "kickback&&" + this.assignId;
            IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
            IWfUtil util = (IWfUtil)RpcProxy.wrapRequired(IWfUtil.class, (String)WfUtil.class.getName());
            if (this.kicktype1.isSelected()) {
                AssignmentInfo currentAssignInfo = service.getAssignmentById(this.assignId);
                String currentActDefId = currentAssignInfo.getActDefId();
                String hash = service.getProcessInstInfo(currentAssignInfo.getProcInstId()).getProcDefHashValue();
                ProcessDef def = service.getProcessDefByDefineHashValue(hash);
                ActivityDef actDef = def.getActivityDef(currentAssignInfo.getActDefId());
                ActivityInstInfo[] activityinfos = service.getActInstMetaArrayByProcInstIdAndActInstState(currentAssignInfo.getProcInstId(), "closed");
                ActivityCollection activityCollection = actDef.getAllPreviousActivities();
                for (int i = 0; i < activityCollection.size(); ++i) {
                    if (!"MANPOWER".equals(activityCollection.get(i).getType().toString()) || currentActDefId.equals(activityCollection.get(i).getID())) continue;
                    String actDefId = activityCollection.get(i).getID();
                    boolean isComplete = false;
                    for (int j = 0; j < activityinfos.length; ++j) {
                        ActivityInstInfo activityInfo = activityinfos[j];
                        if (!actDefId.equals(activityInfo.getActDefId())) continue;
                        isComplete = true;
                    }
                    if (!isComplete) continue;
                    String procInstId = currentAssignInfo.getProcInstId();
                    util.jumpTo(procInstId, actDefId, opinion);
                    break;
                }
            } else if (this.kicktype2.isSelected()) {
                IDynamicWfService.JumpTarget target = (IDynamicWfService.JumpTarget)row.getUserObject();
                String procInstId = "";
                if (this.informFormerHandlerCheckBox.isSelected()) {
                    ProcessDef processDef = service.getProcessDefByDefineHashValue(target.assignment.getProcDefHashValue());
                    procInstId = target.assignment.getProcInstId();
                    for (int i = 0; i <= index; ++i) {
                        IDynamicWfService.JumpTarget act = this.targets[i];
                        if (act.performerPersonIds == null) continue;
                        String key = ParticipantUtils.createDesignatePerformerKey((ActivityDef)processDef.getActivityDef(act.actDefId));
                        String[] tmp = act.performerPersonIds.split(";");
                        ArrayList<String> performerIds = new ArrayList<String>();
                        for (int j = 0; j < tmp.length; ++j) {
                            performerIds.add(tmp[j]);
                        }
                        service.setProcessContext(procInstId, key, performerIds);
                    }
                }
                IDynamicWfServiceFacade dynWFService = WfFacadeUtilFactory.createRemoteDynamicWfService();
                target.comment = (String)this.kickBakMap.get(COMMENT);
                boolean isSendMail = this.enableEmailCheckBox.isSelected();
                boolean isSendSMS = this.enableMobileCheckBox.isSelected();
                target.sendMail = isSendMail;
                target.sendSMS = isSendSMS;
                target.handlerOpinion = 0;
                target.handlerContent = EASResource.getString((String)multiApproveResourcefile, (String)"kickBackHandlerContent");
                util.jumpTo(target.assignment.getProcInstId(), target.actDefId, opinion);
                if (this.informAllHandlerCheckBox.isSelected()) {
                    SysContext ctx = SysContext.getSysContext();
                    Message message = KickBackUtils.constructMessage(target.assignment, ctx.getLocale(), isSendMail, isSendSMS, ctx.getDCNumber(), "eas");
                    message.setBooleanHeader("isSendEmail", isSendMail);
                    message.setBooleanHeader("isSendMobile", isSendSMS);
                    List list = service.getPersonsByProcessExecutor(target.assignment.getProcInstId(), "allocated");
                    String userIds = KickBackUtils.getUserStrs(list);
                    message.setStringHeader("receiver", userIds);
                    service.sendMessage(message);
                }
            }
            MsgBox.showInfo((String)EASResource.getString((String)multiApproveResourcefile, (String)"kickBackSuccess"));
            flag = true;
        }
        catch (Exception ex) {
            logger.error((Object)"kickBackAction_actionPerformed error", (Throwable)ex);
            MsgBox.showInfo((String)EASResource.getString((String)multiApproveResourcefile, (String)"kickBackFail"));
        }
        this.getUIWindow().close();
        this.getUIContext().put(KICKBACK_RESULT, String.valueOf(flag));
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void kicktype2_stateChanged(ChangeEvent e) throws Exception {
        super.kicktype2_stateChanged(e);
        this.setRadioButton();
    }

    private void setRadioButton() {
        if (this.kicktype1.isSelected()) {
            this.kicktype2.setSelected(false);
            this.kDTable1.setVisible(false);
        }
        if (this.kicktype2.isSelected()) {
            this.kicktype2.setSelected(false);
            this.kDTable1.setVisible(true);
        }
    }
}

