/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.client;

import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.monitor.client.WfMonitorUtils;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.message.client.MessageServiceProvider;
import com.kingdee.eas.base.multiapprove.ManualDecisionInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveException;
import com.kingdee.eas.base.multiapprove.client.AbstractManualDecisionBillUI;
import com.kingdee.eas.base.multiapprove.client.DesignatePerformerUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.base.uiframe.client.UIModelDialogFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.service.WorkFlowService;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ManualDecisionBillUI
extends AbstractManualDecisionBillUI {
    private static final long serialVersionUID = 6357561836608981099L;
    public static String MANUALDECISION_NAME = "MANUALDECISION_NAME";
    public static String MANUALDECISION_SELECTITEMS = "MANUALDECISION_ITEMS";
    public static String MANUALDECISION_SELECTCOUNT = "MANUALDECISION_COUNT";
    public static String MANUALDECISION_DESCRIPTION = "MANUALDECISION_DESC";
    private String manualDecisionItems;
    private String manualDecisionOpinions;
    private int selectCount = 0;
    private String billId = null;
    private boolean hasNoOpinions = false;
    public static final String IS_MANUAL_DECISION = "isManualDecision";

    private boolean setEntityManualDecision() throws EASBizException {
        boolean rtn = false;
        this.entityManualDecision = new ManualDecisionInfo();
        this.entityManualDecision.setName(this.lblItemName.getText());
        this.entityManualDecision.setSelectItemCount(this.selectCount);
        if (this.hasNoOpinions) {
            this.entityManualDecision.setSelectOpinions((String)this.getUIContext().get("MANUALDECISION_OPINION"));
        }
        String selectedItemsStr = "";
        String selectedIndicesStr = "";
        int[] selectedIndices = this.lstItems.getSelectedIndices();
        if (selectedIndices.length != this.selectCount) {
            throw new MultiApproveException(MultiApproveException.SELECTED_COUNT_NOT_MATCH, new Object[]{new Integer(this.selectCount)});
        }
        if (selectedIndices.length == 0) {
            return false;
        }
        selectedIndicesStr = String.valueOf(selectedIndices[0]);
        this.entityManualDecision.setSelectedIndices(selectedIndicesStr);
        String opinionAndItem = this.lstItems.getElement(selectedIndices[0]).toString();
        String[] s = opinionAndItem.split("\\s+");
        if (s.length > 1) {
            this.entityManualDecision.setSelectedOpinions(s[0]);
            this.entityManualDecision.setSelectedItems(s[1]);
        }
        selectedItemsStr = "";
        for (int i = 0; i < this.lstItems.getElementCount(); ++i) {
            selectedItemsStr = i == 0 ? selectedItemsStr + this.removeSequenceNumber(this.lstItems.getElement(i).toString(), i) : selectedItemsStr + ";" + this.removeSequenceNumber(this.lstItems.getElement(i).toString(), i);
        }
        this.entityManualDecision.setSelectItems(selectedItemsStr);
        this.entityManualDecision.setDescription(this.txtDescrption.getText());
        rtn = true;
        return rtn;
    }

    public ManualDecisionBillUI() throws Exception {
        this.setPreferredSize(new Dimension(500, 280));
        this.btnViewBill.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnNextPerson.setIcon(EASResource.getIcon((String)"imgTbtn_usercollocatemanage"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getNewId() {
        String newId = BOSUuid.create((BOSObjectType)this.entityManualDecision.getBOSType()).toString();
        this.entityManualDecision.setId(BOSUuid.read((String)newId));
        return newId;
    }

    private String addSequenceNumber(String str, int i) {
        return String.valueOf(i) + " " + str;
    }

    private String addSequenceNumber(String str, String opinion) {
        return opinion + " " + str;
    }

    private String removeSequenceNumber(String str, int i) {
        String[] s = str.split("\\s+");
        if (s.length > 1) {
            return s[1];
        }
        return str;
    }

    public void onLoad() throws Exception {
        this.confirmAction.addService((IBindService)new WorkFlowService());
        this.initServiceContext();
        this.btnDecision.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.getUIContext().put(IS_MANUAL_DECISION, Boolean.TRUE);
        this.lblItemName.setText((String)this.getUIContext().get("MANUALDECISION_NAME"));
        this.txtDescrption.setText((String)this.getUIContext().get("MANUALDECISION_DESC"));
        this.manualDecisionItems = (String)this.getUIContext().get("MANUALDECISION_ITEMS");
        this.manualDecisionOpinions = (String)this.getUIContext().get("MANUALDECISION_OPINION");
        Integer integer = (Integer)this.getUIContext().get("MANUALDECISION_COUNT");
        if (integer == null || integer <= 1) {
            this.selectCount = 1;
            this.lstItems.setSelectionMode(0);
        } else {
            this.selectCount = integer;
            this.lstItems.setSelectionMode(2);
        }
        this.lstItems.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        if (ManualDecisionBillUI.this.isPrepareConfirmAction()) {
                            ManualDecisionBillUI.this.prepareConfirmAction(null);
                        }
                        ManualDecisionBillUI.this.confirmAction_actionPerformed(null);
                    }
                    catch (EASBizException e1) {
                        MsgBox.showError((String)e1.getMessage(SysContext.getSysContext().getLocale()));
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }
        });
        this.initListener();
        Object tempID = this.getUIContext().get("ID");
        if (tempID != null || "".equals(tempID)) {
            String string = this.billId = tempID instanceof String ? (String)tempID : tempID.toString();
        }
        if (this.billId == null || this.billId.trim().length() == 0) {
            this.btnViewBill.setVisible(false);
        }
        if (this.manualDecisionItems == null) {
            throw new MultiApproveException(MultiApproveException.MANUALDECISION_SELECTITEMS_NOT_NULL);
        }
        String[] items = StringUtils.split((String)this.manualDecisionItems, (String)";");
        String[] opinions = null;
        if (!StringUtils.isEmpty((String)this.manualDecisionOpinions)) {
            opinions = StringUtils.split((String)this.manualDecisionOpinions, (String)";");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (opinions != null) {
                this.lstItems.addElement((Object)this.addSequenceNumber(items[i].trim(), opinions[i].trim()));
                continue;
            }
            this.lstItems.addElement((Object)this.addSequenceNumber(items[i], i + 1));
            sb.append(String.valueOf(i + 1)).append(";");
        }
        if (opinions == null) {
            this.hasNoOpinions = true;
            sb.setLength(sb.length() - 1);
            this.getUIContext().put("MANUALDECISION_OPINION", sb.toString());
        }
    }

    private String getEditUIClassByBillId(String billId) {
        BOSUuid id = BOSUuid.read((String)billId);
        BOSObjectType type = id.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo vo = loader.getEntity(type);
        String editUi = vo.getExtendedProperty("editUI");
        return editUi;
    }

    @Override
    public RequestContext prepareBillViewAction(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareBillViewAction(itemAction);
        String billUIStr = this.getEditUIClassByBillId(this.billId);
        if (billUIStr != null && billUIStr.trim().length() > 0) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.billId));
            request.put("objectUuidPK", (Object)pk);
        }
        return request;
    }

    @Override
    public void billViewAction_actionPerformed(ActionEvent e) throws Exception {
        super.billViewAction_actionPerformed(e);
        String billUIStr = this.getEditUIClassByBillId(this.billId);
        if (billUIStr == null || billUIStr.trim().length() == 0) {
            throw new MultiApproveException(MultiApproveException.UI_CLASS_NOT_RIGHT);
        }
        IUIFactory uiFactory = null;
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.billId));
        IObjectValue ov = DynamicObjectFactory.getCachedRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk);
        if (ov == null) {
            throw new MultiApproveException(MultiApproveException.DATAOBJECT_IS_NULL);
        }
        this.getUIContext().put("ID", this.billId);
        this.setDataObject("billInfo", ov);
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create(billUIStr, this.getUIContext(), this.getDataObjects(), OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void confirmAction_actionPerformed(ActionEvent e) throws Exception {
        super.confirmAction_actionPerformed(e);
        this.wfContext.setBindWorkFlow(true);
        this.decitionConfirm();
    }

    @Override
    public boolean isPrepareConfirmAction() {
        return false;
    }

    @Override
    public RequestContext prepareConfirmAction(IItemAction itemAction) throws Exception {
        String pk;
        if (this.lstItems.getSelectedIndex() < 0 || this.lstItems.getSelectedValue() == null) {
            String msg1 = EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"PLEASESELECT");
            String msg2 = EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"SOMEDECITIONITEM");
            String msg = msg1 + this.selectCount + msg2;
            MsgBox.showError((String)msg);
            this.abort();
        }
        RequestContext requestContext = super.prepareConfirmAction(itemAction);
        if (this.setEntityManualDecision()) {
            this.wfContext.addToDataMap((Object)this.getNewId(), (IObjectValue)this.entityManualDecision);
            this.dataObjects.put("entityManualDecision", this.entityManualDecision);
        }
        if (this.wfContext.isBindWorkFlow() && !this.wfContext.hasThrowException() && this.wfContext.getDataMap().size() == 0 && (pk = this.entityManualDecision.getId().toString()) != null) {
            this.wfContext.addToDataMap((Object)pk, (IObjectValue)this.entityManualDecision);
        }
        requestContext.put("dataMap", (Object)this.wfContext.getDataMap());
        requestContext.put("uiObjPK", (Object)this.getMetaDataPK());
        requestContext.put("actionName", (Object)this.wfContext.getActionName());
        requestContext.put("userId", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        requestContext.put("WfAssignmentInfo", (Object)((AssignmentInfo)this.getUIContext().get("WfAssignmentInfo")));
        return requestContext;
    }

    private void decitionConfirm() throws EASBizException {
        if (this.lstItems.getSelectedIndex() < 0 || this.lstItems.getSelectedValue() == null) {
            String msg1 = EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"PLEASESELECT");
            String msg2 = EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"SOMEDECITIONITEM");
            String msg = msg1 + this.selectCount + msg2;
            MsgBox.showError((String)msg);
            return;
        }
        if (this.setEntityManualDecision()) {
            if (!this.isPrepareConfirmAction()) {
                this.wfContext.addToDataMap((Object)this.getNewId(), (IObjectValue)this.entityManualDecision);
            }
            this.dataObjects.put("entityManualDecision", this.entityManualDecision);
            this.submitAssignment();
            this.getUIWindow().close();
        }
    }

    protected void submitAssignment() {
        if (this.wfContext.isBindWorkFlow()) {
            if (!this.wfContext.hasThrowException()) {
                String pk;
                if (this.wfContext.getDataMap().size() == 0 && (pk = this.entityManualDecision.getId().toString()) != null) {
                    this.wfContext.addToDataMap((Object)pk, (IObjectValue)this.entityManualDecision);
                }
                this.submitWfAssignment(this.wfContext.getActionName(), this.wfContext.getDataMap());
            }
            this.wfContext.clear();
        }
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        super.cancelAction_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        AssignmentInfo assignmentInfo = (AssignmentInfo)this.getUIContext().get("WfAssignmentInfo");
        String assignmentId = assignmentInfo.getAssignmentId();
        DesignatePerformerUI.process((CoreUIObject)this, assignmentId, null);
    }

    @Override
    public boolean isPrepareBillViewAction() {
        return true;
    }

    @Override
    public void actionPassHistory_actionPerformed(ActionEvent e) throws Exception {
        MultiApproveUtil.showPassHis(BOSUuid.read((String)this.billId), UIModelDialogFactory.class.getName(), (Object)this);
    }

    @Override
    public void actionApproveHistory_actionPerformed(ActionEvent e) throws Exception {
        MultiApproveUtil.showApproveHis(BOSUuid.read((String)this.billId), UIModelDialogFactory.class.getName(), (Object)this);
    }

    @Override
    public void actionWorkflowG_actionPerformed(ActionEvent e) throws Exception {
        AssignmentInfo assignmentInfo = (AssignmentInfo)this.getUIContext().get("WfAssignmentInfo");
        String assignmentId = assignmentInfo.getAssignmentId();
        WfMonitorUtils.showWfDiagram((Component)((Object)this), (String)assignmentId);
    }

    public void initListener() {
        super.initListener();
        IUIWindow uiWindow = this.getUIWindow();
        if (uiWindow != null && uiWindow instanceof Window) {
            ((Window)uiWindow).addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent event) {
                    IUIObject[] uiObjects = UIFrameUtil.findUIObject((String)MessageCenterUI.class.getName());
                    if (uiObjects != null && uiObjects.length > 0) {
                        MessageServiceProvider.delayRefresh((Object)uiObjects[0]);
                    } else {
                        MessageServiceProvider.delayRefresh(null);
                    }
                }
            });
        }
    }
}

