/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MultiApproveDataProvider
implements BOSQueryDelegate {
    protected static final Logger logger = Logger.getLogger(MultiApproveDataProvider.class);
    public static final String ID = "FID";
    public static final String ISPASS = "FIsPass";
    public static final String OPINION = "FOpinion";
    public static final String HANDLEROPTION = "FHandlerOption";
    public static final String BILLID = "FBillID";
    public static final String BILLNUMBER = "FBillNumber";
    public static final String BILLTYPE = "FBILLTYPE";
    public static final String CREATORID = "FCreatorID";
    public static final String CREATORNAME = "FCreatorName";
    public static final String CREATETIME = "FCreateTime";
    public static final String LASTUPDATEUSERID = "FLastUpdateUserID";
    public static final String LASTUPDATETIME = "FLastUpdateTime";
    public static final String BOSTYPE = "FBosType";
    public static final String CONTROLUNITID = "FControlUnitID";
    public static final String NEXTHANDLERPERSONID = "FNEXTHANDLERPERSONID";
    public static final String ASSIGNMENTID = "FASSIGNMENTID";
    public static final String STATUS = "FSTATUS";
    public static final String TYPE = "FTYPE";
    public static final String NUMBER = "FNUMBER";
    public static final String ACTDEFNAME = "FACTDEFNAME";
    public static final String ADMINUNIT = "FAdminUnit";
    public static final String POSITION = "FPosition";
    public static final String ADMINUNITFULLNAME = "FAdminUnitFullName";
    protected String[] columnNames;
    protected String billId;
    protected String AllAssignemtnsIdString = "";

    public MultiApproveDataProvider(String billId) {
        if (billId == null || billId.length() <= 0) {
            throw new IllegalArgumentException();
        }
        this.billId = billId;
        this.columnNames = new String[]{ID, ISPASS, OPINION, HANDLEROPTION, BILLID, BILLNUMBER, BILLTYPE, CREATORID, CREATORNAME, CREATETIME, LASTUPDATEUSERID, LASTUPDATETIME, BOSTYPE, CONTROLUNITID, NEXTHANDLERPERSONID, ASSIGNMENTID, STATUS, TYPE, NUMBER, ACTDEFNAME, ADMINUNIT, POSITION, ADMINUNITFULLNAME};
    }

    public void setAssignmentIDString(String assignments) {
        this.AllAssignemtnsIdString = assignments;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        try {
            int colCount = this.columnNames.length;
            DynamicRowSet rowSet = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo colInfo = new ColInfo();
                colInfo.colType = 12;
                colInfo.columnName = this.columnNames[i];
                colInfo.nullable = 1;
                rowSet.setColInfo(i + 1, colInfo);
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("(billId='" + this.billId + "')");
            buffer.append(" and (status=" + MultiApproveStatusEnum.SUBMIT.getValue() + ")");
            buffer.append("and (assignment IN (" + this.AllAssignemtnsIdString + "))");
            String oqlFilter = buffer.toString();
            FilterInfo filter = new FilterInfo(oqlFilter);
            EntityViewInfo queryMultiApproveQuery = new EntityViewInfo();
            MetaDataPK queryMultiApproveQueryPK = new MetaDataPK("com.kingdee.eas.base.multiapprove.app", "MultiApproveQuery3");
            queryMultiApproveQuery.setFilter(filter);
            SorterItemInfo sortName = new SorterItemInfo("createTime");
            sortName.setSortType(SortType.DESCEND);
            queryMultiApproveQuery.getSorter().add(sortName);
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryMultiApproveQueryPK);
            exec.setObjectView(queryMultiApproveQuery);
            IRowSet rowSet2 = exec.executeQuery();
            Collection col = rowSet2.toCollection();
            Iterator itr = col.iterator();
            rowSet.beforeFirst();
            while (itr.hasNext()) {
                Vector row = (Vector)itr.next();
                this.fillRowData(rowSet, row);
            }
            rowSet.beforeFirst();
            return rowSet;
        }
        catch (SQLException e) {
            logger.error((Object)"SQLException", (Throwable)e);
            return null;
        }
        catch (BOSException e) {
            logger.error((Object)"BOSException", (Throwable)e);
            return null;
        }
        catch (ParserException e) {
            logger.error((Object)"ParserException", (Throwable)e);
            return null;
        }
    }

    private void fillRowData(DynamicRowSet rowSet, Vector row) throws SQLException, BOSException {
        if (rowSet == null) {
            throw new IllegalArgumentException();
        }
        if (row == null) {
            throw new IllegalArgumentException();
        }
        rowSet.moveToInsertRow();
        String bosType = (String)row.get(8);
        rowSet.updateString(BILLTYPE, MultiApproveUtil.getEntityAlias(bosType));
        String number = MultiApproveUtil.getBillNumber(bosType, this.billId);
        rowSet.updateString(BILLNUMBER, number);
        String isPass = MultiApproveUtil.isPass((String)row.get(6));
        rowSet.updateString(ISPASS, isPass);
        rowSet.updateString(OPINION, (String)row.get(3));
        String time = MultiApproveUtil.formatDate((Timestamp)row.get(1));
        rowSet.updateString(CREATETIME, time);
        rowSet.updateString(CREATORNAME, (String)row.get(2));
        rowSet.updateString(ACTDEFNAME, (String)row.get(7));
        rowSet.updateString(HANDLEROPTION, (String)row.get(4));
        if (row.size() > 9) {
            rowSet.updateString(ADMINUNIT, (String)row.get(9));
            rowSet.updateString(POSITION, (String)row.get(10));
            rowSet.updateString(ADMINUNITFULLNAME, (String)row.get(11));
        }
        rowSet.insertRow();
    }
}

