/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.trans.BillActivityPersonsData;
import com.kingdee.bos.workflow.biz.trans.BillApproveResultInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.ext.Config;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.ext.IApproveHistoryTableUI;
import com.kingdee.bos.workflow.ext.IMultiApproveClientExt;
import com.kingdee.bos.workflow.monitor.IWfUtil;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.bos.workflow.participant.ActivityPersonsInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.client.AttachmentByBoListUI;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.util.UICreator;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.DecisionItemInfo;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.IMultiApproveHst;
import com.kingdee.eas.base.multiapprove.InputType;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveHstCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveHstFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveHstInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.multiapprove.MultiapproveUtils;
import com.kingdee.eas.base.multiapprove.OptionEnum;
import com.kingdee.eas.base.multiapprove.client.ApproveHistoryUI;
import com.kingdee.eas.base.multiapprove.client.DesignatePerformerUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUI;
import com.kingdee.eas.base.multiapprove.client.MultiapproveBillsUI;
import com.kingdee.eas.base.multiapprove.client.PassHistoryUI;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.IUILifeCycleListener;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.framework.client.workflow.UIActionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.lang.reflect.Method;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class MultiApproveUtil {
    private static final Logger logger = Logger.getLogger(MultiApproveUtil.class);
    private static final String RESOURCE_NAME = "com.kingdee.eas.base.multiapprove.MultiApproveResource";
    private static final String MULTIAPPROVE_MANUALDECISION_ITEMS = "manualDecisionItems";
    private static final String[] MULTIAPPROVE_MANUALDECISION_TYPES = new String[]{EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"39_TestIMultiApprove2"), EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"44_ApproveUtil"), EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"45_ApproveUtil")};
    public static final String ACTIONCOMMAND_QUERYHISTORY = "queryHistory";
    public static final String ACTIONCOMMAND_QUERYCURRENT = "queryCurrent";

    public static boolean allowForward(IEnactmentService service, String assignmentId) throws Exception {
        if (service == null) {
            throw new IllegalArgumentException();
        }
        if (assignmentId == null || assignmentId.length() <= 0) {
            throw new IllegalArgumentException();
        }
        AssignmentInfo assignmentInfo = service.getAssignmentById(assignmentId);
        String procInstId = assignmentInfo.getProcInstId();
        String actDefId = assignmentInfo.getActDefId();
        ProcessInstInfo processInstInfo = service.getProcessInstInfo(procInstId);
        ProcessDef processDef = null;
        processDef = service.getRuntimeProcessDef(processInstInfo.getProcDefHashValue());
        if (processDef == null) {
            logger.error((Object)"The process define is not existing ");
            return false;
        }
        ActivityDef activityDef = processDef.getActivityDef(actDefId);
        if (!(activityDef instanceof ManpowerActivityDef)) {
            return false;
        }
        ManpowerActivityDef manpowerActivityDef = (ManpowerActivityDef)activityDef;
        return manpowerActivityDef.getAllowAssignNextPerformer();
    }

    public static boolean allowForward(IEnactmentService service, String[] assignmentIds) throws Exception {
        if (service == null || assignmentIds == null || assignmentIds.length <= 0) {
            throw new IllegalArgumentException();
        }
        return service.allowForward(assignmentIds);
    }

    public static String formatDate(Date date) {
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date).toString();
    }

    public static String getUserName(String userId) throws BOSException, EASBizException {
        IUser user = UserFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(userId);
        UserInfo userInfo = user.getUserByID((IObjectPK)pk);
        Locale locale = SysContext.getSysContext().getLocale();
        return userInfo.getName(locale);
    }

    public static PersonInfo getPersonInfo(String personId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personId)) {
            throw new IllegalArgumentException();
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)personId));
        IPerson person = PersonFactory.getRemoteInstance();
        return person.getPersonInfo((IObjectPK)pk);
    }

    public static String isPass(ApproveResult isPass) {
        if (ApproveResult.PASS.equals((Object)isPass)) {
            return MultiApproveUtil.getMultiApproveResource("ISPASS_TRUE");
        }
        if (ApproveResult.NOT_PASS.equals((Object)isPass)) {
            return MultiApproveUtil.getMultiApproveResource("ISPASS_FALSE");
        }
        throw new IllegalArgumentException();
    }

    public static String isPass(String isPass) {
        if (isPass.equals("true")) {
            return MultiApproveUtil.getMultiApproveResource("ISPASS_TRUE");
        }
        return MultiApproveUtil.getMultiApproveResource("ISPASS_FALSE");
    }

    public static String getEntityAlias(String bosType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        BOSObjectType objectType = BOSObjectType.create((String)bosType);
        EntityObjectInfo entityInfo = loader.getEntity(objectType);
        String alias = entityInfo.getAlias();
        return alias;
    }

    public static String getBillNumber(String bosType, String billId) throws BOSException {
        if (bosType == null || bosType.length() <= 0) {
            throw new IllegalArgumentException();
        }
        if (billId == null || billId.length() <= 0) {
            throw new IllegalArgumentException();
        }
        IDynamicObject dynamicObject = DynamicObjectFactory.getRemoteInstance();
        BOSObjectType objectType = BOSObjectType.create((String)bosType);
        ObjectUuidPK objectPK = new ObjectUuidPK(billId);
        SelectorItemCollection selectorItems = new SelectorItemCollection();
        selectorItems.add(new SelectorItemInfo("number"));
        IObjectValue objectValue = dynamicObject.getValue(objectType, (IObjectPK)objectPK, selectorItems);
        String number = objectValue.getString("number");
        return number;
    }

    public static String getMultiApproveResource(String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(RESOURCE_NAME);
        buffer.append(".");
        buffer.append(name);
        String resName = buffer.toString();
        return EASResource.getString((String)resName);
    }

    public static void showApproveHis(BOSUuid billId, String uiFactoryString, Object Owner) {
        UIContext uiContext = new UIContext(Owner);
        uiContext.put((Object)"ID", (Object)billId.toString());
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)uiFactoryString).create(ApproveHistoryUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)"UIException", (Throwable)ex);
        }
    }

    public static void multiapproveBills(CoreUIObject parent, String userId, String[] billIdArray) throws Exception {
        ProcessInstInfo[] procinsts;
        if (parent == null) {
            String message = "\"parent\" is null!";
            throw new IllegalArgumentException(message);
        }
        if (StringUtils.isEmpty((String)userId)) {
            String message = "\"userId\" is null!";
            throw new IllegalArgumentException(message);
        }
        if (billIdArray == null || billIdArray.length == 0) {
            String message = MultiApproveUtil.getMultiApproveResource("HAVENOSELECTEDBILLS");
            MsgBox.showInfo((Component)parent, (String)message);
            return;
        }
        logger.info((Object)("\"parent\"'s class is " + parent.getClass().getName() + " !"));
        logger.info((Object)("\"userId\" is " + userId + " !"));
        logger.info((Object)("\"billIdArray\"'s length is " + billIdArray.length + " !"));
        MetaDataPK uiObjPK = new MetaDataPK(MultiApproveUI.class.getName());
        String action = "ActionSubmit";
        IEnactmentService enactmentService = EnactmentServiceFactory.createRemoteEnactService();
        for (ProcessInstInfo procinstInfo : procinsts = enactmentService.getProcessInstanceByHoldedObjectId(billIdArray[0])) {
            String procinstId = procinstInfo.getProcInstId();
            if (!enactmentService.isShareCenterAssign(procinstId)) continue;
            MsgBox.showInfo((String)"\u5f53\u524d\u4efb\u52a1\u5728\u8d22\u52a1\u5171\u4eab\u4e2d\uff0c\u4e0d\u80fd\u5ba1\u6279");
            return;
        }
        Locale l = new Locale(BOSLocaleUtil.getShortCode((Locale)SysContext.getSysContext().getLocale()));
        BillApproveResultInfo resultInfo = enactmentService.getBillApproveResultInfo(billIdArray, (IMetaDataPK)uiObjPK, action, userId);
        logger.info((Object)("\"assignmentInfoMap\"'s size is " + resultInfo.getAssignmentInfoMap().size() + " !"));
        if (resultInfo.getAssignmentInfoMap() == null || resultInfo.getAssignmentInfoMap().size() <= 0) {
            logger.info((Object)"Current bills haven't multiapprove assignment!");
            MsgBox.showInfo((String)MultiApproveUtil.getMultiApproveResource("HAVENO_MULTIAPPROVE_ASSIGNMENT"));
            return;
        }
        UIContext uiContext = new UIContext((Object)parent);
        uiContext.put((Object)"BillIdAssignmentMap", (Object)resultInfo.getAssignmentInfoMap());
        uiContext.put((Object)MULTIAPPROVE_MANUALDECISION_ITEMS, (Object)resultInfo.getDecisionItemsString());
        uiContext.put((Object)"approveDefaultOpinion", (Object)resultInfo.getDefaultOpinion());
        uiContext.put((Object)"Owner", (Object)parent);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(MultiapproveBillsUI.class.getName(), (Map)uiContext);
        window.show();
    }

    public static String getCustomDecisiones(ActivityDef actDef, String propertyKey) {
        ExtendedAttributeDef att = actDef.getActivityHeader().getExtendedAttributes().get(propertyKey);
        String propertyValue = "";
        if (att != null) {
            propertyValue = att.getValue();
        }
        return propertyValue;
    }

    public static List getDecisionItemList(String decisionItemsString) {
        ArrayList<DecisionItemInfo> decisionItems = new ArrayList<DecisionItemInfo>();
        if (decisionItemsString != null && decisionItemsString.trim().length() > 0) {
            String[] items = StringUtils.split((String)decisionItemsString, (String)":");
            String[] itemRows = new String[3];
            for (int i = 0; i < items.length; ++i) {
                itemRows = StringUtils.split((String)items[i], (String)";");
                DecisionItemInfo info = new DecisionItemInfo();
                info.setKey(Integer.parseInt(itemRows[0]));
                info.setValue(itemRows[1]);
                if (itemRows.length == 2) {
                    info.setType(MULTIAPPROVE_MANUALDECISION_TYPES[2]);
                    info.setAssocicateLine("");
                } else if (itemRows.length == 3) {
                    info.setAssocicateLine("");
                    info.setType(itemRows[2]);
                } else {
                    info.setType(itemRows[2]);
                    info.setAssocicateLine(itemRows[3].trim());
                }
                decisionItems.add(info);
            }
        }
        return decisionItems;
    }

    public static List getFilterDecisionItemList(String decisionItemsString, boolean approveType) {
        ArrayList<DecisionItemInfo> filteList;
        block2: {
            Iterator it;
            List decisionItems = MultiApproveUtil.getDecisionItemList(decisionItemsString);
            filteList = new ArrayList<DecisionItemInfo>();
            for (int i = 0; i < decisionItems.size(); ++i) {
                DecisionItemInfo item = (DecisionItemInfo)decisionItems.get(i);
                if (approveType) {
                    if (item.getType().trim().equalsIgnoreCase(MULTIAPPROVE_MANUALDECISION_TYPES[1])) continue;
                    filteList.add(item);
                    continue;
                }
                if (item.getType().trim().equalsIgnoreCase(MULTIAPPROVE_MANUALDECISION_TYPES[0])) continue;
                filteList.add(item);
            }
            if (filteList.size() != 0 || !(it = OptionEnum.iterator()).hasNext()) break block2;
            OptionEnum option = (OptionEnum)((Object)it.next());
            DecisionItemInfo info = new DecisionItemInfo();
            info.setKey(option.getValue());
            info.setValue(option.getAlias());
            info.setType(MULTIAPPROVE_MANUALDECISION_TYPES[2]);
            info.setAssocicateLine("");
            filteList.add(info);
        }
        return filteList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getAssignmentIdByBillId(String billId) {
        MultiApproveInfo result = new MultiApproveInfo();
        MultiApproveHstInfo resultHst = new MultiApproveHstInfo();
        try {
            IMultiApprove multiApprove = MultiApproveFactory.getRemoteInstance();
            StringBuffer buffer = new StringBuffer();
            buffer.append("where");
            buffer.append(" (billId='" + billId + "')");
            String oql = buffer.toString();
            MultiApproveCollection multiApproves = multiApprove.getMultiApproveCollection(oql);
            if (multiApproves.isEmpty()) {
                IMultiApproveHst multiApproveHst = MultiApproveHstFactory.getRemoteInstance();
                MultiApproveHstCollection multiApprovesHst = multiApproveHst.getMultiApproveHstCollection(oql);
                resultHst = multiApprovesHst.get(multiApprovesHst.size() - 1);
                if (!resultHst.isEmpty()) return resultHst.getAssignment();
                logger.info((Object)"Current bills haven't multiapprove assignment!");
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_NAME, (String)"NO_ASSIGNMENT"));
                return result.getAssignment();
            } else {
                result = multiApproves.get(multiApproves.size() - 1);
            }
            return result.getAssignment();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return result.getAssignment();
    }

    public static List getCustomButton(CoreUIObject instance) {
        Object result = null;
        if (null == instance) {
            return null;
        }
        try {
            Class<?> c = instance.getClass();
            Method m = c.getMethod("mergeMultiApproveButton", new Class[0]);
            result = m.invoke((Object)instance, new Object[0]);
        }
        catch (Exception e) {
            logger.debug((Object)("mulapprove callback getCustomButton() Exception" + e.getMessage()));
        }
        if (result instanceof List) {
            return (List)result;
        }
        return null;
    }

    public static boolean isShowDialog() {
        try {
            String result = ParamManager.getParamValue(null, null, (String)"enableMultiapproveConfirm");
            return "true".equalsIgnoreCase(result);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static void setQueryHistoryState(KDWorkButton button) {
        if (button == null) {
            throw new IllegalArgumentException();
        }
        String toolTipText = MultiApproveUtil.getMultiApproveResource("QueryHistory");
        button.setToolTipText(toolTipText);
        button.setText(toolTipText);
        Icon icon = EASResource.getIcon((String)"imgTbtn_demandhistorydata");
        button.setIcon(icon);
        button.setActionCommand(ACTIONCOMMAND_QUERYHISTORY);
    }

    public static void setQueryCurrentState(KDWorkButton button) {
        if (button == null) {
            throw new IllegalArgumentException();
        }
        String toolTipText = MultiApproveUtil.getMultiApproveResource("QueryCurrent");
        button.setToolTipText(toolTipText);
        button.setText(toolTipText);
        Icon icon = EASResource.getIcon((String)"imgTbtn_demandnoncedata");
        button.setIcon(icon);
        button.setActionCommand(ACTIONCOMMAND_QUERYCURRENT);
    }

    public static void mergeRowsByAttachment(KDTable approveTable) {
        approveTable.getGroupManager().setGroup(true);
        approveTable.getColumn(0).setGroup(true);
        approveTable.getColumn(1).setGroup(true);
        approveTable.getColumn(2).setGroup(true);
        approveTable.getColumn(3).setGroup(true);
        approveTable.getColumn(4).setGroup(true);
        approveTable.getColumn(5).setGroup(true);
        approveTable.getColumn(6).setGroup(true);
        approveTable.getColumn(7).setGroup(true);
        approveTable.getColumn(8).setGroup(true);
        approveTable.getColumn(9).setGroup(true);
        approveTable.getMergeManager().setMergeMode(1);
    }

    public static String checkPostActivityPersons(ActivityInstInfo activityInstInfo, String currentUserId) throws Exception {
        return MultiApproveUtil.checkPostActivityPersons(activityInstInfo, currentUserId, null);
    }

    public static String checkPostActivityPersons(ActivityInstInfo activityInstInfo, String currentUserId, String associationLine) throws Exception {
        if (activityInstInfo == null) {
            throw new WfException("MltiapproveUtils.checkPostActivityPersons args activityInstInfo can't be null");
        }
        ActivityPersonsInfo[] allPostActPersons = EnactmentServiceFactory.createRemoteEnactService().getPostActivitysPersonsByActInstID(activityInstInfo.getActInstId(), currentUserId, true, associationLine);
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < allPostActPersons.length; ++i) {
            ActivityPersonsInfo info = allPostActPersons[i];
            if (info.getPersons().length > 0) continue;
            bf.append(info.getActDefName());
            bf.append(" -");
            bf.append(info.getProcDefName());
            bf.append(",");
        }
        if (bf.toString().trim().length() > 0) {
            String mesg = bf.substring(0, bf.length() - 1);
            return mesg;
        }
        return null;
    }

    public static ActivityPersonsInfo[] getPostActivityPersonsByAssocationLines(String actInstId, String currentUserId, String[] assocationLines, boolean onlyFirst) throws WfException {
        if (StringUtils.isEmpty((String)actInstId) || StringUtils.isEmpty((String)currentUserId) || assocationLines == null) {
            return new ActivityPersonsInfo[0];
        }
        EASWfServiceClient wfServiceClient = new EASWfServiceClient();
        ActivityPersonsInfo[] allPostActPersons = wfServiceClient.getService().getPostActivitysPersonsByAssociationLine(actInstId, currentUserId, assocationLines, onlyFirst);
        return allPostActPersons;
    }

    public static ActivityPersonsInfo[] getPostActivityPersons(String actInstId, String currentUserId, boolean needCheck) throws WfException {
        if (StringUtils.isEmpty((String)actInstId) || StringUtils.isEmpty((String)currentUserId)) {
            return new ActivityPersonsInfo[0];
        }
        EASWfServiceClient wfServiceClient = new EASWfServiceClient();
        ActivityPersonsInfo[] allPostActPersons = wfServiceClient.getService().getPostActivitysPersonsByActInstID(actInstId, currentUserId, needCheck);
        return allPostActPersons;
    }

    public static BillActivityPersonsData[] getPostActivityPersons(Map bill2AssignMap, final String currentUserId) throws Exception {
        if (bill2AssignMap == null || bill2AssignMap.size() <= 0) {
            throw new WfException("MultiaproveClientUtil.checkPostActivityPersons args bill2AssignMap can't be null");
        }
        final String[] billIds = bill2AssignMap.keySet().toArray(new String[0]);
        final String[] assignIds = bill2AssignMap.values().toArray(new String[0]);
        UIActionHelper actionHelper = new UIActionHelper();
        return (BillActivityPersonsData[])actionHelper.execute(new UIActionHelper.IActionCallBack(){

            public Object execute() throws Exception {
                EASWfServiceClient wfServiceClient = new EASWfServiceClient();
                return wfServiceClient.getService().getPostActivitysPersonsByAssignIDs(assignIds, billIds, currentUserId);
            }

            public void prepareRequestContext(RequestContext requestContext) throws Exception {
                requestContext.put("userID", (Object)currentUserId);
                requestContext.put("billIds", (Object)billIds);
                requestContext.put("assignIds", (Object)assignIds);
                requestContext.setMethodName("handleGetPostActivitysPersonsByAssignIDs");
                requestContext.setClassName("com.kingdee.eas.framework.app.workflow.WfCommonUIHandler");
            }
        });
    }

    public static String getTableCellValue(KDTable table, int rowIndex, String FieldName) {
        ICell cell;
        String selectValue = "";
        if (table == null) {
            return selectValue;
        }
        if (rowIndex < 0) {
            return selectValue;
        }
        IRow row = table.getRow(rowIndex);
        if (row != null && (cell = row.getCell(FieldName)) != null && cell.getValue() != null) {
            selectValue = cell.getValue().toString();
        }
        return selectValue;
    }

    public static String getTableCellValue(KDTable table, String billId, String fieldName) {
        if (table == null || StringUtils.isEmpty((String)billId) || StringUtils.isEmpty((String)fieldName)) {
            return "";
        }
        int rowCount = table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            ICell numberCell;
            IRow row = table.getRow(i);
            ICell cell = row.getCell("id");
            if (cell == null || cell.getValue() == null || !billId.equalsIgnoreCase(cell.getValue().toString()) || (numberCell = row.getCell(fieldName)) == null || numberCell.getValue() == null) continue;
            return numberCell.getValue().toString();
        }
        return "";
    }

    public static String checkPostActivityPersons(ActivityPersonsInfo[] allPostActPersons) {
        if (allPostActPersons == null || allPostActPersons.length <= 0) {
            return null;
        }
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < allPostActPersons.length; ++i) {
            ActivityPersonsInfo info = allPostActPersons[i];
            if (info.getPersons().length > 0) continue;
            bf.append(info.getActDefName());
            bf.append(" -");
            bf.append(info.getProcDefName());
            bf.append(",");
        }
        if (bf.toString().trim().length() > 0) {
            String mesg = bf.substring(0, bf.length() - 1);
            return mesg;
        }
        return null;
    }

    public static String getAllAssignFromRelationProcessInst(String assignmentID) throws WfException {
        EASWfServiceClient wfServiceClient = new EASWfServiceClient();
        IEnactmentService enactmentService = wfServiceClient.getService();
        return enactmentService.getAllAssignFromRelationProcessInst(assignmentID);
    }

    public static Map forwardAssignmentsWithOpinion(String[] assignmentIds, String destUserId, Map opinonMap) throws Exception {
        return EnactmentServiceFactory.createRemoteEnactService().forwardAssignment(assignmentIds, destUserId, opinonMap);
    }

    public static void setTableStateRowSelect(KDTable table) {
        if (table == null) {
            return;
        }
        table.getSelectManager().setSelectMode(2);
    }

    public static void showPassHis(BOSUuid billId, String uiFactoryString, Object Owner) {
        UIContext uiContext = new UIContext(Owner);
        uiContext.put((Object)"ID", (Object)billId.toString());
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)uiFactoryString).create(PassHistoryUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)"UIException", (Throwable)ex);
        }
    }

    public static ArrayList query(String queryMetaData, EntityViewInfo evi) throws SQLException, BOSException {
        MetaDataPK query = new MetaDataPK(queryMetaData);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)query);
        exec.setObjectView(evi);
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = true;
        IRowSet set = exec.executeQuery();
        return MultiApproveUtil.recordSet2ArrayList(set);
    }

    public static ArrayList recordSet2ArrayList(IRowSet set) throws SQLException {
        ArrayList list = new ArrayList(set.size());
        if (set.first()) {
            ResultSetMetaData meta = set.getMetaData();
            do {
                int count = meta.getColumnCount();
                HashMap<String, Object> item = new HashMap<String, Object>(count);
                for (int i = 1; i <= count; ++i) {
                    item.put(meta.getColumnName(i), set.getObject(i));
                }
                list.add(item);
            } while (set.next());
        }
        return list;
    }

    public static boolean paramValueIsTrue(String param) throws BOSException {
        if (StringUtils.isEmpty((String)param)) {
            return false;
        }
        String result = null;
        try {
            result = ParamManager.getParamValue(null, null, (String)param);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return result != null && result.equalsIgnoreCase("true");
    }

    public static boolean multiApprovePrintBill() throws BOSException {
        return MultiApproveUtil.paramValueIsTrue("WfMultiApprovePrintBill");
    }

    public static void setTableSelectMode(KDTable table, int selectMode) {
        if (table == null) {
            return;
        }
        table.getSelectManager().setSelectMode(selectMode);
    }

    public static void showMultiapprovePersonOrg(KDTable tblApproveList) throws BOSException {
        boolean c;
        if (tblApproveList == null) {
            return;
        }
        boolean b = !MultiApproveUtil.paramValueIsTrue("showMultiapprovePersonOrg");
        boolean bl = c = !MultiApproveUtil.paramValueIsTrue("showMultiapproveOrgFullName");
        if (tblApproveList.getColumn("AdminOrgUnit.name") != null) {
            tblApproveList.getColumn("AdminOrgUnit.name").getStyleAttributes().setHided(b);
        }
        if (tblApproveList.getColumn("Position.name") != null) {
            tblApproveList.getColumn("Position.name").getStyleAttributes().setHided(b && c);
        }
    }

    public static boolean showMultiapprovePersonPosOrOrg() throws BOSException {
        return MultiApproveUtil.paramValueIsTrue("showMultiapprovePersonOrg") || MultiApproveUtil.paramValueIsTrue("showMultiapproveOrgFullName");
    }

    public static Map<String, Boolean> getPersonOrgOrFullName() throws BOSException {
        HashMap<String, Object> stringIObjectPKHashMap = new HashMap<String, Object>();
        String showMultiapprovePersonOrg = "showMultiapprovePersonOrg";
        String showMultiapproveOrgFullName = "showMultiapproveOrgFullName";
        stringIObjectPKHashMap.put(showMultiapprovePersonOrg, null);
        stringIObjectPKHashMap.put(showMultiapproveOrgFullName, null);
        HashMap<String, Boolean> personOrgOrFullName = new HashMap<String, Boolean>();
        try {
            HashMap paramHashMap = ParamManager.getParamHashMap(null, stringIObjectPKHashMap);
            personOrgOrFullName.put(showMultiapprovePersonOrg, Boolean.valueOf((String)paramHashMap.get(showMultiapprovePersonOrg)));
            personOrgOrFullName.put(showMultiapproveOrgFullName, Boolean.valueOf((String)paramHashMap.get(showMultiapproveOrgFullName)));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return personOrgOrFullName;
    }

    public static boolean isPersonOrgOrFullNameTrue() throws BOSException {
        boolean c;
        boolean b;
        HashMap<String, Object> stringIObjectPKHashMap = new HashMap<String, Object>();
        stringIObjectPKHashMap.put("showMultiapprovePersonOrg", null);
        stringIObjectPKHashMap.put("showMultiapproveOrgFullName", null);
        try {
            HashMap paramHashMap = ParamManager.getParamHashMap(null, stringIObjectPKHashMap);
            b = Boolean.valueOf((String)paramHashMap.get("showMultiapprovePersonOrg"));
            c = Boolean.valueOf((String)paramHashMap.get("showMultiapproveOrgFullName"));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return b || c;
    }

    public static void showPersonOrgAndFullName(KDTable tblApproveList, boolean isPersonOrg, boolean isOrgFullName) throws BOSException {
        if (tblApproveList == null) {
            return;
        }
        if (tblApproveList.getColumn("AdminOrgUnit.name") != null) {
            tblApproveList.getColumn("AdminOrgUnit.name").getStyleAttributes().setHided(!isPersonOrg);
        }
        if (tblApproveList.getColumn("AdminOrgUnit.displayName") != null) {
            tblApproveList.getColumn("AdminOrgUnit.displayName").getStyleAttributes().setHided(!isOrgFullName);
        }
        if (tblApproveList.getColumn("Position.name") != null) {
            tblApproveList.getColumn("Position.name").getStyleAttributes().setHided(!isPersonOrg && !isOrgFullName);
        }
    }

    public static void showMultiapproveOrgFullName(KDTable tblApproveList) throws BOSException {
        boolean c;
        if (tblApproveList == null) {
            return;
        }
        boolean b = !MultiApproveUtil.paramValueIsTrue("showMultiapprovePersonOrg");
        boolean bl = c = !MultiApproveUtil.paramValueIsTrue("showMultiapproveOrgFullName");
        if (tblApproveList.getColumn("AdminOrgUnit.displayName") != null) {
            tblApproveList.getColumn("AdminOrgUnit.displayName").getStyleAttributes().setHided(c);
        }
        if (tblApproveList.getColumn("Position.name") != null) {
            tblApproveList.getColumn("Position.name").getStyleAttributes().setHided(b && c);
        }
    }

    public static String getMultiapproveAttachmentPermissionMode(String assignmentId) {
        try {
            IWfUtil util = (IWfUtil)RpcProxy.wrapNoSupport(IWfUtil.class, (String)WfUtil.class.getName());
            return util.getApproveActPermissionMode(assignmentId);
        }
        catch (Exception e) {
            logger.error((Object)"retrieve param {MultiApproveAttachmentPermissionMode} failed!", (Throwable)e);
            return null;
        }
    }

    public static String getPasscommentAttachmentPermissionMode() {
        try {
            return ParamManager.getParamValue(null, null, (String)"PassCommentAttachmentPermissionMode");
        }
        catch (Exception e) {
            logger.error((Object)"retrieve param {PassCommentAttachmentPermissionMode} failed!", (Throwable)e);
            return null;
        }
    }

    public static void showAttachmentManager4Approve(AttachmentUIContextInfo info, Object owner, IObjectValue dataobject, String assignmentId) {
        MultiApproveUtil.showAttachmentManager(info, owner, dataobject, MultiApproveUtil.getMultiapproveAttachmentPermissionMode(assignmentId), true);
    }

    public static void showAttachmentManager4PassComment(AttachmentUIContextInfo info, Object owner, IObjectValue dataobject) {
        MultiApproveUtil.showAttachmentManager(info, owner, dataobject, MultiApproveUtil.getPasscommentAttachmentPermissionMode(), false);
    }

    public static void showAttachmentManager(AttachmentUIContextInfo info, Object owner, IObjectValue dataobject, String mode, boolean editable) {
        info.setEdit(editable);
        UIContext uictx = new UIContext(owner);
        uictx.put((Object)AttachmentUIContextInfo.class.getName(), (Object)info);
        uictx.put((Object)"NOALREADY", (Object)"noalready");
        if (mode != null && mode.length() != 0) {
            if ("0".equals(mode)) {
                mode = "1";
            }
            uictx.put((Object)"ATTACHMENTPERMISSIONMODE", (Object)mode);
        }
        if (!"1".equals(mode)) {
            if ("2".equals(mode)) {
                Object tmp = dataobject == null ? null : dataobject.get("creator");
                String creator = null;
                if (tmp instanceof String) {
                    creator = (String)tmp;
                } else if (tmp instanceof IObjectValue) {
                    creator = (tmp = ((IObjectValue)tmp).get("id")) == null ? null : tmp.toString();
                } else if (tmp != null) {
                    creator = tmp.toString();
                }
                uictx.put((Object)"BILLCREATORIDSTR", (Object)creator);
            } else if ("3".equals(mode)) {
                info.setEdit(false);
            } else if ("4".equals(mode)) {
                info.setEdit(true);
            } else if ("5".equals(mode)) {
                // empty if block
            }
        }
        String uiname = AttachmentByBoListUI.class.getName();
        String uimode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        UICreator.create((String)uiname, (String)uimode, (UIContext)uictx, (IUILifeCycleListener)info.getListener());
    }

    public static IRowSet mergeProcessingApproveAssign(IRowSet rowSet, IRowSet otherRowSet) throws Exception {
        if (otherRowSet == null || otherRowSet.size() <= 0) {
            return rowSet;
        }
        if (rowSet == null || rowSet.size() <= 0) {
            return otherRowSet;
        }
        Collection col = otherRowSet.toCollection();
        Iterator itr = col.iterator();
        rowSet.afterLast();
        while (itr.hasNext()) {
            Vector row = (Vector)itr.next();
            rowSet.moveToInsertRow();
            for (int i = 0; i < row.size(); ++i) {
                rowSet.updateObject(i + 1, row.get(i));
            }
            rowSet.insertRow();
        }
        rowSet.beforeFirst();
        return rowSet;
    }

    public static Config getClientExtConfig() throws BOSException {
        return ConfigLoader.getConfig4Client();
    }

    public static MultiApproveInfo generateInfo(String billId, String assignmentId, ApproveResult isPass, String handlerOption, String handlerContent, Object approveContent, boolean sendMail, boolean sendSMS) {
        MultiApproveInfo info = new MultiApproveInfo();
        info.setExtendedProperty("isAddNew", "isAddNew");
        info.setIsMailNotifyNext(sendMail);
        info.setIsMobelNotifyNext(sendSMS);
        if (approveContent == null) {
            approveContent = "";
        }
        if (approveContent instanceof Map) {
            Map opinions = (Map)approveContent;
            for (Locale l : opinions.keySet()) {
                String comment = (String)opinions.get(l);
                info.setOpinion(comment, l);
            }
        } else {
            info.setOpinion(approveContent.toString());
        }
        info.setIsPass(isPass);
        if (handlerOption == null || handlerOption.length() == 0) {
            handlerOption = "0";
        }
        if (handlerOption.indexOf(43) <= 0) {
            int decisionKey = Integer.parseInt(handlerOption);
            info.setHandlerOpinion(decisionKey);
        }
        info.setMultiHandleOpinion(handlerOption);
        info.setHandlerContent(handlerContent);
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        if (billId != null) {
            BOSUuid uuid = BOSUuid.read((String)billId);
            info.setBillId(uuid);
            info.setExtendedProperty("businuessObjectId", billId);
        }
        if (assignmentId != null) {
            info.setAssignment(assignmentId);
            info.setExtendedProperty("assignmentID", assignmentId);
        }
        info.setInputType(InputType.MSG_CENTER);
        return info;
    }

    public static String[] batchSubmit(CoreUIObject ui, String[] billIds, String[] assignmentIds, String[] billNumbers, ApproveResult isPass, String handlerOption, String handlerContent, Object approveContent, boolean sendMail, boolean sendSMS, String assoLine, boolean checkPostParticipants) throws Exception {
        MultiApproveInfo info = MultiApproveUtil.generateInfo(null, null, isPass, handlerOption, handlerContent, approveContent, sendMail, sendSMS);
        IMultiApproveClientExt ext = MultiApproveUtil.getClientExtConfig().getMultiApproveClientExt(billIds[0]);
        if (ext != null && !ext.beforeSubmit(billIds, assignmentIds, info, assoLine, ui)) {
            SysUtil.abort();
        }
        IMultiApprove multi = MultiApproveFactory.getRemoteInstance();
        String[] result = null;
        try {
            result = multi.batchSubmit(billIds, assignmentIds, billNumbers, isPass, handlerOption, handlerContent, approveContent, sendMail, sendSMS, checkPostParticipants);
        }
        catch (BOSException ex) {
            String error = ex.getMessage();
            if (error != null && error.startsWith("NeedAssignParticipantsWarnException::")) {
                String msg = error.substring("NeedAssignParticipantsWarnException::".length());
                if (billIds.length > 1) {
                    int option = MsgBox.showConfirm3a((String)(MultiapproveUtils.getResString("Multiapprove_Confrim_No_Performer_Prefix") + "\uff0c" + MultiapproveUtils.getResString("Multiapprove_List_Confrim_Submit_Suffix")), (String)msg);
                    if (option != 0) {
                        SysUtil.abort();
                    } else {
                        result = multi.batchSubmit(billIds, assignmentIds, billNumbers, isPass, handlerOption, handlerContent, approveContent, sendMail, sendSMS, false);
                    }
                } else {
                    int option = MsgBox.showConfirm4a((String)(MultiapproveUtils.getResString("Multiapprove_Confrim_No_Performer_Prefix") + "\uff0c" + MultiapproveUtils.getResString("Multiapprove_Confrim_No_Performer_Suffix")), (String)msg);
                    if (option == 0) {
                        HashMap map = new HashMap();
                        DesignatePerformerUI.process(ui, assignmentIds[0], map);
                        SysUtil.abort();
                    } else if (option != 1) {
                        SysUtil.abort();
                    } else {
                        result = multi.batchSubmit(billIds, assignmentIds, billNumbers, isPass, handlerOption, handlerContent, approveContent, sendMail, sendSMS, false);
                    }
                }
            }
            throw ex;
        }
        if (ext != null) {
            ext.afterSubmit(billIds, assignmentIds, info, assoLine, ui);
        }
        return result;
    }

    public static KDTable getApproveHistoryTable(String approveHistoryClsName, String billId, boolean isHistory) throws UIException, BOSException, Exception {
        Class<?> cls = Class.forName(approveHistoryClsName);
        IApproveHistoryTableUI tableUI = (IApproveHistoryTableUI)cls.newInstance();
        return tableUI.getApproveHistoryTable(billId, isHistory);
    }

    public static KDTable getApproveHistoryTable(String billId, boolean isHistory) throws UIException, BOSException {
        return ConfigLoader.getConfig4Client().getMultiApproveHistoryGridUI(billId).getApproveHistoryTable(billId, isHistory);
    }

    public static boolean canAppendPreActivity(String procInstId) throws WfException {
        boolean canAppend = true;
        EASWfServiceClient wfServiceClient = new EASWfServiceClient();
        IEnactmentService es = wfServiceClient.getService();
        ArrayList actIds = es.getOpenedActivityByProcInstId(procInstId);
        int length = 0;
        for (int i = 0; i < actIds.size(); ++i) {
            String actId = (String)actIds.get(i);
            ActivityInstInfo info = es.getActivityInstByActInstId(actId);
            ActivityDef actDef = es.getActDefByActInstInfo(info);
            if (actDef == null || actDef.getActivityHeader() == null || actDef.getActivityHeader().getExtendedAttributes() == null || actDef.getActivityHeader().getExtendedAttributes().get("isAppended") == null) continue;
            String isAppended = actDef.getActivityHeader().getExtendedAttributes().get("appendActivity").getValue();
            if ("true".equals(isAppended)) {
                ++length;
            }
            if (length <= 1) continue;
            canAppend = false;
            return canAppend;
        }
        return canAppend;
    }

    public static Object[] getSelectedPersons(IUIObject owner, String billId) {
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.basedata.person.app", "AllPersonQuery");
        QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)pk);
        HashMap<String, String> promptContext = new HashMap<String, String>();
        promptContext.put("0", "1");
        promptContext.put("All_Admins", "true");
        String defaultShowAll = null;
        try {
            if (ConfigLoader.getConfig4Client().getBoolean("next.person.default.show.all.org", billId, "false")) {
                defaultShowAll = "true";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        promptContext.put("DEFAULT_SHOW_ALL", defaultShowAll);
        PersonPromptBox dialog = new PersonPromptBox(owner, promptContext);
        dialog.setQueryInfo(queryInfo);
        dialog.setModal(true);
        dialog.setEnabledMultiSelection(true);
        dialog.setIsSingleSelect(false);
        dialog.show();
        if (dialog.getData() != null) {
            return (Object[])dialog.getData();
        }
        return null;
    }
}

