/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.IWfFacade;
import com.kingdee.bos.workflow.service.ormrpc.WfFacadeFactory;
import com.kingdee.bos.workflow.util.SimpleComparator;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.DecisionItemInfo;
import com.kingdee.eas.base.multiapprove.MultiapproveUtils;
import com.kingdee.eas.base.multiapprove.client.AbstractMultiapproveBillsUI;
import com.kingdee.eas.base.multiapprove.client.DesignatePerformerUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.multiapprove.client.SignatureUtils;
import com.kingdee.eas.base.myeas.MyPhraseInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.CAIdentityAuthorize;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ObjectValueSignature;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class MultiapproveBillsUI
extends AbstractMultiapproveBillsUI {
    private static final long serialVersionUID = -4532049087724555126L;
    public static final String BILLID_ASSIGNMENT_MAP = "BillIdAssignmentMap";
    public static final String APPROVE_DEFAULT_OPINION = "approveDefaultOpinion";
    private static final String MULTIAPPROVE_MANUALDECISION_ITEMS = "manualDecisionItems";
    String notPassText = EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"ISPASS_FALSE");
    String passText = EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"ISPASS_TRUE");
    private static final Logger log = CoreUIObject.getLogger(MultiapproveBillsUI.class);
    private Map billIdAssignmentMap;
    String decisionItems = "";
    private String assignmentId = null;
    private CoreUIObject coreuiObj = null;
    private String caType = SignatureUtils.BOTH;
    private boolean isNeedSignature = false;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        Map billIdAssignmentObj = (Map)this.getUIContext().get(BILLID_ASSIGNMENT_MAP);
        RequestContext requestContext = (RequestContext)postman.getRequestContext();
        requestContext.put(BILLID_ASSIGNMENT_MAP, (Object)billIdAssignmentObj);
        return postman;
    }

    public void onLoad() throws Exception {
        Object billIdAssignmentObj;
        this.setQueryPreference(false);
        super.onLoad();
        this.menuBar = new KDMenuBar();
        this.menuBar.setVisible(false);
        log.info((Object)"Have started onLoad()!");
        this.pass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiapproveBillsUI.this.setRadioButton();
            }
        });
        this.notPass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiapproveBillsUI.this.setRadioButton();
            }
        });
        this.btnNextPerson.setVisible(true);
        this.btnNextPerson.setEnabled(true);
        this.btnNextPerson.setIcon(EASResource.getIcon((String)"imgTbtn_usercollocatemanage"));
        this.setRadioButton();
        this.multiapproveBills.setIcon(EASResource.getIcon((String)"imgTbtn_deliverto"));
        HashMap uiContext = (HashMap)this.getUIContext();
        if (uiContext == null) {
            String message = "\"uicontext\" is null!";
            throw new IllegalArgumentException(message);
        }
        if (this.getUIContext().get("Owner") != null) {
            this.coreuiObj = (CoreUIObject)uiContext.get("Owner");
        }
        if ((billIdAssignmentObj = uiContext.get(BILLID_ASSIGNMENT_MAP)) == null) {
            String message = "\"billIdAssignmentObj\" is null!";
            throw new IllegalArgumentException(message);
        }
        if (!(billIdAssignmentObj instanceof Map)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("\"billIdAssignmentObj\" isn't Map!");
            buffer.append("\"billIdAssignmentObj\" is " + billIdAssignmentObj.getClass().getName() + "!");
            String message = buffer.toString();
            throw new IllegalArgumentException(message);
        }
        if (SysContext.getSysContext().getLocale().equals(new Locale("L3"))) {
            this.auditOpinion.setSelectedIndex(1);
        }
        this.billIdAssignmentMap = (Map)billIdAssignmentObj;
        if (this.billIdAssignmentMap.size() == 1) {
            String opinion;
            String decision;
            this.assignmentId = (String)this.billIdAssignmentMap.values().iterator().next();
            IEnactmentService wfService = EnactmentServiceFactory.createRemoteEnactService();
            Map map = wfService.getActivityDefAndActivityInstInfo(this.assignmentId);
            if (map != null && map.get("ACTIVITYDEF") != null && map.get("ACTIVITYDEF") instanceof ApproveActivityDef && !StringUtils.isEmpty((String)(decision = ((ApproveActivityDef)map.get("ACTIVITYDEF")).getManualDecisionItems(SysContext.getSysContext().getLocale())))) {
                this.getUIContext().put(MULTIAPPROVE_MANUALDECISION_ITEMS, decision);
            }
            if ((opinion = (String)this.getUIContext().get(APPROVE_DEFAULT_OPINION)) == null || opinion.equals("")) {
                opinion = this.passText;
            }
            this.auditOpinion.setDefaultLangItemData((Object)opinion);
        } else {
            this.btnNextPerson.setEnabled(false);
        }
        if (this.getUIContext().get(MULTIAPPROVE_MANUALDECISION_ITEMS) != null) {
            this.decisionItems = (String)this.getUIContext().get(MULTIAPPROVE_MANUALDECISION_ITEMS);
        }
        this.auditOpinion.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
        this.loadDecisionItems(this.decisionItems, true);
        this.setAuditPolicyState();
        this.setSignButtonStatus();
        this.initMyPharse();
    }

    private void initMyPharse() {
        this.kDBizPromptBox1.setEditorLength(0);
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("creator.id", (Object)user.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.kDBizPromptBox1.setEntityViewInfo(viewInfo);
        this.kDBizPromptBox1.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Object newValue = eventObj.getNewValue();
                if (newValue instanceof MyPhraseInfo) {
                    MyPhraseInfo info = (MyPhraseInfo)newValue;
                    MultiapproveBillsUI.this.setOption(info.getName());
                }
            }
        });
    }

    private void setOption(String option) {
        if (StringUtils.isEmpty((String)option)) {
            return;
        }
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo languageInfo = null;
        while (iter.hasNext()) {
            languageInfo = (LanguageInfo)iter.next();
            this.auditOpinion.setItemData(languageInfo, (Object)option);
        }
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        if (e.getSource() == null) {
            return;
        }
        if (MultiApproveUtil.isShowDialog() && MessageDialog.show((Component)((Object)this), (Object)MultiapproveUtils.getResString("MULTIAPPROVE_CONFIRM"), (String)MultiapproveUtils.getResString("MULTIAPPROVE_PROMPT"), (int)2) != 0) {
            return;
        }
        if (this.billIdAssignmentMap == null || this.billIdAssignmentMap.size() <= 0) {
            return;
        }
        if (!this.isCanApprovle()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource.APPROVELOPTION_REQUIRED"));
            return;
        }
        if (this.isNeedSignature) {
            this.signatureBills();
        }
        TreeMap<Locale, String> opinions = new TreeMap<Locale, String>((Comparator<Locale>)new SimpleComparator());
        List langs = KDBizMultiLangArea.getLanguageList();
        for (int i = 0; i < langs.size(); ++i) {
            LanguageInfo lang = (LanguageInfo)langs.get(i);
            String opinion = (String)this.auditOpinion.getItemDataByLang(lang);
            if (opinion.length() > 1000) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"opinionTooLong"));
                return;
            }
            opinions.put(lang.getLocale(), opinion);
        }
        ApproveResult approveResult = this.pass.isSelected() ? ApproveResult.PASS : ApproveResult.NOT_PASS;
        int decisionKey = ((DecisionItemInfo)this.auditPolicy.getSelectedItem()).getKey();
        String decisionValue = ((DecisionItemInfo)this.auditPolicy.getSelectedItem()).getValue();
        Iterator it = this.billIdAssignmentMap.keySet().iterator();
        ArrayList<String> billIds = new ArrayList<String>();
        ArrayList assignmentIds = new ArrayList();
        ArrayList<String> billNumbers = new ArrayList<String>();
        while (it.hasNext()) {
            String billid = (String)it.next();
            billIds.add(billid);
            assignmentIds.add(this.billIdAssignmentMap.get(billid));
            if (this.coreuiObj instanceof ListUI) {
                String number = MultiApproveUtil.getTableCellValue(((ListUI)this.coreuiObj).getMainTable(), billid, "number");
                if (!StringUtils.isEmpty((String)number)) {
                    billNumbers.add(number);
                    continue;
                }
                billNumbers.add(null);
                continue;
            }
            billNumbers.add(null);
        }
        MultiApproveUtil.batchSubmit((CoreUIObject)this, billIds.toArray(new String[0]), assignmentIds.toArray(new String[0]), billNumbers.toArray(new String[0]), approveResult, String.valueOf(decisionKey), decisionValue, opinions, false, false, ((DecisionItemInfo)this.auditPolicy.getModel().getSelectedItem()).getAssocicateLine(), true);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource.BIZAPPROVE_SUCCESS_INFO"));
        this.getUIWindow().close();
    }

    private boolean isCanApprovle() {
        Locale local = this.getCurrentLocale();
        LanguageInfo languageInfo = new LanguageInfo(local);
        String content = (String)this.auditOpinion.getItemDataByLang(languageInfo);
        return content != null && content.trim().length() != 0;
    }

    @Override
    protected void rdPass_stateChanged(ChangeEvent e) throws Exception {
        super.rdPass_stateChanged(e);
        this.setAuditPolicyState();
    }

    @Override
    protected void rdPass_actionPerformed(ActionEvent e) throws Exception {
        super.rdPass_actionPerformed(e);
        this.setAuditPolicyState();
    }

    @Override
    protected void rdNotPass_actionPerformed(ActionEvent e) throws Exception {
        super.rdNotPass_actionPerformed(e);
        this.setAuditPolicyState();
    }

    @Override
    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        if (this.assignmentId == null || this.assignmentId.trim().equals("")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource.HAVENO_MULTIAPPROVE_ASSIGNMENT"));
            return;
        }
        ActivityInstInfo actInstInfo = null;
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        Map actMap = service.getActivityDefAndActivityInstInfo(this.assignmentId);
        actInstInfo = actMap != null ? (ActivityInstInfo)actMap.get("ACTIVITYINSTINFO") : null;
        HashMap<String, String> map = new HashMap<String, String>();
        if (actInstInfo != null) {
            IWfFacade facade = WfFacadeFactory.getRemoteInstance();
            boolean isShowAllEmptyPostActivities = facade.isShowAllEmptyPostActivityPerformers(actInstInfo.getActDefId(), actInstInfo.getProcDefHashValue());
            map.put("isShowAllEmptyPostActivities", String.valueOf(isShowAllEmptyPostActivities));
        }
        DesignatePerformerUI.process((CoreUIObject)this, this.assignmentId, map);
    }

    private void setAuditPolicyState() {
        this.auditPolicy.setVisible(true);
        this.auditPolicy.setEnabled(true);
    }

    private void loadDecisionItems(String decisionItems, boolean approveType) {
        DefaultComboBoxModel<DecisionItemInfo> model = new DefaultComboBoxModel<DecisionItemInfo>();
        List items = MultiApproveUtil.getFilterDecisionItemList(decisionItems, approveType);
        for (int i = 0; i < items.size(); ++i) {
            model.addElement((DecisionItemInfo)items.get(i));
        }
        this.auditPolicy.setModel(model);
    }

    private void setRadioButton() {
        if (this.notPass.isSelected()) {
            this.loadDecisionItems(this.decisionItems, false);
            this.setDefaultOption(this.notPassText);
        } else {
            this.loadDecisionItems(this.decisionItems, true);
            this.setDefaultOption(this.passText);
        }
    }

    private void setDefaultOption(String defaultOption) {
        List langs = KDBizMultiLangArea.getLanguageList();
        for (int i = 0; i < langs.size(); ++i) {
            LanguageInfo lang = (LanguageInfo)langs.get(i);
            String opinion = (String)this.auditOpinion.getItemDataByLang(lang);
            if (opinion != null && !opinion.equalsIgnoreCase("") && !opinion.equalsIgnoreCase(this.notPassText) && !opinion.equalsIgnoreCase(this.passText)) continue;
            this.auditOpinion.setItemData(lang, (Object)defaultOption);
        }
    }

    private void signatureBills() throws Exception {
        Iterator iterator = this.billIdAssignmentMap.entrySet().iterator();
        ObjectUuidPK[] pk = new ObjectUuidPK[this.billIdAssignmentMap.entrySet().size()];
        BOSUuid boId = null;
        BOSObjectType billObjectType = null;
        String keyFieldName = null;
        int i = 0;
        ArrayList<String> signBillIds = new ArrayList<String>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            pk[i] = new ObjectUuidPK(entry.getKey().toString());
            if (pk[i] != null) {
                signBillIds.add(pk[i].toString());
            }
            boId = BOSUuid.read((String)entry.getKey().toString());
            ++i;
        }
        if (boId != null) {
            billObjectType = boId.getType();
            String assignId = (String)this.billIdAssignmentMap.get(boId.toString());
            this.caType = SignatureUtils.getCATypeByAssign(assignId);
        }
        String oprtState = this.coreuiObj.getOprtState();
        if (this.coreuiObj instanceof CoreBillListUI) {
            CoreBillListUI listui = (CoreBillListUI)this.coreuiObj;
            keyFieldName = listui.getKeyFieldNameForWF();
            log.error((Object)("------------listui.getKeyFieldNameForWF() " + keyFieldName));
        }
        if (billObjectType != null && pk != null && pk.length > 0) {
            ObjectValueSignature signature = new ObjectValueSignature();
            if (keyFieldName == null) {
                log.error((Object)"keyFieldName is null");
                keyFieldName = "id";
            }
            log.error((Object)("billObjectType " + billObjectType));
            log.error((Object)("pk.length " + pk.length));
            if (this.caType.equals(SignatureUtils.CHECK_ONLY) || this.caType.equals(SignatureUtils.BOTH)) {
                signature.check(this.coreuiObj.getOprtState(), billObjectType, signBillIds);
            }
            if (this.caType.equals(SignatureUtils.SIGN_ONLY) || this.caType.equals(SignatureUtils.BOTH)) {
                if (this.caType.equals(SignatureUtils.SIGN_ONLY)) {
                    CAIdentityAuthorize.checkUser();
                    CAIdentityAuthorize.checkPassword();
                }
                CAIdentityAuthorize.signatureWithoutCheckSign((String)oprtState, (BOSObjectType)billObjectType, (IObjectPK[])pk, (String)keyFieldName);
            }
        }
    }

    private void setSignButtonStatus() {
        Iterator iterator = this.billIdAssignmentMap.entrySet().iterator();
        BOSUuid boId = null;
        BOSObjectType billObjectType = null;
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            boId = BOSUuid.read((String)entry.getKey().toString());
        }
        this.btnIsSign.setVisible(false);
        if (boId != null) {
            billObjectType = boId.getType();
        }
        if (billObjectType != null && CAIdentityAuthorize.isBosTypeSignatureWhenApprove((String)boId.toString(), (BOSObjectType)billObjectType)) {
            this.isNeedSignature = true;
        }
    }
}

