/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.monitor.client.WfUtils;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.CounterSignInfo;
import com.kingdee.eas.base.multiapprove.client.AbstractParticipantSelectorUI;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.apache.log4j.Logger;

public class ParticipantSelectorUI
extends AbstractParticipantSelectorUI {
    private static final Logger logger = CoreUIObject.getLogger(ParticipantSelectorUI.class);
    private PersonPromptBox personPromptBox = null;
    public static final String DEFAULT_FILTER = "DEFAULT_FILTER";
    public static final String COUNTER_SIGN_INFO = "counterSignInfo";

    public void onLoad() throws Exception {
        super.onLoad();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("All_Admins", "YES");
        String defaultShowAll = null;
        AssignmentInfo assign = (AssignmentInfo)this.getUIContext().get("WfAssignmentInfo");
        String billId = assign.getBizObjectIds();
        try {
            if (ConfigLoader.getConfig4Client().getBoolean("next.person.default.show.all.org", billId, "false")) {
                defaultShowAll = "true";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        hashMap.put("DEFAULT_SHOW_ALL", defaultShowAll);
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.basedata.person.app", "AllPersonQuery");
        QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)pk);
        this.personPromptBox = new PersonPromptBox((IUIObject)this, hashMap);
        this.personPromptBox.setQueryInfo(queryInfo);
        this.personPromptBox.setEnabledMultiSelection(true);
        this.personPromptBox.setIsSingleSelect(false);
        this.setDefaultFilter();
        this.txtComment.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
        this.initCounterSignList();
    }

    private void setDefaultFilter() {
        EntityViewInfo entityViewInfo = (EntityViewInfo)this.getUIContext().get(DEFAULT_FILTER);
        if (entityViewInfo != null) {
            this.personPromptBox.setEntityViewInfo(entityViewInfo);
        }
    }

    private void initCounterSignList() throws BOSException {
        AssignmentInfo info;
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        IPerson iPerson = PersonFactory.getRemoteInstance();
        AssignmentInfo assignMentInfo = (AssignmentInfo)this.getUIContext().get("WfAssignmentInfo");
        String procInstId = assignMentInfo.getProcInstId();
        String activityId = assignMentInfo.getActInstId();
        EASWfServiceClient ormEsc = new EASWfServiceClient();
        Map flowVaries = ormEsc.getProcessContext(procInstId);
        HashSet assignmentIds = (HashSet)flowVaries.get("countersignAssignments");
        DefaultListModel<CounterSignInfo> listModel = new DefaultListModel<CounterSignInfo>();
        boolean hasAssigned = false;
        if (assignmentIds != null) {
            try {
                Iterator iterator = assignmentIds.iterator();
                while (iterator.hasNext()) {
                    CounterSignInfo countSignInfo = new CounterSignInfo();
                    String assignmentId = (String)iterator.next();
                    info = service.getAssignmentById(assignmentId);
                    if (info.getState() == WfAssignmentState.CANCELED || info.getState() == WfAssignmentState.COMPLETED || info.getState() == WfAssignmentState.PROCESSING || info.getState() == WfAssignmentState.REJECTED || !info.getActInstId().equals(activityId)) continue;
                    PersonInfo personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getEmployeeId()));
                    countSignInfo.setAssignment(info);
                    countSignInfo.setPerson(personInfo);
                    hasAssigned = true;
                    if (listModel.contains(countSignInfo)) continue;
                    listModel.addElement(countSignInfo);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)"EASBizException", (Throwable)e);
            }
        }
        if (!hasAssigned) {
            AssignmentInfo[] infos = service.getAssignmentByActInstId(activityId);
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < infos.length; ++i) {
                String personId;
                info = infos[i];
                if (info.getState() == WfAssignmentState.CANCELED || info.getState() == WfAssignmentState.COMPLETED || info.getState() == WfAssignmentState.PROCESSING || info.getState() == WfAssignmentState.REJECTED || set.contains(personId = infos[i].getEmployeeId())) continue;
                set.add(personId);
                try {
                    PersonInfo person = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                    CounterSignInfo countSignInfo = new CounterSignInfo();
                    countSignInfo.setPerson(person);
                    listModel.addElement(countSignInfo);
                    continue;
                }
                catch (EASBizException e) {
                    logger.error((Object)"EASBizException", (Throwable)e);
                }
            }
        }
        this.prfrmrLst.setModel(listModel);
        this.prfrmrLst.setCellRenderer((ListCellRenderer)new CounterSignListCellRenderer());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.addBtn.setText(null);
        this.addBtn.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.deleteBtn.setText(null);
        this.deleteBtn.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    @Override
    public void confirmAction_actionPerformed(ActionEvent e) throws Exception {
        super.confirmAction_actionPerformed(e);
        HashSet<String> setPersonID = new HashSet<String>();
        ListModel listModel = this.prfrmrLst.getModel();
        if (listModel.getSize() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"NO_SIGN_PERSON"));
            return;
        }
        int length = listModel.getSize();
        for (int i = 0; i < length; ++i) {
            CounterSignInfo countSignInfo = (CounterSignInfo)listModel.getElementAt(i);
            PersonInfo personInfo = countSignInfo.getPerson();
            setPersonID.add(personInfo.getId().toString());
        }
        String[] personIdArray = setPersonID.toArray(new String[setPersonID.size()]);
        AssignmentInfo assignmentInfo = (AssignmentInfo)this.getUIContext().get("WfAssignmentInfo");
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        HashMap<Object, Object> extendMsg = new HashMap<Object, Object>();
        HashMap<String, String> counterSignInfoMap = new HashMap<String, String>();
        SysContext ctx = SysContext.getSysContext();
        String procInstId = assignmentInfo.getProcInstId();
        extendMsg.put("assignCountersign", Boolean.TRUE);
        UserInfo user = ctx.getCurrentUserInfo();
        this.setCounterSignInfo(counterSignInfoMap, user);
        counterSignInfoMap.put("procInstId", procInstId);
        extendMsg.put(COUNTER_SIGN_INFO, counterSignInfoMap);
        String comments = (String)this.txtComment.getItemBy(new LanguageInfo(ctx.getLocale())).getData();
        if (comments != null && comments.length() > 0) {
            if (comments.length() > 1000) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"111_ParticipantSelectorUI"));
                return;
            }
            comments = comments + EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"112_ParticipantSelectorUI") + ctx.getCurrentUserInfo().getName(ctx.getLocale());
            extendMsg.put(ctx.getLocale(), comments);
        } else if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"113_ParticipantSelectorUI")) != 0) {
            return;
        }
        service.assignCountersign(assignmentInfo.getAssignmentId(), personIdArray, extendMsg);
        this.getUIWindow().close();
    }

    public void setCounterSignInfo(HashMap map, UserInfo user) {
        HashMap<Locale, String> commentMap = new HashMap<Locale, String>();
        HashMap<Object, String> initiatorMap = new HashMap<Object, String>();
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo languageInfo = null;
        Locale local = null;
        String optionData = null;
        while (iter.hasNext()) {
            languageInfo = (LanguageInfo)iter.next();
            local = languageInfo.getLocale();
            MultiLangItem optionContent = this.txtComment.getItemBy(languageInfo);
            optionData = (String)optionContent.getData();
            commentMap.put(local, StringUtils.trim((String)optionData));
            initiatorMap.put(local, user.getName(local));
        }
        initiatorMap.put("counterSignInitiatorID", user.getId() != null ? user.getId().toString() : "");
        map.put("counterSignComment", commentMap);
        map.put("counterSignInitiator", initiatorMap);
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        super.cancelAction_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void addPerformerAction_actionPerformed(ActionEvent e) throws Exception {
        this.personPromptBox.show();
        Object data = this.personPromptBox.getData();
        if (data instanceof Object[]) {
            Object[] performers = (Object[])data;
            boolean b = false;
            int length = performers.length;
            for (int i = 0; i < length; ++i) {
                if (performers[i] == null || this.checkIsExist(performers[i])) continue;
                CounterSignInfo info = new CounterSignInfo();
                PersonInfo p = (PersonInfo)performers[i];
                if (!WfUtils.checkPersonHasUser((String)p.getId().toString())) {
                    b = true;
                    continue;
                }
                info.setPerson(p);
                info.setAssignment(null);
                this.prfrmrLst.addElement((Object)info);
            }
            if (b) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"114_ParticipantSelectorUI"));
            }
        } else if (data != null && !this.checkIsExist(data)) {
            this.prfrmrLst.addElement(data);
        }
    }

    private boolean checkIsExist(Object o) {
        boolean exist = false;
        if (this.prfrmrLst.getElementCount() < 1) {
            return exist;
        }
        for (int i = 0; i < this.prfrmrLst.getElementCount(); ++i) {
            CounterSignInfo obj = (CounterSignInfo)this.prfrmrLst.getElement(i);
            if (!o.equals(obj.getPerson())) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"PERSON_EXIST"));
            exist = true;
            break;
        }
        return exist;
    }

    @Override
    public void deletePerformerAction_actionPerformed(ActionEvent e) throws Exception {
        int[] indices = this.prfrmrLst.getSelectedIndices();
        if (indices != null && indices.length > 0) {
            int index = 0;
            for (int i = 0; i < indices.length; ++i) {
                CounterSignInfo info = (CounterSignInfo)this.prfrmrLst.getElement(indices[i] - index);
                if (info.getAssignment() == null) {
                    this.prfrmrLst.removeElementAt(indices[i] - index);
                    ++index;
                    continue;
                }
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"ASSIGNMENTED_CANNOT_DEL"));
            }
            if ((index = indices[indices.length - 1] - index + 1) < this.prfrmrLst.getModel().getSize()) {
                this.prfrmrLst.setSelectedIndex(index);
            } else {
                this.prfrmrLst.setSelectedIndex(index - 1);
            }
        }
    }

    class CounterSignListCellRenderer
    extends DefaultListCellRenderer {
        CounterSignListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            CounterSignInfo info = null;
            if (value instanceof CounterSignInfo) {
                info = (CounterSignInfo)value;
                String name = info.getPerson().getName();
                this.setText(name);
                if (info.getAssignment() == null) {
                    this.setIcon(EASResource.getIcon((String)"imgList_taskundistribute"));
                    this.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"COUNTERSIGN_NOT_ASSIGN"));
                    return retValue;
                }
                WfAssignmentState state = info.getAssignment().getState();
                switch (state.getValue()) {
                    case 2: {
                        this.setIcon(EASResource.getIcon((String)"imgList_taskdistribute"));
                        this.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"COUNTERSIGN_ACCEPTED"));
                        break;
                    }
                    case 1: {
                        this.setIcon(EASResource.getIcon((String)"imgList_taskaccept"));
                        this.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"COUNTERSIGN_ASSIGNED"));
                        break;
                    }
                    case 4: {
                        this.setIcon(EASResource.getIcon((String)"imgList_taskcancel"));
                        this.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"COUNTERSIGN_CANCELED"));
                        break;
                    }
                    case 16: {
                        this.setIcon(EASResource.getIcon((String)"imgList_taskcomplete"));
                        this.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"COUNTERSIGN_COMPLETED"));
                        break;
                    }
                    case 8: {
                        this.setIcon(EASResource.getIcon((String)"imgList_taskrefuse"));
                        this.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"COUNTERSIGN_REJECTED"));
                        break;
                    }
                    default: {
                        this.setIcon(EASResource.getIcon((String)"imgList_taskundistribute"));
                        this.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"COUNTERSIGN_NOT_ASSIGN"));
                    }
                }
            }
            return retValue;
        }
    }
}

