/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.monitor.IWfUtil;
import com.kingdee.bos.workflow.monitor.WfFacadeUtilFactory;
import com.kingdee.bos.workflow.monitor.client.WfMonitorUtils;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.message.client.MessageServiceProvider;
import com.kingdee.eas.base.multiapprove.IDynamicObjectLoader;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.IPassComment;
import com.kingdee.eas.base.multiapprove.MetadataUtils;
import com.kingdee.eas.base.multiapprove.MultiApproveException;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.PassCommentFactory;
import com.kingdee.eas.base.multiapprove.PassCommentInfo;
import com.kingdee.eas.base.multiapprove.PassCommentMonitorUtil;
import com.kingdee.eas.base.multiapprove.client.AbstractPassCommentUI;
import com.kingdee.eas.base.multiapprove.client.DynamicOpListUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.base.uiframe.client.UIModelDialogFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class PassCommentUI
extends AbstractPassCommentUI {
    private static final long serialVersionUID = -8748827362851497968L;
    private static Logger log = Logger.getLogger(PassCommentUI.class);
    private static final String multiApproveResourcefile = "com.kingdee.eas.base.multiapprove.MultiApproveResource";
    private String procInstId;
    boolean canSubmit;
    private String boid;
    private String initiator;
    private String passerId;
    private String passId;
    private String assignId;
    private CoreUIObject billUI;

    public PassCommentUI() throws Exception {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        Dimension preferredSize = new Dimension(screenSize.width, screenSize.height - 70);
        this.setMaximumSize(preferredSize);
        this.setPreferredSize(preferredSize);
    }

    public void onLoad() throws Exception {
        this.assignId = null;
        IEnactmentService svc = EnactmentServiceFactory.createRemoteEnactService();
        this.boid = (String)this.getUIContext().get("boid");
        this.initiator = (String)this.getUIContext().get("sender");
        String parameters = (String)this.getUIContext().get("parameters");
        if (this.boid != null) {
            ProcessInstInfo[] procs = svc.getProcessInstanceByHoldedObjectId(this.boid);
            if (!(procs != null && procs.length != 0 || (procs = svc.getAllProcessInstancesByBizobjId(this.boid)) != null && procs.length != 0)) {
                MsgBox.showError((String)EASResource.getString((String)multiApproveResourcefile, (String)"noProcessInstance"));
                SysUtil.abort();
            }
            String state = "";
            this.procInstId = "";
            for (int i = 0; i < procs.length; ++i) {
                state = procs[i].getState();
                this.procInstId = procs[i].getProcInstId();
                if (state.startsWith("open.running")) break;
            }
            if (!state.startsWith("open.running")) {
                Timestamp d = null;
                for (int i = 0; i < procs.length; ++i) {
                    Timestamp tmp = procs[i].getCreatedTime();
                    if (d != null && d.after((Date)tmp)) continue;
                    d = tmp;
                    state = procs[i].getState();
                    this.procInstId = procs[i].getProcInstId();
                }
            }
            this.canSubmit = true;
        } else {
            ProcessInstInfo info;
            String lastItemStr;
            String[] tmp;
            if (parameters == null || !parameters.startsWith("PASS::")) {
                MsgBox.showError((String)EASResource.getString((String)multiApproveResourcefile, (String)"errorParam"));
                SysUtil.abort();
            }
            if ((tmp = parameters.substring("PASS::".length()).split(":")) != null && tmp.length > 0 && !StringUtils.isEmpty((String)(lastItemStr = tmp[tmp.length - 1])) && lastItemStr.endsWith("PASSID")) {
                this.passId = lastItemStr;
                this.assignId = tmp[tmp.length - 2];
            }
            this.procInstId = tmp[0];
            this.boid = tmp[1];
            this.passerId = tmp[2];
            boolean bl = this.canSubmit = !"true".equals(tmp[3]);
            if (!this.canSubmit && (info = svc.getProcessInstInfo(this.procInstId)) != null && info.getState().startsWith("open.running")) {
                this.canSubmit = true;
            }
            this.initiator = UserFactory.getRemoteInstance().getUserInfo("where id='" + tmp[2] + "'").getName(this.getLocale());
        }
        this.tblMain.setEditable(false);
        this.tblMain.checkParsed();
        this.btnSubmit.setEnabled(false);
        this.actionApproveHistory.setEnabled(true);
        this.initListener();
        PassCommentUI.fillTable(this.tblMain, this.boid);
        this.actionAttachment.setEnabled(true);
        this.actionAttachment.setVisible(true);
        this.btnAttachment.setEnabled(false);
        this.btnAttachment.setVisible(true);
    }

    static void fillTable(KDTable tblMain, String boid) throws Exception {
        IColumn col = tblMain.getColumn("comment");
        col.getStyleAttributes().setWrapText(true);
        col.setWidth(400);
        col = tblMain.getColumn("time");
        col.setWidth(110);
        ResourceBundle res = ResourceBundle.getBundle(DynamicOpListUI.class.getName(), SysContext.getSysContext().getLocale());
        tblMain.getHeadRow(0).getCell("comment").setValue((Object)res.getString("comment"));
        IWfUtil util = WfFacadeUtilFactory.createRemoteWfUtil();
        List list = util.getPassComment(boid);
        for (int i = 0; i < list.size(); ++i) {
            Map item = (Map)list.get(i);
            IRow row = tblMain.addRow();
            row.getCell("name").setValue(item.get("ffeedbacker"));
            row.getCell("initiator").setValue(item.get("finitiator"));
            String tmp = (String)item.get("fcomment");
            row.getCell("comment").setValue((Object)tmp);
            row.getCell("time").setValue(item.get("ftime"));
            KDTableHelper.autoFitRowHeight((KDTable)tblMain, (int)i, (int)8);
        }
    }

    public void initListener() {
        super.initListener();
        IUIWindow uiWindow = this.getUIWindow();
        if (uiWindow != null && uiWindow instanceof Window) {
            ((Window)uiWindow).addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent event) {
                    new OpenBillUIThread().start();
                }

                @Override
                public void windowClosed(WindowEvent event) {
                    IUIObject[] uiObjects = UIFrameUtil.findUIObject((String)MessageCenterUI.class.getName());
                    if (uiObjects != null && uiObjects.length > 0) {
                        MessageServiceProvider.delayRefresh((Object)uiObjects[0]);
                    } else {
                        MessageServiceProvider.delayRefresh(null);
                    }
                }

                class OpenBillUIThread
                extends Thread {
                    OpenBillUIThread() {
                    }

                    @Override
                    public void run() {
                        try {
                            IPassComment pass;
                            PassCommentInfo comment;
                            OpenBillUIThread.sleep(300L);
                            PassCommentUI.this.pnlBill.getViewport().removeAll();
                            PassCommentUI.this.initBillUI();
                            PassCommentUI.this.btnSubmit.setEnabled(PassCommentUI.this.canSubmit);
                            PassCommentUI.this.btnAttachment.setEnabled(true);
                            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
                            String personId = null;
                            PersonInfo person = userInfo.getPerson();
                            if (person != null) {
                                personId = person.getId().toString();
                            }
                            if (!StringUtils.isEmpty((String)PassCommentUI.this.passId) && !StringUtils.isEmpty((String)personId) && (comment = (pass = PassCommentFactory.getRemoteInstance()).getPassCommentInfo(" where passId='" + PassCommentUI.this.passId + "' and personId='" + personId + "'")).getUpdateTime() != null) {
                                PassCommentUI.this.btnSubmit.setEnabled(false);
                                MsgBox.showInfo((String)(EASResource.getString((String)PassCommentUI.multiApproveResourcefile, (String)"CIRCULATEREPEAT") + "!"));
                            }
                        }
                        catch (EASBizException e) {
                            PassCommentUI.this.handUIException(e);
                            log.error((Object)"PassCommentUI", (Throwable)e);
                        }
                        catch (BOSException e) {
                            PassCommentUI.this.handUIException(e);
                            log.error((Object)"PassCommentUI", (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            PassCommentUI.this.handUIException(e);
                            log.error((Object)"PassCommentUI", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    private void initBillUI() throws EASBizException, BOSException {
        if (this.oprtState == null || this.oprtState.length() == 0) {
            this.setOprtState(OprtState.ADDNEW);
        }
        BOSUuid billUuid = BOSUuid.read((String)this.boid);
        String approveViewUI = MetadataUtils.getEditUIClassByBillId(this.boid);
        if (approveViewUI == null || approveViewUI.trim().length() == 0) {
            throw new MultiApproveException(MultiApproveException.UI_CLASS_NOT_RIGHT);
        }
        BOSUuid pk = billUuid;
        String billId = billUuid.toString();
        IDynamicObjectLoader loader = (IDynamicObjectLoader)RpcProxy.wrapNoSupport(IDynamicObjectLoader.class);
        IObjectCollection dataCol = loader.find(this.boid);
        if (dataCol == null || dataCol.size() <= 0) {
            IMultiApprove iMultiApprove = MultiApproveFactory.getRemoteInstance();
            String message = EASResource.getString((String)multiApproveResourcefile, (String)"billhasDeleted");
            if (iMultiApprove.exist(pk)) {
                message = EASResource.getString((String)multiApproveResourcefile, (String)"noPermission");
            }
            MsgBox.showInfo((String)message);
            this.getUIWindow().close();
            return;
        }
        if (dataCol.getObject(0) == null) {
            throw new MultiApproveException(MultiApproveException.DATAOBJECT_IS_NULL);
        }
        this.setDataObject("billInfo", dataCol.getObject(0));
        RealModeIDList list = new RealModeIDList();
        list.add(billId);
        this.getUIContext().put("IDList", list);
        this.getUIContext().put("ID", billId);
        this.getUIContext().put("InitDataObject", null);
        this.getUIContext().put("isFromWorkflow", new Boolean(true));
        String cusStatus = null;
        if (this.getUIContext().get("customBizUIStatus") != null) {
            cusStatus = (String)this.getUIContext().get("customBizUIStatus");
        }
        if (StringUtils.isEmpty(cusStatus)) {
            cusStatus = "FINDVIEW";
        }
        this.billUI = (CoreUIObject)UIFactoryHelper.initUIObject((String)approveViewUI, (Map)this.getUIContext(), (Map)this.getDataObjects(), (String)cusStatus);
        if (this.billUI.getPreferredSize().width == 0 || this.billUI.getPreferredSize().height == 0) {
            if (this.billUI.getLayout() == null) {
                this.billUI.setBounds(0, 0, 1016, 600);
            }
            if (this.billUI.getLayout() instanceof KDLayout) {
                this.billUI.setSize(1016, 600);
            }
        } else {
            this.billUI.setBounds(0, 0, this.billUI.getPreferredSize().width, this.billUI.getPreferredSize().height);
        }
        this.pnlBill.getViewport().add((Component)this.billUI, null);
        this.getUIContext().put("tempDataObject", this.billUI.getDataObject());
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int result;
        String opinion = this.txtOpinion.getText();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        HashMap<Object, String> map = new HashMap<Object, String>();
        if (opinion == null || opinion.length() == 0) {
            MsgBox.showError((String)EASResource.getString((String)multiApproveResourcefile, (String)"feedbackOpinionsIsEmpty"));
            return;
        }
        boolean hasFeedBack = PassCommentMonitorUtil.isAlreadyPassFeedBack(null, opinion, userInfo.getId().toString());
        if (hasFeedBack && 0 != (result = MsgBox.showConfirm2((String)(EASResource.getString((String)multiApproveResourcefile, (String)"PASSISNULLCONTINUE") + "?")))) {
            return;
        }
        if (opinion.length() > 500) {
            MsgBox.showError((String)EASResource.getString((String)multiApproveResourcefile, (String)"opinionsIsLong"));
            return;
        }
        Locale local = SysContext.getSysContext().getLocale();
        String personId = null;
        PersonInfo personInfo = userInfo.getPerson();
        if (personInfo != null) {
            personId = personInfo.getId().toString();
        }
        PassCommentInfo comment = null;
        IPassComment pass = PassCommentFactory.getRemoteInstance();
        if (!StringUtils.isEmpty((String)this.passId) && !StringUtils.isEmpty((String)personId) && (comment = pass.getPassCommentInfo(" where passId='" + this.passId + "' and personId='" + personId + "'")) != null) {
            comment.setComment(opinion, SysContext.getSysContext().getLocale());
            comment.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            pass.save(comment);
        }
        if (comment == null) {
            comment = new PassCommentInfo();
            comment.setInitiator(this.initiator);
            comment.setBillId(this.boid);
            comment.setProcInstId(this.procInstId);
            comment.setUserID(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            comment.setComment(opinion, SysContext.getSysContext().getLocale());
            pass.addnew(comment);
        }
        List langList = KDBizMultiLangBox.getLanguageList();
        AssignInfo info = null;
        if (this.assignId != null) {
            info = EnactmentServiceFactory.createRemoteEnactService().getAssignmentById(this.assignId).getAssignInfo();
        }
        if (info == null) {
            String userName = SysContext.getSysContext().getCurrentUserInfo().getName();
            for (int i = 0; i < langList.size(); ++i) {
                String msg;
                LanguageInfo languageInfo = (LanguageInfo)langList.get(i);
                if (languageInfo != null && languageInfo.getLocale().getLanguage().equals(new Locale("l1").getLanguage())) {
                    msg = "Get the reply message from " + userName;
                    map.put(local, msg);
                    continue;
                }
                if (languageInfo != null && languageInfo.getLocale().getLanguage().equals(new Locale("l3").getLanguage())) {
                    msg = EASResource.getString((String)multiApproveResourcefile, (String)"feedbackInfo") + " " + userName;
                    map.put(local, msg);
                    continue;
                }
                msg = EASResource.getString((String)multiApproveResourcefile, (String)"feedbackInfo") + " " + userName;
                map.put(local, msg);
            }
        } else {
            Locale L = new Locale("l1");
            map.put(L, "Reply [" + (info.getSubject(L) == null ? "" : info.getSubject(L)) + "]");
            L = new Locale("l2");
            map.put(L, "\u4f20\u9605\u53cd\u9988 [" + (info.getSubject(L) == null ? "" : info.getSubject(L)) + "]");
            L = new Locale("l3");
            map.put(L, "\u50b3\u95b1\u53cd\u994b [" + (info.getSubject(L) == null ? "" : info.getSubject(L)) + "]");
        }
        map.put("receiver", this.passerId);
        map.put("sender", SysContext.getSysContext().getCurrentUserInfo().getName());
        map.put("body", opinion);
        if (this.checkSendMessage.isSelected()) {
            map.put("is_message", "true");
        }
        if (this.checkSendMail.isSelected()) {
            map.put("is_mail", "true");
        }
        if (this.checkSendMobile.isSelected()) {
            map.put("is_mobile", "true");
        }
        map.put("boid", this.boid);
        map.put("procInstId", this.procInstId);
        pass.sendReplyMessage(map);
        this.getUIWindow().close();
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (b) {
            try {
                if (this.billUI != null) {
                    this.billUI.destroyWindow();
                }
            }
            catch (Exception e) {
                String name = this.billUI == null ? "" : this.billUI.getClass().getName();
                log.error((Object)("destroy billUI {" + name + "} failed!"), (Throwable)e);
            }
        }
        return b;
    }

    @Override
    public void actionWorkflowG_actionPerformed(ActionEvent e) throws Exception {
        WfMonitorUtils.showWfDiagram((Component)((Object)this), (String)this.procInstId);
    }

    @Override
    public void actionApproveHistory_actionPerformed(ActionEvent e) throws Exception {
        MultiApproveUtil.showApproveHis(BOSUuid.read((String)this.boid), UIModelDialogFactory.class.getName(), (Object)this);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentUIContextInfo info = new AttachmentUIContextInfo();
        info.setBoID(this.boid);
        MultiApproveUtil.showAttachmentManager4PassComment(info, (Object)this, this.billUI.getDataObject());
    }
}

