/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.BizEventMap;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.exception.WfParticipantException;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.eas.base.multiapprove.MultiapproveUtils;
import com.kingdee.eas.base.multiapprove.ParticipantUtils;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.apache.log4j.Logger;

public class PerformerDesignateUI
extends CoreUI {
    protected KDLabelContainer actDefLabel;
    protected KDLabelContainer participantLabel;
    protected KDComboBox actDefCombo;
    protected KDComboBox participantCombo;
    protected KDTable performerTable;
    protected KDCheckBox allowAllCheck;
    protected KDCheckBox allPostActCheck;
    protected KDSeparator separator;
    protected KDButton cancelBtn;
    protected KDButton confirmBtn;
    protected KDWorkButton deleteBtn;
    protected KDWorkButton addBtn;
    private static final String PROCESS_DEF = "PerformerDesignateUI.PROCESS_DEF";
    private static final String PERFORMER_MAP = "PerformerDesignateUI.PERFORMER_MAP";
    private static final String FUNCTION_NAME = "PerformerDesignateUI.FUNCTION_NAME";
    private static final String ACTION_NAME = "PerformerDesignateUI.ACTION_NAME";
    private static final String BOS_OBJECT_VALUE = "PerformerDesignateUI.BOS_OBJECT_VALUE";
    private static final String BASE_ACT_ID = "PerformerDesignateUI.BASE_ACT_ID";
    private static final String CONTEXT_OPTIONS = "PerformerDesignateUI.CONTEXT_OPTIONS";
    private static final String RESULT_VALUE = "PerformerDesignateUI.RESULT_VALUE";
    private Map performerMap = null;
    private String procInstId = null;
    private ProcessDef processDef = null;
    private ManpowerActivityDef submitActDef = null;
    private IEnactmentService service = null;
    private PersonPromptBox dialog = null;
    private IPerson iperson = null;
    private HashMap promptContext = null;
    private String baseActInstId = null;
    private HashMap participantNameMap = null;
    private static final Logger logger = CoreUIObject.getLogger(PerformerDesignateUI.class);
    private static final String NEXT_PERSONS_KEY = "nextpersons";

    public PerformerDesignateUI() throws Exception {
        this.jbInit();
        this.initUIP();
        try {
            this.iperson = PersonFactory.getRemoteInstance();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"119_PerformerDesignateUI"));
        }
    }

    protected void jbInit() {
        this.resHelper = new ResourceBundleHelper(((Object)((Object)this)).getClass().getName());
        this.setUITitle(this.resHelper.getString("this.title"));
        this.actDefLabel = new KDLabelContainer();
        this.actDefLabel.setBoundLabelText(this.resHelper.getString("actDefLabel.boundLabelText"));
        this.actDefLabel.setBoundLabelLength(100);
        this.participantLabel = new KDLabelContainer();
        this.participantLabel.setBoundLabelText(this.resHelper.getString("participantLabel.boundLabelText"));
        this.participantLabel.setBoundLabelLength(100);
        this.actDefCombo = new KDComboBox();
        this.actDefCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PerformerDesignateUI.this.actDefCombo_itemStateChanged(e);
            }
        });
        this.participantCombo = new KDComboBox();
        this.participantCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PerformerDesignateUI.this.participantCombo_itemStateChanged(e);
            }
        });
        this.performerTable = new KDTable();
        this.performerTable.addColumn();
        this.performerTable.addColumn().setWidth(130);
        this.performerTable.addColumn().setWidth(200);
        IRow headRow = this.performerTable.addHeadRow();
        headRow.getCell(0).setValue((Object)this.resHelper.getString("person.number"));
        headRow.getCell(1).setValue((Object)this.resHelper.getString("person.name"));
        headRow.getCell(2).setValue((Object)this.resHelper.getString("org.name"));
        this.performerTable.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                PerformerDesignateUI.this.performerTable_tableSelectChanged(e);
            }
        });
        this.allowAllCheck = new KDCheckBox();
        this.allowAllCheck.setText(this.resHelper.getString("allowAllCheck.text"));
        this.allowAllCheck.setToolTipText(this.resHelper.getString("allowAllCheck.toolTipText"));
        this.allowAllCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerformerDesignateUI.this.allowAllCheck_actionPerformed(e);
            }
        });
        this.allPostActCheck = new KDCheckBox();
        this.allPostActCheck.setText(this.resHelper.getString("allPostActCheck.text"));
        this.allPostActCheck.setToolTipText(this.resHelper.getString("allPostActCheck.toolTipText"));
        this.allPostActCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerformerDesignateUI.this.allPostActCheck_actionPerformed(e);
            }
        });
        this.cancelBtn = new KDButton();
        this.cancelBtn.setText(this.resHelper.getString("cancelBtn.text"));
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerformerDesignateUI.this.cancelBtn_actionPerformed(e);
            }
        });
        this.confirmBtn = new KDButton();
        this.confirmBtn.setText(this.resHelper.getString("confirmBtn.text"));
        this.confirmBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerformerDesignateUI.this.confirmBtn_actionPerformed(e);
            }
        });
        this.deleteBtn = new KDWorkButton();
        this.deleteBtn.setText(this.resHelper.getString("deleteBtn.text"));
        this.deleteBtn.setToolTipText(this.resHelper.getString("deleteBtn.toolTipText"));
        this.deleteBtn.setEnabled(false);
        this.deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerformerDesignateUI.this.deleteBtn_actionPerformed(e);
            }
        });
        this.addBtn = new KDWorkButton();
        this.addBtn.setText(this.resHelper.getString("addBtn.text"));
        this.addBtn.setToolTipText(this.resHelper.getString("addBtn.toolTipText"));
        this.addBtn.setEnabled(true);
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerformerDesignateUI.this.addBtn_actionPerformed(e);
            }
        });
        this.separator = new KDSeparator();
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.basedata.person.app", "AllPersonQuery");
        QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)pk);
        this.promptContext = new HashMap();
        this.promptContext.put("0", "1");
        this.dialog = new PersonPromptBox((IUIObject)this, this.promptContext);
        this.dialog.setQueryInfo(queryInfo);
        this.dialog.setModal(true);
        this.dialog.setEnabledMultiSelection(true);
        this.dialog.setIsSingleSelect(false);
        this.initRenderers();
    }

    protected void allPostActCheck_actionPerformed(ActionEvent e) {
        try {
            this.initPostActivity();
        }
        catch (Exception ex) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"120_PerformerDesignateUI"));
            logger.error((Object)ex);
        }
    }

    protected void performerTable_tableSelectChanged(KDTSelectEvent e) {
        this.deleteBtn.setEnabled(this.performerTable.getSelectManager().toRange().size() > 0);
    }

    protected void addBtn_actionPerformed(ActionEvent e) {
        ParticipantDef participantDef = (ParticipantDef)this.participantCombo.getSelectedItem();
        if (participantDef == null) {
            return;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        ParticipantType participantType = participantDef.getParticipantType();
        String orgId = null;
        try {
            orgId = ParticipantUtils.getParticipantOrgId(participantDef);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        if (!ParticipantType.ALL.equals((Object)participantType) && !this.allowAllCheck.isSelected()) {
            try {
                List personIdList = this.getPersonIdList(participantDef);
                FilterInfo filterInfo = new FilterInfo();
                FilterItemCollection filterItems = filterInfo.getFilterItems();
                if (personIdList == null || personIdList.size() == 0) {
                    FilterItemInfo filterItem = new FilterItemInfo();
                    filterItem.setPropertyName("id");
                    filterItem.setCompareType(CompareType.EQUALS);
                    filterItem.setCompareValue((Object)"");
                    filterItems.add(filterItem);
                } else {
                    String mask = "";
                    for (int i = 0; i < personIdList.size(); ++i) {
                        if (i > 0) {
                            mask = mask + " or ";
                        }
                        mask = mask + "(#" + i + ")";
                        String personId = (String)personIdList.get(i);
                        FilterItemInfo filterItem = new FilterItemInfo();
                        filterItem.setPropertyName("id");
                        filterItem.setCompareType(CompareType.EQUALS);
                        filterItem.setCompareValue((Object)personId);
                        filterItems.add(filterItem);
                    }
                    filterInfo.setMaskString(mask);
                    IPerson iP = PersonFactory.getRemoteInstance();
                    ObjectUuidPK pk = new ObjectUuidPK((String)personIdList.get(0));
                    PersonInfo personInfo = iP.getPersonInfo((IObjectPK)pk);
                    AdminOrgUnitInfo adminInfo = iP.getPrimaryAdminOrgUnit(personInfo.getId());
                    AdminOrgUnitInfo p = adminInfo.getParent();
                    while (p != null && !p.equals((Object)adminInfo)) {
                        adminInfo = p;
                        p = adminInfo.getParent();
                    }
                    if (adminInfo != null) {
                        orgId = adminInfo.getId().toString();
                    }
                }
                entityViewInfo.setFilter(filterInfo);
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
            }
        }
        this.dialog.setEntityViewInfo(entityViewInfo);
        if (orgId == null) {
            this.promptContext.put("0", "1");
        } else {
            this.dialog.setExpandAdmin(orgId);
            this.promptContext.put("0", "2");
        }
        String defaultShowAll = null;
        try {
            if (ConfigLoader.getConfig4Client().getBoolean("next.person.default.show.all.org", null, "false")) {
                defaultShowAll = "true";
            }
        }
        catch (Exception filterInfo) {
            // empty catch block
        }
        this.promptContext.put("DEFAULT_SHOW_ALL", defaultShowAll);
        this.dialog.show();
        Object data = this.dialog.getData();
        if (data instanceof Object[]) {
            ManpowerActivityDef actDef = (ManpowerActivityDef)this.actDefCombo.getSelectedItem();
            String key = com.kingdee.bos.workflow.participant.ParticipantUtils.createDesignatePerformerKey((ActivityDef)actDef);
            List list = (List)this.performerMap.get(key);
            HashSet<Object> ids = new HashSet<Object>();
            for (int i = 0; i < this.performerTable.getRowCount(); ++i) {
                ids.add(this.performerTable.getRow(i).getCell(0).getValue());
            }
            Object[] datas = (Object[])data;
            try {
                IUser iUser = UserFactory.getRemoteInstance();
                boolean invalid = false;
                for (int i = 0; i < datas.length; ++i) {
                    PersonInfo person;
                    if (!(datas[i] instanceof PersonInfo) || ids.contains((person = (PersonInfo)datas[i]).getNumber())) continue;
                    if (this.hasUser(iUser, person.getId().toString())) {
                        list.add(person);
                        this.showPersonInTable(person, this.iperson);
                        continue;
                    }
                    invalid = true;
                }
                if (invalid) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"94_DesignatePerformerUI"));
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"121_PerformerDesignateUI"));
            }
        }
    }

    public boolean hasUser(IUser iUser, String personId) throws EASBizException, BOSException {
        if (personId == null) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("person.id", (Object)personId.trim());
        filter.getFilterItems().add(filterItem);
        return iUser.exists(filter);
    }

    private void initRenderers() {
        this.actDefCombo.setRenderer((ListCellRenderer)new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    ManpowerActivityDef postActivityDef = (ManpowerActivityDef)value;
                    ProcessDef procDef = (ProcessDef)postActivityDef.getContainer();
                    Locale locale = PerformerDesignateUI.this.getCurrentLocale();
                    String postActivityName = postActivityDef.getName(locale);
                    this.setText(postActivityName + " -" + procDef.getName(locale));
                    this.setToolTipText(postActivityName);
                }
                return this;
            }
        });
        this.participantCombo.setRenderer((ListCellRenderer)new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null && value instanceof ParticipantDef) {
                    ParticipantDef pdef = (ParticipantDef)value;
                    String name = (String)PerformerDesignateUI.this.participantNameMap.get(pdef);
                    if (name == null) {
                        try {
                            name = ParticipantUtils.getParticipantName(pdef, PerformerDesignateUI.this.processDef, PerformerDesignateUI.this.getCurrentLocale());
                            PerformerDesignateUI.this.participantNameMap.put(pdef, name);
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                    }
                    this.setText(name);
                    this.setToolTipText(name);
                }
                return this;
            }
        });
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 500, 300));
        this.setLayout(null);
        this.actDefLabel.setBounds(new Rectangle(6, 8, 485, 19));
        this.participantLabel.setBounds(new Rectangle(6, 33, 485, 19));
        this.allowAllCheck.setBounds(new Rectangle(6, 58, 150, 19));
        this.allPostActCheck.setBounds(new Rectangle(160, 58, 150, 19));
        this.addBtn.setBounds(new Rectangle(420, 58, 30, 19));
        this.deleteBtn.setBounds(new Rectangle(455, 58, 30, 19));
        this.performerTable.setBounds(new Rectangle(6, 82, 483, 160));
        this.separator.setBounds(new Rectangle(0, 254, 500, 10));
        this.confirmBtn.setBounds(new Rectangle(325, 264, 73, 21));
        this.cancelBtn.setBounds(new Rectangle(413, 264, 73, 21));
        this.actDefLabel.setBoundEditor((JComponent)this.actDefCombo);
        this.participantLabel.setBoundEditor((JComponent)this.participantCombo);
        this.add((Component)this.actDefLabel);
        this.add((Component)this.participantLabel);
        this.add((Component)this.cancelBtn);
        this.add((Component)this.confirmBtn);
        this.add((Component)this.addBtn);
        this.add((Component)this.deleteBtn);
        this.add((Component)this.separator);
        this.add((Component)this.allowAllCheck);
        this.add((Component)this.allPostActCheck);
        this.add((Component)this.performerTable);
    }

    protected void allowAllCheck_actionPerformed(ActionEvent e) {
    }

    protected void cancelBtn_actionPerformed(ActionEvent e) {
        ResultValue result = (ResultValue)this.getUIContext().get(RESULT_VALUE);
        if (result != null) {
            result.isCancel = true;
        }
        this.getUIWindow().close();
    }

    protected void confirmBtn_actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.actDefCombo.getItemCount(); ++i) {
            int retValue;
            String key;
            List performs;
            boolean needMap = false;
            ManpowerActivityDef actDef = (ManpowerActivityDef)this.actDefCombo.getItemAt(i);
            ParticipantCollection parts = actDef.getParticipants();
            for (ParticipantDef participantDef : parts) {
                if (!participantDef.getParticipantType().equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_SCOPE)) continue;
                needMap = true;
                break;
            }
            if (!needMap || (performs = (List)this.performerMap.get(key = com.kingdee.bos.workflow.participant.ParticipantUtils.createDesignatePerformerKey((ActivityDef)actDef))) != null && !performs.isEmpty() || (retValue = MsgBox.showConfirm2((String)(EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"122_PerformerDesignateUI") + actDef.getName(this.getCurrentLocale()) + EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"123_PerformerDesignateUI")))) != 2) continue;
            return;
        }
        ResultValue result = (ResultValue)this.getUIContext().get(RESULT_VALUE);
        if (result != null) {
            result.isCancel = false;
        }
        this.getUIWindow().close();
    }

    private void actDefCombo_itemStateChanged(ItemEvent e) {
        if (1 == e.getStateChange()) {
            ManpowerActivityDef actDef = (ManpowerActivityDef)e.getItem();
            this.participantCombo.removeAllItems();
            ParticipantCollection participants = actDef.getParticipants();
            for (int i = 0; i < participants.size(); ++i) {
                this.participantCombo.addItem((Object)participants.get(i));
            }
            String key = com.kingdee.bos.workflow.participant.ParticipantUtils.createDesignatePerformerKey((ActivityDef)actDef);
            List list = (List)this.performerMap.get(key);
            this.performerTable.removeRows();
            Iterator i = list.iterator();
            while (i.hasNext()) {
                this.showPersonInTable((PersonInfo)i.next(), this.iperson);
            }
        }
    }

    private void showPersonInTable(PersonInfo person, IPerson iperson) {
        IRow newRow = this.performerTable.addRow();
        newRow.setUserObject((Object)person);
        newRow.getCell(0).setValue((Object)person.getNumber());
        newRow.getCell(1).setValue((Object)person.getName());
        if (iperson != null) {
            try {
                AdminOrgUnitInfo adminInfo = iperson.getPrimaryAdminOrgUnit(person.getId());
                newRow.getCell(2).setValue((Object)adminInfo.getName());
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    private void participantCombo_itemStateChanged(ItemEvent e) {
    }

    protected void deleteBtn_actionPerformed(ActionEvent e) {
        ManpowerActivityDef actDef = (ManpowerActivityDef)this.actDefCombo.getSelectedItem();
        String key = com.kingdee.bos.workflow.participant.ParticipantUtils.createDesignatePerformerKey((ActivityDef)actDef);
        List list = (List)this.performerMap.get(key);
        int count = 0;
        KDTRange range = this.performerTable.getSelectManager().toRange();
        for (KDTSelectBlock block : range) {
            for (int rowIndex = block.getBeginRow(); rowIndex <= block.getEndRow(); ++rowIndex) {
                IRow row = this.performerTable.removeRow(rowIndex - count);
                list.remove(row.getUserObject());
                ++count;
            }
        }
        this.performerTable.getSelectManager().remove();
        this.deleteBtn.setEnabled(false);
    }

    private List getPersonIdList(ParticipantDef participantDef) throws WfException {
        ArrayList<String> personIdList = new ArrayList<String>();
        ManpowerActivityDef actDef = (ManpowerActivityDef)this.actDefCombo.getSelectedItem();
        if (actDef == null) {
            return personIdList;
        }
        String actDefId = actDef.getID();
        String currentUserId = this.getUIContext().get("USER.PK").toString();
        List participants = new ArrayList();
        ArrayList<String> participantIdList = new ArrayList<String>();
        participantIdList.add(participantDef.getID());
        try {
            if (this.procInstId != null) {
                participants = this.service.getPersonsByParticipants(this.procInstId, actDef, participantIdList, currentUserId);
            }
            if (participants == null || participants.isEmpty()) {
                ProcessDef procDef = (ProcessDef)actDef.getContainer();
                participants = this.service.getPersonsByDefParticipants(procDef.getHashValue(), actDefId, participantIdList);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.processException(e);
        }
        Iterator iterator = participants.iterator();
        while (iterator.hasNext()) {
            String personId = ((Person)iterator.next()).getEmployeeId();
            personIdList.add(personId);
        }
        return personIdList;
    }

    private void processException(Exception e) {
        Throwable cause = e.getCause();
        String msg = null;
        if (cause instanceof WfParticipantException) {
            if (e.getCause().getMessage().equals("have no such adminOrg!")) {
                msg = EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"88_DesignateNextActivityPerformerUI");
            }
        } else {
            msg = cause instanceof ObjectNotFoundException ? EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"99_DesignatePerformerUI") : EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"99_DesignatePerformerUI");
        }
        MsgBox.showInfo((Component)((Object)this), (String)msg);
    }

    protected void disposeUIWindow() {
        this.processDef = null;
        this.procInstId = null;
        this.service = null;
        this.performerMap = null;
        super.disposeUIWindow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        EASWfServiceClient easWfServiceClient = new EASWfServiceClient();
        this.service = easWfServiceClient.getService();
        this.participantNameMap = new HashMap();
        Map uiContext = this.getUIContext();
        this.processDef = (ProcessDef)uiContext.get(PROCESS_DEF);
        this.performerMap = (Map)uiContext.get(PERFORMER_MAP);
        if (this.performerMap == null) {
            throw new IllegalArgumentException(EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"95_DesignatePerformerUI"));
        }
        this.baseActInstId = (String)uiContext.get(BASE_ACT_ID);
        if (this.baseActInstId != null) {
            ActivityInstInfo actInst = this.service.getActivityInstByActInstId(this.baseActInstId);
            this.procInstId = actInst.getActInstInfo().getProcInstID().toString();
            ActivityDef def = this.service.getActDefByActInstInfo(actInst);
            if (def instanceof ManpowerActivityDef) {
                this.submitActDef = (ManpowerActivityDef)this.service.getActDefByActInstInfo(actInst);
            }
        }
        if (this.submitActDef == null) {
            String functionName = (String)uiContext.get(FUNCTION_NAME);
            String operationName = (String)uiContext.get(ACTION_NAME);
            AbstractObjectValue objectValue = (AbstractObjectValue)uiContext.get(BOS_OBJECT_VALUE);
            if (objectValue != null && (StringUtils.isEmpty((String)functionName) || StringUtils.isEmpty((String)operationName))) {
                MetaDataPK operationPk = new MetaDataPK("dfd2c083-00fa-1000-e000-001fc0a813e6");
                String methodId = operationPk.getName() + objectValue.getBOSType().toString();
                EASWfServiceClient wfServiceClient = new EASWfServiceClient();
                IEnactmentService wfService = wfServiceClient.getService();
                BizEventMap.EventStructEntry[] eventEntry = wfService.getEventStructEntry(methodId);
                if (eventEntry != null && eventEntry.length > 0) {
                    functionName = eventEntry[0].getFunction();
                    operationName = eventEntry[0].getOperation();
                }
            }
            ActivityCollection actClctn = this.processDef.getStartupActivities();
            for (int i = 0; i < actClctn.size(); ++i) {
                ActivityDef actDef = actClctn.get(i);
                if (!(actDef instanceof ManpowerActivityDef)) continue;
                ManpowerActivityDef mnpwrActDef = (ManpowerActivityDef)actDef;
                ApplicationDef aplctn = mnpwrActDef.getRelatedApplication();
                FunctionDef function = aplctn.getFunction();
                String packageName = function.getPackageName();
                String lclFnctnName = function.getName();
                String lclOprtnName = function.getOperation();
                if (!functionName.equals(packageName + "." + lclFnctnName) || !operationName.equals(lclOprtnName)) continue;
                this.submitActDef = mnpwrActDef;
            }
        }
        this.initPostActivity();
    }

    public static Map getPerformList(AbstractObjectValue objectValue, CoreUIObject uiObject) throws Exception {
        Map perMap = new HashMap();
        String value = "";
        value = objectValue.getExtendedProperty("DesignateNextActivityPerformerWhenSubmit");
        if (value == null || value.equalsIgnoreCase("")) {
            value = (String)uiObject.getUIContext().get(NEXT_PERSONS_KEY);
        }
        if (!StringUtils.isEmpty((String)value)) {
            byte[] fieldValueByteArray = StringUtils.hexFromString((String)value);
            ByteArrayInputStream bis = new ByteArrayInputStream(fieldValueByteArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(bis);
            perMap = (Map)objectInputStream.readObject();
        }
        if (perMap.isEmpty()) {
            return perMap;
        }
        IPerson iPerson = PersonFactory.getRemoteInstance();
        for (Map.Entry entry : perMap.entrySet()) {
            ArrayList<PersonInfo> peronInfos = new ArrayList<PersonInfo>();
            List personIDs = (List)entry.getValue();
            int size = personIDs.size();
            for (int i = 0; i < size; ++i) {
                String personID = (String)personIDs.get(i);
                PersonInfo personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(personID));
                peronInfos.add(personInfo);
            }
            entry.setValue(peronInfos);
        }
        return perMap;
    }

    private static void savePerformList(Map perMap, AbstractObjectValue objectValue, CoreUIObject uiObject) throws Exception {
        for (Map.Entry entry : perMap.entrySet()) {
            ArrayList<String> personIDs = new ArrayList<String>();
            List peronInfos = (List)entry.getValue();
            int size = peronInfos.size();
            for (int i = 0; i < size; ++i) {
                PersonInfo personInfo = (PersonInfo)peronInfos.get(i);
                personIDs.add(personInfo.getId().toString());
            }
            entry.setValue(personIDs);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(baos);
        objectOutputStream.writeObject(perMap);
        objectOutputStream.flush();
        objectOutputStream.close();
        byte[] valueByteArray = baos.toByteArray();
        String result = StringUtils.byteArrayToString((byte[])valueByteArray);
        objectValue.setExtendedProperty("DesignateNextActivityPerformerWhenSubmit", result);
        uiObject.getUIContext().put(NEXT_PERSONS_KEY, result);
    }

    private void initPostActivity() throws BOSException, EASBizException {
        String key;
        ManpowerActivityDef def;
        ProcessInstInfo procInstInfo;
        HashMap map = new HashMap();
        this.getPostActivity(map, (ActivityDef)this.submitActDef, this.allPostActCheck.isSelected());
        if (this.procInstId != null && this.allPostActCheck.isSelected() && (procInstInfo = this.service.getProcessInstInfo(this.procInstId)) != null && procInstInfo.getParentActInstId() != null) {
            String parentActInstId = procInstInfo.getParentActInstId();
            ActivityInstInfo actInst = this.service.getActivityInstByActInstId(parentActInstId);
            ActivityDef def2 = this.service.getActDefByActInstInfo(actInst);
            this.getPostActivity(map, def2, this.allPostActCheck.isSelected());
        }
        ArrayList actList = new ArrayList();
        actList.addAll(map.values());
        this.actDefCombo.setModel(new DefaultComboBoxModel<Object>(actList.toArray(new Object[0])));
        if (this.procInstId == null) {
            for (int i = 0; i < actList.size(); ++i) {
                def = (ManpowerActivityDef)actList.get(i);
                key = com.kingdee.bos.workflow.participant.ParticipantUtils.createDesignatePerformerKey((ActivityDef)def);
                ArrayList performerList = (ArrayList)this.performerMap.get(key);
                if (performerList != null) continue;
                performerList = new ArrayList();
                this.performerMap.put(key, performerList);
            }
        } else {
            for (int i = 0; i < actList.size(); ++i) {
                def = (ManpowerActivityDef)actList.get(i);
                key = com.kingdee.bos.workflow.participant.ParticipantUtils.createDesignatePerformerKey((ActivityDef)def);
                List performerList = (ArrayList)this.performerMap.get(key);
                if (performerList == null) {
                    performerList = new ArrayList();
                    String dataFieldName = com.kingdee.bos.workflow.participant.ParticipantUtils.createDesignatePerformerKey((ActivityDef)def);
                    Object dataFieldValueObj = this.service.getProcessContext(this.procInstId, dataFieldName);
                    if (dataFieldValueObj instanceof List) {
                        performerList = this.convertToPersonInfoList((List)dataFieldValueObj);
                    }
                }
                this.performerMap.put(key, performerList);
            }
        }
        this.actDefCombo.setSelectedIndex(-1);
        if (this.actDefCombo.getModel().getSize() > 0) {
            this.actDefCombo.setSelectedIndex(0);
        } else {
            this.participantCombo.removeAllItems();
            this.performerTable.removeRows();
        }
    }

    private List convertToPersonInfoList(List personIdList) throws BOSException, EASBizException {
        ArrayList<PersonInfo> result = new ArrayList<PersonInfo>();
        if (personIdList == null || personIdList.size() <= 0) {
            return result;
        }
        for (String personId : personIdList) {
            PersonInfo personInfo = MultiApproveUtil.getPersonInfo(personId);
            result.add(personInfo);
        }
        return result;
    }

    private void getPostActivity(Map actMap, ActivityDef actDef, boolean getAll) throws BOSException {
        if (actDef == null) {
            throw new IllegalArgumentException();
        }
        ActivityCollection activities = actDef.getPostActivities();
        if (activities == null || activities.size() == 0) {
            return;
        }
        for (ActivityDef activity : activities) {
            if (activity instanceof ManpowerActivityDef) {
                ProcessDef procDef = (ProcessDef)activity.getContainer();
                String key = procDef.getID() + "@" + activity.getID();
                if (actMap.containsKey(key)) continue;
                ManpowerActivityDef mact = (ManpowerActivityDef)activity;
                if (mact.canSpecifyNextActivityPerformer()) {
                    actMap.put(procDef.getID() + "@" + activity.getID(), activity);
                }
                if (!getAll) continue;
                this.getPostActivity(actMap, activity, getAll);
                continue;
            }
            if (activity instanceof ToolActivityDef || activity instanceof RouterActivityDef) {
                this.getPostActivity(actMap, activity, getAll);
                continue;
            }
            if (!(activity instanceof SubflowActivityDef)) continue;
            this.getSubflowPostActivities(actMap, (SubflowActivityDef)activity, getAll);
            if (!getAll) continue;
            this.getPostActivity(actMap, activity, getAll);
        }
    }

    private void getSubflowPostActivities(Map actMap, SubflowActivityDef subflowActivityDef, boolean getAll) throws BOSException {
        String subProcessDefID = subflowActivityDef.getSubflowId();
        ProcessDefInfo subProcessDefInfo = this.service.getProcessDefInfo(subProcessDefID);
        if (subProcessDefInfo == null) {
            return;
        }
        ProcessDef subProcessDef = ApplicationUtil.getProcessDefByDefHashValue((String)subProcessDefInfo.getMd5HashValue());
        ActivityCollection allActs = subProcessDef.getActivitys();
        for (ActivityDef actDef : allActs) {
            if (!(actDef instanceof StartActivityDef)) continue;
            this.getPostActivity(actMap, actDef, getAll);
        }
    }

    public static boolean isNeedAssignate(CoreUIObject parent, AbstractObjectValue objectValue, ProcessDef procDef) throws Exception {
        if (procDef == null) {
            return false;
        }
        HashSet<ActivityDef> actDefs = new HashSet<ActivityDef>();
        ActivityCollection activities = procDef.getActivitys();
        for (ActivityDef def : activities) {
            if (!(def instanceof ManpowerActivityDef)) continue;
            actDefs.add(def);
        }
        Map perMap = PerformerDesignateUI.getPerformList(objectValue, parent);
        for (ManpowerActivityDef manpowerActivityDef : actDefs) {
            ParticipantCollection parts = manpowerActivityDef.getParticipants();
            for (int p = 0; p < parts.size(); ++p) {
                List persons;
                ParticipantType type = parts.get(p).getParticipantType();
                if (!type.equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_SCOPE) || (persons = (List)perMap.get(com.kingdee.bos.workflow.participant.ParticipantUtils.createDesignatePerformerKey((ActivityDef)manpowerActivityDef))) != null && !persons.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static Map process(CoreUIObject parent, AbstractObjectValue objectValue, ProcessDef procDef, String functionName, String operationName, Map options) throws Exception {
        Map perMap = PerformerDesignateUI.getPerformList(objectValue, parent);
        boolean isEmpty = true;
        Iterator i = perMap.keySet().iterator();
        while (i.hasNext()) {
            List persons = (List)perMap.get(i.next());
            if (persons == null || persons.isEmpty()) continue;
            isEmpty = false;
            break;
        }
        if (isEmpty) {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            String curUser = userInfo.getId().toString();
            EASWfServiceClient easWfServiceClient = new EASWfServiceClient();
            IEnactmentService service1 = easWfServiceClient.getService();
            ProcessInstInfo[] insts = service1.getProcessInstancesByProcDefId(procDef.getID());
            ProcessInstInfo preInst = null;
            for (int i2 = 0; i2 < insts.length; ++i2) {
                ProcessInstInfo inst = insts[i2];
                if (!inst.getInitiatorId().equals(curUser)) continue;
                if (preInst == null) {
                    preInst = inst;
                    continue;
                }
                if (inst.getCreatedTime().compareTo(preInst.getCreatedTime()) <= 0) continue;
                preInst = inst;
            }
            if (preInst != null) {
                // empty if block
            }
        }
        UIContext uiContext = new UIContext((Object)parent);
        ResultValue result = new ResultValue();
        uiContext.put((Object)RESULT_VALUE, (Object)result);
        uiContext.put((Object)PROCESS_DEF, (Object)procDef);
        uiContext.put((Object)PERFORMER_MAP, (Object)perMap);
        uiContext.put((Object)FUNCTION_NAME, (Object)functionName);
        uiContext.put((Object)ACTION_NAME, (Object)operationName);
        uiContext.put((Object)BOS_OBJECT_VALUE, (Object)objectValue);
        uiContext.put((Object)CONTEXT_OPTIONS, (Object)options);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(PerformerDesignateUI.class.getName(), (Map)uiContext);
        window.show();
        if (!result.isCancel) {
            PerformerDesignateUI.savePerformList(perMap, objectValue, parent);
            return perMap;
        }
        return null;
    }

    public static Map process(CoreUIObject parent, AbstractObjectValue objectValue, String procDefHashValue, String functionName, String operationName, Map options) throws Exception {
        if (StringUtils.isEmpty((String)procDefHashValue)) {
            throw new IllegalArgumentException("process args procDefHashValue can't be null");
        }
        ProcessDef procDef = ApplicationUtil.getProcessDefByDefHashValue((String)procDefHashValue);
        return PerformerDesignateUI.process(parent, objectValue, procDef, functionName, operationName, options);
    }

    public static void processByBussinessObjId(CoreUIObject parent, String businessObjId, Map options) throws Exception {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isEmpty((String)businessObjId)) {
            throw new IllegalArgumentException();
        }
        String actInstId = null;
        ProcessDef processDef = null;
        String procInstId = null;
        IEnactmentService service = new EASWfServiceClient().getService();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        AssignmentInfo[] assignmentInfoArray = service.checkAssignmentInfos(businessObjId, userId);
        for (int i = 0; i <= assignmentInfoArray.length - 1; ++i) {
            String activityInstId = assignmentInfoArray[i].getActInstId();
            ActivityInstInfo activityInstInfo = service.getActivityInstByActInstId(activityInstId);
            if (activityInstInfo.getState().startsWith("closed")) continue;
            actInstId = activityInstId;
            processDef = service.getProcessDefByDefineHashValue(activityInstInfo.getProcDefHashValue());
            procInstId = activityInstInfo.getProcInstId();
            break;
        }
        if (procInstId == null || processDef == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"98_DesignatePerformerUI"));
            return;
        }
        HashMap perMap = new HashMap();
        UIContext uiContext = new UIContext((Object)parent);
        uiContext.put((Object)BASE_ACT_ID, (Object)actInstId);
        uiContext.put((Object)PROCESS_DEF, (Object)processDef);
        uiContext.put((Object)PERFORMER_MAP, perMap);
        uiContext.put((Object)CONTEXT_OPTIONS, (Object)options);
        PerformerDesignateUI.innerProcessInInst(uiContext, procInstId);
    }

    public static void process(CoreUIObject parent, String assignmentId, Map options) throws BOSException {
        AssignmentInfo assignmentInfo;
        String activityInstId;
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isEmpty((String)assignmentId)) {
            throw new IllegalArgumentException();
        }
        EASWfServiceClient easWfServiceClient = new EASWfServiceClient();
        IEnactmentService service = easWfServiceClient.getService();
        ActivityInstInfo activityInstInfo = service.getActivityInstByActInstId(activityInstId = (assignmentInfo = service.getAssignmentById(assignmentId)).getActInstId());
        if (activityInstInfo.getState().startsWith("closed")) {
            String msg = MultiApproveUtil.getMultiApproveResource("HAVENO_WORKFLOWACTIVITY");
            MsgBox.showInfo((Component)parent, (String)msg);
            return;
        }
        String procInstId = activityInstInfo.getProcInstId();
        ProcessInstInfo processInstInfo = service.getProcessInstInfo(procInstId);
        ProcessDef processDef = ApplicationUtil.getProcessDefByDefHashValue((String)processInstInfo.getProcDefHashValue());
        HashMap perMap = new HashMap();
        UIContext uiContext = new UIContext((Object)parent);
        uiContext.put((Object)BASE_ACT_ID, (Object)activityInstId);
        uiContext.put((Object)PROCESS_DEF, (Object)processDef);
        uiContext.put((Object)PERFORMER_MAP, perMap);
        uiContext.put((Object)CONTEXT_OPTIONS, (Object)options);
        PerformerDesignateUI.innerProcessInInst(uiContext, procInstId);
    }

    private static void innerProcessInInst(UIContext uiContext, String procInstId) throws WfException, UIException {
        ResultValue result = new ResultValue();
        uiContext.put((Object)RESULT_VALUE, (Object)result);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(PerformerDesignateUI.class.getName(), (Map)uiContext);
        window.show();
        if (!result.isCancel) {
            IEnactmentService service = new EASWfServiceClient().getService();
            Map perMap = (Map)uiContext.get((Object)PERFORMER_MAP);
            for (String key : perMap.keySet()) {
                List performerList = (List)perMap.get(key);
                if (performerList == null) continue;
                List prsnIdLst = MultiapproveUtils.convertToPersonIdList(performerList);
                service.setProcessContext(procInstId, key, (Object)prsnIdLst);
            }
        }
    }

    private static class ResultValue {
        boolean isCancel = false;

        private ResultValue() {
        }
    }
}

